/*************************************************************************
 *
 *  $RCSfile: contentholder.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:16:46 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _HIERARCHY_CONTENTHOLDER_HXX
#define _HIERARCHY_CONTENTHOLDER_HXX

#include <osl/mutex.hxx>
#include <list>

template <class Type> class safe_list : public osl::Mutex, public std::list< Type > {};


#include <cppuhelper/weak.hxx>

#ifndef _COM_SUN_STAR_UCB_XCONTENT_HPP_
#include <com/sun/star/ucb/XContent.hpp>
#endif

#ifndef _COM_SUN_STAR_UCB_XCONTENTIDENTIFIER_HPP_
#include <com/sun/star/ucb/XContentIdentifier.hpp>
#endif

#ifndef _COM_SUN_STAR_UCB_XCOMMANDTASKPROCESSOR_HPP_
#include <com/sun/star/ucb/XCommandTaskProcessor.hpp>
#endif

#ifndef _COM_SUN_STAR_UCB_XPROPERTYTASKPROCESSOR_HPP_
#include <com/sun/star/ucb/XPropertyTaskProcessor.hpp>
#endif

#ifndef _COM_SUN_STAR_HIERARCHY_XDYNAMICHIERARCHY_HPP_
#include <com/sun/star/hierarchy/XDynamicHierarchy.hpp>
#endif

#ifndef _COM_SUN_STAR_HIERARCHY_XHIERARCHYIDENTIFIER_HPP_
#include <com/sun/star/hierarchy/XHierarchyIdentifier.hpp>
#endif

#ifndef _COM_SUN_STAR_BEANS_XPROPERTIESCHANGELISTENER_HPP_
#include <com/sun/star/beans/XPropertiesChangeListener.hpp>
#endif

#ifndef _COM_SUN_STAR_LANG_XCOMPONENT_HPP_
#include <com/sun/star/lang/XComponent.hpp>
#endif

#if defined(TF_TYPE) || (SUPD >= 564)
using namespace cppu;
#endif
using namespace osl;
using namespace rtl;
using namespace std;
using namespace com::sun::star::hierarchy;
using namespace com::sun::star::ucb;
using namespace com::sun::star::uno;
using namespace com::sun::star::beans;
using namespace com::sun::star::lang;

class OContentHolder : 
public OWeakObject,
public XContent,
public XCommandTaskProcessor,
public XPropertyTaskProcessor
{
	Reference< XContent >	m_xPhysicalContent;
public:
	OContentHolder( const Reference < XContent > &rContent );
	virtual ~OContentHolder();

	// XInterface
#if defined(TF_TYPE) || (SUPD >= 564)
	virtual Any SAL_CALL queryInterface( const Type& type ) throw( RuntimeException );
#else
	virtual sal_Bool SAL_CALL queryInterface( const Uik& type, Any& ifc ) throw( RuntimeException );
#endif

	virtual void SAL_CALL acquire() throw(RuntimeException);
	virtual void SAL_CALL release() throw(RuntimeException);

	// XContent

    virtual Reference< XContentIdentifier > SAL_CALL getIdentifier(  ) throw(RuntimeException);
    virtual OWString SAL_CALL getContentType(  ) throw(RuntimeException);
    virtual void SAL_CALL addContentEventListener( const Reference< XContentEventListener >& Listener ) throw(RuntimeException);
    virtual void SAL_CALL removeContentEventListener( const Reference< XContentEventListener >& Listener ) throw(RuntimeException);

	// XCommandTaskProcessor 

#if ( SUPD >= 566 )
	virtual Reference< XCommandTask > SAL_CALL createCommandTask( const Command& TheCommand, const Reference< XResultAcceptor > &ResultAcceptor, const Reference< XContentTaskEnvironment >& Environment ) throw(RuntimeException);
#else
    virtual Reference< XCommandTask > SAL_CALL createCommandTask( const Command& TheCommand, const Reference< XContentTaskEnvironment >& Environment ) throw(RuntimeException);
#endif
    virtual Reference< XCommandInfo > SAL_CALL getCommandsInfo(  ) throw(RuntimeException);

	// XPropertyTaskProcessor
	virtual Reference< XPropertyTask > SAL_CALL createPropertyTask( PropertyTaskType Type, const Sequence< PropertyValue >& Properties, const Reference< XContentTaskEnvironment >& Environment ) throw();
	virtual Reference< XPropertySetInfo > SAL_CALL getPropertySetInfo() throw();

};


#endif	// _HIERARCHY_CONTENTHOLDER_HXX
