/*************************************************************************
 *
 *  $RCSfile: importpages.cxx,v $
 *
 *  $Revision: 1.18 $
 *
 *  last change: $Author: fs $ $Date: 2001/10/12 12:24:52 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc..
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _EXTENSIONS_DBI_IMPORTPAGES_HXX_
#include "importpages.hxx"
#endif
#ifndef _EXTENSIONS_DBI_IMPORTDIALOG_HXX_
#include "importdialog.hxx"
#endif
#ifndef _SV_WAITOBJ_HXX 
#include <vcl/waitobj.hxx>
#endif
#ifndef _EXTENSIONS_COMPONENT_MODULE_HXX_
#include "componentmodule.hxx"
#endif
#ifndef _EXTENSIONS_DBIRESID_HRC_
#include "dbiresid.hrc"
#endif
#ifndef _SV_MSGBOX_HXX 
#include <vcl/msgbox.hxx>
#endif
#ifndef _OSL_FILE_H_ 
#include <osl/file.h>
#endif
#ifndef _EXTENSIONS_DBI_SDBFILEACCESS_HXX_
#include "sdbfileaccess.hxx"
#endif
#ifndef _EXTENSIONS_DBI_DSNTYPES_HXX_
#include "dsntypes.hxx"
#endif
#ifndef _UCBHELPER_CONTENT_HXX
#include <ucbhelper/content.hxx>
#endif
#ifndef _EXTENSIONS_DBI_FILENOTATION_HXX_
#include "filenotation.hxx"
#endif
#ifndef __EXTENSIONS_INC_EXTENSIO_HRC__
#include "extensio.hrc"
#endif
#ifndef _OSL_SECURITY_H_ 
#include <osl/security.h>
#endif
#ifndef _FILEDLGHELPER_HXX
#include <sfx2/filedlghelper.hxx>
#endif
#ifndef _TOOLS_DEBUG_HXX 
#include <tools/debug.hxx>
#endif
#ifndef _COM_SUN_STAR_UI_DIALOGS_XFOLDERPICKER_HPP_ 
#include <com/sun/star/ui/dialogs/XFolderPicker.hpp>
#endif
#ifndef _VCL_STDTEXT_HXX 
#include <vcl/stdtext.hxx>
#endif

//.........................................................................
namespace dbi
{
//.........................................................................

	using namespace ::com::sun::star::uno;
	using namespace ::com::sun::star::lang;
	using namespace ::com::sun::star::ui::dialogs;

	//=====================================================================
	//= OImportPage
	//=====================================================================
	//---------------------------------------------------------------------
	static sal_Bool exists(const String& _rName, const StringBag& _rContainer)
	{
		ConstStringBagIterator aExistent = _rContainer.find(_rName);
		return _rContainer.end() != aExistent;
	}

	//=====================================================================
	//= OImportPage
	//=====================================================================
	//---------------------------------------------------------------------
	OImportPage::OImportPage( OImportSdbDialog* _pParent, const ResId& _rId )
		:OImportPage_Base(_pParent, _rId)
		,m_aPicture(this, ResId(BMP_WIZARD_PICTURE))
	{
	}

	//---------------------------------------------------------------------
	void OImportPage::DeactivatePage()
	{
		OImportPage_Base::DeactivatePage();
		getDialog()->enableButtons(WZB_NEXT, sal_True);
	}

	//---------------------------------------------------------------------
	OImportSdbDialog* OImportPage::getDialog()
	{
		return static_cast<OImportSdbDialog*>(GetParent());
	}

	//---------------------------------------------------------------------
	Reference< XMultiServiceFactory > OImportPage::getORB()
	{
		return getDialog()->getORB();
	}

	//---------------------------------------------------------------------
	OImportSettings& OImportPage::getSettings()
	{
		return getDialog()->getSettings();
	}

	//---------------------------------------------------------------------
	const OSdbFileAccess& OImportPage::getSdbInfo()
	{
		return getDialog()->getSdbInfo();
	}

	//=====================================================================
	//= OSdbSelectionPage
	//=====================================================================
	//---------------------------------------------------------------------
	OSdbSelectionPage::OSdbSelectionPage( OImportSdbDialog* _pParent )
		:OImportPage(_pParent, ModuleRes(RID_PAGE_SELECTSDB))
		,m_aFrame					(this,	ResId(FL_SDBSELECTION))
		,m_aSdbSelectionLabel		(this,	ResId(FT_SDBSELECTION))
		,m_aSdbSelection			(this,	ResId(CMB_SDBSELECTION))
		,m_aBrowseSdb				(this,	ResId(PB_BROWSESDBFILE))
		,m_aImportWarningSeparator	(this,	ResId(FL_IMPORTWARNING))
		,m_aImportWarning			(this,	ResId(FT_IMPORTWARNING))
	{
		m_aBrowseSdb.SetClickHdl(LINK(this, OSdbSelectionPage, OnBrowseSdbFile));
		m_aSdbSelection.SetModifyHdl(LINK(this, OSdbSelectionPage, OnEditModified));
		FreeResource();

		// check if there is enough room for the warning text
		Size aNeededSize = m_aImportWarning.CalcMinimumSize();
		Size aCurrentSize = m_aImportWarning.GetSizePixel();
		if (aNeededSize.Height() > aCurrentSize.Height())
		{
			sal_Int32 nDiff = aCurrentSize.Height() - aNeededSize.Height();
			Point aPos = m_aImportWarningSeparator.GetPosPixel();
			aPos.Y() += nDiff;

			// would like to position the separator at pos, but of course it should not overlap the browse button
			sal_Int32 nButtonLowerEnd = m_aBrowseSdb.GetPosPixel().Y() + m_aBrowseSdb.GetSizePixel().Height();
			sal_Int32 nEarlistStart = nButtonLowerEnd + LogicToPixel(Size(0, 3), MAP_APPFONT).Height();
			if (aPos.Y() < nEarlistStart)
			{
				aNeededSize.Height() -= (nEarlistStart - aPos.Y());
				nDiff += (nEarlistStart - aPos.Y());
				aPos.Y() = nEarlistStart;
			}

			m_aImportWarningSeparator.SetPosPixel(aPos);

			aPos = m_aImportWarning.GetPosPixel();
			m_aImportWarning.SetPosPixel(Point(aPos.X(), aPos.Y() + nDiff));
			m_aImportWarning.SetSizePixel(Size(aCurrentSize.Width(), aNeededSize.Height()));
		}
		m_aSdbSelection.SetDropDownLineCount(10);
		m_aSdbSelection.SetHelpId( HID_DBIWIZARD_FILESELECTION );
	}

	//---------------------------------------------------------------------
	void OSdbSelectionPage::ActivatePage()
	{
		OImportPage::ActivatePage();
		m_aSdbSelection.GrabFocus();
		getDialog()->enableButtons(WZB_PREVIOUS, sal_False);
	}

	//---------------------------------------------------------------------
	void OSdbSelectionPage::DeactivatePage()
	{
		OImportPage::DeactivatePage();
		getDialog()->enableButtons(WZB_PREVIOUS, sal_True);
	}

	//---------------------------------------------------------------------
	void OSdbSelectionPage::initializePage()
	{
		OImportPage::initializePage();
		m_aSdbSelection.SetText(getSettings().sImportFile);
	}

	//---------------------------------------------------------------------
	sal_Bool OSdbSelectionPage::commitPage(COMMIT_REASON _eReason)
	{
		getSettings().sImportFile = m_aSdbSelection.GetText();
		return OImportPage::commitPage(_eReason);
	}

	//---------------------------------------------------------------------
	IMPL_LINK( OSdbSelectionPage, OnEditModified, void*, EMPTYARG )
	{
		implCheckNextButton();
		return 0L;
	}

	//---------------------------------------------------------------------
	sal_Bool OSdbSelectionPage::determineNextButtonState()
	{
		return OImportPage::determineNextButtonState() && (0 != m_aSdbSelection.GetText().Len());
	}

	//---------------------------------------------------------------------
	IMPL_LINK( OSdbSelectionPage, OnBrowseSdbFile, PushButton*, NOTINTERESTEDIN )
	{
		::sfx2::FileDialogHelper aFileDlg(WB_3DLOOK);

		// the initial path
		String sPath = m_aSdbSelection.GetText();
		if (sPath.Len())
		{
			OFileNotation aTransformer(sPath, OFileNotation::N_SYSTEM);
			aFileDlg.SetDisplayDirectory(aTransformer.get(OFileNotation::N_URL));
		}

		// the one and only filter we know
		aFileDlg.AddFilter( String( ModuleRes( RID_STR_SDBFILTERNAME ) ), String::CreateFromAscii( "*.sdb" ) );

		// execute
		if (0 == aFileDlg.Execute())
		{
			// get the path in system notation
			OFileNotation aTransformer(aFileDlg.GetPath(), OFileNotation::N_URL);
			m_aSdbSelection.SetText(aTransformer.get(OFileNotation::N_SYSTEM));

			implCheckNextButton();

			commitPage(CR_VALIDATE_NOUI);
			getDialog()->doOpen();
		}

		return 0L;
	}

	//=====================================================================
	//= OContentSelectionPage
	//=====================================================================
	//---------------------------------------------------------------------
	OContentSelectionPage::OContentSelectionPage( OImportSdbDialog* _pParent )
		:OImportPage(_pParent, ModuleRes(RID_PAGE_SELECTCONTENT))
		,m_aSourceFrame			(this,	ResId(FL_SOURCE))
		,m_aSourceStatistics	(this,	ResId(ET_SDBSTATS))
		,m_aDestFrame			(this,	ResId(FL_DEST))
		,m_aCreateDatasource	(this,	ResId(CB_CREATE_DATASOURCE))
		,m_aImportQueries		(this,	ResId(CB_IMPORT_QUERIES))
		,m_aImportForms			(this,	ResId(CB_IMPORT_FORMS))
		,m_aSmallHelp			(this,	ResId(ET_SMALLHELP))
		,m_nQueryCount(0)
		,m_nFormCount(0)
		,m_sHelpDS(ResId(STR_CREATE_DATASOURCE))
		,m_sHelpQueries(ResId(STR_IMPORT_QUERIES))
		,m_sHelpForms(ResId(STR_IMPORT_FORMS))
		,m_sStatisticsBase(ResId(STR_SDBSTATS))
	{
		FreeResource();

		m_aSourceStatistics.SetUniqueId(UID_DBIWIZARD_SOURCESTATS);

		m_aCreateDatasource.SetClickHdl(LINK(this, OContentSelectionPage, OnCheckboxToggled));
		m_aImportQueries.SetClickHdl(LINK(this, OContentSelectionPage, OnCheckboxToggled));
		m_aImportForms.SetClickHdl(LINK(this, OContentSelectionPage, OnCheckboxToggled));
	}

	//---------------------------------------------------------------------
	long OContentSelectionPage::Notify( NotifyEvent& _rNEvt )
	{
		sal_Bool bButton1 = (_rNEvt.GetWindow() == &m_aCreateDatasource);
		sal_Bool bButton2 = (_rNEvt.GetWindow() == &m_aImportQueries);
		sal_Bool bButton3 = (_rNEvt.GetWindow() == &m_aImportForms);
		sal_Bool bHelpText = (m_aSmallHelp.IsWindowOrChild(_rNEvt.GetWindow()));

		switch (_rNEvt.GetType())
		{
			case EVENT_GETFOCUS:
				if (bButton1)
					setHelpText(m_sHelpDS);
				else if (bButton2)
					setHelpText(m_sHelpQueries);
				else if (bButton3)
					setHelpText(m_sHelpForms);
				else
				{
					if (!bHelpText)
						m_sPreviousHelp = String();
					setHelpText(m_sPreviousHelp);
				}
				break;
			case EVENT_LOSEFOCUS:
				if (bButton1 || bButton2 || bButton3 || bHelpText)
				{
					m_sPreviousHelp = m_aSmallHelp.GetText();
					setHelpText(String());
				}
				break;
		}
		return OImportPage::Notify(_rNEvt);
	}

	//---------------------------------------------------------------------
	void OContentSelectionPage::ActivatePage()
	{
		OImportPage::ActivatePage();
		m_aCreateDatasource.GrabFocus();
	}

	//---------------------------------------------------------------------
	void OContentSelectionPage::initializePage()
	{
		OImportPage::initializePage();

		const OSdbFileAccess& rFileInfo = getSdbInfo();
		OImportSettings& rSettings = getSettings();

		StringArray aObjects;
		rFileInfo.getQueryNames(aObjects); m_nQueryCount = aObjects.size();
		rFileInfo.getFormNames(aObjects); m_nFormCount = aObjects.size();

		ODSNTypeInfo aConnectionType(rFileInfo.getTypeLogical());

		String sStatistics(m_sStatisticsBase);
		sStatistics.SearchAndReplaceAscii("$file$", rSettings.sImportFile);
		sStatistics.SearchAndReplaceAscii("$type$", aConnectionType.getDisplayName());
		sStatistics.SearchAndReplaceAscii("$title$", rFileInfo.getTitle());
		sStatistics.SearchAndReplaceAscii("$forms$", m_nFormCount ? String::CreateFromInt32(m_nFormCount) : String(ModuleRes(RID_STR_NONE)));
		sStatistics.SearchAndReplaceAscii("$queries$", m_nQueryCount ? String::CreateFromInt32(m_nQueryCount) : String(ModuleRes(RID_STR_NONE)));
		m_aSourceStatistics.SetText(sStatistics);

		// initialize the controls with the current settings
		m_aCreateDatasource.Check(rSettings.bCreateDatasource && aConnectionType.isAvailable());
		m_aImportQueries.Check(rSettings.bImportQueries && (0 != m_nQueryCount));
		m_aImportForms.Check(rSettings.bImportForms && (0 != m_nFormCount));

		m_aCreateDatasource.Enable(aConnectionType.isAvailable());
		m_aImportQueries.Enable(0 != m_nQueryCount);
		m_aImportForms.Enable(0 != m_nFormCount);
	}

	//---------------------------------------------------------------------
	sal_Bool OContentSelectionPage::commitPage(COMMIT_REASON _eReason)
	{
		// transfer the settings
		OImportSettings& rSettings = getSettings();
		rSettings.bCreateDatasource = m_aCreateDatasource.IsChecked();
		if (0 != m_nQueryCount)
			rSettings.bImportQueries = m_aImportQueries.IsChecked();
		if (0 != m_nFormCount)
			rSettings.bImportForms = m_aImportForms.IsChecked();

		// the data is invalid if we do not have checked anything
		sal_Bool bCheckedAnything = m_aCreateDatasource.IsChecked();
		bCheckedAnything |= m_aImportQueries.IsChecked();
		bCheckedAnything |= m_aImportForms.IsChecked();
		if ((CR_TRAVEL_PREVIOUS != _eReason) && !bCheckedAnything)
			return sal_False;
		// (but we allow traveling to the previous page even if we have invalid data ...)

		return OImportPage::commitPage(_eReason);
	}

	//---------------------------------------------------------------------
	sal_Bool OContentSelectionPage::determineNextButtonState()
	{
		// adjust the 'next' button
		sal_Bool bCheckedAnything = m_aCreateDatasource.IsChecked();
		bCheckedAnything |= m_aImportQueries.IsChecked();
		bCheckedAnything |= m_aImportForms.IsChecked();

		return bCheckedAnything && OImportPage::determineNextButtonState();
	}

	//---------------------------------------------------------------------
	void OContentSelectionPage::setHelpText(const String& _rText)
	{
		if (m_aSmallHelp.GetText() == _rText)
			return;

		m_aSmallHelp.SetText(_rText);

		sal_Bool bTooSmall = m_aSmallHelp.CalcMinimumSize().Height() > m_aSmallHelp.GetSizePixel().Height();
		if (bTooSmall)
			m_aSmallHelp.SetStyle(m_aSmallHelp.GetStyle() | WB_VSCROLL);
		else
			m_aSmallHelp.SetStyle(m_aSmallHelp.GetStyle() & ~WB_VSCROLL);
	}

	//---------------------------------------------------------------------
	IMPL_LINK( OContentSelectionPage, OnCheckboxToggled, CheckBox*, _pBox )
	{
		getDialog()->currentModified();
		implCheckNextButton();
		return 0;
	}

	//=====================================================================
	//= ODsnAdjustmentPage
	//=====================================================================
	//---------------------------------------------------------------------
	ODsnAdjustmentPage::ODsnAdjustmentPage( OImportSdbDialog* _pParent )
		:OImportPage(_pParent, ModuleRes(RID_PAGE_ADJUST_DSN))
		,m_aFrame		(this, ResId(FL_FRAME))
		,m_aDescription	(this, ResId(FT_ADJUSTDSN_DESC))
		,m_aDesc2		(this, ResId(FT_FOLLOWING_PATH))
		,m_aOldLabel	(this, ResId(FT_OLD_DSN))
		,m_aOldDsn		(this, ResId(ET_OLD_DSN))
		,m_aNewLabel	(this, ResId(FT_NEW_DSN))
		,m_aNewDsn		(this, ResId(ET_NEW_DSN))
		,m_aExample		(this, ResId(FT_EXAMPLE))
	{
		String sDefaultPath = String(ResId(STR_PATH_EXAMPLE));
		String sResolved = String(ResId(STR_PATH_RESOLVED));

		// check whether or not we're on a UNIX system (the example's texts depend on this)
		::rtl::OUString sHomeDir;
		osl_getHomeDir(osl_getCurrentSecurity(), &sHomeDir.pData);
		if (sHomeDir.getLength() && sHomeDir.getStr()[0] == '/')
		{
			// we're on a UNIX system
			sDefaultPath = sHomeDir;
			sDefaultPath.AppendAscii("/Office52");

			sResolved = sHomeDir;
			sResolved.AppendAscii("/Office52/user");
		}

		String sExample = m_aExample.GetText();
		sExample.SearchAndReplaceAscii("$defaultpath$", sDefaultPath);
		sExample.SearchAndReplaceAscii("$substpath$", sResolved);
		m_aExample.SetText(sExample);

		FreeResource();
	}

	//---------------------------------------------------------------------
	void ODsnAdjustmentPage::initializePage()
	{
		OImportPage::initializePage();

		const OSdbFileAccess& rSdbFile = getSdbInfo();
		String sDSN = rSdbFile.getDSNStringToken("DSN");
		m_aOldDsn.SetText(sDSN);
		m_aNewDsn.SetText(sDSN);
	}

	//---------------------------------------------------------------------
	sal_Bool ODsnAdjustmentPage::commitPage(COMMIT_REASON _eReason)
	{
		if (!OImportPage::commitPage(_eReason))
			return sal_False;

		getDialog()->adjustDsnPath(m_aNewDsn.GetText(), OImportSdbDialog::PathWriteAccess());

		return sal_True;
	}

	//---------------------------------------------------------------------
	void ODsnAdjustmentPage::ActivatePage()
	{
		OImportPage::ActivatePage();
		m_aNewDsn.GrabFocus();
	}

	//=====================================================================
	//= OObjectSelectionPage
	//=====================================================================
	//---------------------------------------------------------------------
	OObjectSelectionPage::OObjectSelectionPage( OImportSdbDialog* _pParent, const ResId& _rId )
		:OImportPage(_pParent, _rId)
		,m_aFrame			(this, ResId(FL_FRAME))
		,m_aObjectList		(this, ResId(LB_OBJECTSELECTION))
		,m_aSelectAll		(this, ResId(PB_SELECTALL))
		,m_aSelectNone		(this, ResId(PB_SELECTNONE))
	{
		m_aSelectAll.SetClickHdl(LINK(this, OFormImportPage, OnSelectAll));
		m_aSelectNone.SetClickHdl(LINK(this, OFormImportPage, OnSelectNone));
		m_aObjectList.SetSelectHdl(LINK(this, OFormImportPage, OnEntrySelected));
		m_aObjectList.EnableMultiSelection(sal_True);
	}

	//---------------------------------------------------------------------
	sal_Bool OObjectSelectionPage::determineNextButtonState()
	{
		return (0 != m_aObjectList.GetSelectEntryCount()) && OImportPage::determineNextButtonState();
	}

	//---------------------------------------------------------------------
	void OObjectSelectionPage::checkItems(const StringArray& _rChecked)
	{
		m_aObjectList.SetNoSelection();
		for	(	ConstStringArrayIterator aLoop = _rChecked.begin();
				aLoop != _rChecked.end();
				++aLoop
			)
		{
			m_aObjectList.SelectEntry(*aLoop);
		}
		implCheckNextButton();
	}

	//---------------------------------------------------------------------
	void OObjectSelectionPage::getCheckedItems(StringArray& _rChecked)
	{
		_rChecked.clear();

		sal_uInt16 nSelectCount = m_aObjectList.GetSelectEntryCount();
		for (sal_uInt16 i=0; i<nSelectCount; ++i)
			_rChecked.push_back(m_aObjectList.GetSelectEntry(i));
	}

	//---------------------------------------------------------------------
	void OObjectSelectionPage::fillList(const StringArray& _rArray)
	{
		m_aObjectList.Clear();

		for	(	ConstStringArrayIterator aLoop = _rArray.begin();
				aLoop != _rArray.end();
				++aLoop
			)
		{
			m_aObjectList.InsertEntry(*aLoop);
		}
		implCheckNextButton();
	}

	//---------------------------------------------------------------------
	void OObjectSelectionPage::adjustZOrder()
	{
		m_aSelectNone.SetZOrder(NULL, WINDOW_ZORDER_LAST);
		m_aSelectAll.SetZOrder(&m_aSelectNone, WINDOW_ZORDER_BEFOR);
		m_aObjectList.SetZOrder(&m_aSelectAll, WINDOW_ZORDER_BEFOR);
		m_aFrame.SetZOrder(&m_aSelectAll, WINDOW_ZORDER_BEFOR);
	}

	//---------------------------------------------------------------------
	sal_Bool OObjectSelectionPage::checkSelection(const StringArray& _rChecked, Window* _pMessagParent)
	{
		sal_Bool bValid = (0 != _rChecked.size());
		if (!bValid && _pMessagParent)
		{
			ErrorBox aError(_pMessagParent, WB_OK, String(ModuleRes(RID_STR_NEEDOBJECTSELECTION)));
			aError.Execute();
		}
		return bValid;
	}

	//---------------------------------------------------------------------
	IMPL_LINK( OObjectSelectionPage, OnSelectAll, PushButton*, NOTINTERESTEDIN )
	{
		m_aObjectList.SetNoSelection();
		for (sal_uInt16 i=0; i<m_aObjectList.GetEntryCount(); ++i)
			m_aObjectList.SelectEntryPos(i);
		implCheckNextButton();
		getDialog()->currentModified();
		return 0L;
	}

	//---------------------------------------------------------------------
	IMPL_LINK( OObjectSelectionPage, OnSelectNone, PushButton*, NOTINTERESTEDIN )
	{
		m_aObjectList.SetNoSelection();
		implCheckNextButton();
		getDialog()->currentModified();
		return 0L;
	}

	//---------------------------------------------------------------------
	IMPL_LINK( OObjectSelectionPage, OnEntrySelected, ListBox*, NOTINTERESTEDIN )
	{
		implCheckNextButton();
		getDialog()->currentModified();
		return 0L;
	}

	//=====================================================================
	//= OFormImportPage
	//=====================================================================
	//---------------------------------------------------------------------
	OFormImportPage::OFormImportPage( OImportSdbDialog* _pParent )
		:OObjectSelectionPage(_pParent, ModuleRes(RID_PAGE_FORMIMPORT))
		,m_aPathLabel		(this, ResId(FT_FORMDESTPATH))
		,m_aPath			(this, ResId(CMB_FORMDESTPATH))
		,m_aBrowsePath		(this, ResId(PB_BROWSEFORMPATH))
		,m_aFormListLabel	(this, ResId(FT_FORMLIST))
	{
		FreeResource();

		m_aPath.SetOnlyDirectories();
		m_aPath.SetDropDownLineCount(10);

		adjustZOrder();

		m_aBrowsePath.SetClickHdl(LINK(this, OFormImportPage, OnBrowsePath));
		m_aPath.SetModifyHdl(LINK(this, OFormImportPage, OnPathModified));
	}

	//---------------------------------------------------------------------
	void OFormImportPage::ActivatePage()
	{
		OObjectSelectionPage::ActivatePage();

		m_aPath.GrabFocus();
	}

	//---------------------------------------------------------------------
	void OFormImportPage::initializePage()
	{
		OObjectSelectionPage::initializePage();

		// initialize from the settings
		m_aPath.SetText(getSettings().sFormImportPath);

		// fill the query list
		StringArray aForms;
		getSdbInfo().getFormNames(aForms);
		fillList(aForms);
		// select the queries
		checkItems(getSettings().aImportForms);
	}

	//---------------------------------------------------------------------
	sal_Bool OFormImportPage::isValid(const OImportSettings& _rSettings, Window* _pMessagParent)
	{
		::rtl::OUString sSystemNotationPath = _rSettings.sFormImportPath;
		// create an UCB content for the path
		::ucb::Content aDirectory;
		sal_Bool bIsFolder = sal_False;
		try
		{
			// get the file url for the path
			OFileNotation aTransformer(sSystemNotationPath, OFileNotation::N_SYSTEM);
			aDirectory = ::ucb::Content(aTransformer.get(OFileNotation::N_URL), Reference< ::com::sun::star::ucb::XCommandEnvironment >());
			bIsFolder = aDirectory.isFolder();
		}
		catch(Exception& e)
		{
			if (_pMessagParent)
			{
				String sErrorMessage(ModuleRes(RID_STR_COULDNOTACCESSDIR));
				sErrorMessage.SearchAndReplaceAscii("$path$", sSystemNotationPath);
				if (e.Message.getLength())
				{
					String sUCBError(ModuleRes(RID_STR_UCBERROR));
					sUCBError.SearchAndReplaceAscii("$error$", e.Message);
					sErrorMessage += sUCBError;
				}
				ErrorBox aError(_pMessagParent, WB_OK, sErrorMessage);
				aError.Execute();
			}
			return sal_False;
		}

		// check if the content refers to a folder
		if (!bIsFolder)
		{
			if (_pMessagParent)
			{
				ErrorBox aError(_pMessagParent, WB_OK, String(ModuleRes(RID_STR_NEEDPATHSELECTION)));
				aError.Execute();
			}
			return sal_False;
		}

		if (!OObjectSelectionPage::checkSelection(_rSettings.aImportForms, _pMessagParent))
			return sal_False;

		return sal_True;
	}

	//---------------------------------------------------------------------
	sal_Bool OFormImportPage::commitPage(COMMIT_REASON _eReason)
	{
		if (!OObjectSelectionPage::commitPage(_eReason))
			return sal_False;

		// fill the settings
		getSettings().sFormImportPath = m_aPath.GetText();
		getCheckedItems(getSettings().aImportForms);

		if (CR_TRAVEL_PREVIOUS != _eReason)
			if (!isValid(getSettings(), CR_VALIDATE_NOUI != _eReason ? GetParent() : NULL))
				return sal_False;

		return sal_True;
	}

	//---------------------------------------------------------------------
	sal_Bool OFormImportPage::determineNextButtonState()
	{
		return OObjectSelectionPage::determineNextButtonState() && (0 != m_aPath.GetText().Len());
	}

	//---------------------------------------------------------------------
	IMPL_LINK( OFormImportPage, OnPathModified, Edit*, NONTERESTEDIN )
	{
		implCheckNextButton();
		return 0L;
	}

	//---------------------------------------------------------------------
	IMPL_LINK( OFormImportPage, OnBrowsePath, PushButton*, NOTINTERESTEDIN )
	{
		try
		{
			::rtl::OUString sFolderPickerService = ::rtl::OUString::createFromAscii("com.sun.star.ui.dialogs.FolderPicker");
			Reference< XFolderPicker > xFolderPicker(getORB()->createInstance(sFolderPickerService), UNO_QUERY);
			if (!xFolderPicker.is())
			{
				ShowServiceNotAvailableError(getDialog(), sFolderPickerService, sal_True);
				return 1L;
			}

			String sPath = m_aPath.GetText();
			if (sPath.Len())
			{
				OFileNotation aTransformer(sPath, OFileNotation::N_SYSTEM);
				xFolderPicker->setDisplayDirectory(aTransformer.get(OFileNotation::N_URL));
			}

			if (xFolderPicker->execute())
			{
				// set the text in system notation
				OFileNotation aTransformer(xFolderPicker->getDirectory(), OFileNotation::N_URL);
				m_aPath.SetText(aTransformer.get(OFileNotation::N_SYSTEM));
			}
		}
		catch(const Exception&)
		{
			DBG_ERROR("OFormImportPage::OnBrowsePath: caught an exception while browsing for the path!");
		}

		return 0L;
	}

	//=====================================================================
	//= OQueryImportPage
	//=====================================================================
	//---------------------------------------------------------------------
	OQueryImportPage::OQueryImportPage( OImportSdbDialog* _pParent )
		:OObjectSelectionPage(_pParent, ModuleRes(RID_PAGE_QUERYIMPORT))
		,m_aDSLine			(this, ResId(FL_QUERYDESTINATION))
		,m_aDSSelectionLabel(this, ResId(FT_QUERY_DSTARGET))
		,m_aDSSelection		(this, ResId(LB_TARGET_DS))
		,m_aDSSelectionDesc	(this, ResId(FT_INSERTINTODESC))
		,m_aLabel			(this, ResId(FT_QUERYSELECTION))
		,m_sInsertIntoNewDS	(ResId(STR_INSERTINTO_NEW))
	{
		FreeResource();

		adjustZOrder();

		m_aDSSelection.SetDropDownLineCount(10);
		m_aDSSelection.SetSelectHdl(LINK(this, OQueryImportPage, OnDSSelected));
	}

	//---------------------------------------------------------------------
	IMPL_LINK( OQueryImportPage, OnDSSelected, ListBox*, NONTERESTEDIN )
	{
		implDSSelected(sal_True);
		return 0L;
	}

	//---------------------------------------------------------------------
	void OQueryImportPage::implDSSelected(sal_Bool _bBroadcast)
	{
		// display a discription if the "<new datasource>" entry is selected
		if ((0 == m_aDSSelection.GetSelectEntryPos()) && getSettings().bCreateDatasource)
			m_aDSSelectionDesc.SetText(m_sInsertIntoNewDS);
		else
			m_aDSSelectionDesc.SetText(String());

		implCheckNextButton();
		if (_bBroadcast)
			getDialog()->currentModified();
	}

	//---------------------------------------------------------------------
	sal_Bool OQueryImportPage::determineNextButtonState()
	{
		sal_Bool bValidQueryDestination = 0 != m_aDSSelection.GetSelectEntry().Len();
		return bValidQueryDestination && OObjectSelectionPage::determineNextButtonState();
	}

	//---------------------------------------------------------------------
	void OQueryImportPage::ActivatePage()
	{
		OObjectSelectionPage::ActivatePage();
		m_aDSSelection.GrabFocus();
	}

	//---------------------------------------------------------------------
	void OQueryImportPage::initializePage()
	{
		OObjectSelectionPage::initializePage();

		OImportSettings& rSettings = getSettings();

		// fill the data source namess
		m_aDSSelection.Clear();
		const StringBag& rDSNames = getDialog()->getDatasourceNames();
		for	(	ConstStringBagIterator aLoop = rDSNames.begin();
				aLoop != rDSNames.end();
				++aLoop
			)
		{
			m_aDSSelection.InsertEntry(*aLoop);
		}

		// initial selection of the data source name
		m_aDSSelection.SelectEntry(rSettings.sQueryDestinationDS);
		if (rSettings.bCreateDatasource)
		{
			m_aDSSelection.InsertEntry(String(ModuleRes(RID_STR_NEWDATASOURCE)), 0);
			if (0 == rSettings.sQueryDestinationDS.Len())
			{
				m_aDSSelection.SelectEntryPos(0);
			}
		}
		implDSSelected(sal_False);

		// fill the query list
		StringArray aQueries;
		getSdbInfo().getQueryNames(aQueries);
		fillList(aQueries);
		// select the queries
		checkItems(rSettings.aImportQueries);
	}

	//---------------------------------------------------------------------
	sal_Bool OQueryImportPage::isValid(const OImportSettings& _rSettings, Window* _pMessagParent)
	{
		sal_Bool bInvalidDSSelection =
				(	(0 == _rSettings.sQueryDestinationDS.Len())		// no valid data source target
				&&	!_rSettings.bCreateDatasource					// but we need one, as we're not creating a new DS
				);

		if (bInvalidDSSelection && _pMessagParent)
		{
			ErrorBox aError(_pMessagParent, WB_OK, String(ModuleRes(RID_STR_NEEDDSTARGET)));
			aError.Execute();
			return sal_False;
		}

		sal_Bool bValidObjectSelection = OObjectSelectionPage::checkSelection(_rSettings.aImportQueries, _pMessagParent);

		return !bInvalidDSSelection && bValidObjectSelection;
	}

	//---------------------------------------------------------------------
	sal_Bool OQueryImportPage::commitPage(COMMIT_REASON _eReason)
	{
		if (!OObjectSelectionPage::commitPage(_eReason))
			return sal_False;

		OImportSettings& rSettings = getSettings();
		if ((0 == m_aDSSelection.GetSelectEntryPos()) && rSettings.bCreateDatasource)
			// the "new data source" entry has been selected
			rSettings.sQueryDestinationDS = String();
		else
			rSettings.sQueryDestinationDS = m_aDSSelection.GetSelectEntry();

		getCheckedItems(rSettings.aImportQueries);

		if (CR_TRAVEL_PREVIOUS != _eReason)
			if (!isValid(rSettings, CR_VALIDATE_NOUI != _eReason ? GetParent() : NULL))
				return sal_False;

		return sal_True;
	}

	//=====================================================================
	//= OFinalizationPage
	//=====================================================================
	//---------------------------------------------------------------------
	OFinalizationPage::OFinalizationPage( OImportSdbDialog* _pParent )
		:OImportPage(_pParent, ModuleRes(RID_PAGE_FINALIZATION))
		,m_aStatisticsFrame		(this, ResId(FL_STATISTICS))
		,m_aSdbSelectionLabel	(this, ResId(FT_SDBSELECTION))
		,m_aSdbSelection		(this, ResId(ET_SDBSELECTION))
		,m_aQueriesLabel		(this, ResId(FT_QUERIES))
		,m_aQueriesNumbers		(this, ResId(FT_QUERIES_NUMBERS))
		,m_aFormsLabel			(this, ResId(FT_FORMS))
		,m_aFormsNumbers		(this, ResId(FT_FORMS_NUMBERS))
		,m_aFormsDestinationLabel(this, ResId(FT_FORM_DESTINATION))
		,m_aFormsDestination	(this, ResId(ET_FORM_DESTINATION))
		,m_aDSNFrame			(this, ResId(FL_DSN))
		,m_aDSNLabel			(this, ResId(FT_DSN))
		,m_aDSN					(this, ResId(ET_DSN))
		,m_aAdministration		(this, ResId(CB_ADMINISTRATE))
		,m_aMessage				(this, ResId(FT_MESSAGE))
		,m_sSelectionCount(ResId(STR_SELECTIONCOUNT))
		,m_sExistenceMessage(ResId(STR_NAMEISUSED))
		,m_bMovedControlsUp(sal_False)
	{
		FreeResource();

		m_aSdbSelection.SetUniqueId(UID_DBIWIZARD_SOURCEFILE);
		m_aQueriesNumbers.SetUniqueId(UID_DBIWIZARD_QUERIES);
		m_aFormsNumbers.SetUniqueId(UID_DBIWIZARD_FORMS);
		m_aFormsDestination.SetUniqueId(UID_DBIWIZARD_FORMS_SAVETO);

		m_aDSN.SetModifyHdl(LINK(this, OFinalizationPage, OnNewDsnName));
	}

	//---------------------------------------------------------------------
	void OFinalizationPage::ActivatePage()
	{
		OImportPage::ActivatePage();
		m_aDSN.GrabFocus();

		getDialog()->enableButtons(WZB_NEXT, sal_False);
		implCheckDsnName();
	}

	//---------------------------------------------------------------------
	void OFinalizationPage::DeactivatePage()
	{
		OImportPage::DeactivatePage();
		getDialog()->enableButtons(WZB_NEXT, sal_True);
	}

	//---------------------------------------------------------------------
	void OFinalizationPage::implMoveControls(const sal_Bool _bUp)
	{
		if (_bUp == m_bMovedControlsUp)
			return;

		m_bMovedControlsUp = _bUp;
		
		// hide (or show) the "destination directory" line for the forms
		m_aFormsDestinationLabel.Show(!_bUp);
		m_aFormsDestination.Show(!_bUp);

		// and move all other controls up (or down)
		Size aMove(LogicToPixel(Size(0, 8 + 3), MAP_APPFONT));
		if (!_bUp)
			aMove.Height() = -aMove.Height();
		Control* pControlsToMove[] = {
			&m_aDSNFrame, &m_aDSNLabel, &m_aDSN, &m_aAdministration, &m_aMessage
		};
		for (sal_Int32 i=0; i<sizeof(pControlsToMove)/sizeof(pControlsToMove[0]); ++i)
		{
			Point aPos = pControlsToMove[i]->GetPosPixel();
			aPos.Y() -= aMove.Height();
			pControlsToMove[i]->SetPosPixel(aPos);
		}
	}

	//---------------------------------------------------------------------
	void OFinalizationPage::initializePage()
	{
		OImportPage::initializePage();

		// initialize from the settings
		OImportSettings& rSettings = getSettings();
		m_aSdbSelection.SetText(rSettings.sImportFile);				// readonly display
		m_aFormsDestination.SetText(rSettings.sFormImportPath);		// readonly display

		implSetNumbers(&m_aQueriesNumbers, rSettings.bImportQueries ? rSettings.aImportQueries.size() : 0, getSdbInfo().getQueryCount());
		implSetNumbers(&m_aFormsNumbers, rSettings.bImportForms ? rSettings.aImportForms.size() : 0, getSdbInfo().getFormCount());
		implMoveControls(0 == rSettings.aImportForms.size() || !rSettings.bImportForms || 0 == getSdbInfo().getFormCount());

		m_aDSN.SetText(rSettings.bCreateDatasource ? rSettings.sDatasourceName : String());
		m_aAdministration.Check(rSettings.bAdministrateNewDS);

		m_aDSNFrame.Enable(rSettings.bCreateDatasource);
		m_aDSNLabel.Enable(rSettings.bCreateDatasource);
		m_aDSN.Enable(rSettings.bCreateDatasource);
		m_aAdministration.Enable(rSettings.bCreateDatasource);

		implCheckDsnName();
	}

	//---------------------------------------------------------------------
	sal_Bool OFinalizationPage::commitPage(COMMIT_REASON _eReason)
	{
		if (!OImportPage::commitPage(_eReason))
			return sal_False;

		OImportSettings& rSettings = getSettings();
		rSettings.sDatasourceName = m_aDSN.GetText();
		rSettings.bAdministrateNewDS = m_aAdministration.IsChecked();

		sal_Bool bValid = sal_True;
		bValid &= implCheckDsnName();

		if ((CR_TRAVEL_PREVIOUS != _eReason) && !bValid)
			return sal_False;

		return sal_True;
	}

	//---------------------------------------------------------------------
	sal_Bool OFinalizationPage::isValid(const OImportSettings& _rSettings, const StringBag& _rDSNames)
	{
		sal_Bool bExistent = exists(_rSettings.sDatasourceName, _rDSNames);
		sal_Bool bValid = 
			(	!bExistent									// (name not used AND name not empty)
			&&	(0 != _rSettings.sDatasourceName.Len())		//
			)												// OR
			||												//
			!_rSettings.bCreateDatasource;					// we're not going to create a data source

		return bValid;
	}

	//---------------------------------------------------------------------
	sal_Bool OFinalizationPage::implCheckDsnName()
	{
		sal_Bool bIsValid = isValid(getSettings(), getDialog()->getDatasourceNames());

		sal_Bool bExistent = exists(getSettings().sDatasourceName, getDialog()->getDatasourceNames());
		m_aMessage.SetText(bExistent ? m_sExistenceMessage : String());

		return bIsValid;
	}

	//---------------------------------------------------------------------
	IMPL_LINK( OFinalizationPage, OnNewDsnName, Edit*, NOTINTERESTEDIN )
	{
		// check if the name is used already
		implCheckDsnName();
		getDialog()->currentModified();
		return 0L;
	}

	//---------------------------------------------------------------------
	void OFinalizationPage::implSetNumbers(FixedText* _pControl, sal_Int32 _nSelected, sal_Int32 _nOverall)
	{
		String sNewText;
		if (!_nOverall)
		{
			sNewText = String(ModuleRes(RID_STR_NONE));
		}
		else if (!_nSelected)
		{
			sNewText = String(ModuleRes(RID_STR_NDONOTIMPORT));
		}
		else
		{
			sNewText = String(m_sSelectionCount);
			sNewText.SearchAndReplaceAscii("$selected$", String::CreateFromInt32(_nSelected));
			sNewText.SearchAndReplaceAscii("$overall$", String::CreateFromInt32(_nOverall));
		}

		_pControl->SetText(sNewText);
	}

	//---------------------------------------------------------------------
	sal_Bool OFinalizationPage::determineNextButtonState()
	{
		return sal_False;
	}

//.........................................................................
}	// namespace dbi
//.........................................................................

/*************************************************************************
 * history:
 *	$Log: importpages.cxx,v $
 *	Revision 1.18  2001/10/12 12:24:52  fs
 *	#91600# HID_DBIWIZARD_FILESELECTION
 *	
 *	Revision 1.17  2001/08/23 15:30:04  fs
 *	#90010# use a filter name for *.sdb files
 *	
 *	Revision 1.16  2001/08/21 14:41:31  fs
 *	#91329# XFolderPicker::getDirectory instead of XFolderPicker::getDisplayDirectory
 *	
 *	Revision 1.15  2001/06/28 09:10:48  fs
 *	#88477# use URL notation when browsing for a path
 *	
 *	Revision 1.14  2001/06/20 08:24:27  fs
 *	#88477# ui.FolderPicker -> ui.dialogs.FolderPicker
 *	
 *	Revision 1.13  2001/06/15 09:49:46  fs
 *	#86986# moved css/ui/* to css/ui/dialogs/*
 *	
 *	Revision 1.12  2001/06/07 14:18:03  fs
 *	#87892# removed OnCheckboxGot-/-LostFocus / added Notify - improved help text handling
 *	
 *	Revision 1.11  2001/05/29 15:13:07  fs
 *	#86199# the help window is a (scrollable, on request) MultiLineEdit instead of a FixedText
 *	
 *	Revision 1.10  2001/05/11 10:38:06  fs
 *	replaced the SfxFileDialog
 *	
 *	Revision 1.9  2001/04/20 17:38:06  fs
 *	#85461# move the SaveTo related controls in all necessary cases
 *	
 *	Revision 1.8  2001/04/20 17:32:30  fs
 *	#86199# move the explanation up to the browse button, if necessary (vertical text size)
 *	
 *	Revision 1.7  2001/04/09 14:16:37  fs
 *	#85206# extra page for handling $(USER) etc
 *	
 *	Revision 1.6  2001/03/29 11:02:00  fs
 *	#85461# corrected the summary page
 *	
 *	Revision 1.5  2001/03/20 15:47:43  fs
 *	#85200# added missing help ids
 *	
 *	Revision 1.4  2001/03/05 15:17:06  fs
 *	#84642# implMoveControls
 *	
 *	Revision 1.3  2001/03/02 16:57:14  fs
 *	now using the OWizardMachine from svtools / #84575# / minor layout changes
 *	
 *	Revision 1.2  2001/02/20 10:30:55  fs
 *	added pictures to the pages
 *	
 *	Revision 1.1  2001/02/12 07:13:16  fs
 *	initial checkin - importing StarOffice 5.2 database files
 *	
 *
 *	Revision 1.0 01.02.01 08:59:13  fs
 ************************************************************************/

