/*************************************************************************
 *
 *  $RCSfile: importdialog.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: fs $ $Date: 2001/04/09 14:16:37 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc..
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _EXTENSIONS_DBI_IMPORTDIALOG_HXX_
#define _EXTENSIONS_DBI_IMPORTDIALOG_HXX_

//#ifndef _EXTENSIONS_DBI_WIZARDSTATEMACHINE_HXX_
//#include "wizardstatemachine.hxx"
//#endif
#ifndef _SV_TABPAGE_HXX 
#include <vcl/tabpage.hxx>
#endif
#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XNAMEACCESS_HPP_
#include <com/sun/star/container/XNameAccess.hpp>
#endif
#ifndef _EXTENSIONS_DBI_IMPORTSETTINGS_HXX_
#include "importsettings.hxx"
#endif
#ifndef _EXTENSIONS_DBI_IMPORTPAGES_HXX_
#include "importpages.hxx"
#endif
#ifndef _EXTENSIONS_DBI_SDBFILEACCESS_HXX_
#include "sdbfileaccess.hxx"
#endif

//.........................................................................
namespace dbi
{
//.........................................................................
	
	//=====================================================================
	//= OImportSdbDialog
	//=====================================================================
	typedef ::svt::OWizardMachine OImportSdbDialog_Base;
	class OImportSdbDialog : public OImportSdbDialog_Base
	{
	protected:
		::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >
										m_xORB;
		::com::sun::star::uno::Reference< ::com::sun::star::container::XNameAccess >
										m_xDatasources;

		OImportSettings					m_aSettings;
		::vos::ORef< OSdbFileAccess	>	m_pDatabaseFile;
		StringBag						m_aDatasources;
		UInt16Array						m_aInvalidPages;

	public:
		OImportSdbDialog(
			Window* _pParent,
			const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >& _rxORB);

		// helper
		::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >
								getORB() { return m_xORB; }
		OImportSettings&		getSettings() { return m_aSettings; }
		const OSdbFileAccess&	getSdbInfo() const { return *m_pDatabaseFile; }
		const StringBag&		getDatasourceNames() const { return m_aDatasources; }

		class PathWriteAccess { friend class ODsnAdjustmentPage; };
		void					adjustDsnPath( const String& _rNewPath, const PathWriteAccess& );

		void	currentModified();

		void	doOpen();

	protected:
		// OWizardMachine overridables
		virtual ::svt::OWizardPage*	createPage(sal_uInt16 _nState);
		virtual	void				enterState(sal_uInt16 _nState);
		virtual	sal_Bool			leaveState(sal_uInt16 _nState);
		virtual sal_uInt16			determineNextState(sal_uInt16 _nCurrentState);
		virtual sal_Bool			onFinish(sal_Int32 _nResult);

	private:
		void		implCollectDatasources();
		sal_Bool	implOpen();
		void		implCheckFinishButton();

		void		checkPageDependencies(sal_uInt16 _nModifiedPage, ::svt::OWizardPage* _pModifiedPage);

		void		setValid(sal_uInt16 _nState);
		void		setInvalid(sal_uInt16 _nState);
		sal_Bool	isValid(sal_uInt16 _nState);
	};

//.........................................................................
}	// namespace dbi
//.........................................................................

#endif // _EXTENSIONS_DBI_IMPORTDIALOG_HXX_

/*************************************************************************
 * history:
 *	$Log: importdialog.hxx,v $
 *	Revision 1.3  2001/04/09 14:16:37  fs
 *	#85206# extra page for handling $(USER) etc
 *	
 *	Revision 1.2  2001/03/02 16:57:14  fs
 *	now using the OWizardMachine from svtools / #84575# / minor layout changes
 *	
 *	Revision 1.1  2001/02/12 07:12:55  fs
 *	initial checkin - importing StarOffice 5.2 database files
 *	
 *
 *	Revision 1.0 30.01.01 16:24:31  fs
 ************************************************************************/

