/*************************************************************************
 *
 *  $RCSfile: fixededit.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: fs $ $Date: 2001/02/20 10:30:55 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc..
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _EXTENSIONS_DBI_FIXEDEDIT_HXX_
#define _EXTENSIONS_DBI_FIXEDEDIT_HXX_

#ifndef _SV_EDIT_HXX 
#include <vcl/edit.hxx>
#endif
#ifndef _SVEDIT_HXX 
#include <svtools/svmedit.hxx>
#endif

//.........................................................................
namespace dbi
{
//.........................................................................

	//=====================================================================
	//= GrayedControl
	//=====================================================================
	class GrayedControl
	{
	protected:
		GrayedControl() { }

	protected:
		void implSetColors(Control* _pControl, sal_Bool _bGray = sal_True);
	};

	//=====================================================================
	//= FixedEdit
	//=====================================================================
	/** a readonly Edit which looks (i.e. is colored like) a FixedText
	*/
	class FixedEdit : public Edit, public GrayedControl
	{
	public:
		FixedEdit( Window* _pParent, const ResId& _rResId );
	};

	//=====================================================================
	//= FixedMultiEdit
	//=====================================================================
	/** a readonly Edit which looks (i.e. is colored like) a FixedText
	*/
	class FixedMultiEdit : public MultiLineEdit, public GrayedControl
	{
	public:
		FixedMultiEdit( Window* _pParent, const ResId& _rResId );
	};

	//=====================================================================
	//= AutoFixedEdit
	//=====================================================================
	class AutoFixedEdit : public FixedEdit
	{
	public:
		AutoFixedEdit( Window* _pParent, const ResId& _rResId );

	protected:
		virtual void StateChanged( StateChangedType nStateChange );
	};
//.........................................................................
}	// namespace dbi
//.........................................................................

#endif // _EXTENSIONS_DBI_FIXEDEDIT_HXX_

/*************************************************************************
 * history:
 *	$Log: fixededit.hxx,v $
 *	Revision 1.2  2001/02/20 10:30:55  fs
 *	added pictures to the pages
 *	
 *	Revision 1.1  2001/02/12 07:12:39  fs
 *	initial checkin - importing StarOffice 5.2 database files
 *	
 *
 *	Revision 1.0 31.01.01 15:57:40  fs
 ************************************************************************/

