/*************************************************************************
 *
 *  $RCSfile: asyncadmin.hxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: fs $ $Date: 2001/02/12 07:10:24 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc..
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _EXTENSIONS_DBI_ASYNCADMIN_HXX_
#define _EXTENSIONS_DBI_ASYNCADMIN_HXX_

#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _LINK_HXX
#include <tools/link.hxx>
#endif
#ifndef _VOS_REFERNCE_HXX_ 
#include <vos/refernce.hxx>
#endif
#ifndef _OSL_MUTEX_HXX_ 
#include <osl/mutex.hxx>
#endif

//.........................................................................
namespace dbi
{
//.........................................................................

	//=====================================================================
	//= OAsyncAdminDialog
	//=====================================================================
	class OAsyncAdminDialog : public ::vos::OReference
	{
	protected:
		::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >
						m_xORB;
		sal_Bool		m_bExecuting;
		::osl::Mutex	m_aMutex;
		::rtl::OUString	m_sInitialSelection;

	private:
		~OAsyncAdminDialog() { }

	public:
		OAsyncAdminDialog(
			const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >& _rxORB,
			const ::rtl::OUString& _rInitialSelection);

		// The object will acquire itself, post itself a link, and upon execution of this link,
		// the admin dialog will be executed.
		// After this, the object will release itself
		void execute();

	protected:
		DECL_LINK( OnAsyncExecute, void* );
	};

//.........................................................................
}	// namespace dbi
//.........................................................................

#endif // _EXTENSIONS_DBI_ASYNCADMIN_HXX_

/*************************************************************************
 * history:
 *	$Log: asyncadmin.hxx,v $
 *	Revision 1.1  2001/02/12 07:10:24  fs
 *	initial checkin - importing StarOffice 5.2 database files
 *	
 *
 *	Revision 1.0 08.02.01 10:59:42  fs
 ************************************************************************/

