/*************************************************************************
 *
 *  $RCSfile: unofilter.cxx,v $
 *
 *  $Revision: 1.1.8.1 $
 *
 *  last change: $Author: mh $ $Date: 2002/05/31 14:43:10 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc..
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef DBAUI_UNOFILTER_HXX
#include "unofilter.hxx"
#endif
#ifndef _DBU_REGHELPER_HXX_
#include "dbu_reghelper.hxx"
#endif
#ifndef _COM_SUN_STAR_SDBCX_XCOLUMNSSUPPLIER_HPP_ 
#include <com/sun/star/sdbcx/XColumnsSupplier.hpp>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XNAMEACCESS_HPP_ 
#include <com/sun/star/container/XNameAccess.hpp>
#endif
#ifndef _COM_SUN_STAR_CONNECTION_XCONNECTION_HPP_ 
#include <com/sun/star/connection/XConnection.hpp>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XNAMED_HPP_ 
#include <com/sun/star/container/XNamed.hpp>
#endif
#ifndef DBAUI_QUERYFILTER_HXX
#include "queryfilter.hxx"
#endif
#ifndef DBACCESS_SHARED_DBUSTRINGS_HRC
#include "dbustrings.hrc"
#endif

extern "C" void SAL_CALL createRegistryInfo_ORowsetFilterDialog()
{
	static ::dbaui::OMultiInstanceAutoRegistration< ::dbaui::ORowsetFilterDialog > aAutoRegistration;
}

//.........................................................................
namespace dbaui
{
//.........................................................................

#define PROPERTY_ID_QUERYCOMPOSER		100
#define PROPERTY_ID_ROWSET				101
#define PROPERTY_ID_DEFAULTFIELD		102

	IMPLEMENT_CONSTASCII_USTRING( PROPERTY_QUERYCOMPOSER,	"QueryComposer" );
	IMPLEMENT_CONSTASCII_USTRING( PROPERTY_ROWSET,			"RowSet" );
	IMPLEMENT_CONSTASCII_USTRING( PROPERTY_DEFAULTFIELD,	"DefaultFilterColumn" );

	using namespace ::com::sun::star::uno;
	using namespace ::com::sun::star::lang;
	using namespace ::com::sun::star::beans;
	using namespace ::com::sun::star::container;
	using namespace ::com::sun::star::sdbcx;
	using namespace ::com::sun::star::sdbc;
	using namespace ::com::sun::star::sdb;

	//=====================================================================
	//= ORowsetFilterDialog
	//=====================================================================
	//---------------------------------------------------------------------
	ORowsetFilterDialog::ORowsetFilterDialog(const Reference< XMultiServiceFactory >& _rxORB)
		:ORowsetFilterDialog_BASE( _rxORB )
	{
		registerProperty( PROPERTY_QUERYCOMPOSER, PROPERTY_ID_QUERYCOMPOSER, PropertyAttribute::TRANSIENT,
			&m_xComposer, ::getCppuType( &m_xComposer ) );
		registerProperty( PROPERTY_ROWSET, PROPERTY_ID_ROWSET, PropertyAttribute::TRANSIENT,
			&m_xRowSet, ::getCppuType( &m_xRowSet ) );
		registerProperty( PROPERTY_DEFAULTFIELD, PROPERTY_ID_DEFAULTFIELD, PropertyAttribute::TRANSIENT,
			&m_xField, ::getCppuType( &m_xField ) );
	}

	//---------------------------------------------------------------------
	ORowsetFilterDialog::~ORowsetFilterDialog()
	{
	}

	//---------------------------------------------------------------------
	IMPLEMENT_IMPLEMENTATION_ID( ORowsetFilterDialog )

	//---------------------------------------------------------------------
	IMPLEMENT_SERVICE_INFO1_STATIC( ORowsetFilterDialog, "com.sun.star.uno.comp.sdb.RowsetFilterDialog", "com.sun.star.uno.sdb.FilterDialog" )

	//---------------------------------------------------------------------
	IMPLEMENT_PROPERTYCONTAINER_DEFAULTS( ORowsetFilterDialog )

	//---------------------------------------------------------------------
	Dialog*	ORowsetFilterDialog::createDialog(Window* _pParent)
	{
		// obtain all the objects needed for the dialog
		Reference< XConnection > xConnection;
		Reference< XNameAccess > xColumns;
		::rtl::OUString sFieldName;
		try
		{
			// the connection the row set is working with
			Reference< XPropertySet > xRowsetProps( m_xRowSet, UNO_QUERY );
			if ( xRowsetProps.is() )
				xRowsetProps->getPropertyValue( PROPERTY_ACTIVECONNECTION ) >>= xConnection;

			// the columns of the row set
			Reference< XColumnsSupplier > xSuppColumns( m_xRowSet, UNO_QUERY );
			if ( xSuppColumns.is() )
				xColumns = xSuppColumns->getColumns();

			// the name of the field
			if ( m_xField.is() )
			{
				Reference< XNamed > xFieldName( m_xField, UNO_QUERY );
				if ( xFieldName.is() )
					sFieldName = xFieldName->getName();
				else
				{
					Reference< XPropertySet > xFieldProps( m_xField, UNO_QUERY );
					Reference< XPropertySetInfo > xFieldPropsInfo;
					if ( xFieldProps.is() )
						xFieldPropsInfo = xFieldProps->getPropertySetInfo();
					if ( xFieldPropsInfo.is() && xFieldPropsInfo->hasPropertyByName( PROPERTY_NAME ) )
						xFieldProps->getPropertyValue( PROPERTY_NAME ) >>= sFieldName;
				}
				OSL_ENSURE( sFieldName.getLength(), "ORowsetFilterDialog::createDialog: unable to obtain the name of the field!" );
			}
		}
		catch( const Exception& )
		{
			OSL_ENSURE( sal_False, "ORowsetFilterDialog::createDialog: caught an exception!" );
		}

		if	(	!xConnection.is()
			||	!m_xComposer.is()
			||	!xColumns.is()
			)
			// can't create the dialog if I have improper settings
			return NULL;

		return new DlgFilterCrit( _pParent, m_xORB, xConnection, m_xComposer, xColumns, sFieldName );
	}

	//---------------------------------------------------------------------
	void ORowsetFilterDialog::executedDialog( sal_Int16 _nExecutionResult )
	{
		ORowsetFilterDialog_BASE::executedDialog( _nExecutionResult );

		if ( _nExecutionResult && m_pDialog )
			static_cast< DlgFilterCrit* >( m_pDialog )->BuildWherePart();
	}

//.........................................................................
}	// namespace dbaui
//.........................................................................

/*************************************************************************
 * history:
 *	$Log: unofilter.cxx,v $
 *	Revision 1.1.8.1  2002/05/31 14:43:10  mh
 *	join: from SRC641
 *	
 *	Revision 1.2  2002/04/10 06:35:49  fs
 *	#98181# the filter dialog got a new ctor param
 *	
 *	Revision 1.1  2001/08/17 09:20:24  fs
 *	initial checkin - UNO wrapper for the filter dialog
 *	
 *
 *	Revision 1.0 17.08.01 08:55:46  fs
 ************************************************************************/

