/*************************************************************************
 *
 *  $RCSfile: filenotation.cxx,v $
 *
 *  $Revision: 1.8 $
 *
 *  last change: $Author: fs $ $Date: 2001/09/11 07:07:55 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc..
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _DBAUI_FILENOTATION_HXX_
#include "filenotation.hxx"
#endif
#ifndef _OSL_FILE_H_
#include <osl/file.h>
#endif
#ifndef _OSL_DIAGNOSE_H_
#include <osl/diagnose.h>
#endif
#ifndef _URLOBJ_HXX 
#include <tools/urlobj.hxx>
#endif

//.........................................................................
namespace dbaui
{
//.........................................................................

	//=====================================================================
	//= OFileNotation
	//=====================================================================
	//---------------------------------------------------------------------
	OFileNotation::OFileNotation( const ::rtl::OUString& _rFileOrPath )
	{
		construct( _rFileOrPath );
	}

	//---------------------------------------------------------------------
	OFileNotation::OFileNotation( const ::rtl::OUString& _rFileOrPath, NOTATION _eInputNotation )
	{
		// _eInputNotation is obsolete ... sinve we support hierarchy and wfs URLs, too, it would be way too much
		// to correct all callers, We simply detect the format every time ...
		construct( _rFileOrPath );
	}

	//---------------------------------------------------------------------
	void OFileNotation::construct( const ::rtl::OUString& _rFileOrPath )
	{
		sal_Bool bSuccess = sal_False;
		// URL notation?
		INetURLObject aParser( _rFileOrPath );
		switch ( aParser.GetProtocol() )
		{
			case INET_PROT_FILE:
				// file URL
				m_sFileURL = _rFileOrPath;
				osl_getSystemPathFromFileURL(m_sFileURL.pData, &m_sSystem.pData);
				bSuccess = sal_True;
				break;

			case INET_PROT_NOT_VALID:
				// assume system notation
				m_sSystem = _rFileOrPath;
				if ((osl_File_E_None != osl_getFileURLFromSystemPath(m_sSystem.pData, &m_sFileURL.pData)) && (0 == m_sFileURL.getLength()))
				{
					if (_rFileOrPath.getLength())
					{
						INetURLObject aSmartParser;
						aSmartParser.SetSmartProtocol(INET_PROT_FILE);
						if (aSmartParser.SetSmartURL(_rFileOrPath))
						{
							m_sFileURL = aSmartParser.GetMainURL(INetURLObject::NO_DECODE);
							osl_getSystemPathFromFileURL(m_sFileURL.pData, &m_sSystem.pData);
							bSuccess = sal_True;
						}
					}
				}
				else
					bSuccess = sal_True;
				break;

			default:
				// it's a known scheme, but no file-URL -> assume that bothe the URL representation and the
				// system representation are the URL itself
				m_sSystem = m_sFileURL = _rFileOrPath;
				bSuccess = sal_True;
				break;
		}

		OSL_ENSURE( bSuccess, "OFileNotation::OFileNotation: could not detect the format!" );
	}

	//---------------------------------------------------------------------
	::rtl::OUString OFileNotation::get(NOTATION _eOutputNotation)
	{
		switch (_eOutputNotation)
		{
			case N_SYSTEM: return m_sSystem;
			case N_URL: return m_sFileURL;
		}

		OSL_ENSURE(sal_False, "OFileNotation::get: inavlid enum value!");
		return ::rtl::OUString();
	}

//.........................................................................
}	// namespace dbaui
//.........................................................................

/*************************************************************************
 * history:
 *	$Log: filenotation.cxx,v $
 *	Revision 1.8  2001/09/11 07:07:55  fs
 *	#92027# added a ctor without notation - we always detect the format
 *	
 *	Revision 1.7  2001/07/27 05:54:14  fs
 *	#90267# remove TF_FILEURL
 *	
 *	Revision 1.6  2001/07/17 07:30:51  oj
 *	#89533# GetMainURL changed
 *	
 *	Revision 1.5  2001/05/16 11:44:14  fs
 *	#65293# osl changes are TF_FILEURL-, not SUPD-dependent
 *	
 *	Revision 1.4  2001/05/14 13:56:33  fs
 *	#86958# when given a SYSTEM path, do some magics in case the resulting file URL is empty
 *	
 *	Revision 1.3  2001/05/11 10:51:50  fs
 *	osl removed the support for normalized file names
 *	
 *	Revision 1.2  2001/05/08 09:55:35  fs
 *	added N_DETECT
 *	
 *	Revision 1.1  2001/04/26 11:54:44  fs
 *	initial checkin - file notation transformations
 *	
 *
 *	Revision 1.0 07.02.01 16:31:47  fs
 ************************************************************************/

