/*************************************************************************
 *
 *  $RCSfile: documentautolinker.cxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: fs $ $Date: 2001/04/26 11:54:24 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc..
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _DBAUI_DOCUMENTAUTOLINKER_HXX_
#include "documentautolinker.hxx"
#endif
#ifndef _COM_SUN_STAR_DOCUMENT_XEVENTBROADCASTER_HPP_ 
#include <com/sun/star/document/XEventBroadcaster.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XSINGLESERVICEFACTORY_HPP_ 
#include <com/sun/star/lang/XSingleServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_XPROPERTYSET_HPP_ 
#include <com/sun/star/beans/XPropertySet.hpp>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XCHILD_HPP_
#include <com/sun/star/container/XChild.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_DISPOSEDEXCEPTION_HDL_ 
#include <com/sun/star/lang/DisposedException.hdl>
#endif
#ifndef _OSL_DIAGNOSE_H_
#include <osl/diagnose.h>
#endif
#ifndef _URLOBJ_HXX 
#include <tools/urlobj.hxx>
#endif
#ifndef DBACCESS_SHARED_DBUSTRINGS_HRC
#include "dbustrings.hrc"
#endif

//......................................................................
namespace dbaui
{
//......................................................................

	using namespace ::com::sun::star;
	using namespace ::com::sun::star::uno;
	using namespace ::com::sun::star::lang;
	using namespace ::com::sun::star::frame;
	using namespace ::com::sun::star::beans;
	using namespace ::com::sun::star::document;
	using namespace ::com::sun::star::container;

	//==================================================================
	//= ODocumentAutoLinker
	//==================================================================
	//------------------------------------------------------------------
	ODocumentAutoLinker::ODocumentAutoLinker( const Reference< XModel >& _rxNewDocument, const Reference< XNameContainer >& _rxLinks )
		:m_xModel(_rxNewDocument)
		,m_xLinkCollection(_rxLinks)
	{
		// need the container for the links
		OSL_ENSURE(m_xLinkCollection.is(), "ODocumentAutoLinker::ODocumentAutoLinker: invalid model!");
		if (!m_xLinkCollection.is())
			// no sense ...
			return;

		// add as document event listener
		Reference< document::XEventBroadcaster > xBroadcaster(_rxNewDocument, UNO_QUERY);
		OSL_ENSURE(xBroadcaster.is(), "ODocumentAutoLinker::ODocumentAutoLinker: invalid model!");

		osl_incrementInterlockedCount(&m_refCount);
		if (xBroadcaster.is())
		{
			xBroadcaster->addEventListener(this);
		}
		osl_decrementInterlockedCount(&m_refCount);
		OSL_ENSURE(m_refCount > 0, "ODocumentAutoLinker::ODocumentAutoLinker: this is a memory leak!");

		// add as dispose listener to the links collection
		Reference< XChild > xCollectionAsChild(m_xLinkCollection, UNO_QUERY);
		if (xCollectionAsChild.is())
			m_xDataSource = Reference< XComponent >(xCollectionAsChild->getParent(), UNO_QUERY);
		OSL_ENSURE(m_xDataSource.is(), "ODocumentAutoLinker::ODocumentAutoLinker: data source is no component (or collection is no child)!");

		osl_incrementInterlockedCount(&m_refCount);
		if (m_xDataSource.is())
		{
			m_xDataSource->addEventListener(this);
		}
		osl_decrementInterlockedCount(&m_refCount);
	}

	//------------------------------------------------------------------
	ODocumentAutoLinker::~ODocumentAutoLinker()
	{
	}

	//------------------------------------------------------------------
	void ODocumentAutoLinker::implAutoLinkDocument( const ::rtl::OUString& _rURL )
	{
		// TODO: do this with an URLTransformer if possible ...??
		INetURLObject aParser;
		aParser.SetSmartProtocol(INET_PROT_FILE);
		aParser.SetSmartURL(_rURL);

		::rtl::OUString sName = aParser.getBase(INetURLObject::LAST_SEGMENT, true, INetURLObject::DECODE_WITH_CHARSET);

		try
		{
			// disambiguate the name (if necessary)
			if (m_xLinkCollection->hasByName(sName))
			{
				// disambiguate the name
				::rtl::OUString sBase = sName;
				const ::rtl::OUString sWhitespace = ::rtl::OUString::createFromAscii(" ");
				sal_Int32 i=1;
				for (; i<0x7FFFFFFF; ++i)
				{
					sName = sBase;
					sName += sWhitespace;
					sName += ::rtl::OUString::valueOf(i);
					if (!m_xLinkCollection->hasByName(sName))
						break;
				}
				if (i>=0x7FFFFFFF)
				{
					// did not find a name
					OSL_ENSURE(sal_False, "ODocumentAutoLinker::implAutoLinkDocument: did not find a free name!");
					return;
				}
			}

			// insert the new link object
			m_xLinkCollection->insertByName(sName, makeAny(_rURL));
		}
		catch(const DisposedException&)
		{
			// allowed. If somebody revokes a data source, without disposing it, the container is invalid
			// until the data source has been re-inserted in the context. If there is not intention
			// to re-insert the data souurce, we will never get the disposing event.
		}
		catch(const Exception&)
		{
			OSL_ENSURE(sal_False, "ODocumentAutoLinker::implAutoLinkDocument: caught an exception!");
		}
	}

	//------------------------------------------------------------------
	void SAL_CALL ODocumentAutoLinker::notifyEvent( const document::EventObject& _rEvent ) throw (RuntimeException)
	{
		::osl::ClearableMutexGuard aGuard(m_aMutex);

		::rtl::OUString sWhatsUp = _rEvent.EventName;
		if (0 == sWhatsUp.compareToAscii("OnSaveAsDone"))
		{
			try
			{
				// get the new URL of the document
#ifdef DBG_UTIL
				Reference< XModel > xDocModel(_rEvent.Source, UNO_QUERY);
				OSL_ENSURE(m_xModel.get() == xDocModel.get(), "ODocumentAutoLinker::notifyEvent: where did this come from?");
#endif
				if (m_xModel.is())
					implAutoLinkDocument(m_xModel->getURL());

				// detach
				implDetach(aGuard);
			}
			catch(const Exception&)
			{
				OSL_ENSURE(sal_False, "ODocumentAutoLinker::notifyEvent: caught an exception (did not add the link)!");
			}
		}
	}

	//------------------------------------------------------------------
	void ODocumentAutoLinker::implDetach( ::osl::ClearableMutexGuard& _rClearBeforeDestruction )
	{
		Reference< XInterface > xKeepMeAlive(*this);

		// stop listening at the document
		{
			Reference< XEventBroadcaster > xBroadcaster(m_xModel, UNO_QUERY);
			if (xBroadcaster.is())
				xBroadcaster->removeEventListener(this);
		}
		// stop listening at the data source
		{
			if (m_xDataSource.is())
				m_xDataSource->removeEventListener(this);
		}

		_rClearBeforeDestruction.clear();	// _before_ xKeepMeAlive is destroyed!
	}

	//------------------------------------------------------------------
	void SAL_CALL ODocumentAutoLinker::disposing( const lang::EventObject& _rEvent ) throw (RuntimeException)
	{
		::osl::ClearableMutexGuard aGuard(m_aMutex);

		Reference< XComponent > xSourceComponent(_rEvent.Source, UNO_QUERY);
		if (m_xDataSource.get() == xSourceComponent.get())
		{	// we're still listening (means the document has not been saved, yet),
			// but the data source we would insert the link into is beeing disposed
			// -> clear up
			implDetach(aGuard);
			return;
		}

#ifdef DBG_UTIL
		Reference< document::XEventBroadcaster > xEventSource(_rEvent.Source, UNO_QUERY);
		Reference< document::XEventBroadcaster > xListeningAt(m_xModel, UNO_QUERY);
		if (xEventSource.get() == xListeningAt.get())
		{
			// nothing to do: the object is beeing disposed while we're listening, this means
			// that the user didn't save it (if (s)he would have saved it, we would have removed ourself
			// as listener)
		}
		else
			OSL_ENSURE(sal_False, "ODocumentAutoLinker::disposing: where did this come from?");
#endif
	}

//......................................................................
}	// namespace dbaui
//......................................................................

/*************************************************************************
 * history:
 *	$Log: documentautolinker.cxx,v $
 *	Revision 1.1  2001/04/26 11:54:24  fs
 *	initial checkin - automatically bookmark data source associated documents
 *	
 *
 *	Revision 1.0 24.04.01 17:23:11  fs
 ************************************************************************/

