/*************************************************************************
 *
 *  $RCSfile: dsntypes.hxx,v $
 *
 *  $Revision: 1.8 $
 *
 *  last change: $Author: fs $ $Date: 2001/08/07 15:55:18 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc..
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _DBAUI_DSNTYPES_HXX_
#define _DBAUI_DSNTYPES_HXX_

#ifndef _TOOLS_RC_HXX
#include <tools/rc.hxx>
#endif
#ifndef _SFXPOOLITEM_HXX
#include <svtools/poolitem.hxx>
#endif
#ifndef _COMPHELPER_STLTYPES_HXX_
#include <comphelper/stl_types.hxx>
#endif

//.........................................................................
namespace dbaui
{
//.........................................................................

//=========================================================================
//= DATASOURCE_TYPE
//=========================================================================
/// known datasource types
enum DATASOURCE_TYPE
{
	DST_ADABAS = 0,		/// Adabas
	DST_JDBC,			/// generic JDBC
	DST_ODBC,			/// generic ODBC
	DST_DBASE,			/// dBase
	DST_TEXT,			/// plain text files
	DST_ADO,			/// ADO files
	DST_CALC,			/// spreadsheet files
	DST_ADDRESSBOOK,	/// address book 

	DST_UNKNOWN			/// unrecognized type
};

enum ADDRESSBOOK_TYPE
{
	ABT_MORK,			/// mozilla
	ABT_LDAP,			/// LDAP
	ABT_OUTLOOK,		/// Windows address book
	ABT_OE,				/// Outlook Express

	ABT_UNKNOWN			/// unrecognized type
};

//=========================================================================
//= ODsnTypeCollection
//=========================================================================
class ODsnTypeCollection : public Resource
{
protected:
	DECLARE_STL_VECTOR(String, StringVector);
	DECLARE_STL_VECTOR(DATASOURCE_TYPE, TypeVector);

	StringVector	m_aDsnTypesDisplayNames;	/// user readable names for the datasource types
	StringVector	m_aDsnPrefixes;				/// DSN prefixes which determine the type of a datasource
	TypeVector		m_aDsnTypes;				/// types of datasources we know

#ifdef DBG_UTIL
	sal_Int32		m_nLivingIterators;			/// just for debugging reasons, counts the living iterators
#endif

public:
	class TypeIterator;
	friend class ODsnTypeCollection::TypeIterator;

	ODsnTypeCollection();
	~ODsnTypeCollection();

	/// get the datasource type from a DSN string
	DATASOURCE_TYPE	getType(const String& _rDsn);

	/// get the datasource type display name from a DSN string
	String getTypeDisplayName(const String& _rDsn);

	/// get the datasource type display name from a DSN string
	String getTypeDisplayName(DATASOURCE_TYPE _eType);

	/// the the DSN prefix associated with a given type
	String getDatasourcePrefix(DATASOURCE_TYPE _eType);

	/// on a given string, cut the type prefix and return the result
	String cutPrefix(const String& _rDsn);

	/// check if the given data source type needs authentication
	sal_Bool hasAuthentication(DATASOURCE_TYPE _eType);

	/// check if the given data source tyoe is based on the file system - i.e. the URL is a prefix plus a file URL
	sal_Bool isFileSystemBased(DATASOURCE_TYPE _eType);

	/// get access to the first element of the types collection
	TypeIterator	begin() const;
	/// get access to the (last + 1st) element of the types collection
	TypeIterator	end() const;

protected:
	/// return the connection type a DSN string represents
	DATASOURCE_TYPE implDetermineType(const String& _rDsn);

	/// return the index within the internal structures for the connection type a DSN string represents
	sal_Int32 implDetermineTypeIndex(const String& _rDsn);

	/// return the index within the internal structures for the connection type given
	sal_Int32 implDetermineTypeIndex(DATASOURCE_TYPE _eType);
};

//-------------------------------------------------------------------------
//- ODsnTypeCollection::TypeIterator
//-------------------------------------------------------------------------
class ODsnTypeCollection::TypeIterator
{
	friend class ODsnTypeCollection;

	friend bool operator==(const TypeIterator& lhs, const TypeIterator& rhs);
	friend bool operator!=(const TypeIterator& lhs, const TypeIterator& rhs) { return !(lhs == rhs); }

protected:
	const ODsnTypeCollection*	m_pContainer;
	sal_Int32					m_nPosition;

public:
	TypeIterator(const TypeIterator& _rSource);
	~TypeIterator();

	DATASOURCE_TYPE	getType() const;
	String			getPrefix() const;
	String			getDisplayName() const;

	/// prefix increment
	const TypeIterator&	operator++();
	/// postfix increment
	const TypeIterator	operator++(int) { TypeIterator hold(*this); ++*this; return hold; }

	/// prefix decrement
	const TypeIterator&	operator--();
	/// postfix decrement
	const TypeIterator	operator--(int) { TypeIterator hold(*this); --*this; return hold; }

protected:
	TypeIterator(const ODsnTypeCollection* _pContainer, sal_Int32 _nInitialPos = 0);
};

//=========================================================================
//= DbuTypeCollectionItem
//=========================================================================
/** allows an ODsnTypeCollection to be transported in an SfxItemSet
*/
class DbuTypeCollectionItem : public SfxPoolItem
{
	ODsnTypeCollection*	m_pCollection;

public:
	TYPEINFO();
	DbuTypeCollectionItem(sal_Int16 nWhich = 0, ODsnTypeCollection* _pCollection = NULL);
	DbuTypeCollectionItem(const DbuTypeCollectionItem& _rSource);

	virtual int 			 operator==(const SfxPoolItem& _rItem) const;
	virtual SfxPoolItem*	 Clone(SfxItemPool* _pPool = NULL) const;

	ODsnTypeCollection*	getCollection() const { return m_pCollection; }
};

//=========================================================================
//= AddressBookTypes
//=========================================================================
// TODO: if we have the time, this class could be upgraded so that it is really
// a collection, with iterators, encapsulating display names, URLs and such
// (equivalent to the DsnTypeCollection)
class AddressBookTypes
{
public:
	static String			getAddressURL( ADDRESSBOOK_TYPE _eType );
	static ADDRESSBOOK_TYPE	getAddressType( const String& _rAddressURL );
};

//.........................................................................
}	// namespace dbaui
//.........................................................................

#endif // _DBAUI_DSNTYPES_HXX_

/*************************************************************************
 * history:
 *	$Log: dsntypes.hxx,v $
 *	Revision 1.8  2001/08/07 15:55:18  fs
 *	#88431# +isFileSystemBased
 *	
 *	Revision 1.7  2001/07/31 15:58:39  fs
 *	#88530# +AddressBookType(s)
 *	
 *	Revision 1.6  2001/05/23 14:16:41  oj
 *	#87149# new helpids
 *	
 *	Revision 1.5  2001/01/29 15:55:33  nn
 *	added DST_CALC
 *	
 *	Revision 1.4  2001/01/04 11:20:28  fs
 *	#81485# +DST_ADO
 *	
 *	Revision 1.3  2000/10/30 07:59:04  fs
 *	+ hasAuthentification(DATASOURCE_TYPE)
 *	
 *	Revision 1.2  2000/10/11 11:31:54  fs
 *	replace unotools with comphelper
 *	
 *	Revision 1.1  2000/10/05 10:08:27  fs
 *	initial checkin
 *	
 *
 *	Revision 1.0 26.09.00 08:03:37  fs
 ************************************************************************/

