/*************************************************************************
 *
 *  $RCSfile: dataview.hxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: fs $ $Date: 2001/08/23 14:23:57 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the License); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an AS IS basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef DBAUI_DATAVIEW_HXX
#define DBAUI_DATAVIEW_HXX

#ifndef _SV_WINDOW_HXX 
#include <vcl/window.hxx>
#endif
#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_AWT_XCONTROLCONTAINER_HPP_
#include <com/sun/star/awt/XControlContainer.hpp>
#endif

class ToolBox;
class FixedLine;
namespace dbaui
{
	class ODataView : public Window
	{
		::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >	m_xServiceFactory;	// the service factory to work with

	protected:
		ToolBox*	m_pToolBox;		// our toolbox (may be NULL)
		FixedLine*	m_pSeparator;	// our separator above the toolbox (may be NULL)

	public:
		ODataView(Window* pParent, const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >& , WinBits nStyle = 0 );
		virtual ~ODataView();

		/// late construction
		virtual void Construct();
		// initialize will be called when after the controller finished his initialize method
		virtual void initialize(){}

		/**	use this if you want to have a ToolBox to be displayed at the top of the grid control
			The ownership of the window specified by pTB is transfered to this view object itself,
			i.e. it is deleted in the destructor (or in the next call to setToolBox).
			Specify a NULL pointer if you want to remove an existing ToolBox.
		*/
		void	 setToolBox(ToolBox* pTB);
		ToolBox* getToolBox() const { return m_pToolBox; }

		void		enableSeparator( const sal_Bool _bEnable = sal_True );
		sal_Bool	isSeparatorEnabled() const { return NULL != m_pSeparator; }

		::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory > getORB() { return m_xServiceFactory;}

		// the default implementation simply calls resizeAll( GetSizePixel() )
		virtual void Resize();

	protected:
		// window overridables
		virtual void Paint( const Rectangle& _rRect );

		/// re-arrange all controls, including the toolbox, it's separator, and the "real view"
		virtual void resizeAll( const Rectangle& _rPlayground );

		// re-arrange the controls belonging to the document itself
		virtual void resizeDocumentView( Rectangle& _rPlayground );
	};
}
#endif // DBAUI_DATAVIEW_HXX

