/*************************************************************************
 *
 *  $RCSfile: datasourceselector.hxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: fs $ $Date: 2001/06/25 16:02:17 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc..
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef DBAUI_DATASOURCESELECTOR_HXX
#define DBAUI_DATASOURCESELECTOR_HXX

#ifndef _SV_WINDOW_HXX
#include <vcl/window.hxx>
#endif
#ifndef _SV_BUTTON_HXX 
#include <vcl/button.hxx>
#endif
#ifndef _SV_FIXED_HXX
#include <vcl/fixed.hxx>
#endif
#ifndef _SV_LSTBOX_HXX
#include <vcl/lstbox.hxx>
#endif

//.........................................................................
namespace dbaui
{
//.........................................................................

	//=====================================================================
	//= DatasourceState
	//=====================================================================
	enum DatasourceState
	{
		CLEAN,
		MODIFIED,
		NEW,
		DELETED
	};

	/** administrates the listbox for displaying the data sources</p>
		The list may contain normal, modified, new and "deleted" entries. Excluding the deleted ones,
		the entry names must be unique, that's why accessing entries which are not deleted is done by
		specifying a name.<br/>
		To access entries which are deleted, a special access key has to be supplied by the user of this class.
		This key has to be unique, so it can be used for non-ambiguous access.
	*/
	//=====================================================================
	//= ODatasourceSelector
	//=====================================================================
	class ODatasourceSelector : public Window
	{
	protected:
		PushButton	m_aNewDatasource;
		ListBox		m_aDatasourceList;

		Link	m_aNewHandler;
		Link	m_aDeleteHandler;
		Link	m_aRestoreHandler;

		struct EntryData
		{
			DatasourceState		eState;		// state of the data source
			sal_Int32			nAccessKey;	// access key, relevant only if DELETED == eState

			EntryData() :eState(CLEAN), nAccessKey(-1) { }
			EntryData(DatasourceState _eState) :eState(_eState), nAccessKey(-1) { }
		};

	protected:
		/// set the state of a data source specified by position
		void				setEntryState(sal_Int32 _nPos, DatasourceState _eState);
		/// get the state of a data source specified by position
		DatasourceState		getEntryState(sal_Int32 _nPos) const;
		/// get the resource id for imgages to be used for the given data source state
		sal_Int32			getImageId(DatasourceState _eState);
		/** get the position of an entry given by name, excluding the entries marked as deleted
			(with respect to these deleted entries the names are unique)
		*/
		sal_Int32			getValidEntryPos(const String& _rName);
		/// get the position of an (deleted) entry for a given access key
		sal_Int32			getDeletedEntryPos(sal_Int32 _nAccessKey);

		/// get the access key for a entry given by position
		sal_Int32			getAccessKey(sal_Int32 _nPos) const;
		/// set the access key for a entry given by position, to be used for entry which are in state DELETED only
		void				setAccessKey(sal_Int32 _nPos, sal_Int32 _nAccessKey);

		/// remove an entry (given by pos) from the list, auto-select the next one
		void				implDeleted(sal_Int32 _nPos);

	public:
		ODatasourceSelector(Window* _pParent, const ResId& _rResId);
		~ODatasourceSelector();

		/// mark the given data source as modified
		void		modified(const String& _sName);
		/** tell the selector object that a data source has been renamed.
			@param		_rOldName		the old entry name
			@param		_rNewName		the new entry name
			@param		_bIsNew			indicates whether or not the entry refers to a new datasource
		*/
		void		renamed(const String& _rOldName, const String& _rNewName);

		/** tell the selector that a data source is scheduled to be deleted.
			@param	_rName			name of the entry. Must be an entry which's DatasourceState is not DELETED and not NEW
			@param	_nAccessKey		Needed for accessing the entry after it has been marked as deleted
		*/
		void		markDeleted(const String& _rName, sal_Int32 _nAccessKey);

		/** restore an entry previously marked as deleted<p/>
			After returning from this method, the access key used is invalid.
			@param		_nAccessKey		the access key used in <method>markDeleted</method>
			@param		_eState			the new state of the datasource. Must not be DELETED
		*/
		void		restoreDeleted(sal_Int32 _nAccessKey, DatasourceState _eState);

		/** tell the selector to really delete an entry from the list.
			@param	_rName	name of the entry. Must be an entry which's DatasourceState is not DELETED
		*/
		void		deleted(const String& _rName);

		/** tell the selector to really delete an entry from the list.
			@param	_nAccessKey		access key of the entry. Must be an entry which's DatasourceState is DELETED
		*/
		void		deleted(sal_Int32 _nAccessKey);

		/// insert the name of an existent data source
		sal_Int32	insert(const String& _rName);

		/// insert the name of a daza source which is newly created
		void		insertNew(const String& _rName);

		/** tell the selector that a data source has been flushed.<p/>
			This means that the state a formerly modified or new entry changes to <em>clean</em>.
		*/
		void		flushed(const String& _rName);

		/// get the name of the currently selected data source
		String		getSelected() const { return m_aDatasourceList.GetSelectEntry(); }

		/// get the state of the currently selected data source
		DatasourceState	getSelectedState() const { return getEntryState(m_aDatasourceList.GetSelectEntryPos()); }
		/// get the access key of the currently selected data source
		sal_Int32		getSelectedAccessKey() const { return getAccessKey(m_aDatasourceList.GetSelectEntryPos()); }

		/// number of entries in the datasource list
		sal_Int32	count() const { return m_aDatasourceList.GetEntryCount(); }

		/// select a data source by name, valid only for non-deleted data sources
		void		select(const String& _rName);
		/// select a data source by acces key
		void		select(sal_Int32 _nAccessKey);

		/// set a handler to be called whenever the selection changes
		void		setSelectHandler(const Link& _rHdl) { m_aDatasourceList.SetSelectHdl(_rHdl); }

		/// set a handler to be called if the user chooses to create a new data source
		void		setNewHandler(const Link& _rHdl) { m_aNewHandler = _rHdl; }

		/// set a handler to be called if the user chooses to delete a new data source
		void		setDeleteHandler(const Link& _rHdl) { m_aDeleteHandler = _rHdl; }

		/// set a handler to be called if the user chooses to restore a delete data source
		void		setRestoreHandler(const Link& _rHdl) { m_aRestoreHandler = _rHdl; }

	protected:
		virtual void	Resize();
		virtual long	Notify(NotifyEvent& _rNEvt);

		DECL_LINK(OnButtonPressed, Button*);
	};

//.........................................................................
}	// namespace dbaui
//.........................................................................

#endif // DBAUI_DATASOURCESELECTOR_HXX

/*************************************************************************
 * history:
 *	$Log: datasourceselector.hxx,v $
 *	Revision 1.1  2001/06/25 16:02:17  fs
 *	initial checkin - outsourced this from dbadmin.hxx
 *	
 *
 *	Revision 1.0 25.06.01 16:44:22  fs
 ************************************************************************/

