/*************************************************************************
 *
 *  $RCSfile: AdabasPage.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: oj $ $Date: 2001/04/09 07:30:29 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the License); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an AS IS basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef DBAUI_ADABASPAGE_HXX
#include "AdabasPage.hxx"
#endif
#ifndef _DBU_RESOURCE_HRC_
#include "dbu_resource.hrc"
#endif
#ifndef _SFXENUMITEM_HXX 
#include <svtools/eitem.hxx>
#endif
#ifndef _SFXSTRITEM_HXX 
#include <svtools/stritem.hxx>
#endif
#ifndef DBAUI_ADABASPAGE_HRC
#include "AdabasPage.hrc"
#endif
#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif
#ifndef _DBAUI_DATASOURCEITEMS_HXX_
#include "dsitems.hxx"
#endif
#ifndef _SFXINTITEM_HXX 
#include <svtools/intitem.hxx>
#endif
#ifndef _DBAUI_DBADMIN_HXX_
#include "dbadmin.hxx"
#endif
#ifndef _DBAUI_ADASTAT_HXX_
#include "AdabasStat.hxx"
#endif
#ifndef _DBHELPER_DBEXCEPTION_HXX_
#include "connectivity/dbexception.hxx"
#endif
#ifndef _CONNECTIVITY_DBTOOLS_HXX_
#include "connectivity/dbtools.hxx"
#endif
#ifndef DBAUI_TOOLS_HXX
#include "UITools.hxx"
#endif
#ifndef _COMPHELPER_TYPES_HXX_
#include <comphelper/types.hxx>
#endif
#ifndef _SV_WAITOBJ_HXX 
#include <vcl/waitobj.hxx>
#endif
#ifndef _COM_SUN_STAR_SDB_SQLCONTEXT_HPP_
#include <com/sun/star/sdb/SQLContext.hpp>
#endif
#ifndef _DBAUI_MODULE_DBU_HXX_
#include "moduledbu.hxx"
#endif

#define GET_ATTR(c,w)	(const c*)&(rCoreAttrs.Get( (w) ))

using namespace dbaui;
using namespace dbtools;
using namespace ::com::sun::star::sdbc;
using namespace ::com::sun::star::sdb;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::beans;

DBG_NAME(OAdabasAdminSettings);
//========================================================================
OAdabasAdminSettings::OAdabasAdminSettings( Window* pParent, const SfxItemSet& rCoreAttrs )
	:OGenericAdministrationPage(pParent, ModuleRes(TAB_PAG_ADABAS_SETTINGS), rCoreAttrs)
	,m_FT_CACHE_SIZE(		this, ResId( FT_CACHE_SIZE		) )
	,m_NF_CACHE_SIZE(		this, ResId( NF_CACHE_SIZE		) )
	,m_FT_DATA_INCREMENT(	this, ResId( FT_DATA_INCREMENT	) )
	,m_NF_DATA_INCREMENT(	this, ResId( NF_DATA_INCREMENT	) )
	,m_CB_SHUTDB(			this, ResId( CB_SHUTDB			) )
	,aFL_1(					this, ResId( FL_1				) )
	,m_FT_CTRLUSERNAME(		this, ResId( FT_CTRLUSERNAME	) )
	,m_ET_CTRLUSERNAME(		this, ResId( ET_CTRLUSERNAME	) )
	,m_FT_CTRLPASSWORD(		this, ResId( FT_CTRLPASSWORD	) )
	,m_ET_CTRLPASSWORD(		this, ResId( ET_CTRLPASSWORD	) )
	,m_PB_STAT(				this, ResId( PB_STAT			) )
	,bAttrsChanged(FALSE)
{
	DBG_CTOR( OAdabasAdminSettings, NULL );

	m_PB_STAT.SetClickHdl(				LINK(this,OAdabasAdminSettings,PBClickHdl));

	m_CB_SHUTDB.SetClickHdl(			LINK(this,OAdabasAdminSettings,AttributesChangedHdl));
	m_NF_CACHE_SIZE.SetModifyHdl(		LINK(this,OAdabasAdminSettings,AttributesChangedHdl));
	m_NF_DATA_INCREMENT.SetModifyHdl(	LINK(this,OAdabasAdminSettings,AttributesChangedHdl));
	m_ET_CTRLUSERNAME.SetModifyHdl(		LINK(this,OAdabasAdminSettings,AttributesChangedHdl));
	m_ET_CTRLPASSWORD.SetModifyHdl(		LINK(this,OAdabasAdminSettings,AttributesChangedHdl));

	m_ET_CTRLUSERNAME.SetLoseFocusHdl(	LINK(this,OAdabasAdminSettings,LoseFocusHdl));
	m_ET_CTRLPASSWORD.SetLoseFocusHdl(	LINK(this,OAdabasAdminSettings,LoseFocusHdl));
		
	m_NF_DATA_INCREMENT.SetMin(20);
	m_NF_DATA_INCREMENT.SetMax(LONG_MAX);
	m_NF_DATA_INCREMENT.SetValue(20);
	m_NF_DATA_INCREMENT.SetDecimalDigits(0);

	m_NF_CACHE_SIZE.SetMin(4);
	m_NF_CACHE_SIZE.SetMax(LONG_MAX);
	m_NF_CACHE_SIZE.SetValue(4);
	m_NF_CACHE_SIZE.SetDecimalDigits(0);

	SetExchangeSupport(TRUE);
	FreeResource();
}

// -----------------------------------------------------------------------
OAdabasAdminSettings::~OAdabasAdminSettings()
{
	DBG_DTOR( OAdabasAdminSettings, NULL );
}
//------------------------------------------------------------------------
IMPL_LINK( OAdabasAdminSettings, LoseFocusHdl, Edit *, pEdit )
{
	m_CB_SHUTDB.Enable(m_ET_CTRLUSERNAME.GetText().Len() && m_ET_CTRLPASSWORD.GetText().Len());
	return 0;
}
//------------------------------------------------------------------------
IMPL_LINK( OAdabasAdminSettings, PBClickHdl, Button *, pButton )
{
	if(!m_xCurrentConnection.is() && m_pAdminDialog)
		m_xCurrentConnection = m_pAdminDialog->createConnection();
	if(m_xCurrentConnection.is())
	{
		OAdabasStatistics aDlg(this,m_sUser,m_xCurrentConnection,m_pAdminDialog->getORB());
		aDlg.Execute();
	}
	return 0;
}
// -----------------------------------------------------------------------
SfxTabPage*	OAdabasAdminSettings::Create( Window* pParent,	const SfxItemSet& rAttrSet )
{
	return ( new OAdabasAdminSettings( pParent, rAttrSet ) );
}

// -----------------------------------------------------------------------
void OAdabasAdminSettings::Reset( const SfxItemSet& rCoreAttrs )
{
}
// -----------------------------------------------------------------------
BOOL OAdabasAdminSettings::FillItemSet( SfxItemSet& rCoreAttrs )
{
	//	BOOL bChangedSomething = OGenericAdministrationPage::FillItemSet(rCoreAttrs);
	if ( bAttrsChanged )
	{
		rCoreAttrs.Put( SfxBoolItem(GetWhich(DSID_CONN_SHUTSERVICE), m_CB_SHUTDB.IsEnabled() && m_CB_SHUTDB.IsChecked() ) );
		rCoreAttrs.Put( SfxInt32Item(GetWhich(DSID_CONN_DATAINC), m_NF_DATA_INCREMENT.GetValue() ) );
		rCoreAttrs.Put( SfxInt32Item(GetWhich(DSID_CONN_CACHESIZE), m_NF_CACHE_SIZE.GetValue() ) );
		rCoreAttrs.Put( SfxStringItem(GetWhich(DSID_CONN_CTRLUSER), m_ET_CTRLUSERNAME.GetText()));
		rCoreAttrs.Put( SfxStringItem(GetWhich(DSID_CONN_CTRLPWD), m_ET_CTRLPASSWORD.GetText()));
	}
	return TRUE;
}
// -----------------------------------------------------------------------
void OAdabasAdminSettings::ActivatePage( const SfxItemSet& rCoreAttrs )
{
	DBG_CHKTHIS( OAdabasAdminSettings, NULL );

	// check whether or not the selection is invalid or readonly (invalid implies readonly, but not vice versa)
	sal_Bool bValid, bReadonly;
	getFlags(rCoreAttrs, bValid, bReadonly);

	OGenericAdministrationPage::ActivatePage(rCoreAttrs);


	const SfxBoolItem* pShutItem	= GET_ATTR(SfxBoolItem,DSID_CONN_SHUTSERVICE);
	const SfxInt32Item* pIncItem	= GET_ATTR(SfxInt32Item,DSID_CONN_DATAINC);
	const SfxInt32Item* pCacheItem	= GET_ATTR(SfxInt32Item,DSID_CONN_CACHESIZE);
	
	m_CB_SHUTDB.Check( pShutItem->GetValue() );
	m_NF_DATA_INCREMENT.SetValue( pIncItem->GetValue() );
	m_NF_CACHE_SIZE.SetValue( pCacheItem->GetValue() );

	const SfxStringItem*	 pUserItem		= GET_ATTR(SfxStringItem,DSID_USER);
	const SfxStringItem*	 pCtrlUserItem	= GET_ATTR(SfxStringItem,DSID_CONN_CTRLUSER);
	const SfxStringItem*	 pCtrlPwdItem	= GET_ATTR(SfxStringItem,DSID_CONN_CTRLPWD);

	m_sUser = pUserItem->GetValue();
	m_ET_CTRLUSERNAME.SetText(pCtrlUserItem->GetValue());
	m_ET_CTRLPASSWORD.SetText(pCtrlPwdItem->GetValue());

	m_CB_SHUTDB.Enable(m_ET_CTRLUSERNAME.GetText().Len() && m_ET_CTRLPASSWORD.GetText().Len());
	// check if we should show this entries
	const SfxStringItem*	 pUrlItem	= GET_ATTR(SfxStringItem,DSID_CONNECTURL);
	String sConnectionURL = pUrlItem->GetValue();
	sConnectionURL = sConnectionURL.GetToken(2,':');
	if(sConnectionURL.Len())
	{ // here we have a url which shows to a different computer
		m_NF_DATA_INCREMENT.Enable(FALSE);
		m_NF_CACHE_SIZE.Enable(FALSE);
		m_ET_CTRLUSERNAME.Enable(FALSE);
		m_ET_CTRLPASSWORD.Enable(FALSE);
		m_CB_SHUTDB.Enable(FALSE);
	}
}

//------------------------------------------------------------------------
IMPL_LINK_INLINE_START( OAdabasAdminSettings, AttributesChangedHdl, void *, EMPTYARG )
{
	DBG_CHKTHIS( OAdabasAdminSettings, NULL );

	m_CB_SHUTDB.Enable(m_ET_CTRLUSERNAME.GetText().Len() && m_ET_CTRLPASSWORD.GetText().Len());
	bAttrsChanged = TRUE;
	callModifiedHdl();
	return 0;
}
IMPL_LINK_INLINE_END( OAdabasAdminSettings, AttributesChangedHdl, void *, EMPTYARG )
// -----------------------------------------------------------------------------
int OAdabasAdminSettings::DeactivatePage(SfxItemSet* _pSet)
{
	int nResult = OGenericAdministrationPage::DeactivatePage(_pSet);
	::comphelper::disposeComponent(m_xCurrentConnection);
	return nResult;
}
// -----------------------------------------------------------------------------
sal_Int32* OAdabasAdminSettings::getDetailIds()
{
	static sal_Int32* pRelevantIds = NULL;
	if (!pRelevantIds)
	{
		static sal_Int32 nRelevantIds[] =
		{
			DSID_CONN_SHUTSERVICE,
			DSID_CONN_DATAINC,
			DSID_CONN_CACHESIZE,
			DSID_CONN_CTRLUSER,
			DSID_CONN_CTRLPWD,
			0
		};
		pRelevantIds = nRelevantIds;
	}
	return pRelevantIds;
}
// -----------------------------------------------------------------------------

