/*************************************************************************
 *
 *  $RCSfile: testhelper.cxx,v $
 *
 *  $Revision: 1.5.14.1 $
 *
 *  last change: $Author: hr $ $Date: 2002/08/15 13:11:56 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <stdio.h>
#include <rtl/ustrbuf.hxx>
#include <osl/diagnose.h>

#include <cppuhelper/component_context.hxx>
#include <cppuhelper/servicefactory.hxx>
#include <com/sun/star/beans/XPropertySet.hpp>
#include <com/sun/star/registry/XSimpleRegistry.hpp>
#include <com/sun/star/registry/XImplementationRegistration.hpp>
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#include <com/sun/star/lang/XComponent.hpp>

#include "testhelper.hxx"

using namespace rtl;
using namespace cppu;
using namespace com::sun::star::uno;
using namespace com::sun::star;
using namespace com::sun::star::lang;
using namespace com::sun::star::registry;

#if (defined UNX) || (defined OS2)
int main( int argc, char * argv[] )
#else
int __cdecl main( int argc, char * argv[] )
#endif
{
	Reference< XMultiComponentFactory > xMgr( createRegistryServiceFactory(
		OUString( RTL_CONSTASCII_USTRINGPARAM("cpputest.rdb") ) ), UNO_QUERY );
	Reference< XComponentContext > xInitialContext;
    OSL_VERIFY( Reference< beans::XPropertySet >( xMgr, UNO_QUERY )->getPropertyValue(
        OUString( RTL_CONSTASCII_USTRINGPARAM("DefaultContext") ) ) >>= xInitialContext );

    ContextEntry_Init aEntry;
    aEntry.bLateInitService = false;
    aEntry.name = OUString( RTL_CONSTASCII_USTRINGPARAM("bla, bla") );
    aEntry.value = makeAny( (sal_Int32)5 );
    Reference< XComponentContext > xContext( createComponentContext( &aEntry, 1, xInitialContext ) );
    OSL_ASSERT( xContext->getServiceManager() == xMgr );
    
	sal_Bool bSucc = sal_False;
	try
	{
		Reference< XImplementationRegistration > xImplReg(
			xMgr->createInstanceWithContext(
                OUString( RTL_CONSTASCII_USTRINGPARAM("com.sun.star.registry.ImplementationRegistration") ),
                xContext ),
			UNO_QUERY );
		OSL_ENSURE( xImplReg.is(), "### no impl reg!" );
		
#ifdef UNX
#define REG_PREFIX 		"lib"
#ifdef MACOSX
#define DLL_POSTFIX 	".dylib"
#else
#define DLL_POSTFIX 	".so"
#endif
#else
#define REG_PREFIX 		""		
#define DLL_POSTFIX 	".dll"	
#endif
		OString aLibName( REG_PREFIX );
		aLibName += "corefl";
#ifndef OS2   
		aLibName += DLL_POSTFIX;
#endif
		xImplReg->registerImplementation(
			OUString( RTL_CONSTASCII_USTRINGPARAM("com.sun.star.loader.SharedLibrary") ),
			OUString::createFromAscii( aLibName.getStr() ),
			Reference< XSimpleRegistry >() );

        Reference< XMultiServiceFactory > x( xMgr, UNO_QUERY );
		testPropertyTypeHelper();
		testidlclass( x );
		test_PropertySetHelper();
		test_ImplHelper( x );
		test_interfacecontainer();
	}
	catch (Exception & rExc)
	{
		OSL_ENSURE( sal_False, "### exception occured!" );
		OString aMsg( OUStringToOString( rExc.Message, RTL_TEXTENCODING_ASCII_US ) );
		OSL_TRACE( "### exception occured: " );
		OSL_TRACE( aMsg.getStr() );
		OSL_TRACE( "\n" );
	}

    OSL_VERIFY( xContext->getValueByName(
        OUString( RTL_CONSTASCII_USTRINGPARAM("bla, bla") ) ) == (sal_Int32)5 );
	Reference< XComponent >( xInitialContext, UNO_QUERY )->dispose();
	
	printf( "Test finished\n" );
	return 0;
}
