/*************************************************************************
 *
 *  $RCSfile: FTools.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: oj $ $Date: 2001/08/24 06:00:38 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _CONNECTIVITY_FILE_FTOOLS_HXX_
#define _CONNECTIVITY_FILE_FTOOLS_HXX_

#ifndef _CONNECTIVITY_FILE_VALUE_HXX_
#include "connectivity/FValue.hxx"
#endif
#ifndef _VOS_REFERNCE_HXX_ 
#include <vos/refernce.hxx>
#endif

namespace connectivity
{
	namespace file
	{
		class OParameterRowAccess : public ::vos::OReference
		{
			::std::vector<sal_Int32> m_nParameterIndexes;
			OValueRow				 m_aParameterRow;
		public:
			OParameterRowAccess() : m_nParameterIndexes(1,SQL_NO_PARAMETER),m_aParameterRow(NULL){}
			OParameterRowAccess(const OValueRow& _aParameterRow,size_type n) : m_nParameterIndexes(n+1,SQL_NO_PARAMETER),m_aParameterRow(_aParameterRow){}

			void setParameterRow(const OValueRow& _aParameterRow)					{ m_aParameterRow = _aParameterRow; }
			void setParameterIndex(sal_Int32 _nId,sal_Int32 _nParameterIndex)		{ m_nParameterIndexes[_nId] = _nParameterIndex;}
			sal_Int32 getParameterIndex(sal_Int32 _nId) const						{ return m_nParameterIndexes[_nId]; }

			OValueRow::reference operator[](OValueRow::size_type _nId)				{ return m_aParameterRow[m_nParameterIndexes[_nId]]; }
			OValueRow::const_reference operator[](OValueRow::size_type _nId) const	{ return m_aParameterRow[m_nParameterIndexes[_nId]]; }
		};
		typedef ::vos::ORef<OParameterRowAccess> OParameterRowAccessRef;
	}
}

#endif // _CONNECTIVITY_FILE_FTOOLS_HXX_
