/*************************************************************************
 *
 *  $RCSfile: MABResultSet.cxx,v $
 *
 *  $Revision: 1.17 $
 *
 *  last change: $Author: oj $ $Date: 2001/10/26 07:47:13 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): Darren Kenny, Willem van Dorp
 *
 *
 ************************************************************************/
#ifndef _CONNECTIVITY_MAB_RESULTSET_HXX_
#include "mozaddressbook/MABResultSet.hxx"
#endif
#ifndef _COM_SUN_STAR_LANG_DISPOSEDEXCEPTION_HPP_
#include <com/sun/star/lang/DisposedException.hpp>
#endif
#ifndef _COMPHELPER_SEQUENCE_HXX_
#include <comphelper/sequence.hxx>
#endif

#include <MABDebug.hxx>

using namespace connectivity::mozaddressbook;
using namespace connectivity::file;
using namespace connectivity;
using namespace rtl;
using namespace com::sun::star::uno;
using namespace com::sun::star::lang;
using namespace com::sun::star::beans;
using namespace com::sun::star::sdbc;
using namespace com::sun::star::sdbcx;

//------------------------------------------------------------------------------
OMozabResultSet::OMozabResultSet( OStatement_Base* pStmt,connectivity::OSQLParseTreeIterator&   _aSQLIterator)
                : file::OResultSet(pStmt,_aSQLIterator)
                ,m_bBookmarkable(sal_True)
{

    OSL_TRACE( "IN OMozabResultSet::OMozabResultSet()\n" );

    registerProperty(OMetaConnection::getPropMap().getNameByIndex(PROPERTY_ID_ISBOOKMARKABLE),         PROPERTY_ID_ISBOOKMARKABLE,       PropertyAttribute::READONLY,&m_bBookmarkable,                ::getBooleanCppuType());

    OSL_TRACE( "\tOUT OMozabResultSet::OMozabResultSet()\n" );

}
// -------------------------------------------------------------------------
::rtl::OUString SAL_CALL OMozabResultSet::getImplementationName(  ) throw ( RuntimeException)
{   

    OSL_TRACE( "IN/OUT OMozabResultSet::getImplementationName()\n" );

    return ::rtl::OUString::createFromAscii("com.sun.star.sdbcx.mozaddressbook.ResultSet"); 
}
// -------------------------------------------------------------------------    
Sequence< ::rtl::OUString > SAL_CALL OMozabResultSet::getSupportedServiceNames(  ) throw( RuntimeException) 
{   

    OSL_TRACE( "IN OMozabResultSet::getSupportedServiceNames()\n" );

     Sequence< ::rtl::OUString > aSupported(2); 
    aSupported[0] = ::rtl::OUString::createFromAscii("com.sun.star.sdbc.ResultSet");
    aSupported[1] = ::rtl::OUString::createFromAscii("com.sun.star.sdbcx.ResultSet");

    OSL_TRACE( "\tOUT OMozabResultSet::getSupportedServiceNames()\n" );

    return aSupported;  
}
// -------------------------------------------------------------------------    
sal_Bool SAL_CALL OMozabResultSet::supportsService( const ::rtl::OUString& _rServiceName ) throw( RuntimeException) 
{   

    OSL_TRACE( "IN OMozabResultSet::supportsService()\n" );

     Sequence< ::rtl::OUString > aSupported(getSupportedServiceNames());    
    const ::rtl::OUString* pSupported = aSupported.getConstArray(); 
    for (sal_Int32 i=0; i<aSupported.getLength(); ++i, ++pSupported) {
        if (pSupported->equals(_rServiceName)){

    OSL_TRACE( "\tOUT OMozabResultSet::supportsService() --> sal_True\n" );

            return sal_True;    
        }
    }


    OSL_TRACE( "\tOUT OMozabResultSet::supportsService() --> sal_False\n" );

    return sal_False;   
}   
// -------------------------------------------------------------------------
Any SAL_CALL OMozabResultSet::queryInterface( const Type & rType ) throw(RuntimeException)
{

    OSL_TRACE( "IN OMozabResultSet::queryInterface()\n" );

    Any aRet = OResultSet::queryInterface(rType);
    return aRet.hasValue() ? aRet : OMozabResultSet_BASE::queryInterface(rType);
}
// -------------------------------------------------------------------------
 Sequence<  Type > SAL_CALL OMozabResultSet::getTypes(  ) throw( RuntimeException)
{

    OSL_TRACE( "IN/OUT OMozabResultSet::getTypes()\n" );

    return ::comphelper::concatSequences(OResultSet::getTypes(),OMozabResultSet_BASE::getTypes());
}

// -------------------------------------------------------------------------
// XRowLocate
Any SAL_CALL OMozabResultSet::getBookmark(  ) throw( SQLException,  RuntimeException)
{

    OSL_TRACE( "IN OMozabResultSet::getBookmark()\n" );

     ::osl::MutexGuard aGuard( m_aMutex );
    if (OResultSet_BASE::rBHelper.bDisposed)
        throw DisposedException();


    OSL_TRACE( "\tOUT OMozabResultSet::getBookmark()\n" );

    return makeAny((sal_Int32)(*m_aRow)[0]);
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabResultSet::moveToBookmark( const  Any& bookmark ) throw( SQLException,  RuntimeException)
{

    OSL_TRACE( "IN OMozabResultSet::moveToBookmark()\n" );

    ::osl::MutexGuard aGuard( m_aMutex );
    if (OResultSet_BASE::rBHelper.bDisposed)
        throw DisposedException();

    m_bRowDeleted = m_bRowInserted = m_bRowUpdated = sal_False;


    OSL_TRACE( "\tOUT OMozabResultSet::moveToBookmark()\n" );

    return Move(IResultSetHelper::BOOKMARK,comphelper::getINT32(bookmark),sal_True);
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabResultSet::moveRelativeToBookmark( const  Any& bookmark, sal_Int32 rows ) throw( SQLException,  RuntimeException)
{

    OSL_TRACE( "IN OMozabResultSet::moveRelativeToBookmark()\n" );

    ::osl::MutexGuard aGuard( m_aMutex );
    if (OResultSet_BASE::rBHelper.bDisposed)
        throw DisposedException();

    Move(IResultSetHelper::BOOKMARK,comphelper::getINT32(bookmark),sal_False);

	return relative(rows);
}

// -------------------------------------------------------------------------
sal_Int32 SAL_CALL OMozabResultSet::compareBookmarks( const  Any& first, const  Any& second ) throw( SQLException,  RuntimeException)
{
    sal_Int32 nFirst,nSecond,nResult;
	first  >>= nFirst;
	second >>= nSecond;

	// have a look at CompareBookmark
	// we can't use the names there because we already have defines with the same name from the parser
	if(nFirst < nSecond)
		nResult = -1;
	else if(nFirst > nSecond)
		nResult = 1;
	else
		nResult = 0;

	return  nResult; 
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabResultSet::hasOrderedBookmarks(  ) throw( SQLException,  RuntimeException)
{

    OSL_TRACE( "IN/OUT OMozabResultSet::hasOrderedBookmarks()\n" );

    return sal_True;
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL OMozabResultSet::hashBookmark( const  Any& bookmark ) throw( SQLException,  RuntimeException)
{
    return comphelper::getINT32(bookmark);
}
// -------------------------------------------------------------------------
// XDeleteRows
Sequence< sal_Int32 > SAL_CALL OMozabResultSet::deleteRows( const  Sequence<  Any >& rows ) throw( SQLException,  RuntimeException)
{
    return Sequence< sal_Int32 >();
}
// -------------------------------------------------------------------------
sal_Bool OMozabResultSet::fillIndexValues(const Reference< XColumnsSupplier> &_xIndex)
{

    OSL_TRACE( "IN/OUT OMozabResultSet::fillIndexValues()\n" );

    //  Calc table has no index
    return sal_False;
}
// -------------------------------------------------------------------------
cppu::IPropertyArrayHelper & OMozabResultSet::getInfoHelper()
{

    OSL_TRACE( "IN/OUT OMozabResultSet::getInfoHelper()\n" );

    return *OMozabResultSet_BASE3::getArrayHelper();
}
// -----------------------------------------------------------------------------
cppu::IPropertyArrayHelper* OMozabResultSet::createArrayHelper() const
{

    OSL_TRACE( "IN OMozabResultSet::createArrayHelper()\n" );

    Sequence< Property > aProps;
    describeProperties(aProps);

    OSL_TRACE( "\tOUT OMozabResultSet::createArrayHelper()\n" );

    return new cppu::OPropertyArrayHelper(aProps);
}
// -------------------------------------------------------------------------
#if defined DEBUG || defined DBG_UTIL
void printParseTree( const OSQLParseNode*  parseTree, OString tab = "" )
{
    if ( parseTree == NULL )
        return;

    if ( parseTree->count() > 0 ) {
        for ( sal_Int32 i = 0; i < parseTree->count(); i++ )
            printParseTree( parseTree->getChild( i ), tab + " :" );
    } else {
        OUString str;
        (const_cast<connectivity::OSQLParseNode *>(parseTree))->showParseTree( str );
        OSL_TRACE("ParseTree: %s %s\n", tab.getStr(), OUtoCStr( str ));
    }
}
#endif
// -----------------------------------------------------------------------------
void SAL_CALL OMozabResultSet::acquire() throw()
{
    OResultSet_BASE::acquire();
}
// -----------------------------------------------------------------------------
void SAL_CALL OMozabResultSet::release() throw()
{
    OResultSet_BASE::release();
}
// -----------------------------------------------------------------------------
::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySetInfo > SAL_CALL OMozabResultSet::getPropertySetInfo(  ) throw(::com::sun::star::uno::RuntimeException)
{
    return ::cppu::OPropertySetHelper::createPropertySetInfo(getInfoHelper());
}
// -----------------------------------------------------------------------------
void OMozabResultSet::doTableSpecials(const OSQLTable& _xTable)
{
    Reference< ::com::sun::star::lang::XUnoTunnel> xTunnel(_xTable,UNO_QUERY);
    if(xTunnel.is())
    {
        OMozabTable* pOrignalTable = (OMozabTable*)xTunnel->getSomething(OMozabTable::getUnoTunnelImplementationId());

        if(pOrignalTable) 
        {
            // we need a copy of the orignal table to avoid the use of the query in different resultsets
            m_pMozTable = pOrignalTable->clone();
            if(m_pMozTable)
            {
                m_pMozTable->acquire();

                OSL_TRACE( "MozabResultSet: m_aParameterRow.isValid() = %s\n", 
                           (m_aParameterRow.isValid()?"True":"False")
                           );
                if ( m_aParameterRow.isValid() ) {
                    m_pMozTable->setParameterRow( m_aParameterRow );
                }
                
                m_pMozTable->fillRowData(m_aSQLIterator);
                OSL_TRACE("OMozabResultSet::OpenImpl() : calling getCurrentLastPos on table\n");
#ifdef DEBUG
                sal_Int32 dummy = m_pMozTable->getCurrentLastPos();
#endif

                // For completeness, fill in value of m_pTable in OFileResultSet
                // so we can use it's implementation still
                m_pTable = (OFileTable*)m_pMozTable;
            }
        }
        
    }
}
// -----------------------------------------------------------------------------

