/*************************************************************************
 *
 *  $RCSfile: MABDriver.cxx,v $
 *
 *  $Revision: 1.10 $
 *
 *  last change: $Author: oj $ $Date: 2001/09/19 09:33:31 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): Darren Kenny, Willem van Dorp
 *
 *
 ************************************************************************/

#ifndef _CONNECTIVITY_MAB_DRIVER_HXX_
#include "mozaddressbook/MABDriver.hxx"
#endif
#ifndef _CONNECTIVITY_MAB_CONNECTION_HXX_
#include "mozaddressbook/MABConnection.hxx"
#endif
#ifndef _COM_SUN_STAR_LANG_DISPOSEDEXCEPTION_HPP_
#include <com/sun/star/lang/DisposedException.hpp>
#endif
#include <MABDebug.hxx>


using namespace connectivity::mozaddressbook;
using namespace connectivity::file;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::beans;
using namespace ::com::sun::star::sdbcx;
using namespace ::com::sun::star::sdbc;
using namespace ::com::sun::star::lang;




//------------------------------------------------------------------------------
// static ServiceInfo

rtl::OUString OMozabDriver::getImplementationName_Static(  ) throw(RuntimeException)
{
	OSL_TRACE( "IN/OUT rtl::OUString OMozabDriver::getImplementationName_Static()\n" );
	return rtl::OUString::createFromAscii("com.sun.star.comp.sdbc.mozaddressbook.Driver");
}

::rtl::OUString SAL_CALL OMozabDriver::getImplementationName(  ) throw(RuntimeException)
{
	return getImplementationName_Static();
}

// service names from file::OFileDriver

//------------------------------------------------------------------

::com::sun::star::uno::Reference< ::com::sun::star::uno::XInterface > SAL_CALL
	connectivity::mozaddressbook::OMozabDriver_CreateInstance(const ::com::sun::star::uno::Reference<
		::com::sun::star::lang::XMultiServiceFactory >& _rxFactory) throw( ::com::sun::star::uno::Exception )
{
	OSL_TRACE( "IN/OUT connectivity::mozaddressbook::OMozabDriver_CreateInstance()\n" );
	return *(new OMozabDriver(_rxFactory));
}

Reference< XConnection > SAL_CALL OMozabDriver::connect( const ::rtl::OUString& url,
	const Sequence< PropertyValue >& info ) throw(SQLException, RuntimeException)
{
	OSL_TRACE( "IN OMozabDriver::connect()\n" );
	::osl::MutexGuard aGuard( m_aMutex );
	if (ODriver_BASE::rBHelper.bDisposed)
		throw DisposedException();

	OMozabConnection* pCon = new OMozabConnection(this);
	pCon->construct(url,info);
	Reference< XConnection > xCon = pCon;
	m_xConnections.push_back(WeakReferenceHelper(*pCon));

	OSL_TRACE( "\tOUT OMozabDriver::connect()\n" );
	return xCon;
}
// -----------------------------------------------------------------------------
sal_Bool OMozabDriver::acceptsURL_Stat( const ::rtl::OUString& url )
{
	// Skip 'sdbc:mozab: part of URL
    //
	sal_Int32 nLen = url.indexOf(':');
	nLen = url.indexOf(':',nLen+1);
	::rtl::OUString aAddrbookURI(url.copy(nLen+1));
    // Get Scheme
	nLen = aAddrbookURI.indexOf(':');
    ::rtl::OUString aAddrbookScheme;
    if ( nLen == -1 )
	{
        // There isn't any subschema: - but could be just subschema
        if ( aAddrbookURI.getLength() > 0 )
            aAddrbookScheme= aAddrbookURI;
		else if(url == ::rtl::OUString::createFromAscii("sdbc:address:") )
			return sal_True; // special case here
        else
            return sal_False;
    }
    else
        aAddrbookScheme = aAddrbookURI.copy(0, nLen);



	return	( aAddrbookScheme.compareToAscii( OMozabConnection::getSDBC_SCHEME_MOZILLA() ) == 0 )		|| 
			( aAddrbookScheme.compareToAscii( OMozabConnection::getSDBC_SCHEME_LDAP() ) == 0 )			
#if defined(WNT) || defined(WIN)
																				||
			( aAddrbookScheme.compareToAscii( OMozabConnection::getSDBC_SCHEME_OUTLOOK_MAPI() ) == 0 )	||
			( aAddrbookScheme.compareToAscii( OMozabConnection::getSDBC_SCHEME_OUTLOOK_EXPRESS() ) == 0 )
#endif
			;
}
// -----------------------------------------------------------------------------
sal_Bool SAL_CALL OMozabDriver::acceptsURL( const ::rtl::OUString& url )
                throw(SQLException, RuntimeException)
{
	return acceptsURL_Stat(url);
}
// -----------------------------------------------------------------------------

