/*************************************************************************
 *
 *  $RCSfile: valuenodebuilder.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: jb $ $Date: 2001/11/09 12:13:03 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "valuenodebuilder.hxx"

#ifndef CONFIGMGR_PARSERCONTEXT_HXX
#include "parsercontext.hxx"
#endif

namespace configmgr
{
	namespace uno		= ::com::sun::star::uno;
	namespace sax		= ::com::sun::star::xml::sax;
	namespace script	= ::com::sun::star::script;
	namespace lang		= ::com::sun::star::lang;

// -----------------------------------------------------------------------------

AbstractValueNodeBuilder::AbstractValueNodeBuilder(ParserContext& rContext)
: m_rContext(rContext)
, m_aValueConverter(rContext.xTypeConverter)
, m_sNodeName()
, m_sXMLName()
{
}
// -----------------------------------------------------------------------------
	
bool AbstractValueNodeBuilder::isInContent() const
{
	return m_sXMLName.getLength() != 0;
}
// -----------------------------------------------------------------------------

OAttributeParser& AbstractValueNodeBuilder::getAttributeHandler() const
{
	return m_rContext.aAttributeParser;
}
// -----------------------------------------------------------------------------
		
OTreeNodeFactory& AbstractValueNodeBuilder::getNodeFactory() const
{
	return m_rContext.aNodeFactory;
}
// -----------------------------------------------------------------------------

void AbstractValueNodeBuilder::startNode(OUString const& aNodeName, ValueInfo const& aValueDesc)
{
	OSL_ENSURE(!isInContent(), "WARNING: Restarting ValueNodeBuilder while previous node wasn't finished"); 

	m_sNodeName = aNodeName;
	this->getValueConverter().reset( aValueDesc );

	this->startedNode();

	m_sXMLName = m_sNodeName;
}
// -----------------------------------------------------------------------------
void AbstractValueNodeBuilder::endNode()
{
	m_sXMLName = OUString();

	this->finishNode();
}
// -----------------------------------------------------------------------------

void SAL_CALL AbstractValueNodeBuilder::startElement(const rtl::OUString& aName,
													const uno::Reference< sax::XAttributeList > &xAttribs)
	throw(sax::SAXException, uno::RuntimeException)
{
	if (isInContent())
	{
		OSL_ENSURE(false, "Unexpected subelement for value - ignoring");
	}
	else
	{
		OUString aNodeName = getAttributeHandler().getNodeName(aName, xAttribs);

		ValueInfo aValueInfo(m_aBaseAttributes);;
		getAttributeHandler().getValueInfo(xAttribs,aValueInfo);

		this->startNode(aNodeName,aValueInfo);

		m_sXMLName = aName;
	}
}
// -----------------------------------------------------------------------------

void SAL_CALL AbstractValueNodeBuilder::endElement(const rtl::OUString& aName)
	throw(sax::SAXException, uno::RuntimeException)
{
	if (!isInContent())
	{
		OSL_ENSURE(false, "Unexpected end of element for value - ignoring");
	}
	else if (aName.equals(m_sXMLName))
	{
		this->endNode();
	}
}
// -----------------------------------------------------------------------------

uno::Reference< sax::XDocumentHandler > AbstractValueNodeBuilder::doGetSaxHandler()
{
	return this;
}
// -----------------------------------------------------------------------------

void AbstractValueNodeBuilder::doPrepare()
{
	m_sXMLName = m_sNodeName = OUString(); // close and clear
}
// -----------------------------------------------------------------------------

// -----------------------------------------------------------------------------
SimpleValueNodeBuilder::SimpleValueNodeBuilder(ParserContext& rContext)
: AbstractValueNodeBuilder(rContext)
, m_sContentCharacters()
, m_pValueNode()
{
}
		
// -----------------------------------------------------------------------------

void SAL_CALL SimpleValueNodeBuilder::characters(const rtl::OUString& aChars)
		throw(sax::SAXException, uno::RuntimeException)
{
	if (isInContent())
	{
		m_sContentCharacters += aChars;
	}
	else
		OSL_ENSURE(aChars.trim().getLength() == 0, "WARNING: Characters outside of value elements are ignored");
}	
	
// -----------------------------------------------------------------------------
void SAL_CALL SimpleValueNodeBuilder::ignorableWhitespace(const rtl::OUString& aWhitespaces)
		throw(sax::SAXException, uno::RuntimeException)
{
	if (isInContent())
	{
		OSL_ENSURE(false, "There should be no ignorable whitespace inside value text");
		// somehow non-conforming: trear as ordinary character
		this->characters(aWhitespaces);
	}
	// else ignore it
}
		
// -----------------------------------------------------------------------------

void SimpleValueNodeBuilder::startedNode()
{
	OSL_ENSURE(m_pValueNode.get() == NULL, "WARNING: Restarted ValueNodeBuilder without removing previous node");
	m_sContentCharacters = OUString();
}
		
// -----------------------------------------------------------------------------
void SimpleValueNodeBuilder::finishNode()
{
	uno::Any aValue;
    try
    {
	    if (getValueConverter().convertToAny(m_sContentCharacters,aValue))
		    m_pValueNode = implMakeValueNode( aValue );

	    else
		    m_pValueNode = implMakeNullNode();
    }
    catch (com::sun::star::script::CannotConvertException& e)
    {
        OUString const sMsg(RTL_CONSTASCII_USTRINGPARAM("Invalid data format in Value. Conversion error: "));
        throw sax::SAXException(sMsg + e.Message,NULL,uno::makeAny(e));
    }
}
		
// -----------------------------------------------------------------------------

std::auto_ptr<INode> SimpleValueNodeBuilder::doGetNode()
{
	return m_pValueNode;
}	
// -----------------------------------------------------------------------------

void SimpleValueNodeBuilder::doPrepare()
{
	m_pValueNode.reset();
	m_sContentCharacters = OUString();
	AbstractValueNodeBuilder::doPrepare(); 
}
// -----------------------------------------------------------------------------

std::auto_ptr<INode> SimpleValueNodeBuilder::implMakeValueNode(uno::Any const& aValue)
{
	return base_ptr( getNodeFactory().createValueNode( getNodeName(), aValue, getValueInfo().aAttributes ) );
}
		
// -----------------------------------------------------------------------------
std::auto_ptr<INode> SimpleValueNodeBuilder::implMakeNullNode()
{
	return base_ptr( getNodeFactory().createNullValueNode( getNodeName(), getUnoType(), getValueInfo().aAttributes ) );
}		
// -----------------------------------------------------------------------------

	
// -----------------------------------------------------------------------------
	
} // namespace


