/*************************************************************************
 *
 *  $RCSfile: notifycallback.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: jb $ $Date: 2001/09/28 12:44:50 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <stdio.h>

#include "notifycallback.hxx"

#ifndef CONFIGMGR_CONFIGEXCEPT_HXX_
#include "configexcept.hxx"
#endif
#ifndef _CONFIGMGR_STRDECL_HXX_
#include "strdecl.hxx"
#endif
#include "tracer.hxx"

using namespace com::sun::star::uno;
using namespace com::sun::star::xml::sax;
using namespace rtl;

namespace configmgr
{

//==========================================================================
//= ONotifyHandler
//==========================================================================
// -------------------------------------------------------------------------
ONotifyHandler::ONotifyHandler(const vos::ORef<OOptions> &_aOptions,
								 const AbsolutePath& _rPath, 			   
								 const AbsolutePath& _rOrgPath)
				:XMLTreeChangeListBuilder( XMLTreeChangeListBuilder::Uninitialized() )
				,m_xOptions(_aOptions)				
				,m_aPath(_rPath)
				,m_aOrgPath(_rOrgPath)
{	
	XMLTreeChangeListBuilder::init( m_aPath.getModuleName().toString(), m_xOptions);

	m_aCondition.reset();
}

// -------------------------------------------------------------------------
ONotifyHandler::~ONotifyHandler()
{
	m_aCondition.set();
}

// IInterface
// -------------------------------------------------------------------------
void SAL_CALL ONotifyHandler::acquire() throw ()
{
	XMLTreeChangeListBuilder::acquire();
}

// -----------------------------------------------------------------------------
void SAL_CALL ONotifyHandler::release() throw ()
{
	XMLTreeChangeListBuilder::release();
}

// XDocumentHandler
// -------------------------------------------------------------------------
void SAL_CALL ONotifyHandler::startDocument(void) throw (sax::SAXException, uno::RuntimeException)
{
	// be sure the root is empty
	::osl::MutexGuard aGuard(getMutex());
	if (m_pChanges.get())
		setChangeList(*m_pChanges.get());
	XMLTreeChangeListBuilder::startDocument();
}

// -------------------------------------------------------------------------
void SAL_CALL ONotifyHandler::endDocument(void) throw (sax::SAXException, uno::RuntimeException)
{
	XMLTreeChangeListBuilder::endDocument();

	::vos::ORef< INotifyListener > xListener;
	std::auto_ptr<TreeChangeList> pChanges;		// receives the ownership for the changes
	{
		::osl::MutexGuard aGuard(getMutex());
		xListener = m_xNotifyListener;
		pChanges = m_pChanges;
	}

	if (xListener.isValid())
		xListener->nodeUpdated(*pChanges.get());
}

// INotifyBroadcaster
// -------------------------------------------------------------------------
void ONotifyHandler::setNotifyListener(const ::vos::ORef< INotifyListener >& _rListener)
{
	::osl::MutexGuard aGuard(getMutex());
	OSL_ENSURE(!m_xNotifyListener.isValid(), "XMLTreeBuilder::setNodeListener : listener is already set, implementation error!");
	m_xNotifyListener = _rListener;
}

// IDataRequestCallback
// -----------------------------------------------------------------------------
uno::Reference< sax::XDocumentHandler > ONotifyHandler::getDataReader() { return uno::Reference< sax::XDocumentHandler >(this); }

// IRequestCallback
// -----------------------------------------------------------------------------
void ONotifyHandler::failed(sal_Int32 nErrorCode)
{
	m_aCondition.set();				 // will not block
}

// -----------------------------------------------------------------------------
void ONotifyHandler::done(const StatusInfo& rStatus)
{
	m_aStatus = rStatus;
	m_aCondition.set();				 // will not block
}

// -----------------------------------------------------------------------------
StatusInfo ONotifyHandler::waitToResponse(TimeValue* _pTimeout)
{
	m_aCondition.wait(_pTimeout);

	::osl::MutexGuard aGuard(getMutex());
	return m_aStatus;
}

// INotifyCallback
// -------------------------------------------------------------------------
void ONotifyHandler::notifyOccured(const AbsolutePath& _rPath)
{
    using namespace configuration;

    try
    {
        AbsolutePath aFullPath( m_aPath );

	    // determine the rel path for the notification
        OSL_ENSURE( Path::hasPrefix(_rPath,m_aOrgPath), "ONotifyHandler::notifyOccured : notification path mismatch!");																						
        if (_rPath.getDepth() != m_aOrgPath.getDepth())
	    {
            RelativePath aRelPath = Path::stripPrefix(_rPath,m_aOrgPath);

            aFullPath = aFullPath.compose(aRelPath);
        }
        else
            OSL_ENSURE( matches(_rPath,m_aOrgPath), "ONotifyHandler::notifyOccured : notification path mismatch!");																						


        m_pChanges = std::auto_ptr<TreeChangeList>( new TreeChangeList( m_xOptions, aFullPath )   );
    }
    catch (configuration::InvalidName& e)
    {
        OSL_ENSURE(false,"Invalid path receiceved for remote notification\n");
        CFG_TRACE_ERROR("notification dispatch: Invalid path receiceved for remote notification: '%s'",e.what());
    }
}

// -------------------------------------------------------------------------

} // namespace configmgr

