/*************************************************************************
 *
 *  $RCSfile: attributeparser.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: jb $ $Date: 2001/09/28 12:44:49 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

/* PLEASE DON'T DELETE ANY COMMENT LINES, ALSO IT'S UNNECESSARY. */

#ifndef CONFIGMGR_ATTRIBUTEPARSER_HXX
#define CONFIGMGR_ATTRIBUTEPARSER_HXX

#ifndef _COM_SUN_STAR_XML_SAX_XATTRIBUTELIST_HPP_
#include <com/sun/star/xml/sax/XAttributeList.hpp>
#endif

namespace configmgr
{
	namespace uno		= ::com::sun::star::uno;
	namespace sax		= ::com::sun::star::xml::sax;

	using rtl::OUString;
// -----------------------------------------------------------------------------
	namespace node { struct Attributes; }
	typedef node::Attributes NodeAttributes;

	struct ValueInfo;

// -----------------------------------------------------------------------------
	class OAttributeParser
	{
		OUString m_sCurrentModule;
	public:
		OAttributeParser(OUString const& _sModule) 
		: m_sCurrentModule(_sModule)
		{
		}

		OUString const& getCurrentModule() const
		{ return m_sCurrentModule; }


		/// takes the node name from either an attribute or the element name
		OUString getNodeName(OUString const& sElementName, uno::Reference< sax::XAttributeList > const& xAttribs);

		/// retrieve the locale stored in the attribute list
		OUString getLocale(uno::Reference< sax::XAttributeList > const& xAttribs);

		/// retrieve the locale stored in the attribute list or use the context locale
		OUString getLocale(uno::Reference< sax::XAttributeList > const& xAttribs, OUString const& sContextLocale);

		/// query whether the node is deleted
		bool isDeleted(uno::Reference< sax::XAttributeList > const& xAttribs);

		/// query whether the node is localized
		bool isLocalized(uno::Reference< sax::XAttributeList > const& xAttribs);

		/// query whether the node is a value
		bool isValue(uno::Reference< sax::XAttributeList > const& xAttribs);

		/// query whether the node is a set
		bool isSet(uno::Reference< sax::XAttributeList > const& xAttribs);

		/// retrieve element type (without module name) of a set, 
		bool getSetElementType(uno::Reference< sax::XAttributeList > const& xAttribs, OUString& aElementType);

		/// retrieve element type and associated module name of a set, 
		bool getSetElementType(uno::Reference< sax::XAttributeList > const& xAttribs, OUString& aElementType, OUString& aElementTypeModule);

		/// retrieve the node's type name
		OUString getType(uno::Reference< sax::XAttributeList > const& xAttribs);

		/// reads attributes for nodes from the attribute list
		void getNodeAttributes(uno::Reference< sax::XAttributeList > const& xAttribs, NodeAttributes& aAttributes);

		/// reads attributes for value nodes from the attribute list
		bool getValueInfo(uno::Reference< sax::XAttributeList > const& xAttribs, ValueInfo& aInfo);

	// low-level internal methods

		/// checks for presence of a boolean attribute and assigns its value if it exists (and is a bool)
		bool maybeGetAttribute(uno::Reference< sax::XAttributeList > const& xAttribs, OUString const& aAttributeName, bool& aAttributeValue);

		/// checks for presence of an attribute and assigns its value if it exists 
		bool maybeGetAttribute(uno::Reference< sax::XAttributeList > const& xAttribs, OUString const& aAttributeName, OUString& aAttributeValue);

		/// assigns an attribute value or an empty string if it doesn't exist
		void alwaysGetAttribute(uno::Reference< sax::XAttributeList > const& xAttribs, OUString const& aAttributeName, OUString& aAttributeValue);
	};
// -----------------------------------------------------------------------------
	
} // namespace

#endif

