/*************************************************************************
 *
 *  $RCSfile: defaultproviderproxy.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: jb $ $Date: 2001/11/09 12:01:06 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef CONFIGMGR_DEFAULTPROVIDER_PROXY_HXX_
#define CONFIGMGR_DEFAULTPROVIDER_PROXY_HXX_

#ifndef CONFIGMGR_CONFIGPATH_HXX_
#include "configpath.hxx"
#endif
#ifndef CONFIGMGR_UTILITY_HXX_
#include "utility.hxx"
#endif

#ifndef _SALHELPER_SIMPLEREFERENCEOBJECT_HXX_
#include <salhelper/simplereferenceobject.hxx>
#endif

#ifndef _VOS_REF_HXX_
#include <vos/ref.hxx>
#endif

#ifndef INCLUDED_MEMORY
#include <memory>
#define INCLUDED_MEMORY
#endif

namespace configmgr
{
//-----------------------------------------------------------------------------
	class ISubtree;
    class IDefaultProvider;
    class IDefaultableTreeManager;
	class OOptions;
//-----------------------------------------------------------------------------
	namespace configuration
	{
//-----------------------------------------------------------------------------

		/// provides access to the defaults for a given request
        class DefaultProviderProxy 
        : public salhelper::SimpleReferenceObject
		{
            // the data defining a request
            AbsolutePath            m_aBaseLocation;
            vos::ORef< OOptions >   m_xOptions;
            sal_Int16               m_nRequestDepth;

            // the object(s) that provide the defaults
            IDefaultProvider *          m_pDefaultTreeProvider;  
            IDefaultableTreeManager *   m_pDefaultTreeManager;
        public:
            explicit
			DefaultProviderProxy(
                    IDefaultProvider *          _pDefaultTreeProvider,  
                    IDefaultableTreeManager *   _pDefaultTreeManager,
                    AbsolutePath        const&  _aBaseLocation,
                    vos::ORef<OOptions> const&  _xOptions,
                    sal_Int16                   _nRequestDepth
                );

			~DefaultProviderProxy();

        /// tries to load default data into the specified location (which must be within the request range owned)
            bool fetchDefaultData(AbsolutePath const& _aLocation) const CFG_UNO_THROW_ALL();

		/// tries to load a default instance of the specified node (which must be within the request range owned)
            std::auto_ptr<ISubtree> getDefaultTree(AbsolutePath const& _aLocation) const CFG_UNO_THROW_ALL();

        private:
            sal_Int16 implGetRemainingDepth(AbsolutePath const& _aLocation) const;
		};
//-----------------------------------------------------------------------------
	}
}

#endif // CONFIGMGR_DEFAULTPROVIDER_PROXY_HXX_
