/*************************************************************************
 *
 *  $RCSfile: treedata.hxx,v $
 *
 *  $Revision: 1.15 $
 *
 *  last change: $Author: jb $ $Date: 2001/11/09 12:07:04 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef CONFIGMGR_TREEDATA_HXX
#define CONFIGMGR_TREEDATA_HXX

#ifndef CONFIGMGR_LOADER_HXX
#include "loader.hxx"
#endif
#ifndef CONFIGMGR_TREEPROVIDER_HXX
#include "treeprovider.hxx"
#endif
#ifndef CONFIGMGR_CHANGE_HXX
#include "change.hxx"
#endif
#ifndef CONFIGMGR_TIMESTAMP_HXX
#include "timestamp.hxx"
#endif
#ifndef CONFIGMGR_API_APITYPES_HXX_
#include "apitypes.hxx"
#endif

#ifndef _COM_SUN_STAR_LANG_WRAPPEDTARGETEXCEPTION_HPP_
#include <com/sun/star/lang/WrappedTargetException.hpp>
#endif

#ifndef _OSL_MUTEX_HXX_
#include <osl/mutex.hxx>
#endif
#ifndef _VOS_REFERNCE_HXX_
#include <vos/refernce.hxx>
#endif

#ifndef INCLUDED_MEMORY
#include <memory>
#define INCLUDED_MEMORY
#endif
#ifndef INCLUDED_SET
#include <set>
#define INCLUDED_SET
#endif
#ifndef INCLUDED_MAP
#include <map>
#define INCLUDED_MAP
#endif

namespace configmgr
{
////////////////////////////////////////////////////////////////////////////////
	using ::rtl::OUString;
	using ::std::set;
	using ::std::map;
	using ::std::auto_ptr;
	using ::comphelper::UStringLess;

	struct TreeChangeList;
	class Subtree;
	class ConfigChangeBroadcastHelper;
	class OTreeDisposeScheduler;	
	class IConfigSession;

////////////////////////////////////////////////////////////////////////////////
	/** a tree of INode's without to much intelligence. No caching, not automatic loading, just a container.
		<BR>
		This object represents a module tree only
	*/
	class ModuleTree : public vos::OReference, NotCopyable /// base class is a reference for list containment
	{
	public:
        typedef configuration::Name Name;
        typedef configuration::AbsolutePath AbsolutePath;
        typedef configuration::AbsolutePath Location;

		static 
		vos::ORef<ModuleTree> makeModuleTree(const AbsolutePath& _rLocation, std::auto_ptr<ISubtree> pSubtree, 
                                             sal_Int16 nReliableLevels, sal_Int16 nDefaultLevels) CFG_UNO_THROW_RTE();

		ISubtree *	addSubtree(const Location& _rLocation, std::auto_ptr<ISubtree> pSubtree, 
                                sal_Int16 nReliableLevels, sal_Int16 nDefaultLevels) CFG_UNO_THROW_RTE();

		ISubtree *	getModuleRoot( ) const { return m_pModuleRoot.get(); }
		ISubtree *	getSubtree(const Location& aComponentName ) const;
		INode*		getNode(const Location& _rPath) const;

		void addPending(const Location& _rLocation, const SubtreeChange* pSubtreeChange) CFG_UNO_THROW_RTE();
		std::auto_ptr<SubtreeChange> releasePending() {return m_pPending;}
		SubtreeChange* getPending() {return m_pPending.get();}
	
		bool hasPending() const {return m_pPending.get() != NULL;}
		
		// get the module name for this component
		Name getModuleName() const;

		/// add a client for this modules data
		vos::ORefCount::RefCount clientReferences() const { return m_nDataRefs.referenced(); }
		/// add a client for this modules data
		vos::ORefCount::RefCount clientAcquire() { return ++m_nDataRefs; }			
		/// subtract a client for this modules data
		vos::ORefCount::RefCount clientRelease() { return --m_nDataRefs; }		
	private:
		explicit ModuleTree(std::auto_ptr<ISubtree> pModuleRoot); // create a ModuleTree for the given root

		vos::ORefCount			m_nDataRefs;			/// the number of clients on this modules data
		std::auto_ptr<ISubtree>	m_pModuleRoot;			/// the actual data

		std::auto_ptr<SubtreeChange> m_pPending;
	};
	typedef vos::ORef<ModuleTree> ModuleTreeRef;

////////////////////////////////////////////////////////////////////////////////
	struct ModuleTreeLess
	{
		bool operator()(const ModuleTree::Name& lhs, const ModuleTree::Name& rhs) const 
		{ 
			UStringLess comp;
			return comp(lhs.toString(),rhs.toString());
		}
/*		bool operator()(const ModuleTree& lhs, const ModuleTree& rhs) const 
		{ 
			return (*this)(lhs.getModuleName(),rhs.getModuleName());
		}
		bool operator()(const ModuleTreeRef& lhs, const ModuleTreeRef& rhs) const 
		{ 
			return (lhs.isValid() && rhs.isValid() ) 
					? (*this)(lhs.getBody(),rhs.getBody())
					: (lhs.isEmpty() && rhs.isValid()); 
		}
*/
	};
////////////////////////////////////////////////////////////////////////////////
	/** a tree of INode's without to much intelligence. No caching, not automatic loading, just a container.
		<BR>
		Though the object supports the <type>ISynchronizedData</type> interface, no own locking occurs, this is the responsibility
		of the objects using an instance of this class.
	*/
	class Tree			
	{
	public:
        typedef configuration::AbsolutePath AbsolutePath;
	public:
		Tree();
		~Tree();

		/// retrieve the module tree name for the given path
		static ModuleTree::Name extractModuleName(AbsolutePath const& sPath);

		/// retrieve the given subtree without changing its ref count
		ISubtree const*	getSubtree( AbsolutePath const& aComponentName ) const;
		/// retrieve the given node without changing its ref count
		const INode* getNode(const AbsolutePath& _rPath);

		/** add or merge the given subtree at the given location,
			return the tree that is now pertinent and clientAcquire() it once
		*/
		ISubtree * addSubtree(const AbsolutePath& _rLocation, std::auto_ptr<ISubtree> pSubtree, 
                                sal_Int16 nReliableLevels, sal_Int16 nDefaultLevels) CFG_UNO_THROW_RTE(  );
		
		/// add or merge the given subtreechange at the given location
		void addPending(const AbsolutePath& _rLocation, const SubtreeChange* pSubtreeChange) CFG_UNO_THROW_RTE(  );
		std::auto_ptr<SubtreeChange> getPending(ModuleTree::Name const& aComponentName);

		/// retrieve the subtree at aComponentName (if its depth is at least nMinLevels) and clientAcquire() it
		ISubtree* acquireSubtreeWithDepth( AbsolutePath const& aComponentName, sal_Int16 nMinLevels, sal_Int16 nMinDefaultLevels ); 
		/// clientRelease() the tree at aComponentName, and return the resulting reference count
		vos::ORefCount::RefCount releaseSubtree( AbsolutePath const& aComponentName ); 

		/// merge the given change list into this tree
		void mergeChanges(const AbsolutePath& _rRootLocation, SubtreeChange& _aChangeRoot) CFG_UNO_THROW_RTE(  );

		// low-level interface for cache management
		typedef map<ModuleTree::Name, ModuleTreeRef, ModuleTreeLess> ModuleList;
		ModuleList& accessModuleList() { return m_aModules; }


	private:
		ISubtree*	implGetSubtree(const AbsolutePath& aComponentName ) const;
		INode*		implGetNode(const AbsolutePath& _rPath) const;

		ModuleTreeRef implNewModuleTree(const AbsolutePath& _rLocation, std::auto_ptr<ISubtree> _pSubtree, sal_Int16 nLevels, sal_Int16 nDefaultLevels) CFG_UNO_THROW_RTE(  );
		ModuleTreeRef implGetModuleTree(const AbsolutePath& _rPath) const;
		ModuleTreeRef implGetModuleTree(const ModuleTree::Name& _rPath) const;

	private:
		ModuleList m_aModules;
	};


////////////////////////////////////////////////////////////////////////////////
	
//==========================================================================
//= TreeInfo
//==========================================================================

	class TreeManager;
	typedef std::vector<vos::ORef< OOptions > > SuccessfulList;

	struct TreeInfo : NotCopyable
	{
	public:
        typedef configuration::AbsolutePath AbsolutePath;

		typedef set< OUString, UStringLess >						NodeList;
		typedef std::vector< ModuleTreeRef >						DisposeList;
	private:
		typedef map< ModuleTree::Name, TimeStamp, ModuleTreeLess >	DeadModuleList;
		typedef map< ModuleTree::Name, vos::ORef< OTreeLoader >, ModuleTreeLess > PendingLoadList;

		osl::Mutex			aMutex;
		Tree				aTree;		
		DeadModuleList		m_aDeadModules;			/// list of nodes which are registered for throwing away
		PendingLoadList		m_aPendingLoads;		/// list of nodes which are fetched async

	public:
		ConfigChangeBroadcastHelper*			pBroadcastHelper;
		OTreeDisposeScheduler&					m_rDisposer;

		//TreeInfo():aMutex(),aTree(),pBroadcastHelper(NULL){}
		TreeInfo(OTreeDisposeScheduler& _rDisposer, ConfigChangeBroadcastHelper* _pHelper)
		: aMutex()
		, aTree()
		, pBroadcastHelper(_pHelper)
		, m_rDisposer(_rDisposer)
		{}	
		
		/** add or merge the given subtree at the given location,
			return the tree that is now pertinent[relevant] and clientAcquire() it once
		*/
		ISubtree * addSubtree(const AbsolutePath& _rLoadedLocation, const AbsolutePath& _rRelLocation, std::auto_ptr<ISubtree> pSubtree, 
                                sal_Int16 nReliableLevels, sal_Int16 nDefaultLevels) CFG_UNO_THROW_RTE(  );

		/// retrieve the subtree at aComponentName (if its depth is at least nMinLevels) and clientAcquire() it
		ISubtree*  acquireSubtreeWithDepth(AbsolutePath const& aComponentName, sal_Int16 nMinLevels, sal_Int16 nMinDefaultLevels); 

		/// clientRelease() the tree at aComponentName, and return the resulting reference count
		vos::ORefCount::RefCount releaseSubtree( AbsolutePath const& aComponentName ); 

		/// retrieve the given subtree without changing its ref count
		ISubtree const*	getSubtree( AbsolutePath const& aComponentName );

		/// merge the given change list into this tree
		void updateTree( TreeChangeList& _rList) CFG_UNO_THROW_RTE(  );	

		/// create a Loader for loading the node
		vos::ORef< OTreeLoader > getLoader(AbsolutePath const& aComponentName, 
										   sal_Int16 nMinLevels, 
										   vos::ORef< OOptions > const& _xOptions, 
										   IConfigSession* pSession,
										   sal_Bool bPreLoad = sal_False);

		/// create a New Loader for loading the node
		vos::ORef< OTreeLoader > getNewLoaderWithoutPending(AbsolutePath const& aComponentName, 
															sal_Int16 nMinLevels, 
															vos::ORef< OOptions > const& _xOptions, 
															IConfigSession* pSession);

		/// release the Loader if necessary
		void releaseLoader(vos::ORef< OTreeLoader > const& _xLoader);

		/// merge the given change list into the pending change list of this tree
		void addPending( TreeChangeList const& _rList ) CFG_UNO_THROW_RTE(  );
		std::auto_ptr<SubtreeChange> getPending(ModuleTree::Name const& aComponentName);

		void syncPending(vos::ORef< OOptions > const& _xOptions, TreeManager& _rTreeManager) CFG_UNO_THROW_ALL(  );

		/// clear the contained tree, return all contained modules
		void clearTree( DisposeList& _rList) CFG_NOTHROW();

		/// return TRUE if there is no data left in this object's tree 
		bool isEmpty();

		/** do dispose all Trees that are marked for disposal later  than the given time;
			returns a list of removed nodes in _rList
			@return the next dispose time left in the list (or never() if none)
		*/
		TimeStamp runDisposer(DisposeList& _rList, TimeStamp const& aLimitTime);

		// Should fetching and removing be separate ?
		/** extract the first Module having pending changes due after aLimitTime
			<p>Fill _rPendingChange with the next Module (and location),
			   whose changes are due after aLimitTime (or set its root to NULL if none)
			</p>
			@return  the next due time left in the list (or TimeStamp::never() if none)
		*/
		TimeStamp fetchNextPendingChangeAfter(TreeChangeList& _rPendingChange, TimeStamp const& aLimitTime);
 
		static uno::Sequence< OUString > collectNodeIds(DisposeList const& _rList);
	};


////////////////////////////////////////////////////////////////////////////////
	
} // namespace configmgr

#endif

