/*************************************************************************
 *
 *  $RCSfile: socketstream.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: dg $ $Date: 2001/01/25 11:23:35 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _CONFIGMGR_SESSION_SOCKETSTREAM_HXX_
#define _CONFIGMGR_SESSION_SOCKETSTREAM_HXX_

#ifndef _VOS_SOCKET_HXX_
#include <vos/socket.hxx>
#endif

#ifndef _CONFIGMGR_SESSION_SESSIONSTREAM_HXX_
#include "sessionstream.hxx"
#endif

//..........................................................................
namespace configmgr
{
//..........................................................................

//#define ISOCKET()	static_cast<OConnectorSocket*>(m_pReader)
//#define OSOCKET()	static_cast<OConnectorSocket*>(m_pWriter)
#define ISOCKET()	m_pSocket
#define OSOCKET()	m_pSocket

//==========================================================================
//= OSocketInputStream
//==========================================================================
/** wraps an socket stream to an UNO <type scope="com::sun::star::io">XInputStream</type>
*/
class OSocketInputStream : public OSessionInputStream
{
protected:
	::vos::OConnectorSocket*	m_pSocket;	/// the base class knows this as void*
public:
	/** creates a new input stream, based on a connector socket.<BR>
		the socket should not have an read receive timeout.<BR>
		If somebody calls closeInput on the <type scope="com::sun::star::io">XInputStream</type> interface,
		the socket will be closed
		@param		_pReader		the socket to use. Must not be NULL. Instead of using a mutex common for different
									threads accessing the same socket, there are some conventions :<BR>
									The socket MUST not be closed until <method>closeInput</method> on this stream
									object has been called.<BR>
									This implies that the socket must not be deleted before calling
									<method>closeInput</method>.
	*/
	OSocketInputStream(::vos::OConnectorSocket* _pReader);

protected:
	virtual sal_Bool	implRead(::com::sun::star::uno::Sequence< sal_Int8 >& _rData, sal_Int32& _nBytes, sal_Bool _bWantAll)
		throw (::com::sun::star::io::NotConnectedException, ::com::sun::star::io::IOException);

	virtual sal_Bool	isConnected();
	virtual void		implClose();
};


//==========================================================================
//= OSocketOutputStream
//==========================================================================
/** wraps an socket stream to an UNO <type scope="com::sun::star::io">XInputStream</type>
*/
class OSocketOutputStream : public OSessionOutputStream
{
protected:
	::vos::OConnectorSocket*	m_pSocket;	/// the base class knows this as void*
public:
	/** creates a new output stream, based on a connector socket.<BR>
		If somebody calls closeInput on the <type scope="com::sun::star::io">XInputStream</type> interface,
		the socket will be closed.
		@param		_pWriter		the socket to use. Must not be NULL.Instead of using a mutex common for different
									threads accessing the same socket, there are some conventions :<BR>
									The socket MUST not be closed until <method>closeOutput</method> on this stream
									object has been called.<BR>
									This implies that the socket must not be deleted before calling
									<method>closeOutput</method>.
	*/
	OSocketOutputStream(::vos::OConnectorSocket* _pWriter);

protected:
	virtual sal_Int32	implWrite(const ::com::sun::star::uno::Sequence< sal_Int8 >& _rData);
	virtual sal_Bool	isConnected();
	virtual void		implClose();
};

//..........................................................................
}	// namespace configmgr
//..........................................................................

#endif // _CONFIGMGR_SESSION_SOCKETSTREAM_HXX_


