/*************************************************************************
 *
 *  $RCSfile: sessionstream.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: jl $ $Date: 2001/03/21 12:22:24 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "tracer.hxx"
#ifndef _CONFIGMGR_SESSION_SESSIONSTREAM_HXX_
#include "sessionstream.hxx"
#endif
#ifndef _OSL_DIAGNOSE_H_
#include <osl/diagnose.h>
#endif
#ifndef _CONFIGMGR_SESSION_RS_TYPES_HXX_
#include "rs_types.hxx"
#endif

#include <string.h>

#define ENTER()		\
	Guard aGuard(m_aMutex);	\
	checkConnected();

//..........................................................................
namespace configmgr
{
//..........................................................................

using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::io;
using namespace ::std;
using namespace ::osl;

//========================================================================
// = OMutexWrapper
//------------------------------------------------------------------------
void OMutexWrapper::acquire()
{
	m_aMaster.acquire();
}

//------------------------------------------------------------------------
void OMutexWrapper::release()
{
	m_aMaster.release();
}

//==========================================================================
//= OSessionInputStream
//==========================================================================
//--------------------------------------------------------------------------
OSessionInputStream::OSessionInputStream(void* _pReader)
	:m_pReader(_pReader)
	,m_nBytesToSkip(0)
	,m_bClosed(sal_False)
{
}

//--------------------------------------------------------------------------
sal_Bool OSessionInputStream::doImplRead(Sequence< sal_Int8 >& _rData, sal_Int32& _nBytes, sal_Bool _bWantAll) throw (NotConnectedException, IOException)
{
	sal_Int32 nPrepended = 0;

	if (m_aPrependSeq.getLength())
	{	// copy as much bytes from the prepend sequence into the buffer
		sal_Int8* pBuffer = _rData.getArray();
		sal_Int32 nOldLen = m_aPrependSeq.getLength();
		nPrepended = nOldLen < _nBytes ? nOldLen : _nBytes;

		memmove(pBuffer, m_aPrependSeq.getConstArray(), nPrepended);
		memmove(m_aPrependSeq.getArray(), m_aPrependSeq.getArray() + nPrepended, nOldLen - nPrepended);
		m_aPrependSeq.realloc(nOldLen - nPrepended);

		if (_nBytes == nPrepended)
		{	// this was sufficient, the prepend seq supplied enough bytes
			return sal_True;
		}

		// need to read some less bytes
		pBuffer += nPrepended;
		_nBytes -= nPrepended;

		if (!_bWantAll)
		{
			// -> don't really read anything from the socket at this time
			_nBytes = nPrepended;
			return sal_True;
		}
	}

	if (!implRead(_rData, _nBytes, _bWantAll))
		return sal_False;

	_nBytes += nPrepended;
	return sal_True;
}

//--------------------------------------------------------------------------
void OSessionInputStream::pushBackPrependBytes(const sal_Int8* _pBuffer, sal_Int32 _nCount)
{
	sal_Int32 nOldPrependLen = m_aPrependSeq.getLength();
	m_aPrependSeq.realloc(nOldPrependLen + _nCount);
	sal_Int8* pCopyRemainingTo = m_aPrependSeq.getArray() + nOldPrependLen;
	memmove(pCopyRemainingTo, _pBuffer, _nCount);
}

//--------------------------------------------------------------------------
sal_Bool OSessionInputStream::implSkip() throw (NotConnectedException, IOException)
{
	OSL_ENSURE(m_nBytesToSkip != 0, "OSessionInputStream::implSkip : please check m_nBytesToSkip before calling this !");

	const sal_Int32 nTempBufferSize = 1024;
	Sequence< sal_Int8 > aTempBuffer(nTempBufferSize);
	
	sal_Int32 nThisRound;
	// now just read the dummies
	while (m_nBytesToSkip)
	{
		nThisRound = m_nBytesToSkip < nTempBufferSize ? m_nBytesToSkip : nTempBufferSize;
		if (!doImplRead(aTempBuffer, nThisRound, sal_True))
			// will throw a NotConnectedException if somebody closes the input while reading
			// or an IOException if an error occured
		{	// if doImplRead returned sal_False without throwin' an exception, the end-of-file is reached
			return sal_False;
		}
		m_nBytesToSkip -= nThisRound;
	}

	return sal_True;
}

//--------------------------------------------------------------------------
sal_Int32 SAL_CALL OSessionInputStream::readBytes( Sequence< sal_Int8 >& _aData, sal_Int32 _nBytesToRead ) throw(NotConnectedException, BufferSizeExceededException, IOException, RuntimeException)
{
	ENTER();
	// skip bytes, if neccessary
	if (m_nBytesToSkip)
		if (!implSkip())
		{	// eof
			_aData.realloc(0);
			return sal_False;
		}

	if (_aData.getLength() < _nBytesToRead)
		_aData.realloc(_nBytesToRead);

	sal_Int32 nReallyRead(_nBytesToRead);
	doImplRead(_aData, nReallyRead, sal_True);
	_aData.realloc(nReallyRead);
	return nReallyRead;
}

//--------------------------------------------------------------------------
sal_Int32 SAL_CALL OSessionInputStream::readSomeBytes( Sequence< sal_Int8 >& _aData, sal_Int32 _nMaxBytesToRead ) throw(NotConnectedException, BufferSizeExceededException, IOException, RuntimeException)
{
	ENTER();
	// skip bytes, if neccessary
	if (m_nBytesToSkip)
		if (!implSkip())
		{	// eof
			_aData.realloc(0);
			return 0;
		}

	if (_aData.getLength() < _nMaxBytesToRead)
		_aData.realloc(_nMaxBytesToRead);

	sal_Int32 nReallyRead(_nMaxBytesToRead);
	doImplRead(_aData, nReallyRead, sal_False);
#ifdef CFG_ENABLE_TRACING
	CFG_TRACE_INFO("session input stream: read %i bytes", nReallyRead);

	static sal_Bool bReadSomethingLastRound = sal_True;
	if (!bReadSomethingLastRound && (0 == nReallyRead))
	{
		CFG_TRACE_WARNING_NI("session input stream: (two EOF's after another !)");
	}
	bReadSomethingLastRound = (0 != nReallyRead);
#endif
	_aData.realloc(nReallyRead);
	return nReallyRead;
}

//--------------------------------------------------------------------------
void SAL_CALL OSessionInputStream::skipBytes( sal_Int32 _nBytesToSkip ) throw(NotConnectedException, BufferSizeExceededException, IOException, RuntimeException)
{
	ENTER();
	OSL_ENSURE(_nBytesToSkip > 0, "OSessionInputStream::skipBytes : senseless argument !");
	if (0x7FFFFFFF - _nBytesToSkip < m_nBytesToSkip)
		throw BufferSizeExceededException(
			::rtl::OUString::createFromAscii("XInputStream::skipBytes : can skip more than 2GB non-blocking !"),
			*this
		);

	m_nBytesToSkip += _nBytesToSkip;
}

//--------------------------------------------------------------------------
sal_Int32 SAL_CALL OSessionInputStream::available(  ) throw(NotConnectedException, IOException, RuntimeException)
{
	ENTER();
	throw IOException(::rtl::OUString::createFromAscii("XInputStream::available : method is not supported by the present implementation !"),
		*this);
	// not supported in this implementation, no chance to know the number asked for ...
}

//--------------------------------------------------------------------------
void SAL_CALL OSessionInputStream::closeInput(  ) throw(NotConnectedException, IOException, RuntimeException)
{
	CFG_TRACE_INFO("session stream: closing input");
	m_bClosed = sal_True;
		// do this before acquiring m_aMutex !

	MutexGuard aCloseGuard(m_aCloseMutex);
	if (isConnected())
		implClose();

	ENTER();
	m_pReader = NULL;
}

//--------------------------------------------------------------------------
sal_Bool OSessionInputStream::isConnected()
{
	return NULL != m_pReader;
}

//==========================================================================
//= OSessionOutputStream
//==========================================================================
//--------------------------------------------------------------------------
OSessionOutputStream::OSessionOutputStream(void* _pWriter)
	:m_pWriter(_pWriter)
{
	OSL_ENSURE(m_pWriter != NULL, "OSessionOutputStream::OSessionOutputStream : invalid socket !");
}
//--------------------------------------------------------------------------
sal_Bool OSessionOutputStream::isConnected()
{
	return NULL != m_pWriter;
}

//--------------------------------------------------------------------------
void SAL_CALL OSessionOutputStream::writeBytes( const Sequence< sal_Int8 >& _rData ) throw(NotConnectedException, BufferSizeExceededException, IOException, RuntimeException)
{
	ENTER();
	implWrite(_rData);
}

//--------------------------------------------------------------------------
void SAL_CALL OSessionOutputStream::closeOutput(	) throw(NotConnectedException, BufferSizeExceededException, IOException, RuntimeException)
{
	CFG_TRACE_INFO("session stream: closing output");
	MutexGuard aCloseGuard(m_aCloseMutex);
	if (isConnected())
		implClose();

	ENTER();
	m_pWriter = NULL;
}
//..........................................................................
}	// namespace configmgr
//..........................................................................


