/*************************************************************************
 *
 *  $RCSfile: remotesession.cxx,v $
 *
 *  $Revision: 1.43 $
 *
 *  last change: $Author: rt $ $Date: 2001/10/12 11:08:35 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <stdio.h>

#ifndef _CONFIGMGR_SESSION_REMOTESESSION_HXX_
#include "remotesession.hxx"
#endif
#ifndef CONFIGMGR_MISC_ATTRIBUTELIST_HXX
#include "attributelist.hxx"
#endif
#ifndef _CONFIGMGR_SESSION_RECEIVETHREAD_HXX_
#include "receivethread.hxx"
#endif
#ifndef _CONFIGMGR_SESSION_ENVELOPESTREAM_HXX_
#include "envelopestream.hxx"
#endif
#ifndef _CONFIGMGR_SESSION_REDIRECTOR_HXX_
#include "redirector.hxx"
#endif
#ifndef _CONFIGMGR_SESSION_RS_TYPES_HXX_
#include "rs_types.hxx"
#endif
#ifndef _CONFIGMGR_SAXTOOLS_HXX_
#include "saxtools.hxx"
#endif
#ifndef _CONFIGMGR_SESSION_PORTALSTREAM_HXX_
#include "portalstream.hxx"
#endif
#ifndef _CONFIGMGR_SESSION_SOCKETSTREAM_HXX_
#include "socketstream.hxx"
#endif
#ifndef _CONFIGMGR_TRACER_HXX_
#include "tracer.hxx"
#endif
#ifndef CONFIGMGR_API_ENCODENAME_HXX_
#include "encodename.hxx"
#endif
#ifndef CONFIGMGR_NOTIFYCALLBACK_HXX
#include "notifycallback.hxx"
#endif
#ifndef _CONFIGMGR_STRDECL_HXX_
#include "strdecl.hxx"
#endif
#ifndef _CONFIGMGR_XMLTREEBUILDER_HXX
#include "xmltreebuilder.hxx"
#endif
#ifndef _OSL_DIAGNOSE_H_
#include <osl/diagnose.h>
#endif
#ifndef _CPPUHELPER_IMPLBASE2_HXX_
#include <cppuhelper/implbase2.hxx>
#endif
#ifndef _VOS_CONDITN_HXX_
#include <vos/conditn.hxx>
#endif
#ifndef _COM_SUN_STAR_CONNECTION_XCONNECTION2_HPP_
#include <com/sun/star/connection/XConnection2.hpp>
#endif
#ifndef _COM_SUN_STAR_CONNECTION_XCONNECTOR_HPP_
#include <com/sun/star/connection/XConnector.hpp>
#endif
#ifndef _COM_SUN_STAR_IO_XACTIVEDATASOURCE_HPP_
#include <com/sun/star/io/XActiveDataSource.hpp>
#endif
#ifndef _COM_SUN_STAR_UTIL_XCANCELLABLE_HPP_
#include <com/sun/star/util/XCancellable.hpp>
#endif

#ifndef __STLPORT_LIMITS
#include <limits>
#endif

using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::connection;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::xml;
using namespace ::com::sun::star::io;
using namespace ::com::sun::star::util;
using namespace ::vos;
using namespace ::std;
using namespace ::osl;

//..........................................................................
namespace configmgr
{
//..........................................................................

#if defined(_ENCODE_USER_NAMES_)
#define USERNAME_ENCODE(s) remote::encodeClientName(s)	
#else
#define USERNAME_ENCODE(s)	s
#endif


#ifdef DBG_UTIL
	typedef ::cppu::WeakImplHelper2< sax::XDocumentHandler, XActiveDataSource > OLayoutRefiner_Base;
	/** a simple layout "refiner" which insertes some whitespaces for every startElement/endElement
		<BR>
		not really perfect :), as for instance no linebreaks in whitespaces which the caller inserts
		are recognized (we would have to insert tabs there), but sufficient for our purposes
	*/
	class OLayoutRefiner : public OLayoutRefiner_Base
	{
	protected:
		Reference< sax::XDocumentHandler >	m_xMasterWriter;
		Reference< XActiveDataSource >		m_xMasterSource;
		sal_Int32							m_nElementDepth;

		enum ACTION	{ STARTELEMENT, CHARACTERS, ENDELEMENT };
		ACTION								m_eLastAction;

	public:
		OLayoutRefiner(const Reference< sax::XDocumentHandler >& _rxMasterWriter) : m_xMasterWriter(_rxMasterWriter), m_xMasterSource(_rxMasterWriter, UNO_QUERY), m_nElementDepth(0), m_eLastAction(ENDELEMENT) { }

	// XActiveDataSource
		virtual void SAL_CALL setOutputStream( const ::com::sun::star::uno::Reference< ::com::sun::star::io::XOutputStream >& aStream ) throw(::com::sun::star::uno::RuntimeException) { m_xMasterSource->setOutputStream(aStream); }
		virtual ::com::sun::star::uno::Reference< ::com::sun::star::io::XOutputStream > SAL_CALL getOutputStream(  ) throw(::com::sun::star::uno::RuntimeException) { return m_xMasterSource->getOutputStream(); }

	// XDocumentHandler
		virtual void SAL_CALL startDocument(  ) throw(sax::SAXException, RuntimeException) { m_xMasterWriter->startDocument(); }
		virtual void SAL_CALL endDocument(  ) throw(sax::SAXException, RuntimeException) { m_xMasterWriter->endDocument(); }
		virtual void SAL_CALL startElement( const ::rtl::OUString& aName, const Reference< sax::XAttributeList >& xAttribs ) throw(sax::SAXException, RuntimeException);
		virtual void SAL_CALL endElement( const ::rtl::OUString& aName ) throw(sax::SAXException, RuntimeException);
		virtual void SAL_CALL characters( const ::rtl::OUString& aChars ) throw(sax::SAXException, RuntimeException);
		virtual void SAL_CALL ignorableWhitespace( const ::rtl::OUString& aWhitespaces ) throw(sax::SAXException, RuntimeException) { m_xMasterWriter->ignorableWhitespace(aWhitespaces); }
		virtual void SAL_CALL processingInstruction( const ::rtl::OUString& aTarget, const ::rtl::OUString& aData ) throw(sax::SAXException, RuntimeException) { m_xMasterWriter->processingInstruction(aTarget, aData); }
		virtual void SAL_CALL setDocumentLocator( const Reference< sax::XLocator >& xLocator ) throw(sax::SAXException, RuntimeException) { m_xMasterWriter->setDocumentLocator(xLocator); }
	};
	//--------------------------------------------------------------------------
	void SAL_CALL OLayoutRefiner::startElement( const ::rtl::OUString& aName, const Reference< sax::XAttributeList >& xAttribs ) throw(sax::SAXException, RuntimeException)
	{
		{
			sal_Unicode* pWS = new sal_Unicode[m_nElementDepth + 1];
			sal_Unicode* pFill = pWS;
			*pFill = '\n'; ++pFill;
			for (sal_Int32 i=0; i<m_nElementDepth; ++i, ++pFill)
				*pFill = '\t';
			m_xMasterWriter->ignorableWhitespace(::rtl::OUString(pWS, m_nElementDepth + 1));
			delete pWS;
		}

		++m_nElementDepth;
		m_xMasterWriter->startElement(aName, xAttribs);
		m_eLastAction = STARTELEMENT;
	}

	//--------------------------------------------------------------------------
	void SAL_CALL OLayoutRefiner::endElement( const ::rtl::OUString& aName ) throw(sax::SAXException, RuntimeException)
	{
		--m_nElementDepth;
		if (CHARACTERS != m_eLastAction)
		{
			sal_Unicode* pWS = new sal_Unicode[m_nElementDepth + 1];
			sal_Unicode* pFill = pWS;
			*pFill = '\n'; ++pFill;
			for (sal_Int32 i=0; i<m_nElementDepth; ++i, ++pFill)
				*pFill = '\t';
			m_xMasterWriter->ignorableWhitespace(::rtl::OUString(pWS, m_nElementDepth + 1));
			delete pWS;
		}
		m_xMasterWriter->endElement(aName);
		m_eLastAction = ENDELEMENT;
	}

	//--------------------------------------------------------------------------
	void SAL_CALL OLayoutRefiner::characters( const ::rtl::OUString& aChars ) throw(sax::SAXException, RuntimeException)
	{
		m_xMasterWriter->characters(aChars);
		m_eLastAction = CHARACTERS;
	}
#endif


#if defined(_ENCODE_ELEMENT_NAMES_) || defined(_REMOTE_PATH_TRANSLATION_) || defined(_ENCODE_USER_NAMES_)
	typedef ::cppu::WeakImplHelper1< sax::XDocumentHandler > ODataForwarder_Base;

	class ODataForwarder
	: public ODataForwarder_Base
    {
    protected:
		Reference< sax::XDocumentHandler >	m_xMasterHandler;	// the writer to forward to
        sal_Int32							m_nElementDepth;    // the current nesting depth

	protected:
        ODataForwarder() 
            : m_xMasterHandler()
            , m_nElementDepth(0) 
        {}

	public:
		// XDocumentHandler
		virtual void SAL_CALL startDocument(  ) throw(sax::SAXException, RuntimeException);
		virtual void SAL_CALL endDocument(  ) throw(sax::SAXException, RuntimeException);
		virtual void SAL_CALL startElement( const ::rtl::OUString& aName, const Reference< sax::XAttributeList >& xAttribs ) throw(sax::SAXException, RuntimeException);
		virtual void SAL_CALL endElement( const ::rtl::OUString& aName ) throw(sax::SAXException, RuntimeException);
		virtual void SAL_CALL characters( const ::rtl::OUString& aChars ) throw(sax::SAXException, RuntimeException);
		virtual void SAL_CALL ignorableWhitespace( const ::rtl::OUString& aWhitespaces ) throw(sax::SAXException, RuntimeException);
		virtual void SAL_CALL processingInstruction( const ::rtl::OUString& aTarget, const ::rtl::OUString& aData ) throw(sax::SAXException, RuntimeException);
		virtual void SAL_CALL setDocumentLocator( const Reference< sax::XLocator >& xLocator ) throw(sax::SAXException, RuntimeException);
    };

	//--------------------------------------------------------------------------
	void SAL_CALL ODataForwarder::startDocument() throw(sax::SAXException, RuntimeException)
	{
        OSL_ENSURE(m_nElementDepth <= 0, "ODataForwarder::startDocument: Already started a document");
        m_nElementDepth = 0;

		if (m_xMasterHandler.is())
			m_xMasterHandler->startDocument();
	}

	//--------------------------------------------------------------------------
	void SAL_CALL ODataForwarder::endDocument() throw(sax::SAXException, RuntimeException)
	{
        OSL_ENSURE(m_nElementDepth == 0, "ODataForwarder::endDocument: There are still open elements");
        m_nElementDepth = 0;

		if (m_xMasterHandler.is())
			m_xMasterHandler->endDocument();
	}

	//--------------------------------------------------------------------------
	void SAL_CALL ODataForwarder::startElement(const ::rtl::OUString& aName, const Reference< sax::XAttributeList >& xAttribs) throw(sax::SAXException, RuntimeException)
	{
        OSL_ENSURE(m_nElementDepth >= 0, "ODataForwarder::startElement: Invalid element depth");

		if (m_xMasterHandler.is())
			m_xMasterHandler->startElement(aName,xAttribs);

        ++m_nElementDepth;
	}

	//--------------------------------------------------------------------------
	void SAL_CALL ODataForwarder::endElement(const ::rtl::OUString& aName) throw(sax::SAXException, RuntimeException)
	{
        --m_nElementDepth;
        OSL_ENSURE(m_nElementDepth >= 0, "ODataForwarder::startElement: ending element that wasn't started");

		if (m_xMasterHandler.is())
			m_xMasterHandler->endElement(aName);
	}
	//--------------------------------------------------------------------------
	void SAL_CALL ODataForwarder::characters(const ::rtl::OUString& _rChars) throw(sax::SAXException, RuntimeException)
	{
		if (m_xMasterHandler.is())
			m_xMasterHandler->characters(_rChars);
	}

	//--------------------------------------------------------------------------
	void SAL_CALL ODataForwarder::ignorableWhitespace(const ::rtl::OUString& _rWhitespaces) throw(sax::SAXException, RuntimeException)
	{
		if (m_xMasterHandler.is())
			m_xMasterHandler->ignorableWhitespace(_rWhitespaces);
	}

	//--------------------------------------------------------------------------
	void SAL_CALL ODataForwarder::processingInstruction(const ::rtl::OUString& _rTarget, const ::rtl::OUString& _rData ) throw(sax::SAXException, RuntimeException)
	{
		if (m_xMasterHandler.is())
			m_xMasterHandler->processingInstruction(_rTarget, _rData);
	}

	//--------------------------------------------------------------------------
	void SAL_CALL ODataForwarder::setDocumentLocator(const Reference< sax::XLocator >& _rxLocator ) throw(sax::SAXException, RuntimeException)
	{
		if (m_xMasterHandler.is())
			m_xMasterHandler->setDocumentLocator(_rxLocator);
	}

	//--------------------------------------------------------------------------

#endif

#if defined(_ENCODE_ELEMENT_NAMES_)
    namespace remote
    {
        OUString encodeClientNameString(OUString const& _sName, OUString const& _sTypeName);
        OUString decodeServerNameString(OUString const& _sName, OUString& _rsType);
    }

	//==========================================================================
	//= ODataTranscoderBase
	//==========================================================================
	/** a SAX handler which tracks the current node's element type
	*/
	class ODataTranscoderBase
        : public ODataForwarder
    {
    protected:
        typedef configuration::Path::Component  FullNodeName;
        typedef rtl::OUString                   TypeName;
        typedef std::stack< TypeName >          TypeStack;
    protected:
        TypeStack       m_aTypeNames;
		FullNodeName    m_aTopLevelName;    // place to store the top level node name with context
         
        ODataTranscoderBase(const FullNodeName& _rTopLevelElementName) 
            : ODataForwarder()
            , m_aTopLevelName(_rTopLevelElementName)
        {
            resetTypes();
        }

        bool hasCurrentType() const { return m_aTypeNames.top().getLength() != 0; }
        TypeName getCurrentType() const { return m_aTypeNames.top(); }

        void pushType(const Reference< sax::XAttributeList >& xAttribs);
        void popType();
        void resetTypes();

        OUString encodeClientName(OUString const& _sName) const;
        OUString decodeServerName(OUString const& _sName) const;
	protected:
		// XDocumentHandler customization
		virtual void SAL_CALL startDocument( ) throw(sax::SAXException, RuntimeException);
		virtual void SAL_CALL endDocument( ) throw(sax::SAXException, RuntimeException);
   };

	//--------------------------------------------------------------------------
	void ODataTranscoderBase::resetTypes()
	{
        OSL_ENSURE(m_aTypeNames.empty(), "ODataTranscoderBase: found leftover types");

        OSL_ENSURE(!m_aTopLevelName.isEmpty(), "ODataTranscoderBase: invalid (empty) toplevel name !");

        TypeName sTopLevelType = m_aTopLevelName.getTypeName().toString();
        m_aTypeNames.push( sTopLevelType );
	}

	//--------------------------------------------------------------------------
	void SAL_CALL ODataTranscoderBase::startDocument() throw(sax::SAXException, RuntimeException)
	{
        if(!m_aTypeNames.empty()) m_aTypeNames.pop();
        ODataForwarder::startDocument();
        resetTypes();
	}

	//--------------------------------------------------------------------------
	void SAL_CALL ODataTranscoderBase::endDocument() throw(sax::SAXException, RuntimeException)
	{
        ODataForwarder::endDocument();
        if(!m_aTypeNames.empty()) m_aTypeNames.pop();
        OSL_ENSURE(m_aTypeNames.empty(), "ODataTranscoderBase: found leftover types");
	}

	//--------------------------------------------------------------------------
	inline void ODataTranscoderBase::pushType(const Reference< sax::XAttributeList >& xAttribs)
	{
        OUString sTypeName = xAttribs.is() ? xAttribs->getValueByName(ATTR_INSTANCE) : OUString();
        m_aTypeNames.push(sTypeName);
	}

	//--------------------------------------------------------------------------
	inline void  ODataTranscoderBase::popType()
	{
        m_aTypeNames.pop();
	}

	//--------------------------------------------------------------------------
	inline
    OUString ODataTranscoderBase::encodeClientName(OUString const& _sName) const
    {
        return hasCurrentType() ? remote::encodeClientNameString(_sName, getCurrentType()) : _sName;
    }

	//--------------------------------------------------------------------------
    inline 
    OUString ODataTranscoderBase::decodeServerName(OUString const& _sName) const
    {
        OUString sResult = _sName;
        if (hasCurrentType())
        {
            OUString sFoundType;
            sResult = remote::decodeServerNameString(_sName,sFoundType);
            // TODO check the type received
        }
        return sResult;
    }

    //==========================================================================
	//= OEncodedDataProvider
	//==========================================================================
	/** an object which can be used as IDOMNodeDataProvider
		and encodes - on all write requests - the names of set elements
	*/
	class OEncodedDataProvider
			:public IDOMNodeDataProvider
			,public ODataTranscoderBase
	{
	protected:
		IDOMNodeDataProvider*				m_pMasterDataProvider;
        
	public:
		OEncodedDataProvider(IDOMNodeDataProvider* _pMasterProvider, const FullNodeName& _rTopLevelElementName);

		// IDOMNodeDataProvider
		virtual void	writeNodeData(const Reference< sax::XDocumentHandler >& _rHandler);

	protected:
		// XDocumentHandler customization
		virtual void SAL_CALL startElement( const ::rtl::OUString& aName, const Reference< sax::XAttributeList >& xAttribs ) throw(sax::SAXException, RuntimeException);
		virtual void SAL_CALL endElement( const ::rtl::OUString& aName ) throw(sax::SAXException, RuntimeException);
	};

	//==========================================================================
	//= ODecodeDataHandler
	//==========================================================================
	/** an object which can be used as IOpenObjectCallback or IDataRequestCallback
		and decodes - on all read requests - the mnames of set elements written to the
		belonging XDocumentHandler interface.
	*/
	class ODecodeDataHandler
			:public IOpenObjectCallback
			,public ODataTranscoderBase
	{
	protected:
		ORef< IDataRequestCallback >		m_aMasterCallback_Base;
		ORef< IOpenObjectCallback >			m_aMasterCallback;

	public:
		ODecodeDataHandler(const ORef< IDataRequestCallback >& _rMasterCallback, const FullNodeName& _rTopLevelElementName);
		ODecodeDataHandler(const ORef< IOpenObjectCallback >& _rMasterCallback, const FullNodeName& _rTopLevelElementName);

		// IOpenObjectCallback
		virtual	void	gotObjectId(const NodeID& _rId);

		// IDataRequestCallback
		virtual	Reference< sax::XDocumentHandler > getDataReader();

		// IRequestCallback		
		virtual		void failed(sal_Int32 _nErrorCode);
		virtual		void done(const StatusInfo& _rStatus);

		// IInterface / XInterface
		virtual void SAL_CALL acquire(  ) throw () { ODataTranscoderBase::acquire(); }
		virtual void SAL_CALL release(  ) throw () { ODataTranscoderBase::release(); }

    protected:
		// XDocumentHandler customization
		virtual void SAL_CALL startElement( const ::rtl::OUString& aName, const Reference< sax::XAttributeList >& xAttribs ) throw(sax::SAXException, RuntimeException);
		virtual void SAL_CALL endElement( const ::rtl::OUString& aName ) throw(sax::SAXException, RuntimeException);
	};
	//--------------------------------------------------------------------------
	ODecodeDataHandler::ODecodeDataHandler(const ORef< IOpenObjectCallback >& _rMasterCallback, const FullNodeName& _rTopLevelElementName)
		: ODataTranscoderBase(_rTopLevelElementName)
        , m_aMasterCallback_Base(_rMasterCallback.getBodyPtr())
		, m_aMasterCallback(_rMasterCallback)
	{
	}

	//--------------------------------------------------------------------------
	ODecodeDataHandler::ODecodeDataHandler(const ORef< IDataRequestCallback >& _rMasterCallback, const FullNodeName& _rTopLevelElementName)
		: ODataTranscoderBase(_rTopLevelElementName)
        , m_aMasterCallback_Base(_rMasterCallback)
		, m_aMasterCallback()
	{
	}

	//--------------------------------------------------------------------------
	OEncodedDataProvider::OEncodedDataProvider(IDOMNodeDataProvider* _pMasterProvider, const FullNodeName& _rTopLevelElementName)
		:ODataTranscoderBase(_rTopLevelElementName)
        , m_pMasterDataProvider(_pMasterProvider)
	{
	}

	//--------------------------------------------------------------------------
	void ODecodeDataHandler::failed(sal_Int32 _nErrorCode)
	{
		OSL_ENSURE(m_aMasterCallback_Base.isValid(), "ODecodeDataHandler::failed : master not set !");
		if (m_aMasterCallback_Base.isValid())
			m_aMasterCallback_Base->failed(_nErrorCode);
	}

	//--------------------------------------------------------------------------
	void ODecodeDataHandler::done(const StatusInfo& _rStatus)
	{
		OSL_ENSURE(m_aMasterCallback_Base.isValid(), "ODecodeDataHandler::failed : master not set !");
		if (m_aMasterCallback_Base.isValid())
			m_aMasterCallback_Base->done(_rStatus);
	}

	//--------------------------------------------------------------------------
	void ODecodeDataHandler::gotObjectId(const NodeID& _rId)
	{
		OSL_ENSURE(m_aMasterCallback.isValid(), "ODecodeDataHandler::gotObjectId : have no OpenObjectCallback !");
		if (m_aMasterCallback.isValid())
			m_aMasterCallback->gotObjectId(_rId); 
	}

	//--------------------------------------------------------------------------
	void OEncodedDataProvider::writeNodeData(const Reference< sax::XDocumentHandler >& _rHandler)
	{
		OSL_ENSURE(m_pMasterDataProvider, "OEncodedDataProvider::writeNodeData : master not set !");
		if (m_pMasterDataProvider && _rHandler.is())
		{
			OSL_ENSURE(!m_xMasterHandler.is(), "OEncodedDataProvider::writeNodeData : already set an handler !");
			Reference< sax::XDocumentHandler > xOldHandler(m_xMasterHandler);
			m_xMasterHandler = _rHandler;
			m_pMasterDataProvider->writeNodeData(this);
			m_xMasterHandler = xOldHandler;
		}
	}

	//--------------------------------------------------------------------------
	Reference< sax::XDocumentHandler > ODecodeDataHandler::getDataReader()
	{
		OSL_ENSURE(m_aMasterCallback_Base.isValid(), "ODecodeDataHandler:: getDataReader: master not set !");
		m_xMasterHandler = m_aMasterCallback_Base->getDataReader();
		return this;
	}

	//--------------------------------------------------------------------------
	void SAL_CALL OEncodedDataProvider::startElement(const ::rtl::OUString& _rName, const Reference< sax::XAttributeList >& _rxAttribs ) throw(sax::SAXException, RuntimeException)
	{
        OUString sName = encodeClientName(_rName);

        ODataTranscoderBase::startElement(sName, _rxAttribs);

        pushType(_rxAttribs);
	}

	//--------------------------------------------------------------------------
	void SAL_CALL OEncodedDataProvider::endElement(const ::rtl::OUString& _rName) throw(sax::SAXException, RuntimeException)
	{
        popType();

        OUString sName = encodeClientName(_rName);

        ODataTranscoderBase::endElement(sName);
	}

	//--------------------------------------------------------------------------
	void SAL_CALL ODecodeDataHandler::startElement(const ::rtl::OUString& _rName, const Reference< sax::XAttributeList >& _rxAttribs ) throw(sax::SAXException, RuntimeException)
	{
        OUString sName = decodeServerName(_rName);

        ODataTranscoderBase::startElement(sName, _rxAttribs);

        pushType(_rxAttribs);
	}

	//--------------------------------------------------------------------------
	void SAL_CALL ODecodeDataHandler::endElement(const ::rtl::OUString& _rName) throw(sax::SAXException, RuntimeException)
	{
        popType();

        OUString sName = decodeServerName(_rName);

        ODataTranscoderBase::endElement(sName);
	}



#endif

#if defined(_REMOTE_PATH_TRANSLATION_) || defined(_ENCODE_USER_NAMES_)
	//==========================================================================
	//= OFakeDataRootPath
	//==========================================================================
	/** an object which can be used as IOpenObjectCallback, IDataRequestCallback or IDOMNodeDataProvider
		and fakes - on all read or write requests - the top level element written to or read from the
		belonging XDocumentHandler interface.
	*/
	class OFakeDataRootPath
			:public IOpenObjectCallback
			,public IDOMNodeDataProvider
			,public ODataForwarder
	{
	protected:
        typedef configuration::Path::Component FakedName;

		IDOMNodeDataProvider*				m_pMasterDataProvider;
		ORef< IOpenObjectCallback >			m_aMasterCallback;
		ORef< IDataRequestCallback >		m_aMasterCallback_Base;

        FakedName                        m_aFakedName;
        sal_Bool							m_bDidIt;			// just for debugging reasons

	public:
		OFakeDataRootPath(const ORef< IOpenObjectCallback >& _rMasterCallback, const FakedName& _rTopLevelElementFakedName);
		OFakeDataRootPath(const ORef< IDataRequestCallback >& _rMasterCallback, const FakedName& _rTopLevelElementFakedName);
		OFakeDataRootPath(IDOMNodeDataProvider* _pMasterProvider, const FakedName& _rTopLevelElementFakedName);

		// IOpenObjectCallback
		virtual	void	gotObjectId(const NodeID& _rId);

		// IDataRequestCallback
		virtual	Reference< sax::XDocumentHandler > getDataReader();

		// IRequestCallback		
		virtual		void failed(sal_Int32 _nErrorCode);
		virtual		void done(const StatusInfo& _rStatus);

		// IInterface / XInterface
		virtual void SAL_CALL acquire(  ) throw () { ODataForwarder::acquire(); }
		virtual void SAL_CALL release(  ) throw () { ODataForwarder::release(); }

		// IDOMNodeDataProvider
		virtual void	writeNodeData(const Reference< sax::XDocumentHandler >& _rHandler);

		// XDocumentHandler customization
		virtual void SAL_CALL startElement( const ::rtl::OUString& aName, const Reference< sax::XAttributeList >& xAttribs ) throw(sax::SAXException, RuntimeException);
		virtual void SAL_CALL endElement( const ::rtl::OUString& aName ) throw(sax::SAXException, RuntimeException);
	};

	//--------------------------------------------------------------------------
	OFakeDataRootPath::OFakeDataRootPath(const ORef< IOpenObjectCallback >& _rMasterCallback, const FakedName& _rTopLevelElementFakedName)
		:ODataForwarder()
        ,m_aMasterCallback_Base(_rMasterCallback.getBodyPtr())
		,m_aMasterCallback(_rMasterCallback)
		,m_bDidIt(sal_False)
		,m_aFakedName(_rTopLevelElementFakedName)
		,m_pMasterDataProvider(NULL)
	{
		OSL_ENSURE(!m_aFakedName.isEmpty(), "OFakeDataRootPath::OFakeDataRootPath : invalid fake name !");
	}

	//--------------------------------------------------------------------------
	OFakeDataRootPath::OFakeDataRootPath(const ORef< IDataRequestCallback >& _rMasterCallback, const FakedName& _rTopLevelElementFakedName)
		:ODataForwarder()
        ,m_aMasterCallback_Base(_rMasterCallback)
		,m_bDidIt(sal_False)
		,m_aFakedName(_rTopLevelElementFakedName)
		,m_pMasterDataProvider(NULL)
	{
		OSL_ENSURE(!m_aFakedName.isEmpty(), "OFakeDataRootPath::OFakeDataRootPath : invalid fake name !");
	}

	//--------------------------------------------------------------------------
	OFakeDataRootPath::OFakeDataRootPath(IDOMNodeDataProvider* _pMasterProvider, const FakedName& _rTopLevelElementFakedName)
		:ODataForwarder()
        ,m_pMasterDataProvider(_pMasterProvider)
		,m_bDidIt(sal_False)
		,m_aFakedName(_rTopLevelElementFakedName)
	{
		OSL_ENSURE(!m_aFakedName.isEmpty(), "OFakeDataRootPath::OFakeDataRootPath : invalid fake name !");
	}

	//--------------------------------------------------------------------------
	void OFakeDataRootPath::failed(sal_Int32 _nErrorCode)
	{
		OSL_ENSURE(m_aMasterCallback_Base.isValid(), "OFakeDataRootPath::failed : not working as a reader !");
		if (m_aMasterCallback_Base.isValid())
			m_aMasterCallback_Base->failed(_nErrorCode);
	}

	//--------------------------------------------------------------------------
	void OFakeDataRootPath::done(const StatusInfo& _rStatus)
	{
		OSL_ENSURE(m_aMasterCallback_Base.isValid(), "OFakeDataRootPath::done : not working as a reader !");
		if (m_aMasterCallback_Base.isValid())
			m_aMasterCallback_Base->done(_rStatus);
	}

	//--------------------------------------------------------------------------
	void OFakeDataRootPath::gotObjectId(const NodeID& _rId)
	{
		OSL_ENSURE(m_aMasterCallback.isValid(), "OFakeDataRootPath::gotObjectId : have no OpenObjectCallback !");
		if (m_aMasterCallback.isValid())
			m_aMasterCallback->gotObjectId(_rId); 
	}

	//--------------------------------------------------------------------------
	void OFakeDataRootPath::writeNodeData(const Reference< sax::XDocumentHandler >& _rHandler)
	{
		OSL_ENSURE(m_pMasterDataProvider, "OFakeDataRootPath::writeNodeData : not working as writer !");
		if (m_pMasterDataProvider && _rHandler.is())
		{
			OSL_ENSURE(!m_xMasterHandler.is(), "OFakeDataRootPath::writeNodeData : already set an handler !");
			Reference< sax::XDocumentHandler > xOldHandler(m_xMasterHandler);
			m_xMasterHandler = _rHandler;
			m_pMasterDataProvider->writeNodeData(this);
			m_xMasterHandler = xOldHandler;
		}
	}

	//--------------------------------------------------------------------------
	Reference< sax::XDocumentHandler > OFakeDataRootPath::getDataReader()
	{
		OSL_ENSURE(m_aMasterCallback_Base.isValid(), "OFakeDataRootPath:: getDataReader: not working as a reader !");
		m_xMasterHandler = m_aMasterCallback_Base->getDataReader();
		return this;
	}

	//--------------------------------------------------------------------------
	void SAL_CALL OFakeDataRootPath::startElement(const ::rtl::OUString& _rName, const Reference< sax::XAttributeList >& _rxAttribs ) throw(sax::SAXException, RuntimeException)
	{
        OUString aName(_rName);

        if (!m_nElementDepth)
		{	// it's the first element, we have to fake the name
			OSL_ENSURE(!m_bDidIt, "OFakeDataRootPath::startElement : there should only be one top level element !");

            // TODO: if not a simple name, split it and add an attribute
            OSL_ENSURE(m_aFakedName.isSimpleName(), "WARNING: Cannot fake root of set element");

            // the string used here should match the one in endElement
			aName = m_aFakedName.toPathString();

			m_bDidIt = sal_True;
		}

        ODataForwarder::startElement(aName, _rxAttribs);
	}

	//--------------------------------------------------------------------------
	void SAL_CALL OFakeDataRootPath::endElement(const ::rtl::OUString& _rName) throw(sax::SAXException, RuntimeException)
	{
        OUString aName(_rName);

		if (1 == m_nElementDepth)
		{
			OSL_ENSURE(m_bDidIt, "OFakeDataRootPath::endElement : this element was never started ? !");
            // the string used here should match the one in startElement
			aName = m_aFakedName.toPathString();
		}

        ODataForwarder::endElement(aName);
	}

#endif

// -----------------------------------------------------------------------------
// -----------------------------------------------------------------------------
// -----------------------------------------------------------------------------



#ifdef _ENCODE_USER_NAMES_	
	typedef ::cppu::WeakImplHelper1< sax::XDocumentHandler > OUserNameTranslator_Base;
	/** a class which decodes user names which are returned from the server when opening com.sun.star.UserProfile
		as toplevel node.
	*/
	class OUserNameTranslator
			:public OUserNameTranslator_Base
			,public IOpenObjectCallback
			,public IDOMNodeDataProvider
	{
	protected:
		Reference< sax::XDocumentHandler >	m_xMasterHandler;
		ORef< IOpenObjectCallback >			m_aMasterCallback;
		ORef< IDataRequestCallback >		m_aMasterCallback_Base;		
		IDOMNodeDataProvider*				m_pMasterDataProvider;
		bool								m_bUserGroup,m_bEncode;	

	public:
		OUserNameTranslator(const ORef< IOpenObjectCallback >& _rMasterCallback);	
		OUserNameTranslator(IDOMNodeDataProvider* _pMasterWriter);

		// IOpenObjectCallback
		virtual	void	gotObjectId(const ::rtl::OUString& _rId);

		// IDataRequestCallback
		virtual	Reference< sax::XDocumentHandler > getDataReader();

		// IRequestCallback
		virtual		void failed(sal_Int32 _nErrorCode);
		virtual		void done(const StatusInfo& _rStatus);

		// IDOMNodeDataProvider
		virtual void	writeNodeData(const Reference< sax::XDocumentHandler >& _rHandler);

		// IInterface
		virtual void SAL_CALL acquire(  ) throw () { OUserNameTranslator_Base::acquire(); }
		virtual void SAL_CALL release(  ) throw () { OUserNameTranslator_Base::release(); }

		// XDocumentHandler
		virtual void SAL_CALL startDocument(  ) throw(sax::SAXException, RuntimeException);
		virtual void SAL_CALL endDocument(  ) throw(sax::SAXException, RuntimeException);
		virtual void SAL_CALL startElement( const ::rtl::OUString& aName, const Reference< sax::XAttributeList >& xAttribs ) throw(sax::SAXException, RuntimeException);
		virtual void SAL_CALL endElement( const ::rtl::OUString& aName ) throw(sax::SAXException, RuntimeException);
		virtual void SAL_CALL characters( const ::rtl::OUString& aChars ) throw(sax::SAXException, RuntimeException);
		virtual void SAL_CALL ignorableWhitespace( const ::rtl::OUString& aWhitespaces ) throw(sax::SAXException, RuntimeException);
		virtual void SAL_CALL processingInstruction( const ::rtl::OUString& aTarget, const ::rtl::OUString& aData ) throw(sax::SAXException, RuntimeException);
		virtual void SAL_CALL setDocumentLocator( const Reference< sax::XLocator >& xLocator ) throw(sax::SAXException, RuntimeException);
	};

	//--------------------------------------------------------------------------
	OUserNameTranslator::OUserNameTranslator(const ORef< IOpenObjectCallback >& _rMasterCallback)
		:m_aMasterCallback_Base(_rMasterCallback.getBodyPtr())
		,m_aMasterCallback(_rMasterCallback)		
		,m_pMasterDataProvider(NULL)
		,m_bUserGroup(false)
		,m_bEncode(false)
	{
	}

	//--------------------------------------------------------------------------
	OUserNameTranslator::OUserNameTranslator(IDOMNodeDataProvider* _pMasterWriter)
					 :m_pMasterDataProvider(_pMasterWriter)
					 ,m_bUserGroup(false)
					 ,m_bEncode(true)
	{
	}

	//--------------------------------------------------------------------------
	void OUserNameTranslator::writeNodeData(const Reference< sax::XDocumentHandler >& _rHandler)
	{
		OSL_ENSURE(m_pMasterDataProvider, "OUserNameTranslator::writeNodeData : not working as writer !");
		if (m_pMasterDataProvider && _rHandler.is())
		{
			OSL_ENSURE(!m_xMasterHandler.is(), "OUserNameTranslator::writeNodeData : already set an handler !");
			Reference< sax::XDocumentHandler > xOldHandler(m_xMasterHandler);
			m_xMasterHandler = _rHandler;
			m_pMasterDataProvider->writeNodeData(this);
			m_xMasterHandler = xOldHandler;
		}
	}
	
	//--------------------------------------------------------------------------
	void OUserNameTranslator::failed(sal_Int32 _nErrorCode)
	{
		OSL_ENSURE(m_aMasterCallback_Base.isValid(), "OUserNameTranslator::failed : not working as a reader !");
		if (m_aMasterCallback_Base.isValid())
			m_aMasterCallback_Base->failed(_nErrorCode);
	}

	//--------------------------------------------------------------------------
	void OUserNameTranslator::done(const StatusInfo& _rStatus)
	{
		OSL_ENSURE(m_aMasterCallback_Base.isValid(), "OUserNameTranslator::done : not working as a reader !");
		if (m_aMasterCallback_Base.isValid())
			m_aMasterCallback_Base->done(_rStatus);
	}

	//--------------------------------------------------------------------------
	void OUserNameTranslator::gotObjectId(const ::rtl::OUString& _rId)
	{
		OSL_ENSURE(m_aMasterCallback.isValid(), "OUserNameTranslator::gotObjectId : have no OpenObjectCallback !");
		if (m_aMasterCallback.isValid())
			m_aMasterCallback->gotObjectId(_rId); 
	}

	//--------------------------------------------------------------------------
	Reference< sax::XDocumentHandler > OUserNameTranslator::getDataReader()
	{
		OSL_ENSURE(!m_xMasterHandler.is(), "OUserNameTranslator::getDataReader : already called !");
		m_xMasterHandler = m_aMasterCallback_Base->getDataReader();
		return this;
	}

	//--------------------------------------------------------------------------
	void SAL_CALL OUserNameTranslator::startDocument(  ) throw(sax::SAXException, RuntimeException)
	{
		OSL_ENSURE(m_xMasterHandler.is(), "OUserNameTranslator::startDocument : no handler !");
		m_xMasterHandler->startDocument();
	}

	//--------------------------------------------------------------------------
	void SAL_CALL OUserNameTranslator::endDocument(  ) throw(sax::SAXException, RuntimeException)
	{
		OSL_ENSURE(m_xMasterHandler.is(), "OUserNameTranslator::endDocument : no handler !");
		m_xMasterHandler->endDocument();
	}

	//--------------------------------------------------------------------------
	void SAL_CALL OUserNameTranslator::startElement( const ::rtl::OUString& _rName, const Reference< sax::XAttributeList >& _rxAttribs ) throw(sax::SAXException, RuntimeException)
	{
		OSL_ENSURE(m_xMasterHandler.is(), "OUserNameTranslator::startElement : no handler !");		
		m_bUserGroup = (_rName == (OUString) NODE_USERPROFILE_GROUP_FIELD) ? true : false;
		m_xMasterHandler->startElement(_rName, _rxAttribs);
	}

	//--------------------------------------------------------------------------
	void SAL_CALL OUserNameTranslator::endElement( const ::rtl::OUString& _rName ) throw(sax::SAXException, RuntimeException)
	{
		OSL_ENSURE(m_xMasterHandler.is(), "OUserNameTranslator::endElement : no handler !");
		m_bUserGroup = false;
		m_xMasterHandler->endElement(_rName);
	}

	//--------------------------------------------------------------------------
	void SAL_CALL OUserNameTranslator::characters( const ::rtl::OUString& aChars ) throw(sax::SAXException, RuntimeException)
	{
		OSL_ENSURE(m_xMasterHandler.is(), "OUserNameTranslator::characters : no handler !");
		if (m_bUserGroup)
		{
			if (m_bEncode)
				m_xMasterHandler->characters(encodename::encode(aChars));
			else
			{
				bool bValidEncodedName(false);			
				m_xMasterHandler->characters(encodename::decode(aChars, bValidEncodedName));
				OSL_ENSURE(bValidEncodedName, "OUserNameTranslator::characters : read a invalid name (could not decode) !");
			}
		}
		else
			m_xMasterHandler->characters(aChars);
	}

	//--------------------------------------------------------------------------
	void SAL_CALL OUserNameTranslator::ignorableWhitespace( const ::rtl::OUString& aWhitespaces ) throw(sax::SAXException, RuntimeException)
	{
		OSL_ENSURE(m_xMasterHandler.is(), "OUserNameTranslator::ignorableWhitespace : no handler !");
		m_xMasterHandler->ignorableWhitespace(aWhitespaces);
	}

	//--------------------------------------------------------------------------
	void SAL_CALL OUserNameTranslator::processingInstruction( const ::rtl::OUString& aTarget, const ::rtl::OUString& aData ) throw(sax::SAXException, RuntimeException)
	{
		OSL_ENSURE(m_xMasterHandler.is(), "OUserNameTranslator::processingInstruction : no handler !");
		m_xMasterHandler->processingInstruction(aTarget, aData);
	}

	//--------------------------------------------------------------------------
	void SAL_CALL OUserNameTranslator::setDocumentLocator( const Reference< sax::XLocator >& xLocator ) throw(sax::SAXException, RuntimeException)
	{
		OSL_ENSURE(m_xMasterHandler.is(), "OUserNameTranslator::setDocumentLocator : no handler !");
		m_xMasterHandler->setDocumentLocator(xLocator);
	}
#endif

static const ::rtl::OUString sStringType(::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("string")));
static const ::rtl::OUString sNodePathName(::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("nodePath")));
static const ::rtl::OUString sParentNodePathName(::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("parentNodePath")));
static const ::rtl::OUString sNodeName(::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("node")));
static const ::rtl::OUString sUserName(::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("userName")));
static const ::rtl::OUString sLocaleParam(::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("language")));
static const ::rtl::OUString sNotifyParam(::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("notify")));
static const ::rtl::OUString sFalseParam(::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("false")));
static const ::rtl::OUString sGroupName(::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("groupName")));
static const ::rtl::OUString sGroupParent(::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("parentName")));
static const ::rtl::OUString sUpdateNameParam(::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("changedNode")));
static const ::rtl::OUString sAddNameParam(::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("nodeToAdd")));
static const ::rtl::OUString sIntegerType(::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("int")));
static const ::rtl::OUString sGenericStringData(::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("CDATA")));

//==========================================================================
//= OWaitForOpenSession
//==========================================================================
/** an class born for only one reason : be the callback for an openSession
	request on a remote config server, thus making it possible to make this
	request synchronous instead of asynchronous
*/
class OWaitForOpenSession : public IOpenObjectCallback
{
protected:
	oslInterlockedCount		m_refCount;

public:
	enum STATE { WAITING, FAILED, DONE };

protected:
	Mutex			m_aMutex;
	sal_Int32		m_nSessionId;		/// the id as got via the IOpenObjectCallback interface
	sal_Int32		m_nConnError;		/// the error code as got from <method>failed</method>
	STATE			m_eState;			/// the current state
	StatusInfo		m_aStatus;			/// the status as got in done, if this was ever called
	OCondition		m_aWaitCond;		/// used for waiting for the done call

public:
	OWaitForOpenSession() : m_nConnError(0), m_refCount(0),m_nSessionId(-1),m_eState(WAITING) { m_aStatus.nCode = 0; m_aWaitCond.reset(); }

	sal_Bool	isFinished() { MutexGuard aG(m_aMutex); return (FAILED == m_eState) || (DONE == m_eState); }
	STATE		getState() { return m_eState; }
	sal_Int32	getSessionId() { return m_nSessionId; }
	sal_Int32	getConnError() { return m_nConnError; }
	StatusInfo	getStatus() { return m_aStatus; }

	sal_Bool	waitForResponse(const TimeValue* pTimeout = NULL)
	{
		return (ICondition::result_ok == m_aWaitCond.wait(pTimeout));
	}

	// IOpenObjectCallback
	virtual	void	gotObjectId(const ::rtl::OUString& _rId) { MutexGuard aG(m_aMutex); m_nSessionId = _rId.toInt32(); }

	// IDataRequestCallback
	virtual		Reference< sax::XDocumentHandler > getDataReader() { return NULL; }

	// IRequestCallback	
	virtual		void failed(sal_Int32 _nErrorCode) { MutexGuard aG(m_aMutex); m_eState = FAILED;m_nConnError = _nErrorCode; m_aWaitCond.set(); }
	virtual		void done(const StatusInfo& _rStatus) 
	{ 
		MutexGuard aG(m_aMutex); 
		m_aStatus = _rStatus; 
#ifdef CFG_ENABLE_TRACING
		if (_rStatus.nCode)
		{
			CFG_TRACE_ERROR("update callback: done(%i)", _rStatus.nCode);
		}
#endif
		m_eState = DONE;
		m_aWaitCond.set(); 
	}

	// IInterface
    virtual void SAL_CALL acquire(  ) throw () { osl_incrementInterlockedCount(&m_refCount); }
    virtual void SAL_CALL release(  ) throw () { if (!osl_decrementInterlockedCount(&m_refCount)) delete this; }
};

//==========================================================================
//= OWaitForCloseSession
//==========================================================================
/** an class born for only one reason : be the callback for an closeSession
	request on a remote config server
*/
class OWaitForCloseSession : public IRequestCallback
{
protected:
	oslInterlockedCount		m_refCount;

public:
	enum STATE { WAITING, FAILED, DONE };

protected:
	Mutex			m_aMutex;
	STATE			m_eState;			/// the current state
	StatusInfo		m_aStatus;			/// the status as got in done, if this was ever called
	ORef< IRequestCallback >
					m_aMasterCallback;	/// in addition to our own handling we forward all calls to this master
	ORemoteSession*	m_pSession;			/// to be notified after the request is fullfilled

public:
	OWaitForCloseSession(ORemoteSession* m_pSession, const ORef< IRequestCallback >& _rMasterCB);

	sal_Bool	isFinished() { MutexGuard aG(m_aMutex); return (FAILED == m_eState) || (DONE == m_eState); }
	STATE		getState() { return m_eState; }
	StatusInfo	getStatus() { return m_aStatus; }

	// IRequestCallback
	virtual		void failed(sal_Int32 _nErrorCode);
	virtual		void done(const StatusInfo& _rStatus);

	// IInterface
    virtual void SAL_CALL acquire(  ) throw () { osl_incrementInterlockedCount(&m_refCount); }
    virtual void SAL_CALL release(  ) throw () { if (!osl_decrementInterlockedCount(&m_refCount)) delete this; }
};

//--------------------------------------------------------------------------
OWaitForCloseSession::OWaitForCloseSession(ORemoteSession* _pSession, const ORef< IRequestCallback >& _rMasterCB)
	:m_pSession(_pSession)
	,m_refCount(0)
	,m_aMasterCallback(_rMasterCB)
	,m_eState(WAITING)
{
}

//--------------------------------------------------------------------------
void OWaitForCloseSession::failed(sal_Int32 _nErrorCode)
{
	MutexGuard aG(m_aMutex);
	m_eState = FAILED;
	if (m_aMasterCallback.isValid())
		m_aMasterCallback->failed(_nErrorCode);
}

//--------------------------------------------------------------------------
void OWaitForCloseSession::done(const StatusInfo& _rStatus)
{
	MutexGuard aG(m_aMutex);
	m_aStatus = _rStatus;
	m_eState = DONE;
	if (m_aMasterCallback.isValid())
		m_aMasterCallback->done(_rStatus);

	// notify the session, if the close operation was successfull
	if (_rStatus.nCode == 0)
		m_pSession->implCloseSuccessfull();
}

//==========================================================================
//= ORemoteSession
//==========================================================================
#define ENTER()	\
	::osl::MutexGuard aGuard(m_aMutex);	\
	m_eSessionError = E_None;
	
#define ENTER_FULL_CHECK(methodname, handler)	\
	::osl::MutexGuard aGuard(m_aMutex);	\
	m_eSessionError = E_None;	\
	if (!isConnected())	\
	{	\
		OSL_ENSURE(sal_False, "ORemoteSession::"#methodname" : not connected !");	\
		CFG_TRACE_ERROR("remote session: calling %s while not beeing connected", #methodname);	\
		if (handler.isValid())	\
			handler->failed(E_NotConnected);	\
		m_eSessionError = E_NotConnected;	\
		return;	\
	}	\
	if (!isOpen())	\
	{	\
		OSL_ENSURE(sal_False, "ORemoteSession::"#methodname" : not opened !");	\
		CFG_TRACE_ERROR("remote session: calling %s while not beeing open", #methodname);	\
		if (handler.isValid())	\
			handler->failed(E_NotOpen);	\
		m_eSessionError = E_NotOpen;	\
		return;	\
	}

#define CATCH_HANDLE_EXCEPTIONS()	\
	catch (sax::SAXException&)	\
	{	\
		m_eSessionError = E_WrongFormat;	\
		return;	\
	}	\
	catch (RuntimeException&)	\
	{	\
		m_eSessionError = E_Unknown;	\
		return;	\
	}
	
#define CATCH_HANDLE_EXCEPTIONS_RET(retval)	\
	catch (sax::SAXException& e)	\
	{	\
		CFG_TRACE_ERROR("remote session: caught a SAX exception, message: %s", OUSTRING2ASCII(e.Message));	\
		m_eSessionError = E_WrongFormat;	\
		return retval;	\
	}	\
	catch (RuntimeException& e)	\
	{	\
		CFG_TRACE_ERROR("remote session: caught a runtime exception, message: %s", OUSTRING2ASCII(e.Message));	\
		m_eSessionError = E_Unknown;	\
		return retval;	\
	}
	
//--------------------------------------------------------------------------
ORemoteSession::ORemoteSession(const Reference< XMultiServiceFactory >& _rxServiceProvider)
	:m_nSessionId(-1)
	,m_eConnectionError((sal_Int32)ISocketTypes::E_None)
	,m_eSessionError(E_None)
	,m_pServerConnection(NULL)
	,m_pLastUsedTransId(NULL)
	,m_pInterpreter(NULL)
	,m_pTimeout(NULL)
	,m_pAttributes(new AttributeListImpl)
	,m_bCachingPossible(sal_True)
{
	// initialize the (client side) transaction id
	const sal_Unicode aInitialId[] = { 'R', '0', '0', '0', '0' };
	rtl_uString_newFromStr_WithLength(&m_pLastUsedTransId, aInitialId, sizeof(aInitialId) / sizeof(aInitialId[0]));
	// automatically acquired once

	// acquire the attributes once
	m_pAttributes->acquire();

	// create the writer and the parser we want to use
	m_xWriter = Reference< sax::XDocumentHandler >(_rxServiceProvider->createInstance(
			::rtl::OUString::createFromAscii("com.sun.star.xml.sax.Writer")),
			UNO_QUERY);

	m_xReader = Reference< sax::XParser >(_rxServiceProvider->createInstance(
			::rtl::OUString::createFromAscii("com.sun.star.xml.sax.Parser")),
			UNO_QUERY);

	// check them for usability
	m_xWriterSource = Reference< XActiveDataSource >(m_xWriter, UNO_QUERY);
	if (!m_xWriterSource.is())
	{
		OSL_ENSURE(sal_False, "ORemoteSession::ORemoteSession : no or invalid SAX XML Writer !");
		m_eSessionError = E_Invalid;
		return;
	}

	if (!m_xReader.is())
	{
		OSL_ENSURE(sal_False, "ORemoteSession::ORemoteSession : no or invalid SAX XML Parser !");
		m_eSessionError = E_Invalid;
		return;
	}

}

//--------------------------------------------------------------------------
void ORemoteSession::connectToPortal(uno::Reference < lang::XMultiServiceFactory > const& _rServiceMgr,
									 const ::rtl::OUString& _rService,
									 const ::rtl::OUString& _rServer,
									 sal_Int32 _nPort,										 
									 const ::rtl::OUString& _rUser,
									 const ::rtl::OUString& _rPassword,
									 const TimeValue* _pTimeout)
{
	ENTER();
	CFG_TRACE_INFO("remote session: trying to open a connection via PortalConnect");	

	uno::Reference< XConnector > xConnector(_rServiceMgr->createInstance( 
                    OUString( RTL_CONSTASCII_USTRINGPARAM( 
                        "com.sun.star.connection.Connector" ))),
                UNO_QUERY );

    OSL_ENSURE( xConnector.is(), "acceptor service not found.\n" );
	if (!xConnector.is())
		throw ::com::sun::star::connection::ConnectionSetupException(OUString(RTL_CONSTASCII_USTRINGPARAM("Configuration bootstrap error. Unable to create connector")), NULL);

	if (!m_xWriterSource.is() || !m_xReader.is())
	{
		OSL_ENSURE(sal_False, "ORemoteSession::connectToPortal : have no XML helper components (parser/writer) !");
		m_eSessionError = E_Invalid;
		throw ::com::sun::star::connection::ConnectionSetupException(OUString::createFromAscii("Could not establish the connection to the portal's configuration service."), NULL);
	}

	// now compose the connection string
	::rtl::OUString aConnectString(RTL_CONSTASCII_USTRINGPARAM("portal,service="));
	aConnectString += _rService;

	if (_rServer.getLength())
	{
		aConnectString += ::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM(",host="));
		aConnectString += _rServer;
		aConnectString += ::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM(",port="));
		aConnectString += ::rtl::OUString::valueOf(_nPort);
	}

	if (_rUser.getLength())
	{
		aConnectString += ::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM(",user="));
		aConnectString += _rUser;
	}

	if (_rPassword.getLength())
	{
		aConnectString += ::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM(",password="));
		aConnectString += _rPassword;
	}
	CFG_TRACE_INFO_NI("remote session: trying to connect with connect string: %s", OUSTRING2ASCII(aConnectString));
	Reference< XConnection2 > xConnection(xConnector->connect(aConnectString), UNO_QUERY);
	if (!xConnection.is())
	{
		OSL_ENSURE(sal_False, "ORemoteSession::connectToPortal : connection2 interface not supported !");
		m_eSessionError = E_Invalid;
		throw ::com::sun::star::connection::ConnectionSetupException(OUString::createFromAscii("Could not establish the connection to the portal's configuration service."), NULL);
	}
	CFG_TRACE_INFO_NI("remote session: connected to configserver with connection description: %s", OUSTRING2ASCII(xConnection->getDescription()));	

	// a wrapper for the output to the socket stream
	CFG_TRACE_INFO_NI("remote session: creating the output stream wrapper");
	m_xOutputStream = new OEnvelopeOutputStream<OPortalOutputStream, XConnection2 >(xConnection.get());

	// the interpreter for the parsed xml stream
	CFG_TRACE_INFO_NI("remote session: creating the response redirector");
	m_pInterpreter = new OResponseRedirector();
	m_pInterpreter->acquire();
	m_xReader->setDocumentHandler(m_pInterpreter);

	// register a Handler for the OpenSession response
	// the response is redirected from the configpump using the clientid "P0000"
	OWaitForOpenSession* pWaitObject = new OWaitForOpenSession;
	ORef< IOpenObjectCallback > aKeepAlive = pWaitObject;

	// open the envelope
	::rtl::OUString sClientId(::rtl::OUString::createFromAscii("P0000"));
	// register the callback
	m_pInterpreter->registerCallback(sClientId, aKeepAlive);

	// start an reader thread for the socket stream
	CFG_TRACE_INFO_NI("remote session: creating the input stream wrapper and the receive thread");
	m_pReaderThread = new OReceiveThread(new OEnvelopeInputStream<OPortalInputStream, XConnection2 >(xConnection.get()), m_xReader);
	m_pReaderThread->create();

	if (_pTimeout)
		m_pTimeout = new TimeValue(*_pTimeout);
	else
	{
		m_pTimeout = new TimeValue;
		// 300 seconds seems to be a reasonable timeout in a remote environment
		m_pTimeout->Seconds = 300;
		m_pTimeout->Nanosec = 0;
	}
	
	pWaitObject->waitForResponse(m_pTimeout);
	if (!pWaitObject->isFinished())
	{
		CFG_TRACE_ERROR("remote session: something went wrong, conn status %i, server returned %s", pWaitObject->getConnError(), OUSTRING2ASCII(pWaitObject->getStatus().sMessage));

		// though the request could not be finished, send an closeSession, just in case the
		// request is fullfilled just at this moment
		kill();
		m_eSessionError = E_TimedOut;
		throw ::com::sun::star::connection::ConnectionSetupException(OUString::createFromAscii("Could not establish the connection to the configuration server."), NULL);
	}

	sal_Bool bSuccess = pWaitObject->getConnError() == 0 && pWaitObject->getStatus().nCode == 0;
	m_nSessionId = bSuccess ? pWaitObject->getSessionId() : -1;

	CFG_TRACE_INFO_NI("remote session: got a session id of %i", m_nSessionId);

	if (!bSuccess)
	{
		m_eSessionError = E_ConnectionError;
		m_eConnectionError = pWaitObject->getConnError();

		if (pWaitObject->getStatus().nCode != 0)
			throw ::com::sun::star::connection::ConnectionSetupException(pWaitObject->getStatus().sMessage, NULL);
		else
			throw ::com::sun::star::connection::ConnectionSetupException(OUString::createFromAscii("Could not establish the connection to the configuration server."), NULL);
	}

	// now we have the connection ...
	CFG_TRACE_INFO_NI("remote session: all fine, have the portal connection");
	
    // this is a hack for user nobody
	// user nobody is a special user who is only used within the environment
	// this user needs the most uptodate informations
	// as there are currently some problems with the update notification respectivly 
	// there are at the moment implementations missing. So this is only temporary !!!

	// parse the connect desc to identify the user
	rtl::OUString aConnectDesc(xConnection->getDescription());	
	static OUString sNobody = OUString::createFromAscii("nobody");
	
	// user is the first part
	sal_Int32 nStartIndex = aConnectDesc.indexOf((sal_Unicode)'=');
	if (nStartIndex == -1)
	{
		CFG_TRACE_INFO_NI("remote session: user info not found in connect string");
		return;
	}
	sal_Int32 nEndIndex = aConnectDesc.indexOf((sal_Unicode)',', nStartIndex);
	rtl::OUString sUser = aConnectDesc.copy(nStartIndex+1,nEndIndex-nStartIndex-1).trim();
	CFG_TRACE_INFO_NI("remote session: user '%s' connected to configserver", OUSTRING2ASCII(sUser));		
	
	// no caching for user nobody
	if (sUser == sNobody)
	{
		m_bCachingPossible = sal_False;	
		CFG_TRACE_INFO_NI("remote session: caching is going to be diabled for user '%s' ", OUSTRING2ASCII(sUser));		
	}	
}

//--------------------------------------------------------------------------
sal_Bool ORemoteSession::connect(const ::rtl::OUString& _rDottedAddress, sal_Int32 _nPort, const TimeValue* _pTimeout)
{
	CFG_TRACE_INFO("remote session: trying to connect to server %s, port %i", OUSTRING2ASCII(_rDottedAddress), _nPort);

	ENTER();

	if (!m_xWriterSource.is() || !m_xReader.is())
	{
		OSL_ENSURE(sal_False, "ORemoteSession::connect : have no XML helper components (parser/writer) !");
		m_eSessionError = E_Invalid;
		return sal_False;
	}

	// create the socket for the basic connection to the registry server
	m_pServerConnection = new OConnectorSocket;
	m_pServerConnection->create(ISocketTypes::TType_Stream, ISocketTypes::TFamily_Inet, ISocketTypes::TProtocol_Ip);
	if (!m_pServerConnection->isValid())
	{
		CFG_TRACE_INFO("remote session: no socket connection available");

		m_eConnectionError = (sal_Int32)m_pServerConnection->getError();
		m_eSessionError = E_ConnectionError;
		delete m_pServerConnection;
		m_pServerConnection = NULL;
		return sal_False;
	}

	m_eConnectionError = (sal_Int32)ISocketTypes::E_None;

	// collect connection information
	OInetSocketAddr aAddress(_rDottedAddress, _nPort);

	// connect to the server
	ISocketTypes::TResult eConnectResult = m_pServerConnection->connect(aAddress, _pTimeout);
	switch (eConnectResult)
	{
		case ISocketTypes::TResult_Error:
		{
			CFG_TRACE_INFO("remote session: a generic error occured");
			m_eConnectionError = (sal_Int32)m_pServerConnection->getError();
		}
		break;
		case ISocketTypes::TResult_TimedOut:
			{
			CFG_TRACE_INFO("remote session: a timeout occured");
			m_eConnectionError = (sal_Int32)ISocketTypes::E_TimedOut;
		}
		break;
		case ISocketTypes::TResult_Interrupted:
		{
			CFG_TRACE_INFO("remote session: the request was interrupted");
			m_eConnectionError = (sal_Int32)ISocketTypes::E_ConnAborted;
		}
		break;
		case ISocketTypes::TResult_InProgress:
		{
			OSL_ENSURE(sal_False, "ORemoteSession::connect : TResult_InProgress while connecting should never happen, me thinks !");
			m_eConnectionError = (sal_Int32)ISocketTypes::E_InProgress;
		}
		break;
	}

	if ((sal_Int32)ISocketTypes::E_None != m_eConnectionError)
	{
		CFG_TRACE_ERROR("remote session: could not connect ...");
		m_eSessionError = E_ConnectionError;
		delete m_pServerConnection;
		m_pServerConnection = NULL;
		return sal_False;
	}

	CFG_TRACE_INFO_NI("remote session: all fine, have the socket");
	// a wrapper for the output to the socket stream
	m_xOutputStream = new OEnvelopeOutputStream<OSocketOutputStream, ::vos::OConnectorSocket>(m_pServerConnection);

	// the interpreter for the parsed xml stream
	m_pInterpreter = new OResponseRedirector();
	m_pInterpreter->acquire();
	m_xReader->setDocumentHandler(m_pInterpreter);

	// start an reader thread for the socket stream
	m_pReaderThread = new OReceiveThread(new OEnvelopeInputStream<OSocketInputStream, ::vos::OConnectorSocket>(m_pServerConnection), m_xReader);
	m_pReaderThread->create();

	if (_pTimeout)
		m_pTimeout = new TimeValue(*_pTimeout);

	// now we have the connection ...
	return sal_True;
}

//--------------------------------------------------------------------------
void ORemoteSession::implDisconnect()
{
	CFG_TRACE_INFO("remote session: disconnecting");
	try
	{
		m_xWriter->endDocument();
			// see the according startDocument call for a comment on this
	}
	catch (sax::SAXException&)
	{
	}

	if (m_pReaderThread)
	{
		// kill the reader thread
		m_pReaderThread->terminateBlocking();
			// will free all resources and terminate the thread, returnes when the thread is really finished.
			// the thread object will be deleted upon return
		m_pReaderThread = NULL;
	}

	if (m_pInterpreter)
	{
		m_pInterpreter->release();
		m_pInterpreter = NULL;
	}

	if (m_xOutputStream.is())
	{
		Reference< XCancellable > xCancel(m_xOutputStream, UNO_QUERY);
		OSL_ENSURE(xCancel.is(), "ORemoteSession::implDisconnect : invalid output stream !");
		if (xCancel.is())
			xCancel->cancel();
			// if the stream would be a simple SocketOutputStream instead of an EnvelopeOutputStream,
			// we would have to do an closeOutput
		m_xOutputStream = NULL;
	}

	delete m_pTimeout;
	m_pTimeout = NULL;

	// kill the socket
	// (do this after killing the thread and the output stream, as they may access the socket)
	if (m_pServerConnection)
	{	// (only if not working as portal session)
		m_pServerConnection->close();
		delete m_pServerConnection;
		m_pServerConnection = NULL;
	}
}

//--------------------------------------------------------------------------
ORemoteSession::~ORemoteSession()
{
	{
		::osl::MutexGuard aGuard(m_aMutex);

		// close if necessary
		if (isOpen())
			kill();

		// disconnect if necessary
		if (isConnected())
			implDisconnect();

		// kill the transaction id string
		rtl_uString_release(m_pLastUsedTransId);

		m_pAttributes->release();
		// TODO : think about real thread safety of this destructor
	}
	delete m_pTimeout;
}

//--------------------------------------------------------------------------
void ORemoteSession::openNode(const AbsolutePath& _rNodeAccessor, 
							  const vos::ORef < OOptions >& _rOptions,
							  sal_Int32 _nLevel, 
							  const ::vos::ORef< IOpenObjectCallback >& _rHandler,
							  INotifyListener* _pListener)
{
	ENTER_FULL_CHECK(openNode, _rHandler);

	OSL_ENSURE(_nLevel >= 0, "ORemoteSession::openNode : invalid level count !");
	OSL_ENSURE(!_rNodeAccessor.isRoot(), "ORemoteSession::openNode : invalid node path !");

	sal_Bool bAddUser = !_rOptions->hasDefaultUser();
	::vos::ORef< IOpenObjectCallback > aRealHandler(_rHandler);
	::vos::ORef< INotifyCallback > xNotifyHandler;	

    Name aUser = configuration::makeName(_rOptions->getUser(), Name::NoValidate());
	::rtl::OUString	sLocale(_rOptions->getLocale());

	sal_Int32 nOverwrites = 0;
	if (bAddUser)
		++nOverwrites;

	if (sLocale.getLength())
		++nOverwrites;		

	if (!m_bCachingPossible)
		++nOverwrites;
	
	if (nOverwrites)
		CFG_TRACE_INFO_NI("remote session: opening a node (%s) for user %s for locale (%s)", OUSTRING2ASCII(_rNodeAccessor.toString()), OUSTRING2ASCII(aUser.toString()), OUSTRING2ASCII(sLocale));
	else
		CFG_TRACE_INFO_NI("remote session: opening the node %s", OUSTRING2ASCII(_rNodeAccessor.toString()));

	// start the envelope
	// count the num
	::rtl::OUString sClientId = openEnvelopedRequest(::rtl::OUString::createFromAscii("openNode"), 2 + nOverwrites);

#ifdef _REMOTE_PATH_TRANSLATION_
	::rtl::OUString	sNodePath = translateClientPath(_rNodeAccessor);
    if (aRealHandler.isValid() && _rNodeAccessor.getDepth() == 1)
    {
	    // the client side node path has depth 1, so we have to fake the name of the top level element the
	    // server will return
	    aRealHandler.bind(new OFakeDataRootPath(aRealHandler, _rNodeAccessor.getLocalName()));
	}
#endif // _REMOTE_PATH_TRANSLATION_

#ifdef _ENCODE_ELEMENT_NAMES_
	if (aRealHandler.isValid())
    {
	    // the client side node path has depth 1, so we have to fake the name of the top level element the
	    // server will return
	    aRealHandler.bind(new ODecodeDataHandler(aRealHandler, _rNodeAccessor.getLocalName()));
	}
#endif // _ENCODE_ELEMENT_NAMES_


#ifdef _ENCODE_USER_NAMES_
	// we have to encode decode the UserGroup Value for the UserProfile
	if (aRealHandler.isValid() && _rNodeAccessor.getModuleName().toString() == (OUString) NODE_USERPROFILE)
		aRealHandler.bind(new OUserNameTranslator(aRealHandler.getBodyPtr()));
#endif

	// register notification handler
	if (m_bCachingPossible && _pListener)	
	{
        ONotifyHandler* pHandler = new ONotifyHandler(_rOptions, _rNodeAccessor, remote::mapServerPath(sNodePath));	
		pHandler->setNotifyListener(_pListener);			
		xNotifyHandler = pHandler;		
	}

	if (aRealHandler.isValid())
		m_pInterpreter->registerCallback(sClientId, aRealHandler, xNotifyHandler);
	
	writeStringParameter(sStringType, sNodePathName, sNodePath);
	writeStringParameter(sIntegerType, ::rtl::OUString::createFromAscii("numLevels"), ::rtl::OUString::valueOf(_nLevel));

	if (bAddUser)
		writeStringParameter(sStringType, sUserName, USERNAME_ENCODE(aUser));

	if (sLocale.getLength())
		writeStringParameter(sStringType, sLocaleParam, sLocale);

	// don't ask for notifications
	if (!m_bCachingPossible)
		writeStringParameter(sStringType, sNotifyParam, sFalseParam);	

	closeEnvelopedRequest();	
}

//--------------------------------------------------------------------------
void ORemoteSession::closeNode(const NodeID& _rNodeId, const ::vos::ORef< IRequestCallback >& _rHandler)
{
	CFG_TRACE_INFO("remote session: closing node with id %s", OUSTRING2ASCII(_rNodeId));
	ENTER_FULL_CHECK(closeNode, _rHandler);

	// remove the notification callback if there is any
	m_pInterpreter->removeCallback(_rNodeId);
	
	
	::rtl::OUString sClientId = openEnvelopedRequest(::rtl::OUString::createFromAscii("closeNode"), 1);

	if (_rHandler.isValid())
		m_pInterpreter->registerCallback(sClientId, _rHandler);
	writeStringParameter(sStringType, ::rtl::OUString::createFromAscii("nodeId"), _rNodeId);
	closeEnvelopedRequest();
}

//IUpdateProvider
//--------------------------------------------------------------------------
void ORemoteSession::updateNode(const NodeID& _rNodeId, 
								const AbsolutePath& _rNodeAccessor,
								const vos::ORef < OOptions >& _rOptions,
								IDOMNodeDataProvider* _pNodeWriter, 
								const ::vos::ORef< IDataRequestCallback >& _rHandler)
{
	ENTER_FULL_CHECK(updateNode, _rHandler);
	OSL_ENSURE(_pNodeWriter != NULL, "ORemoteSession::updateNode : invalid data provider !");	

    Name aUser = configuration::makeName(_rOptions->getUser(),Name::NoValidate());
	::rtl::OUString	sLocale(_rOptions->getLocale());
	sal_Bool bAddUser = !_rOptions->hasDefaultUser();

	if (bAddUser)
		CFG_TRACE_INFO_NI("remote session: updating a node (%s) for user %s", OUSTRING2ASCII(_rNodeAccessor.toString()), OUSTRING2ASCII(aUser.toString()));
	else
		CFG_TRACE_INFO_NI("remote session: updating the node %s", OUSTRING2ASCII(_rNodeAccessor.toString()));

	::vos::ORef< IDataRequestCallback > aRealHandler(_rHandler);
	::rtl::OUString sClientId = openEnvelopedRequest(::rtl::OUString::createFromAscii("updateNode"), aUser.isEmpty() ? 3 : 4);

#ifdef _REMOTE_PATH_TRANSLATION_
	// perhaps we have to fake the root of the data data the server may return (on an unsuccessfull update)
	::rtl::OUString	sNodePath = translateClientPath(_rNodeAccessor);

	// if the orginal (untranslated path) contains only one level, we have to fake the top level elements which are
	// transported through the XDocumentHandler interfaces
	sal_Bool bOriginalPathOneLevel = (_rNodeAccessor.getDepth() == 1);

	if (aRealHandler.isValid())
		if (bOriginalPathOneLevel)
		{
			CFG_TRACE_INFO("remote session: adding a translator for the top level element of the may-be-returned tree");
			aRealHandler = new OFakeDataRootPath(aRealHandler, _rNodeAccessor.getLocalName());
		}
#endif

#ifdef _ENCODE_ELEMENT_NAMES_
	if (aRealHandler.isValid())
	{
		CFG_TRACE_INFO("remote session: adding a translator for set element names of the may-be-returned tree");
		aRealHandler = new ODecodeDataHandler(aRealHandler, _rNodeAccessor.getLocalName());
	}
#endif

	if (aRealHandler.isValid())
		m_pInterpreter->registerCallback(sClientId, aRealHandler);

	writeStringParameter(sStringType, ::rtl::OUString::createFromAscii("nodeId"), _rNodeId);
	writeStringParameter(sStringType, sNodePathName, sNodePath);

	if (_pNodeWriter)
	{

#ifdef _REMOTE_PATH_TRANSLATION_
        AbsolutePath aTranslated = remote::mapServerPath(sNodePath);

		::vos::ORef< OFakeDataRootPath > xFakeDataRootPath;
		// the same (root element name) fake as above, this time for the root element the writer is going to write	
		if (bOriginalPathOneLevel)
		{
			CFG_TRACE_INFO("remote session: adding a translator for the top level element of the to-be-written tree");
			// in write mode, the new element the writer should use is the last element of the translated path
			xFakeDataRootPath = new OFakeDataRootPath(_pNodeWriter, aTranslated.getLocalName());			
			_pNodeWriter = xFakeDataRootPath.getBodyPtr();
		}
#endif

#ifdef _ENCODE_ELEMENT_NAMES_
        CFG_TRACE_INFO("remote session: adding a encoder for set element names of the to-be-written tree");
		::vos::ORef< OEncodedDataProvider > xEncodedDataProvider = new OEncodedDataProvider(_pNodeWriter, aTranslated.getLocalName());
		_pNodeWriter = xEncodedDataProvider.getBodyPtr();
#endif

#ifdef _ENCODE_USER_NAMES_
		::vos::ORef< OUserNameTranslator > xUserNameTranslator;
		// translation for UserGroupName
		if (_rNodeAccessor.getModuleName().toString() == (OUString) NODE_USERPROFILE)
		{
			xUserNameTranslator = new OUserNameTranslator(_pNodeWriter);
			_pNodeWriter = xUserNameTranslator.getBodyPtr();
		}
#endif

		//! convert new to old
		writeNodeParameter(_pNodeWriter, sUpdateNameParam);
	}

	if (bAddUser)
		writeStringParameter(sStringType, sUserName, USERNAME_ENCODE(aUser));
	closeEnvelopedRequest();
}

//--------------------------------------------------------------------------
::rtl::OUString ORemoteSession::openEnvelopedRequest(const ::rtl::OUString& _rRequestName, sal_Int32 _nParamCount)
{
	// no mutex guarding, this is a protected method which has to be called from within guarded methods
	// only

	OSL_ENSURE(m_xWriter.is(), "ORemoteSession::openEnvelopedRequest : no writer !");

	// TODO : string optimizations : either some central place to store the ascii versions, or even hold
	// the unicode versions in a central place

	::rtl::OUString sRequest(::rtl::OUString::createFromAscii("request"));
	::rtl::OUString sTransaction(::rtl::OUString::createFromAscii("transaction"));
	::rtl::OUString sEmptyString;

	// generate a new id
	::rtl::OUString sClientId;
	nextRequestTransId(sClientId);

	// attribute container
	m_pAttributes->clear();
	Reference< sax::XAttributeList > xAttribs = m_pAttributes;

	try
	{
		// propagate the output stream to the XML generator
		m_xWriterSource->setOutputStream(m_xOutputStream);
		m_xWriter->startDocument();

		// <envelope>
		m_xWriter->startElement(::rtl::OUString::createFromAscii("envelope"), xAttribs);

		// <header>
		m_xWriter->startElement(::rtl::OUString::createFromAscii("header"), xAttribs);

		// <transaction type="request" name="..." clientId="..." serverId=""/>
		m_pAttributes->addAttribute(::rtl::OUString::createFromAscii("type"), sGenericStringData, sRequest);
		m_pAttributes->addAttribute(::rtl::OUString::createFromAscii("name"), sGenericStringData, _rRequestName);
		m_pAttributes->addAttribute(::rtl::OUString::createFromAscii("clientId"), sGenericStringData, sClientId);
		m_pAttributes->addAttribute(::rtl::OUString::createFromAscii("serverId"), sGenericStringData, sEmptyString);
		m_xWriter->startElement(sTransaction, xAttribs);
		m_xWriter->endElement(sTransaction);
		m_pAttributes->clear();

		// </header>
		m_xWriter->endElement(::rtl::OUString::createFromAscii("header"));

		// <body>
		m_xWriter->startElement(::rtl::OUString::createFromAscii("body"), xAttribs);

		// <params total="...">
		m_pAttributes->addAttribute(::rtl::OUString::createFromAscii("total"), sGenericStringData, ::rtl::OUString::valueOf(_nParamCount));
		m_xWriter->startElement(::rtl::OUString::createFromAscii("params"), xAttribs);
		m_pAttributes->clear();
	}
	CATCH_HANDLE_EXCEPTIONS_RET(::rtl::OUString());

	return sClientId;
}

//--------------------------------------------------------------------------
void ORemoteSession::closeEnvelopedRequest()
{
	// no mutex guarding, this is a protected method which has to be called from within guarded methods
	// only

	OSL_ENSURE(m_xWriter.is(), "ORemoteSession::closeEnvelopedRequest : no writer !");

	try
	{
		m_xWriter->endElement(::rtl::OUString::createFromAscii("params"));
		m_xWriter->endElement(::rtl::OUString::createFromAscii("body"));
		m_xWriter->endElement(::rtl::OUString::createFromAscii("envelope"));
		m_xWriter->characters(::rtl::OUString::createFromAscii("\n\n"));
		m_xWriter->endDocument();
	}
	CATCH_HANDLE_EXCEPTIONS();
}

//--------------------------------------------------------------------------
sal_Bool ORemoteSession::open(const ::rtl::OUString& _rUser, const ::rtl::OUString& _rPwd)
{
	CFG_TRACE_INFO("remote session: opening a session for user %s", OUSTRING2ASCII(_rUser));

	ENTER();
	if (!isConnected())
	{
		OSL_ENSURE(sal_False, "ORemoteSession::open : You have to call \"connect\" before opening a session !");
		m_eSessionError = E_NotConnected;
		return sal_False;
	}

	// a callback for the open request to the server
	OWaitForOpenSession* pWaitObject = new OWaitForOpenSession;
	ORef< IOpenObjectCallback > aKeepAlive = pWaitObject;

	// open the envelope
	::rtl::OUString sClientId = openEnvelopedRequest(::rtl::OUString::createFromAscii("openSession"), 2);
	// register the callback
	m_pInterpreter->registerCallback(sClientId, aKeepAlive);
	// write the params, which currently are the user and the (not encrypted) password
	writeStringParameter(sStringType, ::rtl::OUString::createFromAscii("userName"), _rUser);
	writeStringParameter(sStringType, ::rtl::OUString::createFromAscii("password"), _rPwd);
	// close the envelope, which will trigger the transaction
	closeEnvelopedRequest();

	TimeValue aTimeout;
	aTimeout.Seconds = 30;
	aTimeout.Nanosec = 0;
	pWaitObject->waitForResponse(m_pTimeout ? m_pTimeout : &aTimeout);

	if (!pWaitObject->isFinished())
	{
		CFG_TRACE_ERROR("remote session: something went wrong, conn status %i, server returned %s", pWaitObject->getConnError(), OUSTRING2ASCII(pWaitObject->getStatus().sMessage));

		// though the request could not be finished, send an closeSession, just in case the
		// request is fullfilled just at this moment
		kill();
		m_eSessionError = E_TimedOut;
		return sal_False;
	}

	sal_Bool bSuccess = pWaitObject->getConnError() == 0 && pWaitObject->getStatus().nCode == 0;
	m_nSessionId = bSuccess ? pWaitObject->getSessionId() : -1;

	CFG_TRACE_INFO_NI("remote session: got a session id of %i", m_nSessionId);

	if (!bSuccess)
	{
		m_eSessionError = E_ConnectionError;
		m_eConnectionError = pWaitObject->getConnError();

		if (pWaitObject->getStatus().nCode != 0)
			throw ::com::sun::star::connection::ConnectionSetupException(pWaitObject->getStatus().sMessage, NULL);
		else
			throw ::com::sun::star::connection::ConnectionSetupException(OUString::createFromAscii("Could not establish the connection to the configuration server."), NULL);
	}

	return bSuccess;
}

//--------------------------------------------------------------------------
void ORemoteSession::kill()
{
	CFG_TRACE_INFO("remote session: killing the current session");

	ENTER();
	if (!isConnected())
	{
		OSL_ENSURE(sal_False, "ORemoteSession::kill : not connected !");
		m_eSessionError = E_NotConnected;
		return;
	}
	
	// reset the interpreter
	if (m_pInterpreter)
		m_pInterpreter->reset();

	// send a closeSession request
	openEnvelopedRequest(::rtl::OUString::createFromAscii("closeSession"), 0);
	closeEnvelopedRequest();

	// reset the session id, indicating that we're closed
	m_nSessionId = -1;
}

//--------------------------------------------------------------------------
void ORemoteSession::close()
{
	::osl::MutexGuard aGuard(m_aMutex);

	// close if necessary
	if (isOpen())
		kill();

	// disconnect if necessary
	if (isConnected())
		implDisconnect();
}
  
//--------------------------------------------------------------------------
void ORemoteSession::implCloseSuccessfull()
{
	::osl::MutexGuard aGuard(m_aMutex);

	// reset the interpreter
	if (m_pInterpreter)
		m_pInterpreter->reset();

	m_nSessionId = -1;
}

//--------------------------------------------------------------------------
void ORemoteSession::writeStringParameter(const ::rtl::OUString& _rTypeDesc, const ::rtl::OUString& _rParamName, const ::rtl::OUString& _rValue)
{
	// no mutex guarding, this is a protected method which has to be called from within guarded methods
	// only

	OSL_ENSURE(m_xWriter.is(), "ORemoteSession::writeStringParameter : no writer !");

	// attribute container
	m_pAttributes->clear();
	Reference< sax::XAttributeList > xAttribs = m_pAttributes;

	try
	{
		// <data type="...">
		m_pAttributes->addAttribute(::rtl::OUString::createFromAscii("type"), sGenericStringData, _rTypeDesc);
		m_pAttributes->addAttribute(::rtl::OUString::createFromAscii("name"), sGenericStringData, _rParamName);
		m_xWriter->startElement(::rtl::OUString::createFromAscii("data"), xAttribs);
		m_pAttributes->clear();

		// <value>...</value>
		m_xWriter->startElement(::rtl::OUString::createFromAscii("value"), xAttribs);
		m_xWriter->characters(_rValue);
		m_xWriter->endElement(::rtl::OUString::createFromAscii("value"));

		// </data>
		m_xWriter->endElement(::rtl::OUString::createFromAscii("data"));
	}
	CATCH_HANDLE_EXCEPTIONS();
}

//--------------------------------------------------------------------------
void ORemoteSession::writeNodeParameter(IDOMNodeDataProvider* _pProvider, const ::rtl::OUString& _rNameParamValue)
{
	// no mutex guarding, this is a protected method which has to be called from within guarded methods
	// only

	OSL_ENSURE(m_xWriter.is(), "ORemoteSession::writeNodeParameter : no writer !");

	// attribute container
	m_pAttributes->clear();
	Reference< sax::XAttributeList > xAttribs(m_pAttributes);

	try
	{
		// <data type="...">
		m_pAttributes->addAttribute(::rtl::OUString::createFromAscii("type"), sGenericStringData, sNodeName);
		m_pAttributes->addAttribute(::rtl::OUString::createFromAscii("name"), sGenericStringData, _rNameParamValue);
		m_xWriter->startElement(::rtl::OUString::createFromAscii("data"), xAttribs);
		m_pAttributes->clear();

		// <value>...</value>
		m_xWriter->startElement(::rtl::OUString::createFromAscii("value"), xAttribs);
		_pProvider->writeNodeData(Reference< sax::XDocumentHandler >(m_xWriter.get()));
			// TODO : think about exception handling for this single call .... maybe we don't want the excpetions
			// thrown by the provider to leave this method ...
		m_xWriter->endElement(::rtl::OUString::createFromAscii("value"));

		// </data>
		m_xWriter->endElement(::rtl::OUString::createFromAscii("data"));
	}
	CATCH_HANDLE_EXCEPTIONS();
}

//--------------------------------------------------------------------------
void ORemoteSession::writeEmptyProfile(const ::rtl::OUString& _rNameParamValue, const ::rtl::OUString& _rProfileName)
{
	// no mutex guarding, this is a protected method which has to be called from within guarded methods
	// only	

	// attribute container
	m_pAttributes->clear();
	Reference< sax::XAttributeList > xAttribs = m_pAttributes;

	try
	{
		// <data type="...">
		m_pAttributes->addAttribute(::rtl::OUString::createFromAscii("type"), sGenericStringData, sNodeName);
		m_pAttributes->addAttribute(::rtl::OUString::createFromAscii("name"), sGenericStringData, _rNameParamValue);
		m_xWriter->startElement(::rtl::OUString::createFromAscii("data"), xAttribs);
		m_pAttributes->clear();

		// <value>...</value>
		m_xWriter->startElement(::rtl::OUString::createFromAscii("value"), xAttribs);
		
		m_xWriter->startElement(_rProfileName, Reference< sax::XAttributeList >());
		m_xWriter->endElement(_rProfileName);
		
		m_xWriter->endElement(::rtl::OUString::createFromAscii("value"));

		// </data>
		m_xWriter->endElement(::rtl::OUString::createFromAscii("data"));
	}
	CATCH_HANDLE_EXCEPTIONS();
}

//--------------------------------------------------------------------------
void ORemoteSession::nextRequestTransId(::rtl::OUString& _rId)
{
	OSL_ENSURE(1 == m_pLastUsedTransId->refCount,
		"ORemoteSession::nextRequestTransId : invalid ref count of the transaction id !");
		// if you assign m_pLastUsedTransId to an ::rtl::OUString an call this method before
		// destroying that string, this assertion will fail. This is important as if some foreign string
		// references the characters, we could dou heavy damage with modifying them here.

	// TODO : for performance reasons : think about removing the following code which copies the string data.
	// Normally it should never be necessary ...
	if (1 != m_pLastUsedTransId->refCount)
	{	// create a new implobject to work with
		rtl_uString* pNewObject = NULL;
		rtl_uString_newFromString(&pNewObject, m_pLastUsedTransId);
			// acquired automatically
		rtl_uString_release(m_pLastUsedTransId);
		m_pLastUsedTransId = pNewObject;
	}

	// the algorithm for generating new ids is quite simple :
	// for each id the first character is an 'R' (like request)
	// followed by n*4 characters from [0..9, A..Z], where n is a sal_Int32 of at least 1.
	// So there are about 16^(2^31) ~= 2^(100.000.000.000) (or something like that :)
	// valid ids, which should be sufficient.

	sal_Unicode* pLoop = m_pLastUsedTransId->buffer + m_pLastUsedTransId->length - 1;
	for (sal_Int32 i = m_pLastUsedTransId->length - 1; i >= 0; --i, --pLoop)
	{
		if ('R' == *pLoop)	// terminator, we have an overflow
		{
			// we've used all digits we have, so append new ones
			rtl_uString* pNewObject = NULL;
			rtl_uString_new_WithLength(&pNewObject, m_pLastUsedTransId->length + 4);
				// acquired automatically

			sal_Int32 j;
			sal_Unicode* pCopyLoop = pNewObject->buffer;
			// the first character is the terminator character
			*pCopyLoop = 'R';
			++pCopyLoop;
			// 4 new '0' characters + the remainings in 
			for (j=1; j<pNewObject->length; ++j, ++pCopyLoop)
				*pCopyLoop = '0';

			// now we have a new string describing our ids
			rtl_uString_release(m_pLastUsedTransId);
			m_pLastUsedTransId = pNewObject;

			// and the increment is done, so break
			break;
		}
		else
		{
			if ('F' == *pLoop)	// digit overflow
				*pLoop = '0';	// no break, continue with the previous character
			else
			{
				if ('9' == *pLoop)
					*pLoop = 'A';
				else
					++*pLoop;
				break;			// the increment is done, no need to visit the other characters
			}
		}
	}

	// unfortunally the transaction ids live much longer than any single method call in this class
	// lasts, which means that if we would use m_pLastUsedTransId for the ::rtl::OUString's, we would
	// have no chance to control the acquire/release calls with our mutex, so we would be heavyly unsafe.
	// Thus we have to copy the data in m_pLastUsedTransId.

	_rId = ::rtl::OUString(m_pLastUsedTransId->buffer, m_pLastUsedTransId->length);
}

//--------------------------------------------------------------------------
void ORemoteSession::cancelTrans(sal_Int32 _nTransId, const ::vos::ORef< IRequestCallback >& _rHandler)
{
	ENTER_FULL_CHECK(cancelTrans, _rHandler);

	::rtl::OUString sClientId = openEnvelopedRequest(::rtl::OUString::createFromAscii("cancelTrans"), 1);
	if (_rHandler.isValid())
		m_pInterpreter->registerCallback(sClientId, _rHandler);
	writeStringParameter(sIntegerType, ::rtl::OUString::createFromAscii("clientId"), ::rtl::OUString::valueOf(_nTransId));
	closeEnvelopedRequest();
}

//--------------------------------------------------------------------------
void ORemoteSession::cancelNodeTrans(const AbsolutePath& _rNodeAccessor, const ::vos::ORef< IRequestCallback >& _rHandler)
{
	ENTER_FULL_CHECK(cancelNodeTrans, _rHandler);
    OSL_ENSURE(false, "Canceling node transactions not yet implemented");
}

//--------------------------------------------------------------------------
void ORemoteSession::cancelAllTrans()
{
	ENTER_FULL_CHECK(cancelAllTrans, ORef< IRequestCallback >());

	openEnvelopedRequest(::rtl::OUString::createFromAscii("cancelTrans"), 0);
	writeStringParameter(sStringType, sNodePathName, ::rtl::OUString::createFromAscii("ALL"));
	closeEnvelopedRequest();
}

/// IAdminProvider Implementation
//--------------------------------------------------------------------------
void ORemoteSession::addUser(const Name& _rUser, const Name& _rGroup, 
							 IDOMNodeDataProvider* _pNodeWriter, 
							 const ::vos::ORef< IRequestCallback >& _rHandler)
{
	ENTER_FULL_CHECK(addUser, _rHandler);

	// special path	
	::rtl::OUString sClientId;
	sClientId = openEnvelopedRequest(::rtl::OUString::createFromAscii("addUser"), 3);

	if (_rHandler.isValid())
		m_pInterpreter->registerCallback(sClientId, _rHandler);

	writeStringParameter(sStringType, sUserName, USERNAME_ENCODE(_rUser));
	if (_rGroup.isEmpty())	
		writeStringParameter(sStringType, sGroupName, NODE_USERPROFILE_DEFAULTGROUP);
	else
		writeStringParameter(sStringType, sGroupName, USERNAME_ENCODE(_rGroup));	

	writeStringParameter(sStringType, sParentNodePathName, NODE_USERPROFILE);	

	if (_pNodeWriter)
	{
#ifdef _NO_ADDNODE_REDUNDANCE_
		::vos::ORef< OTreeRootTagKiller > xRedundanceKiller = new OTreeRootTagKiller(_pNodeWriter, OUString());
		_pNodeWriter = xRedundanceKiller.getBodyPtr();
#endif

#ifdef _ENCODE_USER_NAMES_
        using configuration::Path::wrapSimpleName;
		// the first element of the to-be-written stream is the user name, which has to be encoded
        ::vos::ORef< OFakeDataRootPath > xFakeUserName = new OFakeDataRootPath(_pNodeWriter, wrapSimpleName(USERNAME_ENCODE(_rUser)));
		_pNodeWriter = xFakeUserName.getBodyPtr();
#endif
		writeNodeParameter(_pNodeWriter, sAddNameParam);
	}
	else
	{
		writeEmptyProfile(sAddNameParam, USERNAME_ENCODE(_rUser));
	}

	closeEnvelopedRequest();
}

//--------------------------------------------------------------------------
void ORemoteSession::deleteUser(const Name& _rUser, const ::vos::ORef< IRequestCallback >& _rHandler)
{
	ENTER_FULL_CHECK(deleteUser, _rHandler);

	::rtl::OUString sClientId = openEnvelopedRequest(::rtl::OUString::createFromAscii("deleteUser"), 1);
	if (_rHandler.isValid())
		m_pInterpreter->registerCallback(sClientId, _rHandler);

	writeStringParameter(sStringType, sUserName, USERNAME_ENCODE(_rUser));
	closeEnvelopedRequest();
}

//--------------------------------------------------------------------------
void ORemoteSession::addGroup(const Name& _rGroup, const Name& _rParent, IDOMNodeDataProvider* _pNodeWriter, 
							  const ::vos::ORef< IRequestCallback >& _rHandler)
{
	ENTER_FULL_CHECK(addGroup, _rHandler);

	// special path	
	::rtl::OUString sClientId;
	bool bHasParent = !_rParent.isEmpty();

	sClientId = openEnvelopedRequest(::rtl::OUString::createFromAscii("addGroup"), bHasParent ? 4 : 3);

	if (_rHandler.isValid())
		m_pInterpreter->registerCallback(sClientId, _rHandler);
	
	writeStringParameter(sStringType, sGroupName, USERNAME_ENCODE(_rGroup));
	if (bHasParent)
		writeStringParameter(sStringType, sGroupParent, USERNAME_ENCODE(_rParent));

	writeStringParameter(sStringType, sParentNodePathName, NODE_USERPROFILE);	

	if (_pNodeWriter)
	{
#ifdef _NO_ADDNODE_REDUNDANCE_
		::vos::ORef< OTreeRootTagKiller > xRedundanceKiller = new OTreeRootTagKiller(_pNodeWriter, OUString());
		_pNodeWriter = xRedundanceKiller.getBodyPtr();
#endif

#ifdef _ENCODE_USER_NAMES_
        using configuration::Path::wrapSimpleName;
		// the first element of the to-be-written stream is the user name, which has to be encoded
		::vos::ORef< OFakeDataRootPath > xFakeUserName = new OFakeDataRootPath(_pNodeWriter, wrapSimpleName(USERNAME_ENCODE(_rGroup)));
		_pNodeWriter = xFakeUserName.getBodyPtr();
#endif
		writeNodeParameter(_pNodeWriter, sAddNameParam);
	}
	else
	{
		writeEmptyProfile(sAddNameParam, USERNAME_ENCODE(_rGroup));
	}

	closeEnvelopedRequest();
}

//--------------------------------------------------------------------------
void ORemoteSession::deleteGroup(const Name& _rGroup, const ::vos::ORef< IRequestCallback >& _rHandler)
{
	ENTER_FULL_CHECK(deleteGroup, _rHandler);
	
	::rtl::OUString sClientId = openEnvelopedRequest(::rtl::OUString::createFromAscii("deleteGroup"), 1);
	if (_rHandler.isValid())
		m_pInterpreter->registerCallback(sClientId, _rHandler);

	writeStringParameter(sStringType, sGroupName, USERNAME_ENCODE(_rGroup));
	closeEnvelopedRequest();
}

//--------------------------------------------------------------------------
IAdminProvider* ORemoteSession::asIAdminProvider() { return this; }
IAdminProvider const* ORemoteSession::asIAdminProvider() const { return this; }

//--------------------------------------------------------------------------
IUpdateProvider* ORemoteSession::asIUpdateProvider() { return this; }
IUpdateProvider const* ORemoteSession::asIUpdateProvider() const { return this; }

#ifdef _REMOTE_PATH_TRANSLATION_
//#define _SIMULATE_COMPONENT_DOTS_
//#define _STRIP_ABSOLUTE_PATH_SLASH_
//--------------------------------------------------------------------------
namespace remote { 
    typedef configuration::Path::Iterator PathIter;
    static ::rtl::OUString implMapClientPath(PathIter _aFirst, PathIter _aLast, OUString const& _sExtraPrefix);
}
//--------------------------------------------------------------------------
::rtl::OUString ORemoteSession::translateClientPath(AbsolutePath const & _aPath)
{
	CFG_TRACE_INFO("remote session: translating a node path. origin: proxy");
	CFG_TRACE_INFO_NI("remote session: old        value: %s", OUSTRING2ASCII(_aPath.toString()));

    AbsolutePath::Iterator          aFirst = _aPath.begin();
    AbsolutePath::Iterator const    aLast  = _aPath.end();

    OSL_ENSURE( aFirst != aLast, "ERROR: Root path passed to remote session for translation\n");

    OUString sSubstituteModule;

#ifdef REQUEST_TEMPLATE_DETECTION
    if (0 == _aPath.getModuleName().toString().compareToAscii(REQUEST_TEMPLATE_DETECTION))
    {
#ifdef CFGSERVER_TEMPLATE_LOCATION
        sSubstituteModule = OUString( RTL_CONSTASCII_USTRINGPARAM(CFGSERVER_TEMPLATE_LOCATION "/") );
#endif // CFGSERVER_TEMPLATE_LOCATION

        ++aFirst; // skip the pseudo-module
        OSL_ENSURE( aFirst != aLast, "ERROR: Template path without module or name passed to remote session for translation\n");
        
        OSL_ENSURE( aFirst->isSimpleName(), "ERROR: Template module is an element name ?");

#ifdef _SIMULATE_TEMPLATE_COMPONENT_DOTS_
        sSubstituteModule += aFirst->getName().toString().replace('.', '/');
#else  // !_SIMULATE_TEMPLATE_COMPONENT_DOTS_
        sSubstituteModule += aFirst->getName().toString();
#endif // !_SIMULATE_TEMPLATE_COMPONENT_DOTS_

        ++aFirst; // skip the original module part as well 
    
        CFG_TRACE_INFO_NI("remote session: adjusted  module: %s", OUSTRING2ASCII(sSubstituteModule));
    }
    else
#endif // REQUEST_TEMPLATE_DETECTION
#if defined(_SIMULATE_COMPONENT_DOTS_) || defined(_STRIP_ABSOLUTE_PATH_SLASH_)
    {
    #if defined(_SIMULATE_COMPONENT_DOTS_) 
        if (!_aPath.getModuleName().toString().equals(NODE_USERPROFILE))
            sSubstituteModule += aFirst->getName().toString().replace('.', '/');
        else
            sSubstituteModule += aFirst->getName().toString();

    #elif defined(_STRIP_ABSOLUTE_PATH_SLASH_)       
        sSubstituteModule += aFirst->getName().toString();
    #endif //_SIMULATE_COMPONENT_DOTS_ ||  _STRIP_ABSOLUTE_PATH_SLASH_

        ++aFirst; // skip the original module part as well 
        CFG_TRACE_INFO_NI("remote session: adjusted  module: %s", OUSTRING2ASCII(sSubstituteModule));
    }
#else
    {}
#endif // 

    OUString sPath = remote::implMapClientPath(aFirst,aLast,sSubstituteModule);

	CFG_TRACE_INFO_NI("remote session: translated value: %s", OUSTRING2ASCII(sPath));
    return sPath;
}
//--------------------------------------------------------------------------
#endif

//..........................................................................
}	// namespace configmgr

// ----------------- old name translation ---------------------------------------

#ifndef CONFIGMGR_CONFNAME_HXX_
#include "confname.hxx"
#endif
#ifndef _RTL_USTRBUF_HXX_
#include <rtl/ustrbuf.hxx>
#endif
//..........................................................................
namespace configmgr
{
    namespace remote
    {
        using namespace configuration;
        using namespace configuration::Path;
        using ::rtl::OUString;
//----------------------------------------------------------------------------

    AbsolutePath mapServerPath(OUString const& _sPath)
    {
#ifdef _ENCODE_ELEMENT_NAMES_
        Rep aResult;

        ConfigurationName aParser( _sPath, ConfigurationName::Absolute() );

        ConfigurationName::Iterator it = aParser.end(), stop = aParser.begin();      
        while (it != stop)
        {
            --it;
 
            OUString sName, sType;
            bool bValid;
            if (encodename::decode_pair(*it,sName,sType,bValid))
            {
                OSL_ASSERT(bValid);
                aResult.prepend( makeCompositeName(sName,sType) );
            }
            else if (bValid)
            {
                aResult.prepend( wrapSimpleName(sName) );
            }
            else 
            {
                OSL_ENSURE(false, "Path received from the server did contain an invalid escaped name");
                aResult.prepend( wrapSafeName(*it) );
            }
        }

        return AbsolutePath(aResult);
#else
#error "not yet supported - need to parse in XPath mode"
        return AbsolutePath::parse(_sPath);
#endif // _ENCODE_ELEMENT_NAMES_
    }
//----------------------------------------------------------------------------
    static
    OUString implMapClientPath(PathIter _aFirst, PathIter _aLast, OUString const& _sExtraPrefix = OUString())
    {
#ifdef _ENCODE_ELEMENT_NAMES_
        OSL_PRECOND(_aFirst != _aLast || _sExtraPrefix.getLength(), "Mapping root path is not properly supported !");
        rtl::OUStringBuffer sMapped(_sExtraPrefix);

        for( ;_aFirst != _aLast; ++_aFirst)
        {
            OUString sEncodedName;
            
            Name sName, sType;
            if (_aFirst->splitCompositeName(sName, sType))
            {
                sEncodedName = encodename::encode_pair(sName.toString(), sType.toString());
            }
            else
            {
                sEncodedName = _aFirst->toPathString();
                OSL_ASSERT(sEncodedName == sName.toString());
            }

            sMapped.append(sal_Unicode('/')).append( sEncodedName );
        }

        return sMapped.makeStringAndClear();
#else
#error "not yet supported - need to render to String in XPath mode"
        return _sExtraPrefix + Path::Rep(_aFirst,_aLast).toString(true);
#endif // _ENCODE_ELEMENT_NAMES_
    }

//----------------------------------------------------------------------------
    OUString mapClientPath(AbsolutePath const& _aPath)
    {
        return implMapClientPath(_aPath.begin(), _aPath.end());
    }
//----------------------------------------------------------------------------

    OUString decodeServerNameString(OUString const& _sName, OUString& _rsType)
    {
#ifdef _ENCODE_ELEMENT_NAMES_
        bool bValid =false;

        OUString sName;
        _rsType = sName; // clear it
        if (!encodename::decode_pair(_sName,sName,_rsType,bValid) && !bValid)
        {
            OSL_ENSURE(false, "Name being decoded was not a valid encoded name");
            sName = _sName;
        }

        OSL_ENSURE(sName.getLength(), "ERROR: Decoded name is empty !!");
        return sName;
#else
        return _sName;
#endif // _ENCODE_ELEMENT_NAMES_
    }
//----------------------------------------------------------------------------

    Name decodeServerName(OUString const& _sName)
    {
#ifdef _ENCODE_ELEMENT_NAMES_
        bool bValid =false;

        OUString sResult = encodename::decode(_sName, bValid);

        OSL_ENSURE(bValid, "Name being decoded was not a valid encoded name");

        return makeName(sResult,Name::NoValidate());
#else
        return makeName(_sName,Name::NoValidate());
#endif // _ENCODE_ELEMENT_NAMES_
    }
//----------------------------------------------------------------------------

    OUString encodeClientNameString(OUString const& _sName, OUString const& _sTypeName)
    {
#ifdef _ENCODE_ELEMENT_NAMES_
        return encodename::encode_pair(_sName,_sTypeName);
#else
        return _sName;
#endif // _ENCODE_ELEMENT_NAMES_
    }
//----------------------------------------------------------------------------

    OUString encodeClientName(Name const& _aName)
    {
#ifdef _ENCODE_ELEMENT_NAMES_
        return encodename::encode(_aName.toString());
#else
        return _aName.toString();
#endif // _ENCODE_ELEMENT_NAMES_
    }
//----------------------------------------------------------------------------
}	// namespace remote
//..........................................................................
}	// namespace configmgr
//..........................................................................

/**************************************************************************
 history:
	$Log: remotesession.cxx,v $
	Revision 1.43  2001/10/12 11:08:35  rt
	#65293# avoid overloading ambiguity for solaris compiler
	
	Revision 1.42  2001/10/11 14:24:31  dg
	#92234# added feature for adding groups within groups
	
	Revision 1.41  2001/09/27 18:45:54  hr
	#65293#: exception specification
	
	Revision 1.40  2001/07/17 10:10:00  jb
	#89766# Missing data in AddNode transaction
	
	Revision 1.39  2001/07/16 15:02:48  jb
	#89745# Also need to drop the initial slash off pathes to user-profile nodes
	
	Revision 1.38  2001/07/16 07:56:28  jb
	#89687# Corrected syntax for conditional compilation
	
	Revision 1.37  2001/07/13 15:35:06  jb
	#89687# Added ODecodeDataHandler and OEncodedDataProvider to support the new free-form element names. Removed some obsolete stuff.
	
	Revision 1.36  2001/07/05 17:05:48  jb
	#87904# New path format; Adjusted Name and Path Handling
	
	Revision 1.34  2001/06/12 16:12:47  jb
	#88103# Separate templates on the server
	
	Revision 1.33  2001/05/14 13:10:05  lla
	changes to build also within solaris environment
	
	Revision 1.32  2001/05/11 19:26:44  pl
	rtl string api changes
	
	Revision 1.31  2001/05/08 13:40:46  dg
	#83823# validation if open session was successful
	
<<<<<<< remotesession.cxx
	Revision 1.30  2001/05/03 16:09:46  dg
	#86437# requestNotify and cancelNotify removed as they are obsolete
	
<<<<<<< remotesession.cxx
	Revision 1.29  2001/04/27 14:04:29  dg
	#85095# Encode/Decoding of Group Names
	
<<<<<<< remotesession.cxx
	Revision 1.28  2001/03/30 13:53:39  dg
	path structure changed for configserver
	
	Revision 1.27  2001/03/29 11:46:02  svesik
	No more strconverter.hxx
	
	Revision 1.26  2001/03/23 12:44:26  lla
	Attributes moved to AttributeList and configuration::Attributes now in it's own file.
	
	Revision 1.25  2001/03/21 12:22:23  jl
	OSL_ENSHURE replaced by OSL_ENSURE
	
	Revision 1.24  2001/03/08 08:59:22  armin
	changed stl includes
	
=======
	Revision 1.23.2.1  2001/04/27 13:46:04  dg
	#85095# Encode/Decoding of Group Names
	
>>>>>>> 1.23.2.1
=======
	Revision 1.23.2.2  2001/05/03 11:37:43  dg
	#86437# requestNotify and cancelNotify removed as they are obsolete
	
	Revision 1.23.2.1  2001/04/27 13:46:04  dg
	#85095# Encode/Decoding of Group Names
	
>>>>>>> 1.23.2.2
=======
	Revision 1.23.2.3  2001/05/08 13:32:52  dg
	#83823# validation if open session was successful
	
	Revision 1.23.2.2  2001/05/03 11:37:43  dg
	#86437# requestNotify and cancelNotify removed as they are obsolete
	
	Revision 1.23.2.1  2001/04/27 13:46:04  dg
	#85095# Encode/Decoding of Group Names
	
>>>>>>> 1.23.2.3
	Revision 1.23  2001/02/21 13:41:51  dg
	#84191# encoding of user name was missing for deletion of user
	
	Revision 1.22  2001/02/15 17:19:25  dg
	#83885# sychronizing problems solved
	
	Revision 1.21  2001/02/13 09:49:13  dg
	#83239# timeout now 300 seconds by default
	
	Revision 1.20  2001/01/29 08:44:28  dg
	#82336# for user nobody cache disabled, updateing only with absolute name
	
	Revision 1.19  2001/01/25 11:23:34  dg
	#82240# using XConnector for establishing a portal connect
	
	Revision 1.18  2000/12/07 15:08:56  dg
	#81528# Using different service for administration and user configuration
	
	Revision 1.17  2000/12/04 19:43:11  dg
	#80460# having different trees for options
	
	Revision 1.16  2000/12/03 17:02:39  dg
	#81164# wrong connections
	
	Revision 1.15  2000/12/03 12:00:45  dg
	#81164# arguments for openNode
	
	Revision 1.14  2000/11/30 08:36:45  dg
	#79032# changes for localisation
	
	Revision 1.13  2000/11/24 15:33:58  dg
	#78348# UserAdministration completed
	
	Revision 1.12  2000/11/23 12:09:27  dg
	#79258# notification interface enriched
	
	Revision 1.11  2000/11/20 12:06:54  dg
	AdminSession ->AdminProvider
	
	Revision 1.10  2000/11/17 08:43:44  dg
	 correct implementations for transactions
	
	Revision 1.9  2000/11/14 09:46:17  dg
	Error while inserting user
	
	Revision 1.8  2000/11/10 22:44:55  dg
	adjust due to adding new admin func
	
	Revision 1.7  2000/11/06 07:45:58  dg
	Reading all user with new node path
	
	Revision 1.6  2000/10/24 11:15:51  dg
	extension of the session api for notifications
	
	Revision 1.5  2000/10/13 06:09:51  dg
	#79284# OValueTagConverter was not aware of attribute cfg:type, so the conversion to defaultvalue failed
	
	Revision 1.4  2000/10/05 13:29:14  fs
	openNode: use OUserNameTranslator only if necessary
	
	Revision 1.3  2000/09/29 13:57:56  dg
	MUST IPortalConnector removed
	
	Revision 1.2  2000/09/27 08:44:46  dg
	#78543# Illegal declaration of realhandler
	
	Revision 1.1.1.1  2000/09/18 16:13:42  hr
	initial import
	
	Revision 1.57  2000/09/15 09:51:52  willem.vandorp
	OpenOffice header added
	
	Revision 1.56  2000/09/13 14:40:48  dg
	conversion from com.sun.star to org.openoffice
	
	Revision 1.55  2000/09/06 09:28:52  lla
	local write always in new format
	
	Revision 1.54  2000/09/05 14:56:45  lla
	changes in old to new mappings
	
	Revision 1.53  2000/09/05 09:24:32  lla
	OFakeValueConverter to convert old XML Files to new one
	Converter to change org.openoffice path names to com.sun.star for old server
	
	Revision 1.52  2000/08/28 13:24:35  fs
	#78218# remember the user name in connectToPortal
	
	Revision 1.51  2000/08/24 08:48:19  fs
	traces
	
	Revision 1.50  2000/08/21 15:31:17  fs
	#77895# implDisconnect: don't access m_pServerConnection if NULL
	
	Revision 1.49  2000/08/20 15:03:21  obr
	#77370# server name should contain port
	
	Revision 1.48  2000/08/20 12:47:00  fs
	#77860# close: reset m_nSessionId before sending the envelope
	
	Revision 1.47  2000/08/18 16:48:57  fs
	#77803# user name en-/decoding
	
	Revision 1.46  2000/08/14 17:53:41  fs
	#77593# enable connecting to a remote portal
	
	Revision 1.45  2000/08/14 12:44:59  jb
	#77568# New service UserAdministration. Allows to invoke 'addUser' transactions
	
	Revision 1.44  2000/08/13 10:29:23  fs
	#77367# fake a session id for a portal session
	
	Revision 1.43  2000/08/11 09:04:28  fs
	#77367# changed signature of implWrite
	
	Revision 1.42  2000/08/11 08:41:05  fs
	#77367# envelope streams are now teplate classes
	
	Revision 1.41  2000/08/09 19:03:38  fs
	wrong trace type in openSession
	
	Revision 1.40  2000/08/09 18:54:14  fs
	implemented some tracing / removed some obsolete stuff
	
	Revision 1.39  2000/08/08 08:57:56  fs
	#77367#
	
	Revision 1.38  2000/08/07 17:39:25  fs
	OFakeDataRootPath : use the node accessor, not the node path !
	
	Revision 1.37  2000/08/07 13:34:16  fs
	no _IMPLICIT_USERPROFILE_USER_NAME_ anymore
	
	Revision 1.36  2000/08/07 11:59:47  lla
	OTreeRootTagKiller checks his invariant
	
	Revision 1.35  2000/08/07 07:43:05  fs
	adjusted connectToPortal
	
	Revision 1.34  2000/08/06 11:13:14  fs
	connectToPortal
	
	Revision 1.33  2000/08/04 15:56:11  willem.vandorp
	Header and footer replaced
	
	Revision 1.32  2000/08/04 09:27:39  fs
	adjustments
	
	Revision 1.31  2000/08/04 07:17:53  fs
	no special server side user profile path anymore
	
	Revision 1.30  2000/08/03 10:35:10  fs
	oops .... admin default tags for admin layer, not user layer access (flipped a bit)
	
	Revision 1.29  2000/08/03 08:43:42  fs
	adjustments for admin update
	
	Revision 1.28  2000/08/02 19:17:30  fs
	_ADMIN_WRITES_DEFAULT_TAGS_
	
	Revision 1.27  2000/08/02 14:14:12  fs
	node id is string now
	
	Revision 1.26  2000/07/31 17:31:03  fs
	use the user name in UserProfile accesses
	
	Revision 1.25  2000/07/28 10:40:47  fs
	adjustments for accessing foreign user data
	
	Revision 1.24  2000/07/27 18:25:39  fs
	adjustments to the latest server version
	
	Revision 1.23  2000/07/27 13:20:26  fs
	new user param for node related methods / adjustments to server 3
	
	Revision 1.22  2000/07/26 12:07:08  fs
	removed one line which was intended for the next server version
	
	Revision 1.21  2000/07/26 12:03:04  fs
	moved AddNodeRedundanceKiller to saxtools.hxx
	
	Revision 1.20  2000/07/21 17:47:16  fs
	use the OValueTagKiller in updates for removing tags the writer provides
	
	Revision 1.19  2000/07/20 12:07:20  fs
	timeout handling
	
	Revision 1.18  2000/07/20 09:00:08  fs
	OListMerger : slightly modified the format of lists
	
	Revision 1.17  2000/07/19 16:23:28  fs
	_REMERGE_VALUE_LISTS_ / OListMerger
	
	Revision 1.16  2000/07/19 13:51:50  fs
	typo
	
	Revision 1.15  2000/07/17 17:37:55  fs
	path translation for com.sun.star.UserProfile
	
	Revision 1.14  2000/07/14 16:00:12  fs
	OValueTagKiller / translateNodePath as member
	
	Revision 1.13  2000/07/14 13:36:15  jb
	Adjusted throw specs on acquire/release to nothrow
	
	Revision 1.12  2000/07/13 18:45:05  fs
	confirmOpenNode
	
	Revision 1.11  2000/07/13 16:48:08  fs
	adjustments for addNode (no node name redundance)
	
	Revision 1.10  2000/07/10 14:22:14  fs
	translateNodePath no class member anymore
	
	Revision 1.9  2000/07/07 16:43:49  fs
	removed some old defines
	
	Revision 1.8  2000/07/05 09:05:49  fs
	new server adjustments
	
	Revision 1.7  2000/07/04 09:24:38  fs
	node path translation
	
	Revision 1.6  2000/07/02 11:15:22  fs
	assertion
	
	Revision 1.5  2000/06/28 07:47:07  fs
	adjustments
	
	Revision 1.4  2000/06/26 07:02:32  fs
	changed the thread handling
	
	Revision 1.3  2000/06/23 11:40:13  fs
	adjustments
	
	Revision 1.2  2000/06/23 08:51:23  fs
	adjustments
	
	Revision 1.1  2000/06/21 06:39:23  fs
	remote config sessions
	

	Revision 1.0 15.06.00 09:12:25  fs
/**************************************************************************/

