/*************************************************************************
 *
 *  $RCSfile: portalstream.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: jl $ $Date: 2001/03/21 12:22:23 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _CONFIGMGR_SESSION_PORTALSTREAM_HXX_
#include "portalstream.hxx"
#endif
#ifndef _OSL_DIAGNOSE_H_
#include <osl/diagnose.h>
#endif
#ifndef _CONFIGMGR_SESSION_RS_TYPES_HXX_
#include "rs_types.hxx"
#endif
#include "tracer.hxx"

#include <string.h>

using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::io;
using namespace ::com::sun::star::connection;
using namespace ::std;

//..........................................................................
namespace configmgr
{
//..........................................................................

#define ENTER()		\
	Guard aGuard(m_aMutex);	\
	checkConnected();

#define CHECK_CONN_ERROR(bytes)	\
	if (-1 == bytes)	\
		throw IOException(::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("a generic error occured while accessing the connection.")), *this);	\
	if (0 == bytes)	\
		throw IOException(::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("lost the connection.")), *this);	\

//==========================================================================
//= OPortalInputStream
//==========================================================================
//--------------------------------------------------------------------------
OPortalInputStream::OPortalInputStream(XConnection2* _pReader)
	:OSessionInputStream(_pReader)
	,m_aEnsureLifetime(_pReader)
{
	OSL_ENSURE(ICONNECTION() != NULL, "OPortalInputStream::OPortalInputStream : invalid socket !");
}

//--------------------------------------------------------------------------
sal_Bool OPortalInputStream::implRead(Sequence< sal_Int8 >& _aData, sal_Int32& _nBytes, sal_Bool _bWantAll)
	throw (NotConnectedException, IOException)
{
	OSL_ENSURE(ICONNECTION() != NULL, "OPortalInputStream::implRead : something went heavily wrong ... have no reader !");

	sal_Int32 nReallyRead = _bWantAll
		? ICONNECTION()->read(_aData, _nBytes)
		: ICONNECTION()->readSomeBytes(_aData, _nBytes);

	CHECK_CONN_ERROR(nReallyRead);

	_nBytes = nReallyRead;
	return sal_True;	// case we already checked nReallyRead against 0
}

//--------------------------------------------------------------------------
void OPortalInputStream::implClose()
{
	ICONNECTION()->close();
		// TODO : normally we would need a shutdown ...
}

//==========================================================================
//= OPortalOutputStream
//==========================================================================
//--------------------------------------------------------------------------
OPortalOutputStream::OPortalOutputStream(XConnection2* _pWriter)
	:OSessionOutputStream(_pWriter)
	,m_aEnsureLifetime(_pWriter)
{
	OSL_ENSURE(OCONNECTION() != NULL, "OPortalOutputStream::OPortalOutputStream : invalid socket !");
}

//--------------------------------------------------------------------------
void SAL_CALL OPortalOutputStream::flush(  ) throw(NotConnectedException, BufferSizeExceededException, IOException, RuntimeException)
{
	ENTER();
	OCONNECTION()->flush();
}

//--------------------------------------------------------------------------
sal_Int32 OPortalOutputStream::implWrite(const Sequence< sal_Int8 >& _rData)
{
	if (_rData.getLength())
		OCONNECTION()->write(_rData);		
	else
	{
		CFG_TRACE_WARNING("portal output stream: somebody attempted to write 0 bytes");	
	}		
	return _rData.getLength();
}

//--------------------------------------------------------------------------
void OPortalOutputStream::implClose()
{
	OCONNECTION()->close();
		// TODO : normally we would need a shutdown ...
}

//..........................................................................
}	// namespace configmgr
//..........................................................................
