/*************************************************************************
 *
 *  $RCSfile: envelopestream.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: dg $ $Date: 2001/02/08 11:26:32 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _CONFIGMGR_SESSION_ENVELOPESTREAM_HXX_
#define _CONFIGMGR_SESSION_ENVELOPESTREAM_HXX_

#include "tracer.hxx"
#ifndef _CONFIGMGR_SESSION_SESSIONSTREAM_HXX_
#include "sessionstream.hxx"
#endif

#ifndef _COM_SUN_STAR_UTIL_XCANCELLABLE_HPP_
#include <com/sun/star/util/XCancellable.hpp>
#endif
#ifndef _CPPUHELPER_IMPLBASE1_HXX_
#include <cppuhelper/implbase1.hxx>
#endif

//..........................................................................
namespace configmgr
{
//..........................................................................

//==========================================================================
//= OEnvelopeInputStream
//==========================================================================
/** a socket input stream which interprets a 0-character got from the socket as eof, but may be restarted
	afterwards
*/
template <class SESSIONINPUT, class CONNTYPE>
class OEnvelopeInputStream : public SESSIONINPUT
{
protected:
	sal_Bool		m_bEof;		/// true if the last implRead encountered the envelope separating sign

protected:
	virtual sal_Bool	doImplRead(::com::sun::star::uno::Sequence< sal_Int8 >& _rData, sal_Int32& _nBytes, sal_Bool _bWantAll)
		throw (::com::sun::star::io::NotConnectedException, ::com::sun::star::io::IOException);

public:
	OEnvelopeInputStream(CONNTYPE* _pReader) : SESSIONINPUT(_pReader), m_bEof(sal_False) { }
};

#define BUFFER_LEN	4096
//==========================================================================
//= OEnvelopeOutputStream
//==========================================================================
typedef ::cppu::ImplHelper1< ::com::sun::star::util::XCancellable > OEnvelopeOutputStream_Base;
/** a specialized <type>SESSIONOUTPUT</type> which differs from it's base class
	in the handling of closeOutput.<BR>
	In addition, it "semi-implements" an <type scope="com.sun.star.util">XCancellable</type>, to
	provide the functionality of the original closeOutput.
*/
template <class SESSIONOUTPUT, class CONNTYPE>
class OEnvelopeOutputStream
		:public SESSIONOUTPUT
		,public OEnvelopeOutputStream_Base
{
protected:
	sal_Int8	m_aBuffer[BUFFER_LEN];
	sal_Int32	m_nLen;
	bool		m_bWroteAnything;
	// need this to determine if we're "closed". This changes at the moment somebody writes anything after we were closed

public:
	OEnvelopeOutputStream(CONNTYPE* _pWriter) : SESSIONOUTPUT(_pWriter),m_nLen(0),m_bWroteAnything(false){ }

    // XInterface
	virtual ::com::sun::star::uno::Any SAL_CALL queryInterface( const ::com::sun::star::uno::Type& aType ) throw(::com::sun::star::uno::RuntimeException);
    virtual void SAL_CALL acquire(  ) throw() { SESSIONOUTPUT::acquire(); }
    virtual void SAL_CALL release(  ) throw() { SESSIONOUTPUT::release(); }

	/** in opposite to the base class behaviour, this closeOutput does not shutdown the socket, but
		it just sends an 0-character to it. After that, any further write operations are executed
		as usual.
	*/
	virtual void SAL_CALL closeOutput(	) throw(::com::sun::star::io::NotConnectedException, ::com::sun::star::io::BufferSizeExceededException, ::com::sun::star::io::IOException, ::com::sun::star::uno::RuntimeException);

	/** the same as if <method>closeOutput</method> on the base class would have been called : shutdown the socket,
		and nevermore access it afterwards.
	*/
    virtual void SAL_CALL cancel(  ) throw(::com::sun::star::uno::RuntimeException);

protected:
	virtual sal_Int32	implWrite(const ::com::sun::star::uno::Sequence< sal_Int8 >& _rData);
};

//..........................................................................
}	// namespace configmgr
//..........................................................................

#include <envelopestream_impl.hxx>

#endif // _CONFIGMGR_SESSION_ENVELOPESTREAM_HXX_


