/*************************************************************************
 *
 *  $RCSfile: saxtools.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: jl $ $Date: 2001/03/21 12:15:40 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <stdio.h>
#ifndef _CONFIGMGR_SAXTOOLS_HXX_
#include "saxtools.hxx"
#endif

//........................................................................
namespace configmgr
{
//........................................................................

using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::xml;

//========================================================================
//= OTreeRootTagKiller
//========================================================================

//--------------------------------------------------------------------------
OTreeRootTagKiller::OTreeRootTagKiller(IDOMNodeDataProvider* _pMasterWriter, const rtl::OUString &_aName)
	:m_pMasterDataProvider(_pMasterWriter)
	,m_nElementDepth(0)
	,m_bDidIt(sal_False)
	,m_aMustBeFirstName(_aName)
{
}

//--------------------------------------------------------------------------
void OTreeRootTagKiller::writeNodeData(const Reference< sax::XDocumentHandler >& _rHandler)
{
	OSL_ENSURE(!m_xMasterHandler.is(), "OFakeDataRootPath::writeNodeData : already set an handler !");

	Reference< sax::XDocumentHandler > xOldHandler(m_xMasterHandler);
	m_xMasterHandler = _rHandler;

	m_pMasterDataProvider->writeNodeData(this);

	m_xMasterHandler = xOldHandler;
}

//--------------------------------------------------------------------------
void SAL_CALL OTreeRootTagKiller::startDocument() throw(sax::SAXException, RuntimeException)
{
	if (m_xMasterHandler.is())
		m_xMasterHandler->startDocument();
}

//--------------------------------------------------------------------------
void SAL_CALL OTreeRootTagKiller::endDocument() throw(sax::SAXException, RuntimeException)
{
	if (m_xMasterHandler.is())
		m_xMasterHandler->endDocument();
}

//--------------------------------------------------------------------------
void SAL_CALL OTreeRootTagKiller::startElement(const ::rtl::OUString& _rName, const Reference< sax::XAttributeList >& _rxAttribs ) throw(sax::SAXException, RuntimeException)
{
	if (m_nElementDepth == 0)
		OSL_ENSURE( !m_aMustBeFirstName.getLength() || _rName.equals(m_aMustBeFirstName) , "OTreeRootTagKiller::startElement(): the FirstName is not the name we expected.");

	if (m_xMasterHandler.is())
	{
		if (!m_nElementDepth)
		{	// it's the first element, we have to fake the name
			OSL_ENSURE(!m_bDidIt, "OTreeRootTagKiller::startElement : there should only be one top level element !");

			// do not forward this element. This is the reason why this class exists ...

			m_bDidIt = sal_True;
		}
		else
			m_xMasterHandler->startElement(_rName, _rxAttribs);
	}
	++m_nElementDepth;
}

//--------------------------------------------------------------------------
void SAL_CALL OTreeRootTagKiller::endElement(const ::rtl::OUString& _rName) throw(sax::SAXException, RuntimeException)
{
	if (m_xMasterHandler.is())
	{
		if (1 == m_nElementDepth)
		{
			// do not forward this element. This is the reason why this class exists ...
		}
		else
			m_xMasterHandler->endElement(_rName);
	}
	--m_nElementDepth;
}

//--------------------------------------------------------------------------
void SAL_CALL OTreeRootTagKiller::characters(const ::rtl::OUString& _rChars) throw(sax::SAXException, RuntimeException)
{
	if (m_xMasterHandler.is())
		m_xMasterHandler->characters(_rChars);
}

//--------------------------------------------------------------------------
void SAL_CALL OTreeRootTagKiller::ignorableWhitespace(const ::rtl::OUString& _rWhitespaces) throw(sax::SAXException, RuntimeException)
{
	if (m_xMasterHandler.is())
		m_xMasterHandler->ignorableWhitespace(_rWhitespaces);
}

//--------------------------------------------------------------------------
void SAL_CALL OTreeRootTagKiller::processingInstruction(const ::rtl::OUString& _rTarget, const ::rtl::OUString& _rData ) throw(sax::SAXException, RuntimeException)
{
	if (m_xMasterHandler.is())
		m_xMasterHandler->processingInstruction(_rTarget, _rData);
}

//--------------------------------------------------------------------------
void SAL_CALL OTreeRootTagKiller::setDocumentLocator(const Reference< sax::XLocator >& _rxLocator ) throw(sax::SAXException, RuntimeException)
{
	if (m_xMasterHandler.is())
		m_xMasterHandler->setDocumentLocator(_rxLocator);
}

//........................................................................
} // namespace configmgr
//........................................................................


