/*************************************************************************
 *
 *  $RCSfile: configshutdown.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: obo $ $Date: 2001/09/28 16:29:15 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <stdio.h>
#include <string.h>

#ifndef _OSL_SOCKET_H_
#include <osl/socket.h>
#endif
#ifndef _VOS_SOCKET_HXX_
#include <vos/socket.hxx>
#endif

#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif
#ifndef _OSL_SECURITY_H_
#include <osl/security.h>
#endif

using namespace vos;

//=============================================================================
void explain()
{
	fprintf(stdout, "configshutdown - shut down (cooperatively) a running registry server\n");
	fprintf(stdout, "\nusage : configshutdown -p <port> -u <user>\n");
	fprintf(stdout, "  <port> - port the registry server is listening at\n");
	fprintf(stdout, "  <user> - the user allowed to shutdown the server\n");
	fflush(stdout);
}

//=============================================================================
sal_Bool ignoreEnvelope(OConnectorSocket& rConnector)
{
	const sal_Int32 nBufSize = 1024;	// we expect only small envelopes
	sal_Char* pBuffer = new sal_Char[1024];

	sal_Bool bEnvelopeEnded = sal_True;
	do
	{
		// wait 'til we have some bytes
		TimeValue aTimeout;
		aTimeout.Seconds = 10;
		if (!rConnector.isRecvReady(&aTimeout))
		{
			delete pBuffer;
			return sal_False;
		}

		// peek how much we have
		sal_Int32 nAvailable = rConnector.recv(pBuffer, nBufSize, ISocketTypes::TMsg_Peek);

		// read them
		sal_Int32 nToRead = nAvailable < nBufSize ? nAvailable : nBufSize;
		sal_Int32 nRead = rConnector.recv(pBuffer, nToRead);

		sal_Char* pSearchLoop = pBuffer;
		for (sal_Int32 i=0; i<nRead; ++i, ++pSearchLoop)
			if (!*pSearchLoop)
			{
				// found the envelope separator
				// break only, quash the remaining bytes, nobody is interested in
				bEnvelopeEnded = sal_True;
				break;
			}
	}
	// next round 'til we have an envelope
	while (!bEnvelopeEnded);

	delete pBuffer;
	return sal_True;
}

//=============================================================================

int SAL_CALL main( int argc, char * argv[] )
{
	sal_Char* pPort = NULL;
	sal_Char* pUser = "Administrator";

	sal_Char** pArgs = argv + 1;
	for (sal_Int32 i=1; i<argc; ++i, ++pArgs)
	{
		sal_Char* pCurArg = *pArgs;
		sal_Int32 nLen = strlen(pCurArg);
		sal_Bool bInvalidArg = sal_True;
		if (nLen && ('-' == *pCurArg))
		{	// it's a switch
			sal_Char* pSwitch = pCurArg + 1;
			switch (nLen)
			{
				case 2:
					switch (*pSwitch)
					{
						case '?':
						case 'h':
							explain();
                                                        return 0;
						case 'p':
							pPort = *++pArgs;
							++i;
							bInvalidArg = sal_False;
							break;
						case 'u':
							pUser = *++pArgs;
							bInvalidArg = sal_False;
							++i;							
							break;
					}
					break;
			}
		}
		else
		{
			if ((1 == nLen) && ('?' == *pCurArg))
			{
				explain();
                                return 0;
			}
		}
		if (bInvalidArg)
		{
			explain();
                        return 0;
		}
	}

	if (!pPort)
	{
		explain();
                return 0;
	}

//	if (!osl_isAdministrator(osl_getCurrentSecurity()))
//	{
//		fprintf(stdout, "you do not have the privileges to shut down the registry server\n");
//		fflush(stdout);
//		return;
//	}

	::rtl::OUString sServer;
	osl_getLocalHostname(&sServer.pData);
	sal_Int32 nPort = ::rtl::OUString::createFromAscii(pPort).toInt32();

	::rtl::OString sServerAsc(sServer.getStr(), sServer.getLength(), RTL_TEXTENCODING_ASCII_US);
	fprintf(stdout, "connecting to %s:%i ...\n", sServerAsc.getStr(), nPort);
	fflush(stdout);

	OInetSocketAddr sServerAddress(sServer, nPort);
	OConnectorSocket aConnector;
	TimeValue aTimeout;
	aTimeout.Seconds = 30;
	aTimeout.Nanosec = 0;
	ISocketTypes::TResult eResult = aConnector.connect(sServerAddress, &aTimeout);

	switch (eResult)
	{
		case ISocketTypes::TResult_Ok:
			break;
		case ISocketTypes::TResult_Error:
			fprintf(stderr, "\tcould not connect ... exiting\n\n");
                        return 0;
		case ISocketTypes::TResult_TimedOut:
			fprintf(stderr, "\ttimed out ... exiting\n\n");
                        return 0;
	}

	fprintf(stdout, "sending the shutdown request\n");

	aTimeout.Seconds = 10;
	aConnector.setRecvTimeout(&aTimeout);

	::rtl::OString sOpenSessionRequest("<envelope><header><transaction type=\"request\" name=\"openSession\" clientId=\"1\" serverId=\"\"/></header><body>");
	sOpenSessionRequest += "<params total=\"2\"><data type=\"string\" name=\"userName\"><value>";
	sOpenSessionRequest += pUser;
	sOpenSessionRequest += "</value></data><data type=\"string\" name=\"password\">";
	sOpenSessionRequest += "<value></value></data></params></body></envelope>";

	sal_Char cEnvelopeSeparator = 0;

	aConnector.write(sOpenSessionRequest.getStr(), sOpenSessionRequest.getLength());
	aConnector.write(&cEnvelopeSeparator, 1);

	// wait for the answer envelope
	if (!ignoreEnvelope(aConnector))
	{
		fprintf(stdout, "\ntimed out ... exiting\n\n");
		fflush(stdout);
                return 0;
	}

	::rtl::OString sShutdowRequest("<envelope><header><transaction type=\"request\" name=\"regShutdown\" clientId=\"2\" serverId=\"\"/></header>");
	sShutdowRequest += "<body><params total=\"1\"><data type=\"string\" name=\"mode\"><value>normal</value></data></params></body></envelope>";

	aConnector.write(sShutdowRequest.getStr(), sShutdowRequest.getLength());
	aConnector.write(&cEnvelopeSeparator, 1);

	if (!ignoreEnvelope(aConnector))
	{
		fprintf(stdout, "\ntimed out ... exiting\n\n");
		fflush(stdout);
                return 0;
	}

	aTimeout.Seconds = 10;
	aConnector.isRecvReady(&aTimeout);
		// will return if
		// - the timeout is over (the server does not respond anymore)
		// - there are bytes to read (should not happen, we expect exactly two envelpopes which we already read)
		// - the connection was closed (which means the shutdown was successfull)
}
