/*************************************************************************
 *
 *  $RCSfile: groupimpl.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: dg $ $Date: 2001/10/11 14:18:27 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef CONFIGMGR_API_GROUPIMPL_HXX_
#define CONFIGMGR_API_GROUPIMPL_HXX_

#ifndef CONFIGMGR_API_ADMINIMPL_HXX_
#include <adminimpl.hxx>
#endif

namespace configmgr
{
	namespace css  = ::com::sun::star;
	namespace uno  = css::uno;
	namespace container  = css::container;
	namespace lang = css::lang;		
	
	extern const ServiceInfo aGroupAccessSI;	
	
	//==========================================================================
	//= OGroupAccess
	//==========================================================================
	typedef ::cppu::ImplHelper2	<	container::XNameContainer,
									lang::XSingleServiceFactory
								>	OGroupAccess_Base;	


	/** class for adding and removing groups and to retrieve group profiles
	*/
	class OGroupAccess : public OAdminAccess
	{			

	public:
		/** constructs the object.
			@param		_pProviderImpl		a pointer to the provider			
		*/
		OGroupAccess(OAdminProviderImpl* _pProviderImpl);					

		// XTypeProvider		
		uno::Sequence< sal_Int8 > SAL_CALL getImplementationId() throw (uno::RuntimeException);		
		
		// XNameAccess		
		virtual uno::Any SAL_CALL	getByName( const ::rtl::OUString& aName ) throw(container::NoSuchElementException, lang::WrappedTargetException, uno::RuntimeException);
		virtual uno::Sequence< ::rtl::OUString > SAL_CALL getElementNames(  ) throw(uno::RuntimeException);		
		
	protected:
		/// @seealso OAdminAccess::insertElement
		virtual void insertElement(const configuration::Name& _rName, 
							       const configuration::Name& _rParent, 
								   IDOMNodeDataProvider* _pNodeWriter, 
								   const ::vos::ORef< IRequestCallback >& _rHandler);	
		
		
		/// @seealso OAdminAccess::deleteElement
		virtual void deleteElement(const configuration::Name& _rName, 
							       const ::vos::ORef< IRequestCallback >& _rHandler);		
	};

} // namespace configmgr

#endif // CONFIGMGR_API_GROUPIMPL_HXX_


