/*************************************************************************
 *
 *  $RCSfile: coutprt.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: mhu $ $Date: 2001/07/24 17:42:39 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#define _COUTPRT_CXX "$Revision: 1.2 $"

#ifndef _SOLAR_H
#include <tools/solar.h>
#endif

#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif

#ifndef _STRING_HXX
#include <tools/string.hxx>
#endif

#ifndef _STREAM_HXX
#include <tools/stream.hxx>
#endif

#ifndef _TOOLS_TIME_HXX
#include <tools/time.hxx>
#endif

#ifndef _SVTOOLS_CINTITEM_HXX
#include <svtools/cintitem.hxx>
#endif

#ifndef _CNTOUTIMP_HXX
#include <coutimp.hxx>
#endif

#ifndef _CNTMSGNODE_HXX
#include <cntmsgnd.hxx>
#endif

#ifndef _CNTRESID_HXX
#include <cntresid.hxx>
#endif

#ifndef _PROCHAOS_HRC
#include <prochaos.hrc>
#endif

#ifndef _CASTMACS_HXX
#include <castmacs.hxx>
#endif

#ifndef _CHAOS_IMPORT_HXX
#include <import.hxx>
#endif

#ifndef _CHAOS_EXPORT_HXX
#include <export.hxx>
#endif

#ifndef _CHAOS_STRMITEM_HXX
#include <strmitem.hxx>
#endif

#ifndef _CHAOS_STORITEM_HXX
#include <storitem.hxx>
#endif

using namespace chaos;

#ifdef _CHAOS_STORITEM_REF
SV_IMPL_REF(CntStoreItemSet);
#endif

/*========================================================================
 *
 *  CntOut... internals.
 *
 *======================================================================*/
/*
 * CntStoreItemSet ranges.
 */
COUTMSG_DIR_RANGES_IMPL (aMsgDirRanges_Impl);

/*========================================================================
 *
 *  CntOutMessageCachingPolicy.
 *
 *======================================================================*/
class CntOutMessageCachingPolicy : public CntMessageCachingPolicy
{
	CntStorageNode *m_pCache;
	String          m_aURL;

public:
	CntOutMessageCachingPolicy (CntStorageNode *pCache)
		: m_pCache (pCache) {}
	virtual ~CntOutMessageCachingPolicy (void);

	void setURL (const String &rURL) { m_aURL = rURL; }

	virtual CntStorageNode* getCacheNode (void);
	virtual BOOL doCache (
		const CntMBXVersion * pVersion,
		SfxItemSet          & rItems,
		String              & rName);
};

/*
 * ~CntOutMessageCachingPolicy.
 */
CntOutMessageCachingPolicy::~CntOutMessageCachingPolicy (void)
{
}

/*
 * getCacheNode.
 */
CntStorageNode* CntOutMessageCachingPolicy::getCacheNode (void)
{
	return m_pCache;
}

/*
 * doCache.
 */
BOOL CntOutMessageCachingPolicy::doCache (
	const CntMBXVersion * pVersion,
	SfxItemSet          & rItems,
	String              & rName)
{
	if (pVersion && !pVersion->getVersion())
	{
		const CntMBXVersion0 * pVersion0 = PTR_CAST(CntMBXVersion0, pVersion);
		if (pVersion0 &&
			(!(pVersion0->getType() == CntMBXVersion0::TYPE_MESSAGE)))
			return FALSE;
	}

	rName  = m_aURL;
	rName.AppendAscii(RTL_CONSTASCII_STRINGPARAM(".body"));
	return TRUE;
}

/*========================================================================
 *
 * CntOutBoxImportJob_Impl implementation.
 *
 *======================================================================*/
/*
 * CntOutBoxImportJob_Impl.
 */
CntOutBoxImportJob_Impl::CntOutBoxImportJob_Impl (
	CntNodeJob *pJob, CntOutTrayNode_Impl *pParent)
	: CntOutJob_Impl (pJob, pParent),
	  m_pStream      (NULL),
	  m_pImport      (NULL),
	  m_pPolicy      (NULL),
	  m_nHintID      (0)
{
}

/*
 * ~CntOutBoxImportJob_Impl.
 */
CntOutBoxImportJob_Impl::~CntOutBoxImportJob_Impl (void)
{
	delete m_pPolicy;
	delete m_pImport;
	INSECURE_DYNAMIC_CAST(const CntInStreamItem *, GetJob()->GetRequest())->
	 releaseStream();
}

/*
 * Execute.
 */
const SfxPoolItem* CntOutBoxImportJob_Impl::Execute (void)
{
	// Ensure clean destruction.
	CntOutJob_ImplRef xThis (this);

	// Check context.
	CntNodeJob *pJob = GetJob();
	if (pJob == NULL)
		return NULL;

	// Initialize.
	if (!pJob->IsRescheduled())
	{
		CntStorageNode *pCache = pJob->GetCacheNode();
		if (!pCache)
		{
			pJob->Cancel();
			return 0;
		}
		m_pPolicy = new CntOutMessageCachingPolicy (pCache);

		m_pStream = INSECURE_DYNAMIC_CAST(const CntInStreamItem *,
										  pJob->GetRequest())->
		             tryToAcquireStream();
		if (!m_pStream)
		{
			pJob->Cancel();
			return 0;
		}
		m_pImport = new CntImport (*m_pStream);

		if (m_pStream->IsA() == ID_FILESTREAM)
			m_sFileName
				= static_cast< SvFileStream * >(m_pStream)->GetFileName();
		m_bMessageFound = false;

		m_nHintID = CntStatusBarHint::CreateHintId();
		String aStatusText;
		if (m_sFileName.Len() > 0)
		{
			aStatusText = CntResId(RID_STATUS_IMPORT_FROM);
			aStatusText.SearchAndReplaceAscii("%1", m_sFileName);
		}
		else
			aStatusText = CntResId(RID_STATUS_IMPORT);
		Broadcast (CntStatusBarHint (
			m_nHintID, 0, m_pImport->getProgressMax(), aStatusText));
	}

	ULONG nTicks = Time::GetSystemTicks();
	for (;;)
	{
		String aURL (GetRootNode()->CreateInterimURL());
		m_pPolicy->setURL (aURL);

		static const USHORT aRanges[] =
		{
			WID_CHAOS_START, WID_INTERIM_URL,
			WID_OWN_URL, WID_CHAOS_END,
			0
		};

		SfxItemSet aItems(*GetRootNode()->GetPool(), aRanges);

		CntMBXVersion * pVersion = 0;
		ULONG nProgress;
		BOOL bFound;

		ErrCode nError = m_pImport->getMessage (
			*m_pPolicy, bFound, pVersion, aItems, nProgress);
		if (nError)
		{
			delete pVersion;

			pJob->SetError(nError);
			pJob->Cancel();
			return 0;
		}
		if (!bFound)
		{
			delete pVersion;
			break;
		}
		m_bMessageFound = true;

		const SfxPoolItem * pPoolItem = NULL;
		if (aItems.GetItemState(WID_RECIPIENTLIST, FALSE, &pPoolItem)
			 >= SFX_ITEM_SET)
		{
			const CntRecipientListItem *pItem =
				STATIC_CAST(const CntRecipientListItem *, pPoolItem);

			// If the item is build from a X-Mozilla-Status header field, the
			// send server etc must be filled in:
			BOOL bFillIn = FALSE;
			for (USHORT i = 0; i < pItem->Count(); ++i)
			{
				const CntRecipientInfo * pInfo = (*pItem)[i];
				if (pInfo->GetProtocolError()
					 == CNT_IMPORT_PARTIAL_RECIPIENT_INFO_ERROR
					&& pInfo->GetProtocolErrorStr().Len() == 0
					&& !pInfo->GetSendTries() && pInfo->GetServer().Len() == 0
					&& pInfo->GetUsername().Len() == 0
					&& pInfo->GetPassword().Len() == 0
					&& pInfo->GetVIMPOPath().Len() == 0)
				{
					bFillIn = TRUE;
					break;
				}
			}
			if (bFillIn)
			{
				CntRecipientListItem aList(WID_RECIPIENTLIST);
				for (USHORT i = 0; i < pItem->Count(); ++i)
				{
					const CntRecipientInfo * pInfo = (*pItem)[i];
					INT16 nErrorCode = pInfo->GetProtocolError();
					String aErrorText(pInfo->GetProtocolErrorStr());
					String aServer(pInfo->GetServer());
					String aUsername(pInfo->GetUsername());
					String aPassword(pInfo->GetPassword());
					if (nErrorCode == CNT_IMPORT_PARTIAL_RECIPIENT_INFO_ERROR
						&& aErrorText.Len() == 0 && !pInfo->GetSendTries()
						&& aServer.Len() == 0 && aUsername.Len() == 0
						&& aPassword.Len() == 0
						&& pInfo->GetVIMPOPath().Len() == 0)
					{
						nErrorCode = 0;
						aErrorText = CntResId(RID_CNTOUT_MAILSTATE_NOT_SENT);
						CntInterface & rBox = *GetRootNode();
						CntOutMsgProtocolType eProtocol
						 = pInfo->GetProtocol();
						aServer = CntOutMessage_Impl::querySendInfo(
							rBox, WID_SEND_SERVERNAME, eProtocol);
						aUsername = CntOutMessage_Impl::querySendInfo(
							rBox, WID_SEND_USERNAME, eProtocol);
						aPassword = CntOutMessage_Impl::querySendInfo(
							rBox, WID_SEND_PASSWORD, eProtocol);
					}
					aList.Append(new
								  CntRecipientInfo(pInfo->GetToRecipient(),
												   pInfo->GetCcRecipient(),
												   pInfo->GetBccRecipient(),
												   pInfo->GetNewsRecipient(),
												   aServer, aErrorText,
												   pInfo->GetProtocol(),
												   pInfo->GetState(),
												   nErrorCode,
												   pInfo->GetSendTries(),
												   aUsername, aPassword,
												   String()));
				}
				aItems.Put(aList);
				pItem = STATIC_CAST(const CntRecipientListItem *,
									&aItems.Get(WID_RECIPIENTLIST));
			}

			aItems.Put (CntStringItem (
				WID_TO, pItem->GetToString()));
			aItems.Put (CntStringItem (
				WID_CC, pItem->GetCcString()));
			aItems.Put (CntStringItem (
				WID_BCC, pItem->GetBccString()));
			aItems.Put (CntStringItem (
				WID_NEWSGROUPS, pItem->GetNewsgroupString()));

			CntOutMsgInternalState eState;
			if (pItem->IsCompletelySent())
				eState = CNTOUT_ISTATE_SENT;
			else if (pItem->IsPartiallySent())
				eState = CNTOUT_ISTATE_PARTSENT;
			else
			{
				eState = CNTOUT_ISTATE_WRITTEN;
				for (USHORT i = 0; i < pItem->Count(); ++i)
				{
					const CntRecipientInfo * pInfo = (*pItem)[i];
					if (eState != CNTOUT_ISTATE_ERROR)
						eState = pInfo->GetState();
					if (eState == CNTOUT_ISTATE_FATALERROR)
						break;
				}
			}
			aItems.Put(CntOutMsgInternalStateItem(WID_OUTMSGINTERNALSTATE,
												  eState));
		}
		else
		{
			CntRecipientListItem aRecipients (WID_RECIPIENTLIST);

			String aTo  (ITEMSET_VALUE_STRING (&aItems, WID_TO));
			String aCC  (ITEMSET_VALUE_STRING (&aItems, WID_CC));
			String aBCC (ITEMSET_VALUE_STRING (&aItems, WID_BCC));
			if (aTo.Len() || aCC.Len() || aBCC.Len())
			{
				CntInterface *pRoot = GetRootNode();
				String aServer (CntOutMessage_Impl::querySendInfo (
					*pRoot, WID_SEND_SERVERNAME, CNT_OUTMSG_PROTOCOL_SMTP));

				aRecipients.Append (new CntRecipientInfo (
					aTo, aCC, aBCC, String(), aServer,
					CntResId (RID_STATUS_IMPORTED_OUT_TRAY_MSG),
					CNT_OUTMSG_PROTOCOL_SMTP,
					CNTOUT_ISTATE_SENT, 0,
					0, String(), String(), String()));
			}

			String aNewsgroups (
				ITEMSET_VALUE_STRING (&aItems, WID_NEWSGROUPS));
			if (aNewsgroups.Len())
			{
				CntInterface *pRoot = GetRootNode();
				String aServer (CntOutMessage_Impl::querySendInfo (
					*pRoot, WID_SEND_SERVERNAME, CNT_OUTMSG_PROTOCOL_NNTP));
				String aUser (CntOutMessage_Impl::querySendInfo (
					*pRoot, WID_SEND_USERNAME, CNT_OUTMSG_PROTOCOL_NNTP));
				String aPassword (CntOutMessage_Impl::querySendInfo (
					*pRoot, WID_SEND_PASSWORD, CNT_OUTMSG_PROTOCOL_NNTP));

				aRecipients.Append (new CntRecipientInfo (
					String(), String(), String(), aNewsgroups, aServer,
					CntResId (RID_STATUS_IMPORTED_OUT_TRAY_MSG),
					CNT_OUTMSG_PROTOCOL_NNTP,
					CNTOUT_ISTATE_SENT, 0,
					0, aUser, aPassword, String()));
			}

			aItems.Put (aRecipients);
			aItems.Put (CntOutMsgInternalStateItem (
				WID_OUTMSGINTERNALSTATE, CNTOUT_ISTATE_SENT));
		}

		BOOL bProcess = TRUE;
		if (pVersion && !pVersion->getVersion())
		{
			const CntMBXVersion0 *pVersion0 =
				PTR_CAST(CntMBXVersion0, pVersion);
			if (pVersion0
				&& pVersion0->getType() != CntMBXVersion0::TYPE_MESSAGE)
				bProcess = FALSE;
		}
		delete pVersion;

		CntNodeRef xNode;
		if (bProcess)
		{
			xNode = GetRootNode()->Query(aURL);
			bProcess = xNode.Is();
		}

		if (bProcess)
		{
			// Process current message.
			String aNodeURL (aURL);
			aNodeURL.AppendAscii(RTL_CONSTASCII_STRINGPARAM(".node"));

			CntStorageNode *pCache = m_pPolicy->getCacheNode();
			CntStoreItemSetRef xDirSet (pCache->openItemSet (
				aMsgDirRanges_Impl, aNodeURL,
				STREAM_READWRITE | STREAM_TRUNC));
			if (xDirSet.Is())
			{
				// Flag the message as sent/unsent:
				if (STATIC_CAST(const CntRecipientListItem *,
								&aItems.Get(WID_RECIPIENTLIST))->
					 IsCompletelySent())
					pCache->attrib(aNodeURL, CNTDIRENTRY_ATTRIB_UNSENT, 0);
				else
					pCache->attrib(aNodeURL, 0, CNTDIRENTRY_ATTRIB_UNSENT);

				// Store message.
				xNode->Put (aItems);
				xNode->Put (CntBoolItem (WID_FLAG_READONLY, FALSE));

				xDirSet->Put (*xNode);
				xDirSet.Clear();

				// Obtain KnownContentCount.
				ULONG nKnown = ITEMSET_VALUE_UINT32(
					GetRootNode(), WID_TOTALCONTENTCOUNT);
				CntStoreItemSetRef xBoxSet (
					GetParent()->GetBoxItemSet (pCache));
				if (xBoxSet.Is())
				{
					nKnown = ITEMSET_VALUE_UINT32(
						GetRootNode(), WID_TOTALCONTENTCOUNT);
				}
				nKnown += 1;

				// Update Box: KnownContentCount.
				CntUInt32Item aKnownCount (WID_TOTALCONTENTCOUNT, nKnown);
				GetRootNode()->Put (aKnownCount);
				if (xBoxSet.Is())
					xBoxSet->Put (aKnownCount);

				// Check message state.
				USHORT eState = ITEMSET_VALUE(
					xNode, CntOutMsgInternalStateItem,
					WID_OUTMSGINTERNALSTATE);
				if (eState == CNTOUT_ISTATE_SENT)
				{
					// Obtain SentContentCount.
					ULONG nSent = ITEMSET_VALUE_UINT32(
						GetRootNode(), WID_SENTCONTENTCOUNT);
					if (xBoxSet.Is())
					{
						nSent = ITEMSET_VALUE_UINT32(
							xBoxSet, WID_SENTCONTENTCOUNT);
					}
					nSent += 1;

					// Update Box: SentContentCount.
					CntUInt32Item aSentCount (WID_SENTCONTENTCOUNT, nSent);
					GetRootNode()->Put (aSentCount);
					if (xBoxSet.Is())
						xBoxSet->Put (aSentCount);
				}
			}

			// Notify caller.
			if (!xNode->IsInserted())
				GetRootNode()->Inserted (xNode, pJob);
		}

		// Check elapsed time.
		if ((Time::GetSystemTicks() - nTicks) > COUTJOB_RESCHEDULE_TIMELIMIT)
		{
			// Notify caller (ProgressSet).
			Broadcast (CntStatusBarHint (m_nHintID, nProgress));

			// Be nice.
			GetRootNode()->RescheduleJob (pJob);
			return NULL;
		}
	}

	if (!m_bMessageFound
		&& pJob->SetError(m_sFileName.Len() == 0 ?
						      ERRCODE_CHAOS_NOTHING_IMPORTED :
						      *new StringErrorInfo(
								       ERRCODE_CHAOS_NOTHING_IMPORTED_FROM,
									   m_sFileName)))
		return 0;

	// Done.
	pJob->Done();
	return NULL;
}

/*
 * Notify.
 */
void CntOutBoxImportJob_Impl::Notify (
	SfxBroadcaster& rBC, const SfxHint& rHint)
{
	CntNodeJob *pJob = PTR_CAST (CntNodeJob, &rBC);
	if ((pJob != NULL) && (pJob == GetJob()))
	{
		if (pJob->IsCancelled() || pJob->IsDone())
		{
			EndListening (*pJob);
			if (m_nHintID)
			{
				Broadcast (CntStatusBarHint(m_nHintID));
				m_nHintID = 0;
			}
		}
	}
	CntOutJob_Impl::Notify (rBC, rHint);
}

/*========================================================================
 *
 * CntOutBoxExportJob_Impl implementation.
 *
 *======================================================================*/
/*
 * CntOutBoxExportJob_Impl.
 */
CntOutBoxExportJob_Impl::CntOutBoxExportJob_Impl (
	CntNodeJob *pJob, CntOutTrayNode_Impl *pParent)
	: CntOutJob_Impl (pJob, pParent),
	  m_pStream      (NULL),
	  m_pExport      (NULL),
	  m_pCache       (NULL),
	  m_pIter        (NULL),
	  m_nIter        (0),
	  m_nHintID      (0)
{
}

/*
 * Execute.
 */
const SfxPoolItem* CntOutBoxExportJob_Impl::Execute (void)
{
	// Ensure clean destruction.
	CntOutJob_ImplRef xThis (this);

	// Check context.
	CntNodeJob *pJob = GetJob();
	if (pJob == NULL)
		return NULL;

	// Check request.
	const CntExpStreamItem *pReq = INSECURE_DYNAMIC_CAST(
		const CntExpStreamItem *, pJob->GetRequest());
	if (pReq == NULL || !pReq->hasStream())
	{
		// Failure.
		pJob->Cancel();
		return NULL;
	}

	// Initialize.
	if (!m_pStream)
	{
		m_pStream = pReq->tryToAcquireStream();
		if (!m_pStream)
		{
			// @@@ Busy waiting -> think it over @@@
			GetRootNode()->RescheduleJob (pJob);
			return NULL;
		}
		m_pExport = new CntExport (*m_pStream);

		m_pCache = pJob->GetCacheNode();
		if (!m_pCache)
		{
			pJob->Cancel();
			return NULL;
		}

		m_nHintID = CntStatusBarHint::CreateHintId();

		ULONG nTotal = ITEMSET_VALUE(
			GetRootNode(), CntUInt32Item, WID_TOTALCONTENTCOUNT);

		String aFileName;
		if (m_pStream->IsA() == ID_FILESTREAM)
			aFileName = INSECURE_DYNAMIC_CAST(SvFileStream *, m_pStream)->
				         GetFileName();
		String aStatusText;
		if (aFileName.Len())
		{
			aStatusText = CntResId(RID_STATUS_EXPORT_TO);
			aStatusText.SearchAndReplaceAscii("%1", aFileName);
		}
		else
			aStatusText = CntResId(RID_STATUS_EXPORT);

		Broadcast (CntStatusBarHint (m_nHintID, 0, nTotal, aStatusText));

		// Initialize iteration.
		UINT32 nExclMask = 0;
		nExclMask |= CNTDIRENTRY_ATTRIB_HIDDEN;
		nExclMask |= CNTDIRENTRY_ATTRIB_MARKEDFORDELETE;

		m_pIter = new CntStorageIterator (0, nExclMask);
		m_nIter = 0;
	}

	// Iterate.
	for (;;)
	{
		if (!m_xMessageNode)
		{
			m_pCache->iter (*m_pIter);
			if (m_pIter->eof())
				break;

			// Process current message.
			String aMsgURL ((**m_pIter).m_pszName);
			aMsgURL.Erase (aMsgURL.Len() - 5);

			m_xMessageNode = GetRootNode()->Query (aMsgURL);
			if (m_xMessageNode.Is())
			{
				m_xOpenJob
				 = new CntNodeJob(pJob, m_xMessageNode, m_xMessageNode,
								  CntOpenModeItem(WID_OPEN,
												  CNT_OPEN_MESSAGES));
				StartListening(*m_xOpenJob);
				m_xMessageNode->InsertJob(m_xOpenJob);
				return 0;
			}
		}

		if (m_xMessageNode.Is())
		{
			ErrCode eErrCode = m_pExport->writeMessage (*m_xMessageNode);
			m_xMessageNode.Clear();
			if (eErrCode != ERRCODE_NONE)
			{
				pJob->SetError (eErrCode);
				pJob->Cancel();
				return NULL;
			}
		}

		// Notify caller (ProgressSet).
		Broadcast (CntStatusBarHint (m_nHintID, ++m_nIter));
	}

	pJob->Done();
	return NULL;
}

/*
 * Notify.
 */
void CntOutBoxExportJob_Impl::Notify (
	SfxBroadcaster &rBC, const SfxHint& rHint)
{
	if (&rBC == &m_xOpenJob)
	{
		CntStatusHint * pStatusHint = PTR_CAST(CntStatusHint, &rHint);
		if (pStatusHint
			&& (pStatusHint->GetStatus() == CNT_STATUS_DONE
				|| pStatusHint->GetStatus() == CNT_STATUS_ERROR
				   && pStatusHint->GetError() == ERRCODE_ABORT))
		{
			EndListening(*m_xOpenJob);
			m_xOpenJob.Clear();
			GetRootNode()->RescheduleJob(GetJob());
		}
	}
	else
	{
		if (&rBC == GetJob())
		{
			CntStatusHint * pStatusHint = PTR_CAST(CntStatusHint, &rHint);
			if (pStatusHint
				&& (pStatusHint->GetStatus() == CNT_STATUS_DONE
					|| pStatusHint->GetStatus() == CNT_STATUS_ERROR
					   && pStatusHint->GetError() == ERRCODE_ABORT))
			{
				if (m_xOpenJob.Is())
					EndListening(*m_xOpenJob);
				delete m_pIter;
				delete m_pExport;
				if (m_pStream)
					INSECURE_DYNAMIC_CAST(const CntExpStreamItem *,
										  GetJob()->GetRequest())->
					 releaseStream();
				if (m_nHintID)
					Broadcast (CntStatusBarHint(m_nHintID));
			}
		}
		CntOutJob_Impl::Notify (rBC, rHint);
	}
}

/*========================================================================
 *
 * CntOutMsgExportJob_Impl implementation.
 *
 *======================================================================*/
/*
 * CntOutMsgExportJob_Impl.
 */
CntOutMsgExportJob_Impl::CntOutMsgExportJob_Impl (
	CntNodeJob *pJob, CntOutTrayNode_Impl *pParent)
	: CntOutJob_Impl (pJob, pParent),
	  m_pStream      (NULL),
	  m_nHintID      (0)
{
}

/*
 * ~CntOutMsgExportJob_Impl.
 */
CntOutMsgExportJob_Impl::~CntOutMsgExportJob_Impl (void)
{
}

/*
 * Execute.
 */
const SfxPoolItem* CntOutMsgExportJob_Impl::Execute (void)
{
	// Ensure clean destruction.
	CntOutJob_ImplRef xThis (this);

	// Check context.
	CntNodeJob *pJob = GetJob();
	if (pJob == NULL)
		return NULL;

	// Check request.
	const CntExpStreamItem *pReq = INSECURE_DYNAMIC_CAST(
		const CntExpStreamItem *, pJob->GetRequest());
	if (pReq == NULL || !pReq->hasStream())
	{
		// Failure.
		pJob->Cancel();
		return NULL;
	}

	// Initialize.
	if (!m_pStream)
	{
		// Check subject.
		CntNode *pSubject = pJob->GetSubject();
		DBG_ASSERT(
			pSubject, "CntOutMsgExportJob_Impl::Execute(): no Subject");
		if (pSubject == NULL)
		{
			// Failure.
			pJob->Cancel();
			return NULL;
		}

		// Obtain export stream.
		m_pStream = pReq->tryToAcquireStream();
		if (!m_pStream)
		{
			// @@@ Busy waiting -> think it over @@@ */
			GetRootNode()->RescheduleJob (pJob);
			return NULL;
		}

		// Obtain export filename.
		String aFileName;
		if (m_pStream->IsA() == ID_FILESTREAM)
			aFileName = INSECURE_DYNAMIC_CAST(SvFileStream *, m_pStream)->
				         GetFileName();
		if (aFileName.Len())
		{
			// Setup StatusText.
			String aStatusText (CntResId (RID_STATUS_EXPORT_TO));
			aStatusText.SearchAndReplaceAscii("%1", aFileName);

			// Notify caller (ShowStatusText).
			m_nHintID = (USHORT)(-1);
			Broadcast (CntStatusBarHint (aStatusText));
		}
		else
		{
			// Setup StatusText.
			String aStatusText (CntResId (RID_STATUS_EXPORT));

			// Notify caller (ShowStatusText).
			m_nHintID = (USHORT)(-1);
			Broadcast (CntStatusBarHint (aStatusText));
		}

		// Ensure nonblocking bulk operation.
		GetRootNode()->RescheduleJob (pJob);
		return NULL;
	}

	// Load message (immediate execution).
	CntNodeJob *pSubJob = new CntNodeJob (
		pJob, pJob->GetClient(), pJob->GetSubject(),
		CntOpenModeItem (WID_OPEN, CNT_OPEN_MESSAGE));

	CntNode *pSubject = pJob->GetSubject();
	pSubject->InsertJob (pSubJob);

	// Export message.
	CntExport aExport (*m_pStream);
	ErrCode eErrCode = aExport.writeMessage (*pSubject);
	if (eErrCode != ERRCODE_NONE)
	{
		// Failure.
		pJob->SetError (eErrCode);
		pJob->Cancel();
		return NULL;
	}
	else
	{
		// Done.
		pJob->Done();
		return NULL;
	}
}

/*
 * Notify.
 */
void CntOutMsgExportJob_Impl::Notify (
	SfxBroadcaster &rBC, const SfxHint& rHint)
{
	CntNodeJob *pJob = PTR_CAST (CntNodeJob, &rBC);
	if ((pJob != NULL) && (pJob == GetJob()))
	{
		if (pJob->IsCancelled() || pJob->IsDone())
		{
			EndListening (*pJob);
			if (m_nHintID)
			{
				// Remove StatusText.
				Broadcast (CntStatusBarHint(String()));
				m_nHintID = 0;
			}
			if (m_pStream)
			{
				const CntExpStreamItem *pItem = INSECURE_DYNAMIC_CAST(
					const CntExpStreamItem *, pJob->GetRequest());
				if (pItem)
					pItem->releaseStream ();
				m_pStream = NULL;
			}
		}
	}
	CntOutJob_Impl::Notify (rBC, rHint);
}

