/*************************************************************************
 *
 *  $RCSfile: coutmsg.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: mhu $ $Date: 2001/07/24 17:59:46 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#define _COUTMSG_CXX "$Revision: 1.4 $"

#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XCONTENTTRANSMITTER_HPP_
#include <com/sun/star/ucb/XContentTransmitter.hpp>
#endif

#ifndef _SOLAR_H
#include <tools/solar.h>
#endif
#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif
#ifndef _STREAM_HXX
#include <tools/stream.hxx>
#endif

#ifndef _DATETIMEITEM_HXX
#include <svtools/dateitem.hxx>
#endif
#ifndef _SVTOOLS_CENUMITM_HXX
#include <svtools/cenumitm.hxx>
#endif
#ifndef _SVTOOLS_CINTITEM_HXX
#include <svtools/cintitem.hxx>
#endif

#ifndef _INETCOREMAIL_HXX
#include <inet/inetmail.hxx>
#endif
#ifndef _INETCOREMSG_HXX
#include <inet/inetmsg.hxx>
#endif

#ifndef _CNTOUTIMP_HXX
#include <coutimp.hxx>
#endif
#ifndef _CNTRNMGR_HXX
#include <cntrnmgr.hxx>
#endif
#ifndef _CNTMBITM_HXX
#include <cntmbitm.hxx>
#endif
#ifndef _CNTVWITM_HXX
#include <cntvwitm.hxx>
#endif
#ifndef _CHAOS_INIMGR_HXX
#include <inimgr.hxx>
#endif
#ifndef _CHAOS_STORITEM_HXX
#include <storitem.hxx>
#endif

#include <string>
#include <algorithm>

using namespace com::sun::star;
using namespace chaos;

#ifdef _USE_NAMESPACE
using namespace inet;
#endif

#ifdef _CHAOS_STORITEM_REF
SV_IMPL_REF(CntStoreItemSet);
#endif

/*========================================================================
 *
 * CntOutMsg... internals.
 *
 *======================================================================*/
/*
 * CntStoreItemSet ranges.
 */
COUTMSG_DIR_RANGES_IMPL (aMsgDirRanges_Impl);

/*========================================================================
 *
 * CntOutMsgSendJob_Impl implementation.
 *
 *======================================================================*/
/*
 * CntOutMsgSendJob_Impl.
 */
CntOutMsgSendJob_Impl::CntOutMsgSendJob_Impl (
	CntNodeJob *pJob, CntOutTrayNode_Impl *pParent)
	: CntOutJob_Impl (pJob, pParent),
	  m_xSubJob      (NULL),
	  m_pCache       (NULL),
	  m_pRcptList    (NULL),
	  m_nIndex       (0),
	  m_eState       (STATE_NONE)
{
}

/*
 * CntOutMsgSendJob_Impl.
 */
CntOutMsgSendJob_Impl::~CntOutMsgSendJob_Impl (void)
{
	delete m_pRcptList;
}

/*
 * queryAvailable.
 */
CntOutMsgSendJob_Impl::Availability
CntOutMsgSendJob_Impl::queryAvailable (
	CntNode               *pSubject,
	CntRecipientListItem *&rpRcptList)
{
	// Initialize.
	Availability result = AVAIL_UNKNOWN;
	rpRcptList = NULL;

	// Obtain RecipientList state.
	SfxItemState eState =
		pSubject->GetItemState (WID_RECIPIENTLIST, FALSE);

	// Setup node URL.
	String aNodeURL (OWN_URL(pSubject));
	aNodeURL.AppendAscii (".node");

	// Check ItemSet availability.
	if (m_pCache->attrib (aNodeURL, 0, 0) == ERRCODE_NONE)
	{
		if (eState == SFX_ITEM_SET)
			result = AVAIL_INSERTED;
		else
			result = AVAIL_KNOWN;
	}

	// Check RecipientList availability.
	if (!(eState == SFX_ITEM_SET))
	{
		// Setup RecipientList.
		CntNodeRef xRoot (GetRootNode());
		CntOutMessage_Impl::setRecipientList (*pSubject, *xRoot);
	}

	// Allocate writeable RecipientList.
	rpRcptList = new CntRecipientListItem (
		(const CntRecipientListItem&)(pSubject->Get(WID_RECIPIENTLIST)));

	// Done.
	return (result);
}

/*
 * queryInsert.
 */
BOOL CntOutMsgSendJob_Impl::queryInsert (CntNode *pSubject)
{
	// Setup node URL.
	String aNodeURL (OWN_URL(pSubject));
	aNodeURL.AppendAscii (".node");

	// Check existence.
	ErrCode eErrCode = m_pCache->attrib (aNodeURL, 0, 0);
	if (!(eErrCode == ERRCODE_NONE))
	{
		// Assume not exists.
		eErrCode = ERRCODE_IO_NOTEXISTS;
	}

	// Create node itemset.
	CntStoreItemSetRef xDirSet (m_pCache->openItemSet (
		aMsgDirRanges_Impl, aNodeURL, STREAM_READWRITE | STREAM_TRUNC));
	if (!xDirSet.Is())
		return FALSE;

	// Initialize creation date.
	pSubject->Put (SfxDateTimeItem (WID_DATE_CREATED, DateTime()));
	pSubject->Put (CntBoolItem (WID_FLAG_READONLY, FALSE));

	// Setup message state.
	CntOutMsgInternalStateItem aState (WID_OUTMSGINTERNALSTATE);
	aState.SetEnumValue (CNTOUT_ISTATE_WRITTEN);
	pSubject->Put (aState);

	// Obtain MessageBody.
	CntMessageBodyItem aOldBody (
		(const CntMessageBodyItem&)(pSubject->Get(WID_MESSAGEBODY)));
	INetCoreNewsMessage *pMsg = aOldBody.Get();
	if (pMsg == NULL)
	{
		// Create message container.
		INetCoreMailer *pMailer = GetParent()->GetMailer();
		if (pMailer)
			pMsg = pMailer->CreateINetCoreNewsMessage();
	}

	// Check message container.
	if (pMsg != NULL)
	{
		// Setup header fields.
		pMsg->SetFrom (
			ITEMSET_VALUE (pSubject, CntNameItem, WID_FROM));
		pMsg->SetReplyTo (
			ITEMSET_VALUE_STRING (pSubject, WID_REPLY_TO));

#if 0   /* NEW */
		pMsg->SetTo (
			ITEMSET_VALUE_STRING (pSubject, WID_TO));
		pMsg->SetCC (
			ITEMSET_VALUE_STRING (pSubject, WID_CC));
		pMsg->SetBCC (
			ITEMSET_VALUE_STRING (pSubject, WID_BCC));
		pMsg->SetNewsgroups (
			ITEMSET_VALUE_STRING (pSubject, WID_NEWSGROUPS));
#endif  /* NEW */

		pMsg->SetSubject (
			ITEMSET_VALUE_STRING (pSubject, WID_TITLE));
		pMsg->SetInReplyTo (
			ITEMSET_VALUE_STRING (pSubject, WID_IN_REPLY_TO));
		pMsg->SetReferences (
			ITEMSET_VALUE_STRING (pSubject, WID_REFERENCES));

		// Change owner and store MessageBody.
		String aBodyURL (OWN_URL(pSubject));
		aBodyURL.AppendAscii (".body");

		CntMessageBodyItem aNewBody (WID_MESSAGEBODY, aBodyURL);
		aOldBody.Set (NULL, NULL);
		aNewBody.Set (pMsg, m_pCache);

		pSubject->Put (aNewBody);

		// Determine message size.
		SvStream *pStrm = m_pCache->openStream (aBodyURL, STREAM_STD_READ);
		if (pStrm)
		{
			ULONG nSize = pStrm->Seek (STREAM_SEEK_TO_END);
			delete pStrm;

			pSubject->Put (CntUInt32Item (WID_SIZE, nSize));
		}
	}

	// Store message itemset.
	xDirSet->Put (*pSubject);
	xDirSet.Clear();

	// Mark as unsent.
	m_pCache->attrib (aNodeURL, 0, CNTDIRENTRY_ATTRIB_UNSENT);

	// Done.
	return (eErrCode == ERRCODE_IO_NOTEXISTS);
}

/*
 * querySend.
 */
CntNodeJob* CntOutMsgSendJob_Impl::querySend (
	const CntRecipientInfoItem &rRecipient)
{
	// Check context.
	CntRecipientInfo *pInfo = rRecipient.GetValue();
	DBG_ASSERT(
		pInfo, "CntOutMsgSendJob_Impl::querySend(): no Recipient");
	if (pInfo == NULL)
		return NULL;

	// Check State.
	USHORT eState = pInfo->GetState();
	if (!((eState == CNTOUT_ISTATE_WRITTEN) ||
		  (eState == CNTOUT_ISTATE_ERROR  )    ))
	{
		// Nothing to do.
		return NULL;
	}

	// Check SendTries.
	USHORT nSendTries = pInfo->GetSendTries();
	if (!(nSendTries < COUTIMP_SENDTRIES_LIMIT))
	{
		// Mark recipient unreachable.
		pInfo->SetState (CNTOUT_ISTATE_FATALERROR);

		// Done.
		return NULL;
	}

	// Check protocol.
	CntNodeJob *pJob = GetJob();
	USHORT eProto = pInfo->GetProtocol();
	if (eProto == CNT_OUTMSG_PROTOCOL_NNTP)
	{
		// Setup SubJob.
		CntNodeJob *pSubJob = new CntNodeJob (
			pJob, pJob->GetClient(), pJob->GetSubject(), rRecipient);
		CntOutJob_Impl *pJobImpl =
			new CntOutNNTPJob_Impl (pSubJob, GetParent());

		// Done.
		return pSubJob;
	}
	else if (eProto == CNT_OUTMSG_PROTOCOL_SMTP)
	{
		// Setup SubJob.
		CntNodeJob *pSubJob = new CntNodeJob (
			pJob, pJob->GetClient(), pJob->GetSubject(), rRecipient);
		CntOutJob_Impl *pJobImpl =
			new CntOutSMTPJob_Impl (pSubJob, GetParent());

		// Done.
		return pSubJob;
	}
	else if (eProto == CNT_OUTMSG_PROTOCOL_COPY)
	{
		// Setup SubJob.
		CntNodeJob *pSubJob = new CntNodeJob (
			pJob, pJob->GetClient(), pJob->GetSubject(), rRecipient);
		CntOutJob_Impl *pJobImpl =
			new CntOutCopyJob_Impl (pSubJob, GetParent());

		// Done.
		return pSubJob;
	}
	else
	{
		// Mark recipient unreachable.
		DBG_ERRORFILE ("CntOutMsgSendJob_Impl::querySend(): no Protocol");
		pInfo->SetState (CNTOUT_ISTATE_FATALERROR);

		// Done.
		return NULL;
	}
}

/*
 * Execute.
 */
const SfxPoolItem* CntOutMsgSendJob_Impl::Execute (void)
{
	// Ensure clean destruction.
	CntOutJob_ImplRef xThis (this);

	// Check context.
	CntNodeJob *pJob = GetJob();
	DBG_ASSERT (pJob, "CntOutMsgSendJob_Impl::Execute(): no Job");
	if (pJob == NULL)
		return NULL;

	// Check request.
	const SfxPoolItem *pReq = pJob->GetRequest();
	DBG_ASSERT (pReq, "CntOutMsgSendJob_Impl::Execute(): no Request");
	if (pReq == NULL)
	{
		// Failure.
		pJob->Cancel();
		return NULL;
	}

	// Initialize.
	if (m_eState == STATE_NONE)
	{
		// Obtain cache node.
		m_pCache = pJob->GetCacheNode();
		DBG_ASSERT(
			m_pCache, "CntOutMsgSendJob_Impl::Execute(): no Cache");
		if (m_pCache == NULL)
		{
			// Failure.
			pJob->Cancel();
			return NULL;
		}

		// Obtain subject.
		CntNode *pSubject = pJob->GetSubject();
		DBG_ASSERT(
			pSubject, "CntOutMsgSendJob_Impl::Execute(): no Subject");
		if (pSubject == NULL)
		{
			// Failure.
			pJob->Cancel();
			return NULL;
		}

		// Check for Sender present.
		const SfxPoolItem *pItem = NULL;
		pSubject->GetItemState (WID_FROM, FALSE, &pItem);
		if (pItem == NULL)
		{
			// No Sender present. Obtain IniManager.
			CntIniManager *pIniMgr = CNT_RNM()->GetIniManager();
			if (pIniMgr)
			{
				// Obtain email address.
				String aSender (pIniMgr->getEntry (CNT_KEY_ADDRESS_EMAIL));
				if (aSender.Len())
				{
					// Use as Sender.
					pSubject->Put (CntNameItem (WID_FROM, aSender));
				}
			}
		}

		// Check sender.
		String aSender (ITEMSET_VALUE (pSubject, CntNameItem, WID_FROM));
		if (aSender.Len() == 0)
		{
			// No Sender. Notify caller.
			pJob->SetError (ERRCODE_CHAOS_CNTOUT_NO_FROM);

			// Failure.
			pJob->Cancel();
			return NULL;
		}

		// Check Availability.
		Availability result = queryAvailable (pSubject, m_pRcptList);
		if (!(result == AVAIL_INSERTED))
			m_eState = STATE_INSERT;
		else
			m_eState = STATE_SEND;

		// Check RecipientList.
		if (m_pRcptList->IsCompletelySent())
		{
			// Nothing to do.
			pJob->Done();
			return NULL;
		}

		// Ensure nonblocking bulk operation.
		GetRootNode()->RescheduleJob (pJob);
		return NULL;
	}

	if (m_eState == STATE_INSERT)
	{
		// Check subject.
		CntNode *pSubject = pJob->GetSubject();
		if (queryInsert (pSubject))
		{
			// Obtain KnownContentCount.
			ULONG nKnown = ITEMSET_VALUE_UINT32(
				GetRootNode(), WID_TOTALCONTENTCOUNT);
			CntStoreItemSetRef xBoxSet (
				GetParent()->GetBoxItemSet (m_pCache));
			if (xBoxSet.Is())
			{
				nKnown = ITEMSET_VALUE_UINT32(
					GetRootNode(), WID_TOTALCONTENTCOUNT);
			}
			nKnown += 1;

			// Update Box: KnownContentCount.
			CntUInt32Item aKnownCount (WID_TOTALCONTENTCOUNT, nKnown);
			GetRootNode()->Put (aKnownCount);
			if (xBoxSet.Is())
				xBoxSet->Put (aKnownCount);

			// Notify caller.
			pJob->Result (pSubject, CNT_ACTION_INSERTED);
		}

		// Next state.
		CntConnMode eConnMode = GetParent()->GetConnMode();
		if (eConnMode == CNT_CONN_MODE_ONLINE)
			m_eState = STATE_SEND;
		else
			m_eState = STATE_DONE;
	}

	if (m_eState == STATE_SEND)
	{
		// Setup node URL.
		CntNode *pSubject = pJob->GetSubject();
		String aMessageURL (OWN_URL (pSubject));
		String aNodeURL (aMessageURL);
		aNodeURL.AppendAscii (".node");

		// Process RecipientList.
		while (m_nIndex < m_pRcptList->Count())
		{
			// Obtain current RecipientInfo.
			CntRecipientInfo *pInfo = (*m_pRcptList)[m_nIndex];

			// Check SubJob.
			if (!m_xSubJob.Is())
			{
				// Setup SubJob.
				m_xSubJob = querySend (
					CntRecipientInfoItem (pReq->Which(), pInfo));
				if (m_xSubJob.Is())
				{
					// Start SubJob.
					StartListening (*m_xSubJob);
					GetRootNode()->RescheduleJob (m_xSubJob);
					return NULL;
				}
			}

			// Cleanup.
			m_xSubJob.Clear();

			// Next recipient.
			m_nIndex++;
		}

		// Update message itemset.
		pSubject->Put (*m_pRcptList);
		CntStoreItemSetRef xDirSet (m_pCache->openItemSet (
			aMsgDirRanges_Impl, aNodeURL,
			STREAM_READWRITE | STREAM_NOCREATE));
		if (xDirSet.Is())
		{
			xDirSet->Put (*pSubject);
			xDirSet.Clear();
		}

		// Check send result.
		GetParent()->updateMessageStatus(*pJob);

		// Next state.
		m_eState = STATE_DONE;
	}

	if (m_eState == STATE_DONE)
	{
		// Finished.
		pJob->Done();
	}

	// Leave.
	return NULL;
}

/*
 * Notify.
 */
void CntOutMsgSendJob_Impl::Notify (
	SfxBroadcaster& rBC, const SfxHint& rHint)
{
	CntNodeJob *pJob = PTR_CAST (CntNodeJob, &rBC);
	if ((pJob != NULL) && (pJob == &m_xSubJob))
	{
		if (pJob->IsCancelled() || pJob->IsDone())
		{
			// SubJob finished.
			EndListening (*m_xSubJob);

			// Restart parent job.
			GetRootNode()->RescheduleJob (GetJob());
		}
		return;
	}
	CntOutJob_Impl::Notify (rBC, rHint);
}

/*========================================================================
 *
 * CntOutMsgResendJob_Impl implementation.
 *
 *======================================================================*/
/*
 * CntOutMsgResendJob_Impl.
 */
CntOutMsgResendJob_Impl::CntOutMsgResendJob_Impl (
	CntNodeJob *pJob, CntOutTrayNode_Impl *pParent)
	: CntOutJob_Impl (pJob, pParent),
	  m_xSubJob      (NULL),
	  m_pCache       (NULL),
	  m_eState       (STATE_NONE)
{
}

/*
 * ~CntOutMsgResendJob_Impl.
 */
CntOutMsgResendJob_Impl::~CntOutMsgResendJob_Impl (void)
{
}

/*
 * Execute.
 */
const SfxPoolItem* CntOutMsgResendJob_Impl::Execute (void)
{
	// Ensure clean destruction.
	CntOutJob_ImplRef xThis (this);

	// Check context.
	CntNodeJob *pJob = GetJob();
	DBG_ASSERT (pJob, "CntOutMsgResendJob_Impl::Execute(): no Job");
	if (pJob == NULL)
		return NULL;

	// Initialize.
	if (m_eState == STATE_NONE)
	{
		// Obtain cache node.
		m_pCache = pJob->GetCacheNode();
		DBG_ASSERT(
			m_pCache, "CntOutMsgResendJob_Impl::Execute(): no Cache");
		if (m_pCache == NULL)
		{
			// Failure.
			pJob->Cancel();
			return NULL;
		}

		// Obtain subject.
		CntNode *pSubject = pJob->GetSubject();
		DBG_ASSERT(
			pSubject, "CntOutMsgResendJob_Impl::Execute(): no Subject");
		if (pSubject == NULL)
		{
			// Failure.
			pJob->Cancel();
			return NULL;
		}

		// Check subject state.
		SfxItemState eState =
			pSubject->GetItemState (WID_RESEND_MSG, FALSE);
		DBG_ASSERT(
			(!(eState & SFX_ITEM_DISABLED)),
			"CntOutMsgResendJob_Impl::Execute(): resend not allowed");
		if (eState & SFX_ITEM_DISABLED)
		{
			// Not allowed.
			pJob->Cancel();
			return NULL;
		}

		// Check for Offline mode.
		CntConnMode eConnMode = GetParent()->GetConnMode();
		if (eConnMode == CNT_CONN_MODE_OFFLINE)
		{
			if (pJob->SetError (ERRCODE_CHAOS_OFFLINE))
			{
				// Job cancelled.
				return NULL;
			}
			eConnMode = GetParent()->GetConnMode();
		}

		// Check for Transacted mode.
		if (eConnMode == CNT_CONN_MODE_OFFLINE_TRANSACTED)
		{
			// Insert into log and finish.
			pJob->Log();
			pJob->Done();
			return NULL;
		}

		// Ensure nonblocking bulk operation.
		m_eState = STATE_RESEND;
		GetRootNode()->RescheduleJob (pJob);
		return NULL;
	}

	if (m_eState == STATE_RESEND)
	{
		// Check SubJob.
		if (!m_xSubJob.Is())
		{
			// Load message (immediate execution).
			CntNode *pSubject = pJob->GetSubject();
			CntNodeRef xNode (pSubject);

			CntNodeJobRef xLoadJob (new CntNodeJob (
				pJob, pSubject, pSubject,
				CntOpenModeItem (WID_OPEN, CNT_OPEN_MESSAGE)));

			pSubject->InsertJob (xLoadJob);
			if (xLoadJob->IsCancelled())
			{
				// Failure.
				pJob->Cancel();
				return NULL;
			}
			xLoadJob.Clear();

			// Obtain RecipientList.
			const CntRecipientListItem &rRcptList =
				(const CntRecipientListItem&)(xNode->Get(WID_RECIPIENTLIST));
			if (rRcptList.IsCompletelySent())
			{
				// Create resend message node.
				String aNodeURL (GetRootNode()->CreateInterimURL());
				xNode = GetRootNode()->Query (aNodeURL);
				if (!xNode.Is())
				{
					// Failure.
					pJob->Cancel();
					return NULL;
				}

				// Copy (but re-initialize OwnUrl).
				xNode->Put (*pSubject);
				xNode->Put (CntStringItem (WID_OWN_URL, aNodeURL));
				xNode->Initialize (GetRootNode(), aNodeURL);

				// Reset RecipientList.
				CntRecipientListItem aRcptList (rRcptList);
				aRcptList.ResetState();
				xNode->Put (aRcptList);
			}

			// Setup SubJob.
			m_xSubJob = new CntNodeJob (
				pJob, pJob->GetClient(), xNode, SfxVoidItem (WID_INSERT));
			CntOutJob_Impl *pJobImpl =
				new CntOutMsgSendJob_Impl (m_xSubJob, GetParent());

			// Start SubJob.
			StartListening (*m_xSubJob);
			GetRootNode()->RescheduleJob (m_xSubJob);
			return NULL;
		}
		else
		{
			// Check SubJob result.
			if (m_xSubJob->IsCancelled())
			{
				// Failure.
				pJob->Cancel();
				return NULL;
			}

			// Cleanup.
			m_xSubJob.Clear();

			// Next state.
			m_eState = STATE_DONE;
		}
	}

	// Done.
	pJob->Done();
	return NULL;
}

/*
 * Notify.
 */
void CntOutMsgResendJob_Impl::Notify (
	SfxBroadcaster& rBC, const SfxHint& rHint)
{
	CntNodeJob *pJob = PTR_CAST (CntNodeJob, &rBC);
	if ((pJob != NULL) && (pJob == &m_xSubJob))
	{
		if (pJob->IsCancelled() || pJob->IsDone())
		{
			// SubJob finished.
			EndListening (*m_xSubJob);

			// Restart parent job.
			GetRootNode()->RescheduleJob (GetJob());
		}
		return;
	}
	CntOutJob_Impl::Notify (rBC, rHint);
}

/*========================================================================
 *
 * CntOutMsgMarkJob implementation.
 *
 *======================================================================*/
/*
 * CntOutMsgMarkJob_Impl.
 */
CntOutMsgMarkJob_Impl::CntOutMsgMarkJob_Impl (
	CntNodeJob *pJob, CntOutTrayNode_Impl *pParent)
	: CntOutJob_Impl (pJob, pParent),
	  m_pCache       (NULL),
	  m_eState       (STATE_NONE)
{
}

/*
 * ~CntOutMsgMarkJob_Impl.
 */
CntOutMsgMarkJob_Impl::~CntOutMsgMarkJob_Impl (void)
{
}

/*
 * Execute.
 */
const SfxPoolItem* CntOutMsgMarkJob_Impl::Execute (void)
{
	// Ensure clean destruction.
	CntOutJob_ImplRef xThis (this);

	// Check context.
	CntNodeJob *pJob = GetJob();
	DBG_ASSERT (pJob, "CntOutMsgMarkJob_Impl::Execute(): no Job");
	if (pJob == NULL)
		return NULL;

	// Check request.
	const CntBoolItem *pReq = (const CntBoolItem *)(pJob->GetRequest());
	DBG_ASSERT (pReq, "CntOutMsgMarkJob_Impl::Execute(): no Request");
	if (pReq == NULL)
	{
		// Failure.
		pJob->Cancel();
		return NULL;
	}

	// Initialize.
	if (m_eState == STATE_NONE)
	{
		// Obtain subject.
		CntNode *pSubject = pJob->GetSubject();
		DBG_ASSERT(
			pSubject, "CntOutMsgMarkJob_Impl::Execute(): no Subject");
		if (pSubject == NULL)
		{
			// Failure.
			pJob->Cancel();
			return NULL;
		}

		// Check for attribute change.
		if (pSubject->Get (pReq->Which()) == *pReq)
		{
			// Nothing to do.
			pJob->Done();
			return NULL;
		}

		// Obtain cache node.
		m_pCache = pJob->GetCacheNode();
		DBG_ASSERT(
			m_pCache, "CntOutMsgDeleteJob_Impl::Execute(): no Cache");
		if (m_pCache == NULL)
		{
			// Failure.
			pJob->Cancel();
			return NULL;
		}

		// Ensure nonblocking bulk operation.
		m_eState = STATE_MARK;
		GetRootNode()->RescheduleJob (pJob);
		return NULL;
	}

	if (m_eState == STATE_MARK)
	{
		// Setup Node URL.
		CntNode *pSubject = pJob->GetSubject();
		String aNodeURL (OWN_URL (pSubject));
		aNodeURL.AppendAscii (".node");

		// Change attribute.
		if (pReq->GetValue())
		{
			// Set Marked attribute.
			m_pCache->attrib (aNodeURL, 0, CNTDIRENTRY_ATTRIB_MARKED);
		}
		else
		{
			// Remove Marked attribute.
			m_pCache->attrib (aNodeURL, CNTDIRENTRY_ATTRIB_MARKED, 0);
		}

		// Finished.
		pSubject->Put (*pReq);
		m_eState = STATE_DONE;
	}

	// Done.
	pJob->Done();
	return NULL;
}

/*
 * Notify.
 */
void CntOutMsgMarkJob_Impl::Notify (
	SfxBroadcaster& rBC, const SfxHint& rHint)
{
	CntOutJob_Impl::Notify (rBC, rHint);
}

/*========================================================================
 *
 * CntOutMsgDeleteJob implementation.
 *
 *======================================================================*/
/*
 * CntOutMsgDeleteJob_Impl.
 */
CntOutMsgDeleteJob_Impl::CntOutMsgDeleteJob_Impl (
	CntNodeJob *pJob, CntOutTrayNode_Impl *pParent)
	: CntOutJob_Impl (pJob, pParent),
	  m_pCache       (NULL),
	  m_eState       (STATE_NONE)
{
}

/*
 * ~CntOutMsgDeleteJob_Impl.
 */
CntOutMsgDeleteJob_Impl::~CntOutMsgDeleteJob_Impl (void)
{
}

/*
 * Execute.
 */
const SfxPoolItem* CntOutMsgDeleteJob_Impl::Execute (void)
{
	// Ensure clean destruction.
	CntOutJob_ImplRef xThis (this);

	// Check context.
	CntNodeJob *pJob = GetJob();
	DBG_ASSERT (pJob, "CntOutMsgDeleteJob_Impl::Execute(): no Job");
	if (pJob == NULL)
		return NULL;

	// Check request.
	const CntBoolItem *pReq = (const CntBoolItem *)(pJob->GetRequest());
	DBG_ASSERT (pReq, "CntOutMsgDeleteJob_Impl::Execute(): no Request");
	if (pReq == NULL)
	{
		// Failure.
		pJob->Cancel();
		return NULL;
	}

	// Initialize.
	if (m_eState == STATE_NONE)
	{
		// Obtain message node.
		CntNode *pSubject = pJob->GetSubject();
		DBG_ASSERT(
			pSubject, "CntOutMsgDeleteJob_Impl::Execute(): no Subject");
		if (pSubject == NULL)
		{
			// Failure.
			pJob->Cancel();
			return NULL;
		}

		// Check marked flag.
		if (ITEMSET_VALUE (pSubject, CntBoolItem, WID_IS_MARKED))
		{
			// Don't delete marked message.
			pJob->Cancel();
			return NULL;
		}

		// Obtain cache node.
		m_pCache = pJob->GetCacheNode();
		DBG_ASSERT(
			m_pCache, "CntOutMsgDeleteJob_Impl::Execute(): no Cache");
		if (m_pCache == NULL)
		{
			// Failure.
			pJob->Cancel();
			return NULL;
		}

		// Ensure nonblocking bulk operation.
		m_eState = STATE_DELETE;
		GetRootNode()->RescheduleJob (pJob);
		return NULL;
	}

	if (m_eState == STATE_DELETE)
	{
		// Setup Node URL.
		CntNode *pSubject = pJob->GetSubject();

		String aNodeURL (OWN_URL (pSubject));
		aNodeURL.AppendAscii (".node");

		// Check for trashed message.
		UINT32 nAttrib = 0;
		m_pCache->attrib (aNodeURL, 0, 0, nAttrib);
		if (!(nAttrib & CNTDIRENTRY_ATTRIB_MARKEDFORDELETE))
		{
			// Obtain KnownContentCount.
			ULONG nKnown = ITEMSET_VALUE_UINT32(
				GetRootNode(), WID_TOTALCONTENTCOUNT);
			CntStoreItemSetRef xBoxSet (
				GetParent()->GetBoxItemSet (m_pCache));
			if (xBoxSet.Is())
				nKnown = ITEMSET_VALUE_UINT32(xBoxSet, WID_TOTALCONTENTCOUNT);
			nKnown = ((nKnown > 0) ? nKnown - 1 : 0);

			// Update Box: KnownContentCount.
			CntUInt32Item aKnownCount (WID_TOTALCONTENTCOUNT, nKnown);
			GetRootNode()->Put (aKnownCount);
			if (xBoxSet.Is())
				xBoxSet->Put (aKnownCount);

			// Obtain SentContentCount.
			ULONG nSent = ITEMSET_VALUE_UINT32(
				GetRootNode(), WID_SENTCONTENTCOUNT);
			if (xBoxSet.Is())
				nSent = ITEMSET_VALUE_UINT32(xBoxSet, WID_SENTCONTENTCOUNT);
			nSent = std::min (nSent, nKnown + 1);

			// Check Sent flag/state.
			USHORT eState = ITEMSET_VALUE(
				pSubject,
				CntOutMsgInternalStateItem,
				WID_OUTMSGINTERNALSTATE);
			if ((eState == CNTOUT_ISTATE_SENT         ) ||
				(eState == CNTOUT_ISTATE_WAITCONFIRMED) ||
				(eState == CNTOUT_ISTATE_CONFIRMED    )    )
			{
				// Completely sent, update SentContentCount.
				nSent = ((nSent > 0) ? nSent - 1 : 0);
			}

			// Update Box: SentContentCount.
			CntUInt32Item aSentCount (WID_SENTCONTENTCOUNT, nSent);
			GetRootNode()->Put (aSentCount);
			if (xBoxSet.Is())
				xBoxSet->Put (aSentCount);
		}

		// Delete message from cache.
		if (pReq->GetValue())
		{
			// Destroyed. Remove message itemset.
			m_pCache->remove (aNodeURL);

			// Remove message body.
			aNodeURL.SearchAndReplace (S2U(".node"), S2U(".body"));
			m_pCache->remove (aNodeURL);
		}
		else
		{
			// Trashed. Mark message for delete.
			m_pCache->attrib (
				aNodeURL, 0, CNTDIRENTRY_ATTRIB_MARKEDFORDELETE);
		}

		// Notify caller.
		pSubject->Broadcast (CntNodeHint (pSubject, CNT_ACTION_DELETED, pJob));

		// Finish.
		m_eState = STATE_DONE;
	}

	// Done.
	pJob->Done();
	return NULL;
}

/*
 * Notify.
 */
void CntOutMsgDeleteJob_Impl::Notify (
	SfxBroadcaster& rBC, const SfxHint& rHint)
{
	CntOutJob_Impl::Notify (rBC, rHint);
}

/*========================================================================
 *
 * CntOutMsgRestoreJob implementation.
 *
 *======================================================================*/
/*
 * CntOutMsgRestoreJob_Impl.
 */
CntOutMsgRestoreJob_Impl::CntOutMsgRestoreJob_Impl (
	CntNodeJob *pJob, CntOutTrayNode_Impl *pParent)
	: CntOutJob_Impl (pJob, pParent),
	  m_pCache       (NULL),
	  m_eState       (STATE_NONE)
{
}

/*
 * ~CntOutMsgRestoreJob_Impl.
 */
CntOutMsgRestoreJob_Impl::~CntOutMsgRestoreJob_Impl (void)
{
}

/*
 * Execute.
 */
const SfxPoolItem* CntOutMsgRestoreJob_Impl::Execute (void)
{
	// Ensure clean destruction.
	CntOutJob_ImplRef xThis (this);

	// Check context.
	CntNodeJob *pJob = GetJob();
	DBG_ASSERT (pJob, "CntOutMsgRestoreJob_Impl::Execute(): no Job");
	if (pJob == NULL)
		return NULL;

	// Initialize.
	if (m_eState == STATE_NONE)
	{
		// Obtain message node.
		CntNode *pSubject = pJob->GetSubject();
		DBG_ASSERT(
			pSubject, "CntOutMsgRestoreJob_Impl::Execute(): no Subject");
		if (pSubject == NULL)
		{
			// Failure.
			pJob->Cancel();
			return NULL;
		}

		// Obtain cache node.
		m_pCache = pJob->GetCacheNode();
		DBG_ASSERT(
			m_pCache, "CntOutMsgRestoreJob_Impl::Execute(): no Cache");
		if (m_pCache == NULL)
		{
			// Failure.
			pJob->Cancel();
			return NULL;
		}

		// Check message itemset.
		String aNodeURL (OWN_URL (pSubject));
		aNodeURL.AppendAscii (".node");

		UINT32 nAttrib = 0;
		m_pCache->attrib (aNodeURL, 0, 0, nAttrib);
		if (!(nAttrib & CNTDIRENTRY_ATTRIB_MARKEDFORDELETE))
		{
			// Nothing to do.
			pJob->Done();
			return NULL;
		}

		// Ensure nonblocking bulk operation.
		m_eState = STATE_RESTORE;
		GetRootNode()->RescheduleJob (pJob);
		return NULL;
	}

	if (m_eState == STATE_RESTORE)
	{
		// Setup node URL.
		CntNode *pSubject = pJob->GetSubject();
		String aNodeURL (OWN_URL (pSubject));
		aNodeURL.AppendAscii (".node");

		// Remove MarkedForDelete attribute.
		m_pCache->attrib (aNodeURL, CNTDIRENTRY_ATTRIB_MARKEDFORDELETE, 0);

		// Check for inserted message.
		if (!pSubject->IsInserted())
		{
			// Restore message itemset.
			CntStoreItemSetRef xDirSet (m_pCache->openItemSet (
				aMsgDirRanges_Impl, aNodeURL, STREAM_STD_READ));
			if (xDirSet.Is())
			{
				pSubject->Put (*xDirSet);
				xDirSet.Clear();
			}

			// Insert.
			GetRootNode()->Inserted (pSubject, pJob);
		}

		// Obtain KnownContentCount.
		ULONG nKnown = ITEMSET_VALUE_UINT32(
			GetRootNode(), WID_TOTALCONTENTCOUNT);
		CntStoreItemSetRef xBoxSet (
			GetParent()->GetBoxItemSet (m_pCache));
		if (xBoxSet.Is())
			nKnown = ITEMSET_VALUE_UINT32(xBoxSet, WID_TOTALCONTENTCOUNT);
		nKnown += 1;

		// Update Box: KnownContentCount.
		CntUInt32Item aKnownCount (WID_TOTALCONTENTCOUNT, nKnown);
		GetRootNode()->Put (aKnownCount);
		if (xBoxSet.Is())
			xBoxSet->Put (aKnownCount);

		// Obtain SentContentCount.
		ULONG nSent = ITEMSET_VALUE_UINT32(
			GetRootNode(), WID_SENTCONTENTCOUNT);
		if (xBoxSet.Is())
			nSent = ITEMSET_VALUE_UINT32(xBoxSet, WID_SENTCONTENTCOUNT);
		nSent = std::min (nSent, nKnown - 1);

		// Check Sent flag/state.
		USHORT eState = ITEMSET_VALUE(
			pSubject, CntOutMsgInternalStateItem, WID_OUTMSGINTERNALSTATE);
		if ((eState == CNTOUT_ISTATE_SENT         ) ||
			(eState == CNTOUT_ISTATE_WAITCONFIRMED) ||
			(eState == CNTOUT_ISTATE_CONFIRMED    )    )
		{
			// Completely sent, update SentContentCount.
			nSent += 1;
		}

		// Update Box: SentContentCount.
		CntUInt32Item aSentCount (WID_SENTCONTENTCOUNT, nSent);
		GetRootNode()->Put (aSentCount);
		if (xBoxSet.Is())
			xBoxSet->Put (aSentCount);

		// Finish.
		m_eState = STATE_DONE;
	}

	// Done.
	pJob->Done();
	return NULL;
}

/*
 * Notify.
 */
void CntOutMsgRestoreJob_Impl::Notify (
	SfxBroadcaster& rBC, const SfxHint& rHint)
{
	CntOutJob_Impl::Notify (rBC, rHint);
}

/*========================================================================
 *
 * CntOutCopyJob_Impl implementation.
 *
 *======================================================================*/
/*
 * CntOutCopyJob_Impl.
 */
CntOutCopyJob_Impl::CntOutCopyJob_Impl (
	CntNodeJob *pJob, CntOutTrayNode_Impl *pParent)
	: CntOutJob_Impl (pJob, pParent)
{
}

/*
 * ~CntOutCopyJob_Impl.
 */
CntOutCopyJob_Impl::~CntOutCopyJob_Impl (void)
{
}

/*
 * Execute.
 */
const SfxPoolItem* CntOutCopyJob_Impl::Execute (void)
{
	// Ensure clean destruction.
	CntOutJob_ImplRef xThis (this);

	// Check context.
	CntNodeJob *pJob = GetJob();
	DBG_ASSERT (pJob, "CntOutCopyJob_Impl::Execute(): no Job");
	if (pJob == NULL)
		return NULL;

	// Check request.
	const SfxPoolItem *pReq = pJob->GetRequest();
	DBG_ASSERT (pReq, "CntOutCopyJob_Impl::Execute(): no Request");
	if (pReq == NULL)
	{
		// Failure.
		pJob->Cancel();
		return NULL;
	}

	// Obtain RecipientInfo.
	CntRecipientInfo * pRcptInfo = ITEM_VALUE (CntRecipientInfoItem, *pReq);
	DBG_ASSERT(
		pRcptInfo, "CntOutCopyJob_Impl::Execute(): no Recipient");
	if (pRcptInfo == NULL)
	{
		// Failure.
		pJob->Cancel();
		return NULL;
	}

	// Check State.
	USHORT eState = pRcptInfo->GetState();
	if (!((eState == CNTOUT_ISTATE_WRITTEN) ||
		  (eState == CNTOUT_ISTATE_ERROR  )    ))
	{
		// Nothing to do.
		pJob->Done();
		return NULL;
	}

	// Check SendTries.
	USHORT nSendTries = pRcptInfo->GetSendTries();
	if (!(nSendTries < COUTIMP_SENDTRIES_LIMIT))
	{
		// Mark undeliverable.
		pRcptInfo->SetState (CNTOUT_ISTATE_FATALERROR);

		// Done.
		pJob->Done();
		return NULL;
	}

	// Obtain subject.
	CntNode *pSubject = pJob->GetSubject();
	DBG_ASSERT(
		pSubject, "CntOutCopyJob_Impl::Execute(): no Subject");
	if (pSubject == NULL)
	{
		// Failure.
		pJob->Cancel();
		return NULL;
	}

	uno::Reference< lang::XMultiServiceFactory > xFactory
		= CntRootNodeMgr::getProcessServiceManager();
	uno::Reference< ucb::XContentTransmitter > xService;
	if (xFactory.is())
		xService = uno::Reference< ucb::XContentTransmitter >(
			xFactory->createInstance(
				rtl::OUString::createFromAscii(
					"com.sun.star.ucb.ContentTransmitter")),
			uno::UNO_QUERY);
	if (xService.is())
		xService->transmit (OWN_URL(pSubject), pRcptInfo->GetToRecipient(), 3);
	else
		pRcptInfo->SetState(CNTOUT_ISTATE_ERROR);
			// when no copy service is available, mark the message as not
			// successfully copied

	// Increment SendTries.
	pRcptInfo->SetSendTries (nSendTries + 1);

	// Done.
	pJob->Done();
	return NULL;
}

/*
 * Notify.
 */
void CntOutCopyJob_Impl::Notify (
	SfxBroadcaster& rBC, const SfxHint& rHint)
{
	CntOutJob_Impl::Notify (rBC, rHint);
}

