/*************************************************************************
 *
 *  $RCSfile: cnftpfld.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: mhu $ $Date: 2001/07/25 12:49:09 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef CHAOS_CNFTPFLD_HXX
#define CHAOS_CNFTPFLD_HXX

#ifndef _STREAM_HXX
#include <tools/stream.hxx>
#endif

#ifndef CHAOS_CNFTPTSK_HXX
#include <cnftptsk.hxx>
#endif

namespace chaos
{

//============================================================================
class CntFTPFolderChildEntry
{
	String m_aName;
	bool m_bDoc;

public:
	CntFTPFolderChildEntry(const String & rTheName, bool bTheDoc):
		m_aName(rTheName), m_bDoc(bTheDoc) {}

	const String & getName() const { return m_aName; }

	void setName(const String & rTheName) { m_aName = rTheName; }

	bool isDoc() const { return m_bDoc; }
};

//============================================================================
DECLARE_LIST(CntFTPFolderChildList, CntFTPFolderChildEntry *)

//============================================================================
class CntFTPFolderImp
{
	CntFTPFolderNode & m_rNode;
	bool m_bNodeInitialized;
	bool m_bStored;
	CntFTPFolderChildList m_aChildren;

	void findChild(const String & rName, bool bDoc, ULONG & rIndex,
				   bool & rFound) const;

public:
	CntFTPFolderImp(CntFTPFolderNode & rTheNode):
		m_rNode(rTheNode), m_bNodeInitialized(false), m_bStored(false) {}

	~CntFTPFolderImp();

	/** Set the m_bNodeInitialized flag to true and return its old value.
	 */
	inline bool setNodeInitialized();

	void storeChildren(CntStorageNode & rFolderDirNode);

	void addChild(const String & rName, bool bDoc);

	void removeChild(const String & rName, bool bDoc);

	void renameChild(const String & rOldName, const String & rNewName,
					 bool bDoc);

	bool hasChild(const String & rName, bool bDoc) const;

	ULONG getChildCount() const { return m_aChildren.Count(); }

	const CntFTPFolderChildEntry & getChild(ULONG nIndex) const
	{ return *m_aChildren.GetObject(nIndex); }
};

inline bool CntFTPFolderImp::setNodeInitialized()
{
	bool bOldValue = m_bNodeInitialized;
	m_bNodeInitialized = true;
	return bOldValue;
}

//============================================================================
class CntFTPOpenFolderTask: public CntFTPTask
{
	enum  { STATE_LIST = FURTHER_STATES, STATE_LIST_DONE, STATE_CWD_BACK,
			STATE_CWD_BACK_DONE, STATE_CWD_LINK, STATE_CWD_LINK_DONE,
			STATE_TYPE_I, STATE_TYPE_I_DONE, STATE_RETR, STATE_RETR_DONE,
			STATE_OLD_LIST_STORAGE, STATE_OLD_LIST_NODE, STATE_ITER_INIT };

	enum ChildProcessMode { CHILD_RESOLVE_LINK, CHILD_LINK_RESOLVED,
							CHILD_DOWNLOADED };

	struct ChildItem
	{
		String m_aName;
		ChildItem * m_pNext;

		ChildItem(const String & rTheName, ChildItem * pTheNext):
			m_aName(rTheName), m_pNext(pTheNext) {}
	};

	USHORT m_nWhich;
	bool m_bResultFolders;
	bool m_bResultDocs;
	CntMsgViewMode m_eResultDocsMode;
	bool m_bCompleteList;
	CntNodeRef m_xFolderDirNode;
	CntNodeRef m_xFolderUserNode;
	CntStorageNode * m_pCacheNode;
	String m_aFolderURL;
	CntStorageIterator * m_pFolderDirIterator;
	List m_aChildNames;
	ChildItem * m_pOldFolders;
	ChildItem * m_pOldDocs;
	ULONG m_nChildIndex;
	bool m_bResetFolderCounts;
	ChildProcessMode m_eChildProcessMode;
	String m_aChildName;
	bool m_bChildDoc;
	bool m_bChildLink;
	String m_aChildID;
	CntNodeRef m_xChildNode;
	String m_aDocCacheName;
	SvOpenLockBytesRef m_xDocLockBytes;
	int m_nCWDBackNextState;

	void removeDocFromCache();

	bool downloadDocIntoCache();

	void resetDocDownload();

	virtual bool initialize();

	virtual void handleCallback(sal_Int32 nReplyCode,
								const sal_Char * pReplyText);

	virtual void handleReschedule();

	virtual void handleCancel();

public:
	inline CntFTPOpenFolderTask(CntNodeJob & rJob, CntFTPImp & rImp);

	virtual ~CntFTPOpenFolderTask();
};

inline CntFTPOpenFolderTask::CntFTPOpenFolderTask(CntNodeJob & rJob,
												  CntFTPImp & rImp):
	CntFTPTask(rJob, rImp, CntFTPImp::LINK_THRU, true,
			   inet::INetFTPConnection::DATA_TYPE_ASCII),
	m_pCacheNode(0),
	m_pFolderDirIterator(0),
	m_pOldFolders(0),
	m_pOldDocs(0)
{}

//============================================================================
class CntFTPMakeFolderTask: public CntFTPTask
{
	enum { STATE_MKD = FURTHER_STATES, STATE_MKD_DONE };

	virtual bool initialize();

	virtual void handleCallback(sal_Int32 nReplyCode,
								const sal_Char * pReplyText);

public:
	CntFTPMakeFolderTask(CntNodeJob & rJob, CntFTPImp & rImp):
		CntFTPTask(rJob, rImp, CntFTPImp::LINK_THRU) {}
};

//============================================================================
class CntFTPRenameFolderTask: public CntFTPTask
{
	enum { STATE_RNFR = FURTHER_STATES, STATE_RNTO, STATE_RNTO_DONE };

	virtual bool initialize();

	virtual void handleCallback(sal_Int32 nReplyCode,
								const sal_Char * pReplyText);

	virtual void handleReschedule();

public:
	CntFTPRenameFolderTask(CntNodeJob & rJob, CntFTPImp & rImp):
		CntFTPTask(rJob, rImp) {}
};

//============================================================================
class CntFTPDeleteFolderTask: public CntFTPTask
{
	enum { STATE_RMD = FURTHER_STATES, STATE_RMD_DONE };

	bool m_bDELE;

	void trash();

	virtual bool initialize();

	virtual void handleCallback(sal_Int32 nReplyCode,
								const sal_Char * pReplyText);

public:
	CntFTPDeleteFolderTask(CntNodeJob & rJob, CntFTPImp & rImp):
		CntFTPTask(rJob, rImp) {}
};

//============================================================================
class CntFTPUndeleteFolderTask: public CntFTPTask
{
	virtual bool initialize();

public:
	CntFTPUndeleteFolderTask(CntNodeJob & rJob, CntFTPImp & rImp):
		CntFTPTask(rJob, rImp) {}
};

//============================================================================
class CntFTPFlagFolderTask: public CntFTPTask
{
	virtual bool initialize();

	virtual void handleCallback(sal_Int32, const sal_Char *);

public:
	CntFTPFlagFolderTask(CntNodeJob & rJob, CntFTPImp & rImp):
		CntFTPTask(rJob, rImp, CntFTPImp::LINK_THRU) {}
};

} // namespace chaos

#endif // CHAOS_CNFTPFLD_HXX

