/*************************************************************************
 *
 *  $RCSfile: cnftpdoc.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: mhu $ $Date: 2001/07/25 12:49:09 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef CHAOS_CNFTPDOC_HXX
#define CHAOS_CNFTPDOC_HXX

#ifndef _COM_SUN_STAR_IO_XACTIVEDATASINK_HPP_
#include <com/sun/star/io/XActiveDataSink.hpp>
#endif
#ifndef _COM_SUN_STAR_IO_XOUTPUTSTREAM_HPP_
#include <com/sun/star/io/XOutputStream.hpp>
#endif
#ifndef _STREAM_HXX
#include <tools/stream.hxx>
#endif

#ifndef CHAOS_CNFTPTSK_HXX
#include <cnftptsk.hxx>
#endif

class SvLockBytesInputStream;

namespace chaos
{

//============================================================================
class CntFTPRetrieveDocTask: public CntFTPTask
{
	enum { STATE_INIT = FURTHER_STATES, STATE_RETR, STATE_RETR_DONE };

	com::sun::star::uno::Reference<
		com::sun::star::io::XActiveDataSink > m_xActiveSink;
	vos::ORef< SvLockBytesInputStream > m_xActiveSinkInput;
	com::sun::star::uno::Reference<
		com::sun::star::io::XOutputStream > m_xPassiveSink;
	CntNodeRef m_xDocNode;
	CntNodeRef m_xParentDir;
	String m_aDocDirID;
	CntNodeRef m_xCache;
	String m_aCacheName;
	SvOpenLockBytesRef m_xLockBytes;
	sal_uInt32 m_nRestartOffset;
	sal_uInt16 m_nHintID;
	bool m_bSetInputStream;

	void clearStreams();

	void updateProxy();

	bool checkCachedContent();

	void removeCachedContent();

	virtual bool initialize();

	virtual void handleCallback(sal_Int32 nReplyCode,
								const sal_Char * sReplyText);

	virtual void handleTransferCallback();

	virtual void handleCancel();

public:
	CntFTPRetrieveDocTask(CntNodeJob & rJob, CntFTPImp & rImp);
};

//============================================================================
class CntFTPStoreDocTask: public CntFTPTask
{
	enum { STATE_STOR = FURTHER_STATES, STATE_STOR_DONE };

	sal_uInt16 m_nHintID;

	virtual bool initialize();

	virtual void handleCallback(sal_Int32 nReplyCode,
								const sal_Char * sReplyText);

	virtual void handleTransferCallback();

	virtual void handleCancel();

public:
	inline CntFTPStoreDocTask(CntNodeJob & rJob, CntFTPImp & rImp);
};

inline CntFTPStoreDocTask::CntFTPStoreDocTask(CntNodeJob & rJob,
											  CntFTPImp & rImp):
	CntFTPTask(rJob, rImp, CntFTPImp::LINK_NO, false,
			   inet::INetFTPConnection::DATA_TYPE_IMAGE),
	m_nHintID(0)
{}

//============================================================================
class CntFTPTransferDocTask: public CntFTPTask
{
	enum { STATE_STOR = FURTHER_STATES, STATE_STOR_DONE };

	CntNodeRef m_xDocNode;

	virtual bool initialize();

	virtual void handleCallback(sal_Int32 nReplyCode,
								const sal_Char * sReplyText);

	virtual void handleTransferCallback();

public:
	inline CntFTPTransferDocTask(CntNodeJob & rJob, CntFTPImp & rImp);
};

inline CntFTPTransferDocTask::CntFTPTransferDocTask(CntNodeJob & rJob,
													CntFTPImp & rImp):
	CntFTPTask(rJob, rImp, CntFTPImp::LINK_THRU, true,
			   inet::INetFTPConnection::DATA_TYPE_IMAGE)
{}

//============================================================================
class CntFTPRenameDocTask: public CntFTPTask
{
	enum { STATE_RNFR = FURTHER_STATES, STATE_RNTO, STATE_RNTO_DONE };

	virtual bool initialize();

	virtual void handleCallback(sal_Int32 nReplyCode,
								const sal_Char * sReplyText);

	virtual void handleReschedule();

public:
	CntFTPRenameDocTask(CntNodeJob & rJob, CntFTPImp & rImp):
		CntFTPTask(rJob, rImp) {}
};

//============================================================================
class CntFTPDeleteDocTask: public CntFTPTask
{
	enum { STATE_DELE = FURTHER_STATES, STATE_DELE_DONE };

	virtual bool initialize();

	virtual void handleCallback(sal_Int32 nReplyCode,
								const sal_Char * sReplyText);

public:
	CntFTPDeleteDocTask(CntNodeJob & rJob, CntFTPImp & rImp):
		CntFTPTask(rJob, rImp) {}
};

//============================================================================
class CntFTPUndeleteDocTask: public CntFTPTask
{
	virtual bool initialize();

public:
	CntFTPUndeleteDocTask(CntNodeJob & rJob, CntFTPImp & rImp):
		CntFTPTask(rJob, rImp) {}
};

} // namespace chaos

#endif // CHAOS_CNFTPDOC_HXX

