/*************************************************************************
 *
 *  $RCSfile: cnftpdoc.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: mhu $ $Date: 2001/07/25 12:49:09 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SVTOOLS_CINTITEM_HXX
#include <svtools/cintitem.hxx>
#endif
#ifndef _DATETIMEITEM_HXX
#include <svtools/dateitem.hxx>
#endif
#ifndef _LCKBITEM_HXX
#include <svtools/lckbitem.hxx>
#endif
#ifndef SVTOOLS_STRMADPT_HXX
#include <svtools/strmadpt.hxx>
#endif
#ifndef _FSYS_HXX
#include <tools/fsys.hxx>
#endif

#ifndef _CNTNFTP_HXX
#include <cntnftp.hxx>
#endif
#ifndef _CNTRNMGR_HXX
#include <cntrnmgr.hxx>
#endif
#ifndef _CNTSTGND_HXX
#include <cntstgnd.hxx>
#endif
#ifndef _CNTTRITM_HXX
#include <cnttritm.hxx>
#endif
#ifndef _CSTRITEM_HXX
#include <cstritem.hxx>
#endif
#ifndef _CHAOS_STORITEM_HXX
#include <storitem.hxx>
#endif
#ifndef _CHAOS_STRMITEM_HXX
#include <strmitem.hxx>
#endif

#ifndef CHAOS_CNFTPDOC_HXX
#include <cnftpdoc.hxx>
#endif
#ifndef CHAOS_CNFTPFLD_HXX
#include <cnftpfld.hxx>
#endif

using namespace chaos;

using namespace com::sun::star;

SV_IMPL_REF(CntStoreItemSet);

//============================================================================
class CntFTPRetrieveCacheLockBytes_Impl: public SvAsyncLockBytes
{
	CntNodeRef m_xStorage;
	String m_aID;

	inline CntFTPRetrieveCacheLockBytes_Impl(SvStream * pStream,
											 CntStorageNode * pTheStorage,
											 String const & rTheID);

public:
	TYPEINFO();

	virtual ~CntFTPRetrieveCacheLockBytes_Impl();

	static CntFTPRetrieveCacheLockBytes_Impl * open(CntStorageNode *
													    pTheStorage,
													String const & rTheID,
													StreamMode eMode);
};

inline CntFTPRetrieveCacheLockBytes_Impl::CntFTPRetrieveCacheLockBytes_Impl(
		   SvStream * pStream, CntStorageNode * pTheStorage,
		   String const & rTheID):
	SvAsyncLockBytes(pStream, true),
	m_xStorage(pTheStorage),
	m_aID(rTheID)
{}

//============================================================================
class CntFTPRetrieveTempLockBytes_Impl: public SvAsyncLockBytes
{
public:
	TYPEINFO();

	CntFTPRetrieveTempLockBytes_Impl();

	virtual ~CntFTPRetrieveTempLockBytes_Impl();
};

//============================================================================
//
//  CntFTPRetrieveDocTask
//
//============================================================================

void CntFTPRetrieveDocTask::clearStreams()
{
	m_xActiveSink = 0;
	m_xActiveSinkInput = 0;
	m_xPassiveSink = 0;
	m_xLockBytes = 0;
}

//============================================================================
void CntFTPRetrieveDocTask::updateProxy()
{
	CntNode * pSubject = getJob().GetSubject();
	if (pSubject != &m_xDocNode)
	{
		pSubject->Put(m_xDocNode->Get(WID_DOCUMENT_BODY));
		pSubject->Put(m_xDocNode->Get(WID_DOCUMENT_SIZE));
		pSubject->Put(m_xDocNode->Get(WID_DATE_CREATED));
	}
}

//============================================================================
bool CntFTPRetrieveDocTask::checkCachedContent()
{
	m_xParentDir = CntFTPImp::GetDirectory(m_xDocNode->GetParent());
	if (!m_xParentDir.Is())
		return false;
	m_aDocDirID.
		AssignAscii(RTL_CONSTASCII_STRINGPARAM(CNT_FTP_DOC_ENTRY_PREFIX));
	m_aDocDirID += CntFTPImp::GetName(m_xDocNode);

	CntStoreItemSetRef
		xDocDirSet(static_cast< CntStorageNode * >(&m_xParentDir)->
				       openItemSet(m_aDocDirID,
								   STREAM_STD_READWRITE | STREAM_NOCREATE));
	if (!xDocDirSet.Is())
		return false;

	m_aCacheName = ITEMSET_VALUE(&xDocDirSet, CntStringItem,
								 WID_FTP_CACHENAME);
	if (m_aCacheName.Len() == 0)
		return false;

	String aContentCacheID(RTL_CONSTASCII_USTRINGPARAM(
		                       CNT_FTP_DOC_CONTENTS_CACHE_ENTRY_PREFIX));
	aContentCacheID += m_aCacheName;

	if (getJob().GetRequest()->Which() == WID_SYNCHRONIZE)
	{
		removeCachedContent();
		return false;
	}

	UINT32 nContentCacheAttribs = 0;
	static_cast< CntStorageNode * >(&m_xCache)->attrib(aContentCacheID, 0, 0,
													   nContentCacheAttribs);
	if (nContentCacheAttribs & CNTDIRENTRY_ATTRIB_FTP_PARTIAL)
		return false;

	m_xLockBytes = CntFTPRetrieveCacheLockBytes_Impl::open(
		               static_cast< CntStorageNode * >(&m_xCache),
					   aContentCacheID, STREAM_STD_READ);
	if (!m_xLockBytes.Is())
	{
		removeCachedContent();
		return false;
	}
	m_xLockBytes->Terminate();

	m_nHintID = CntStatusBarHint::CreateHintId();
	SvLockBytesStat aStat;
	if (m_xLockBytes->Stat(&aStat, SVSTATFLAG_DEFAULT) != ERRCODE_NONE)
		aStat.nSize = 0;
	getJob().Broadcast(CntStatusBarHint(m_nHintID, 0, aStat.nSize, String()));

	if (m_xActiveSink.is())
	{
		m_xActiveSinkInput = new SvLockBytesInputStream(m_xLockBytes);
		m_xActiveSink->setInputStream(m_xActiveSinkInput.getBodyPtr());
	}
	else if (m_xPassiveSink.is())
	{
		for (sal_uInt32 i = 0;;)
		{
			uno::Sequence< sal_Int8 > aBuffer(16384);
			sal_uInt32 nRead;
			ErrCode nError
				= m_xLockBytes->ReadAt(i, aBuffer.getArray(), 16384, &nRead);
			if (nError != ERRCODE_NONE && nError != ERRCODE_IO_PENDING)
			{
				if (error(nError))
					cancel();
				return true;
			}
			if (nError == ERRCODE_NONE && nRead == 0)
				break;
			i += nRead;
			aBuffer.realloc(sal_Int32(nRead));
			m_xPassiveSink->writeBytes(aBuffer);
			getJob().Broadcast(CntStatusBarHint(m_nHintID, i));
		}
		m_xPassiveSink->closeOutput();
	}
	else
		m_xDocNode->Put(SfxLockBytesItem(WID_DOCUMENT_BODY, m_xLockBytes));

	getJob().Broadcast(CntStatusBarHint(m_nHintID));
	m_nHintID = 0;

	if (getImp().KeepDocPersistent(m_xDocNode))
		static_cast< CntStorageNode * >(&m_xCache)->
			attrib(aContentCacheID, 0, CNTDIRENTRY_ATTRIB_FTP_PERSISTENT);

	updateProxy();
	return true;
}

//============================================================================
void CntFTPRetrieveDocTask::removeCachedContent()
{
	if (m_xParentDir.Is())
	{
		CntStoreItemSetRef
			xDocDirSet(static_cast< CntStorageNode * >(&m_xParentDir)->
					       openItemSet(m_aDocDirID,
									   STREAM_STD_READWRITE
									       | STREAM_NOCREATE));
		if (xDocDirSet.Is())
		{
			xDocDirSet->ClearItem(WID_FTP_CACHENAME);
			xDocDirSet->ClearItem(WID_FTP_RETR_DATE_CREATED);
			xDocDirSet->ClearItem(WID_FTP_RETR_DOCUMENT_SIZE);
		}
	}

	if (m_xCache.Is())
	{
		String aContentCacheID(RTL_CONSTASCII_USTRINGPARAM(
			                       CNT_FTP_DOC_CONTENTS_CACHE_ENTRY_PREFIX));
		aContentCacheID += m_aCacheName;
		static_cast< CntStorageNode * >(&m_xCache)->
			attrib(aContentCacheID, CNTDIRENTRY_ATTRIB_FTP_PERSISTENT, 0);
		static_cast< CntStorageNode * >(&m_xCache)->remove(aContentCacheID);
	}

	m_aCacheName.Erase();
}

//============================================================================
// virtual
bool CntFTPRetrieveDocTask::initialize()
{
	if (CntOpenModeItem const * pItem
		    = PTR_CAST(CntOpenModeItem, getJob().GetRequest()))
	{
		uno::Reference< uno::XInterface > xSink(pItem->getDataSink());
		m_xActiveSink
			= uno::Reference< io::XActiveDataSink >(xSink, uno::UNO_QUERY);
		if (!m_xActiveSink.is())
			m_xPassiveSink
				= uno::Reference< io::XOutputStream >(xSink, uno::UNO_QUERY);

		DBG_ASSERT(m_xActiveSink.is() || m_xPassiveSink.is(),
				   "CntFTPRetrieveDocTask::initialize(): Bad sink");
	}

	m_xCache = getJob().GetCacheNode(false);

	String aURL;
	if (getImp().ParseNodeURL(OWN_URL(getJob().GetSubject()), aURL))
	{
		m_xDocNode = getImp().GetFTPBoxNode().Query(aURL);
		if (m_xDocNode.Is() && checkCachedContent())
		{
			clearStreams();
			done();
			return false;
		}
	}

	bConnModeDetermined = true;
	for (;;)
	{
		eConnMode = getImp().GetConnMode();
		if (eConnMode == CNT_CONN_MODE_ONLINE)
			break;
		if (!error(ERRCODE_CHAOS_OFFLINE))
			return false;
	}
	return true;
}

//============================================================================
// virtual
void CntFTPRetrieveDocTask::handleCallback(sal_Int32 nReplyCode,
										   sal_Char const * sReplyText)
{
	for (;;)
		switch (m_nState)
		{
			case STATE_INIT:
			{
				m_bSetInputStream = false;

				m_xDocNode = getImp().GetFTPBoxNode().Query(aNodeURL);
				if (!m_xDocNode.Is())
				{
					if (error(ERRCODE_CHAOS_FTP_GENERAL_FAILURE))
						cancel();
					return;
				}

				if (checkCachedContent())
				{
					clearStreams();
					done();
					return;
				}

				bool bPartial = false;
				if (m_aCacheName.Len() > 0 && m_xActiveSink.is())
				{
					CntStoreItemSetRef
						xDocDirSet(static_cast< CntStorageNode * >(
							               &m_xParentDir)->
								       openItemSet(m_aDocDirID,
												   STREAM_STD_READWRITE
												       | STREAM_NOCREATE));
					if (!xDocDirSet.Is())
					{
						if (error(ERRCODE_CHAOS_FTP_GENERAL_FAILURE))
							cancel();
						return;
					}

					SfxPoolItem const * pItem1;
					SfxPoolItem const * pItem2;
					if (xDocDirSet->GetItemState(WID_FTP_RETR_DOCUMENT_SIZE,
												 false, &pItem1)
						    == SFX_ITEM_SET
						&& m_xDocNode->GetItemState(WID_DOCUMENT_SIZE, false,
													&pItem2)
						       == SFX_ITEM_SET
						&& ITEM_VALUE(CntUInt32Item, *pItem1)
						       == ITEM_VALUE(CntUInt32Item, *pItem2)
						&& xDocDirSet->GetItemState(WID_FTP_RETR_DATE_CREATED,
													false, &pItem1)
						       == SFX_ITEM_SET
						&& m_xDocNode->GetItemState(WID_DATE_CREATED, false,
													&pItem2)
						       == SFX_ITEM_SET
						&& static_cast< SfxDateTimeItem const * >(pItem1)->
						           GetDateTime()
						       == static_cast< SfxDateTimeItem const * >(
								          pItem2)->
						              GetDateTime())
					{
						String
							aContentCacheID(
								RTL_CONSTASCII_USTRINGPARAM(
									CNT_FTP_DOC_CONTENTS_CACHE_ENTRY_PREFIX));
						aContentCacheID += m_aCacheName;
						m_xLockBytes
							= CntFTPRetrieveCacheLockBytes_Impl::open(
								  static_cast< CntStorageNode * >(&m_xCache),
								  aContentCacheID, STREAM_STD_READWRITE);
						if (m_xLockBytes.Is())
						{
							m_nRestartOffset
								= m_xLockBytes->Seek(STREAM_SEEK_TO_END);
							m_xActiveSinkInput
								= new SvLockBytesInputStream(m_xLockBytes);
							m_bSetInputStream = true;
							bPartial = true;
						}
					}
				}

				if (!bPartial)
				{
					if (m_aCacheName.Len() > 0)
						removeCachedContent();

					m_nRestartOffset = 0;

					if (m_xActiveSink.is() && m_xCache.Is()
						|| getImp().KeepDocPersistent(&m_xDocNode))
					{
						if (!m_xCache.Is())
						{
							getImp().forceDirectoryStorage();
							m_xCache = getJob().GetCacheNode(true);
							if (!m_xCache.Is())
							{
								if (error(ERRCODE_CHAOS_FTP_GENERAL_FAILURE))
									cancel();
								return;
							}

							m_xParentDir
								= CntFTPImp::GetDirectory(m_xDocNode->
														  GetParent());
							if (m_xParentDir.Is())
								static_cast< CntFTPFolderNode * >(
									    m_xDocNode->GetParent())->
									getImp().
									    storeChildren(
											*static_cast< CntStorageNode * >(
												 &m_xParentDir));
						}

						if (!m_xParentDir.Is())
						{
							m_xParentDir
								= CntFTPImp::GetDirectory(m_xDocNode->
														  GetParent());
							if (!m_xParentDir.Is())
							{
								if (error(ERRCODE_CHAOS_FTP_GENERAL_FAILURE))
									cancel();
								return;
							}
							m_aDocDirID.
								AssignAscii(RTL_CONSTASCII_STRINGPARAM(
									            CNT_FTP_DOC_ENTRY_PREFIX));
							m_aDocDirID += CntFTPImp::GetName(&m_xDocNode);
						}

						m_aCacheName
							= getImp().FindUnusedCacheName(
									       &getJob(),
										   static_cast< CntStorageNode * >(
											   &m_xCache));
						String
							aContentCacheID(
								RTL_CONSTASCII_USTRINGPARAM(
									CNT_FTP_DOC_CONTENTS_CACHE_ENTRY_PREFIX));
						aContentCacheID += m_aCacheName;
						static_cast< CntStorageNode * >(&m_xCache)->
							attrib(aContentCacheID, 0,
								   CNTDIRENTRY_ATTRIB_HIDDEN);
						m_xLockBytes
							= CntFTPRetrieveCacheLockBytes_Impl::open(
								  static_cast< CntStorageNode * >(&m_xCache),
								  aContentCacheID, STREAM_STD_READWRITE);
						if (!m_xLockBytes.Is())
						{
							if (error(ERRCODE_CHAOS_FTP_GENERAL_FAILURE))
								cancel();
							return;
						}

						if (m_xActiveSink.is())
						{
							m_xActiveSinkInput
								= new SvLockBytesInputStream(m_xLockBytes);
							m_bSetInputStream = true;
						}
						else if (!m_xPassiveSink.is())
							m_xDocNode->
								Put(SfxLockBytesItem(WID_DOCUMENT_BODY,
													 m_xLockBytes));
					}
					else if (m_xPassiveSink.is())
						m_xLockBytes
							= new SvOutputStreamOpenLockBytes(m_xPassiveSink);
					else
					{
						m_xLockBytes = new CntFTPRetrieveTempLockBytes_Impl;
						if (m_xActiveSink.is())
						{
							m_xActiveSinkInput
								= new SvLockBytesInputStream(m_xLockBytes);
							m_bSetInputStream = true;
						}
						else
							m_xDocNode->
								Put(SfxLockBytesItem(WID_DOCUMENT_BODY,
													 m_xLockBytes));
					}
				}

				m_nState = STATE_RETR;
				break;
			}

			case STATE_RETR:
			{
				m_nHintID = CntStatusBarHint::CreateHintId();
				SfxPoolItem const * pItem;
				sal_uInt32 nSize
					= m_xDocNode->GetItemState(WID_DOCUMENT_SIZE, false,
											   &pItem)
					          == SFX_ITEM_SET ?
					      static_cast< CntUInt32Item const * >(pItem)->
					          GetValue() :
					      0;
				getJob().Broadcast(CntStatusBarHint(m_nHintID, 0, nSize,
													String()));

				m_nState = STATE_RETR_DONE;
				if (!connectionRetrieve(aName, m_xLockBytes,
										m_nRestartOffset))
				{
					m_xDocNode->ClearItem(WID_DOCUMENT_BODY);
					if (error(ERRCODE_CHAOS_FTP_GENERAL_FAILURE))
						cancel();
				}
				return;
			}

			case STATE_RETR_DONE:
				if (nReplyCode / 100 == 2)
				{
					CntUInt32Item aSize(WID_DOCUMENT_SIZE,
										m_xLockBytes->Tell());
					m_xDocNode->Put(aSize);
					m_xLockBytes->Flush();
					m_xLockBytes->Terminate();

					if (m_aCacheName.Len() != 0)
					{
						CntStoreItemSetRef
							xDocDirSet(
								static_cast< CntStorageNode * >(
									    &m_xParentDir)->
								    openItemSet(
									  CntFTPImp::GetDocDirectoryEntryRanges(),
										m_aDocDirID, STREAM_STD_WRITE));
						if (xDocDirSet.Is())
						{
							xDocDirSet->Put(CntStringItem(WID_FTP_CACHENAME,
														  m_aCacheName));
							xDocDirSet->Put(aSize);
							xDocDirSet->ClearItem(WID_FTP_RETR_DATE_CREATED);
							xDocDirSet->ClearItem(WID_FTP_RETR_DOCUMENT_SIZE);
						}

						String
							aContentCacheID(
								RTL_CONSTASCII_USTRINGPARAM(
									CNT_FTP_DOC_CONTENTS_CACHE_ENTRY_PREFIX));
						aContentCacheID += m_aCacheName;
						static_cast< CntStorageNode * >(&m_xCache)->
							attrib(aContentCacheID,
								   CNTDIRENTRY_ATTRIB_FTP_PARTIAL,
								   getImp().KeepDocPersistent(&m_xDocNode) ?
								       CNTDIRENTRY_ATTRIB_FTP_PERSISTENT : 0);
					}

					updateProxy();

					getJob().Broadcast(CntStatusBarHint(m_nHintID));
					m_nHintID = 0;

					if (m_bSetInputStream)
						m_xActiveSink->setInputStream(m_xActiveSinkInput.
													      getBodyPtr());

					clearStreams();
					done();
				}
				else if (nReplyCode / 100 != 1)
				{
					if (m_nHintID != 0)
					{
						getJob().Broadcast(CntStatusBarHint(m_nHintID));
						m_nHintID = 0;
					}
					m_xDocNode->ClearItem(WID_DOCUMENT_BODY);
					if (error(nReplyCode, sReplyText))
						cancel();
				}
				return;
		}
}

//============================================================================
// virtual
void CntFTPRetrieveDocTask::handleTransferCallback()
{
	getJob().Broadcast(CntStatusBarHint(m_nHintID,
										getImp().getConnection()->
										    getRetrieveCount()));
}

//============================================================================
// virtual
void CntFTPRetrieveDocTask::handleCancel()
{
	if (m_xLockBytes.Is() && m_aCacheName.Len() > 0 && m_xCache.Is())
	{
		CntStoreItemSetRef xDocDirSet;
		if (m_xParentDir.Is())
			xDocDirSet
				= static_cast< CntStorageNode * >(&m_xParentDir)->
				      openItemSet(CntFTPImp::GetDocDirectoryEntryRanges(),
								  m_aDocDirID,
								  STREAM_STD_READWRITE | STREAM_NOCREATE);

		const SfxPoolItem * pDate;
		const SfxPoolItem * pSize;
		if (xDocDirSet.Is()
			&& m_xDocNode->GetItemState(WID_DATE_CREATED, false, &pDate)
			       == SFX_ITEM_SET
			&& m_xDocNode->GetItemState(WID_DOCUMENT_SIZE, false, &pSize)
			       == SFX_ITEM_SET)
		{
			xDocDirSet->Put(CntStringItem(WID_FTP_CACHENAME, m_aCacheName));
			xDocDirSet->
				Put(SfxDateTimeItem(WID_FTP_RETR_DATE_CREATED,
									static_cast< const SfxDateTimeItem * >(
										pDate)->GetDateTime()));
			xDocDirSet->Put(CntUInt32Item(WID_FTP_RETR_DOCUMENT_SIZE,
										  ITEM_VALUE(CntUInt32Item, *pSize)));

			String aContentCacheID(
				       RTL_CONSTASCII_USTRINGPARAM(
						   CNT_FTP_DOC_CONTENTS_CACHE_ENTRY_PREFIX));
			aContentCacheID += m_aCacheName;
			static_cast< CntStorageNode * >(&m_xCache)->
				attrib(aContentCacheID, 0,
					   getImp().KeepDocPersistent(&m_xDocNode) ?
					       CNTDIRENTRY_ATTRIB_FTP_PERSISTENT
					           | CNTDIRENTRY_ATTRIB_FTP_PARTIAL :
					       CNTDIRENTRY_ATTRIB_FTP_PARTIAL);
		}
		else
			removeCachedContent();
	}

	clearStreams();

	if (m_nHintID != 0)
	{
		getJob().Broadcast(CntStatusBarHint(m_nHintID));
		m_nHintID = 0;
	}
}

//============================================================================
CntFTPRetrieveDocTask::CntFTPRetrieveDocTask(CntNodeJob & rJob,
											 CntFTPImp & rImp):
	CntFTPTask(rJob, rImp, CntFTPImp::LINK_NO, false,
			   inet::INetFTPConnection::DATA_TYPE_IMAGE),
	m_nHintID(0)
{}

//============================================================================
//
//  CntFTPStoreDocTask
//
//============================================================================

// virtual
bool CntFTPStoreDocTask::initialize()
{
	bConnModeDetermined = true;
	for (;;)
	{
		eConnMode = getImp().GetConnMode();
		if (eConnMode == CNT_CONN_MODE_ONLINE)
			break;
		if (!error(ERRCODE_CHAOS_OFFLINE))
			return false;
	}
	return true;
}

//============================================================================
// virtual
void CntFTPStoreDocTask::handleCallback(sal_Int32 nReplyCode,
										sal_Char const * sReplyText)
{
	for (;;)
		switch (m_nState)
		{
			case STATE_STOR:
			{
				SvLockBytesRef xLockBytes;
				if (CntInStreamItem * pItem
					    = PTR_CAST(CntInStreamItem, getJob().GetRequest()))
				{
					SvStream * pStream = pItem->tryToAcquireStream();
					if (pStream)
						xLockBytes = new SvLockBytes(pStream);
				}
				else
				{
					xLockBytes = ITEMSET_VALUE(getJob().GetSubject(),
											   SfxLockBytesItem,
											   WID_DOCUMENT_BODY);
					getJob().GetSubject()->ClearItem(WID_DOCUMENT_BODY);
				}
				if (!xLockBytes.Is())
				{
					if (error(ERRCODE_CHAOS_FTP_GENERAL_FAILURE))
						errorRestart();
					return;
				}

				SvLockBytesStat aStat;
				if (xLockBytes->Stat(&aStat, SVSTATFLAG_DEFAULT)
					    != ERRCODE_NONE)
					aStat.nSize = 0;
				m_nHintID = CntStatusBarHint::CreateHintId();
				getJob().Broadcast(CntStatusBarHint(m_nHintID, 0, aStat.nSize,
													String()));

				m_nState = STATE_STOR_DONE;
				if (!connectionStore(xLockBytes, aName, 0))
				{
					if (error(ERRCODE_CHAOS_FTP_GENERAL_FAILURE))
						errorRestart();
				}
				return;
			}

			case STATE_STOR_DONE:
				if (nReplyCode / 100 == 2)
				{
					CntNodeRef
						xDocNode(getImp().GetFTPBoxNode().Query(aNodeURL));
					if (xDocNode.Is())
					{
						getImp().GetDocNodeData(PTR_CAST(CntFTPDocNode,
														 &xDocNode));

						CntUInt32Item
							aSize(WID_DOCUMENT_SIZE,
								  getImp().getConnection()->getStoreCount());
						xDocNode->Put(aSize);

						String aDocDirID(RTL_CONSTASCII_USTRINGPARAM(
							                 CNT_FTP_DOC_ENTRY_PREFIX));
						aDocDirID += CntFTPImp::GetName(&xDocNode);

						bool bCreated = false;

						CntNode * pFolderNode = xDocNode->GetParent();
						CntNodeRef
							xFolderDir(CntFTPImp::GetDirectory(pFolderNode));
						if (xFolderDir.Is())
						{
							static_cast< CntFTPFolderNode * >(pFolderNode)->
								getImp().storeChildren(
									         *static_cast< CntStorageNode * >(
												  &xFolderDir));

							CntStoreItemSetRef
								xDocDirSet(
									static_cast< CntStorageNode * >(
										    &xFolderDir)->
									    openItemSet(
									  CntFTPImp::GetDocDirectoryEntryRanges(),
											aDocDirID,
											STREAM_STD_WRITE
											    | STREAM_NOCREATE));
							if (!xDocDirSet.Is())
							{
								xDocDirSet
									= static_cast< CntStorageNode * >(
										      &xFolderDir)->
									      openItemSet(
									  CntFTPImp::GetDocDirectoryEntryRanges(),
											  aDocDirID, STREAM_STD_WRITE);
								bCreated = xDocDirSet.Is() != false;
							}

							if (xDocDirSet.Is())
								xDocDirSet->Put(aSize);
						}
						else
						{
							bCreated = !static_cast< CntFTPFolderNode * >(
								                pFolderNode)->
								            getImp().hasChild(aName, true);
							if (bCreated)
								static_cast< CntFTPFolderNode * >(
									    pFolderNode)->
									getImp().addChild(aName, true);
						}

						if (bCreated)
						{
							getImp().
								GetFolderNodeData(PTR_CAST(CntFTPFolderNode,
														   pFolderNode));
							CntFTPImp::updateFolderCountsAddDoc(
								*pFolderNode,
								ITEMSET_VALUE(xDocNode, CntBoolItem,
											  WID_IS_READ)
								    != false,
								ITEMSET_VALUE(xDocNode, CntBoolItem,
											  WID_IS_MARKED)
								    != false,
								true);
							getJob().Result(&xDocNode);
						}
					}

					getJob().Broadcast(CntStatusBarHint(m_nHintID));
					m_nHintID = 0;

					done();
				}
				else if (nReplyCode / 100 != 1)
				{
					if (m_nHintID != 0)
					{
						getJob().Broadcast(CntStatusBarHint(m_nHintID));
						m_nHintID = 0;
					}
					if (error(nReplyCode, sReplyText))
						errorRestart();
				}
				return;
		}
}

//============================================================================
// virtual
void
CntFTPStoreDocTask::handleTransferCallback()
{
	getJob().Broadcast(CntStatusBarHint(m_nHintID,
										getImp().getConnection()->
										    getStoreCount()));
}

//============================================================================
// virtual
void CntFTPStoreDocTask::handleCancel()
{
	if (m_nHintID != 0)
	{
		getJob().Broadcast(CntStatusBarHint(m_nHintID));
		m_nHintID = 0;
	}
}

//============================================================================
//
//  CntFTPTransferDocTask
//
//============================================================================

// virtual
bool CntFTPTransferDocTask::initialize()
{
	if (static_cast< CntTransferItem const * >(getJob().GetRequest())->
		        getSpec()
		    != CntTransferItem::SPEC_DATA_TITLE)
	{
		if (error(ERRCODE_CHAOS_TRANSFER_URL_NOT_SUPPORTED))
			cancel();
		return false;
	}

	bConnModeDetermined = true;
	for (;;)
	{
		eConnMode = getImp().GetConnMode();
		if (eConnMode == CNT_CONN_MODE_ONLINE)
			break;
		if (!error(ERRCODE_CHAOS_OFFLINE))
			return false;
	}

	return true;
}

//============================================================================
// virtual
void CntFTPTransferDocTask::handleCallback(sal_Int32 nReplyCode,
										   sal_Char const * sReplyText)
{
	for (;;)
		switch (m_nState)
		{
			case STATE_STOR:
			{
				String aTitle(static_cast< CntTransferItem const * >(
					                  getJob().GetRequest())->
							      getTargetTitle());
				String aDocURL(OWN_URL(xTargetNode));
				aDocURL += CntFTPURL::encodeFSegment(aTitle);
				m_xDocNode = getImp().GetFTPBoxNode().Query(aDocURL);
				if (!m_xDocNode.Is())
				{
					if (error(ERRCODE_CHAOS_FTP_GENERAL_FAILURE))
						errorRestart();
					return;
				}
				getImp().GetDocNodeData(PTR_CAST(CntFTPDocNode, &m_xDocNode));

				SvLockBytesRef
					xLockBytes(static_cast< const CntTransferItem * >(
						               getJob().GetRequest())->
							       getSourceData());

				m_nState = STATE_STOR_DONE;
				if (!connectionStore(xLockBytes, aTitle, 0))
				{
					if (error(ERRCODE_CHAOS_FTP_GENERAL_FAILURE))
						errorRestart();
				}
				return;
			}

			case STATE_STOR_DONE:
				if (nReplyCode / 100 == 2)
				{
					CntUInt32Item
						aSize(WID_DOCUMENT_SIZE,
							  getImp().getConnection()->getStoreCount());
					m_xDocNode->Put(aSize);

					String aDocDirID(RTL_CONSTASCII_USTRINGPARAM(
						                 CNT_FTP_DOC_ENTRY_PREFIX));
					aDocDirID += CntFTPImp::GetName(&m_xDocNode);

					bool bCreated = false;

					CntNode * pFolderNode = m_xDocNode->GetParent();
					CntNodeRef
						xFolderDir(CntFTPImp::GetDirectory(pFolderNode));
					if (xFolderDir.Is())
					{
						static_cast< CntFTPFolderNode * >(pFolderNode)->
							getImp().storeChildren(
								         *static_cast< CntStorageNode * >(
											  &xFolderDir));

						CntStoreItemSetRef
							xDocDirSet(
								static_cast< CntStorageNode * >(&xFolderDir)->
								    openItemSet(
									  CntFTPImp::GetDocDirectoryEntryRanges(),
										aDocDirID,
										STREAM_STD_WRITE | STREAM_NOCREATE));
						if (!xDocDirSet.Is())
						{
							xDocDirSet
								= static_cast< CntStorageNode * >(
									      &xFolderDir)->
								      openItemSet(
									  CntFTPImp::GetDocDirectoryEntryRanges(),
										  aDocDirID, STREAM_STD_WRITE);
							bCreated = xDocDirSet.Is() != false;
						}

						if (xDocDirSet.Is())
							xDocDirSet->Put(aSize);
					}
					else
					{
						bCreated = !static_cast< CntFTPFolderNode * >(
							                pFolderNode)->
							            getImp().hasChild(aName, true);
						if (bCreated)
							static_cast< CntFTPFolderNode * >(pFolderNode)->
								getImp().addChild(aName, true);
					}

					if (bCreated)
					{
						getImp().GetFolderNodeData(PTR_CAST(CntFTPFolderNode,
															pFolderNode));
						CntFTPImp::updateFolderCountsAddDoc(
							*pFolderNode,
							ITEMSET_VALUE(m_xDocNode, CntBoolItem,
										  WID_IS_READ)
							    != false,
							ITEMSET_VALUE(m_xDocNode, CntBoolItem,
										  WID_IS_MARKED)
							    != false,
							true);

						// Override CntNodeJob::Result() in case the job's
						// subject is a 'pseudo' node:
						if (xTargetNode != getJob().GetSubject()
							&& !m_xDocNode->IsInserted())
							xTargetNode->Inserted(m_xDocNode, &getJob());
						else
							getJob().Result(m_xDocNode);
					}

					done();
				}
				else if (nReplyCode / 100 != 1
						 && error(nReplyCode, sReplyText))
					errorRestart();
				return;
		}
}

//============================================================================
// virtual
void CntFTPTransferDocTask::handleTransferCallback()
{
	//@@@ getImp().getConnection()->getStoreCount()
}

//============================================================================
//
//  CntFTPRenameDocTask
//
//============================================================================

// virtual
bool CntFTPRenameDocTask::initialize()
{
	String aTitle(ITEMSET_VALUE(getJob().GetSubject(), CntStringItem,
								WID_TITLE));
	if (aTitle.Len() == 0
		|| aTitle == ITEM_VALUE(CntStringItem, *getJob().GetRequest()))
	{
		done();
		return false;
	}
	bConnModeDetermined = true;
	for (;;)
	{
		eConnMode = getImp().GetConnMode();
		if (eConnMode == CNT_CONN_MODE_ONLINE)
			break;
		if (!error(ERRCODE_CHAOS_OFFLINE))
			return false;
	}
	return true;
}

//============================================================================
// virtual
void CntFTPRenameDocTask::handleCallback(sal_Int32 nReplyCode,
										 sal_Char const * sReplyText)
{
	switch (m_nState)
	{
		case STATE_RNFR:
			m_nState = STATE_RNTO;
			if (!connectionRenameFrom(aName)
				&& error(ERRCODE_CHAOS_FTP_GENERAL_FAILURE))
				errorRestart();
			break;

		case STATE_RNTO:
			if (nReplyCode / 100 == 3)
			{
				m_nState = STATE_RNTO_DONE;
				if (!connectionRenameTo(ITEM_VALUE(CntStringItem,
												   *getJob().GetRequest()))
					&& error(ERRCODE_CHAOS_FTP_GENERAL_FAILURE))
					errorRestart();
			}
			else if (error(nReplyCode, sReplyText))
				errorRestart();
			break;

		case STATE_RNTO_DONE:
			if (nReplyCode / 100 == 2)
				reschedule();
			else if (error(nReplyCode, sReplyText))
				errorRestart();
			break;
	}
}

//============================================================================
// virtual
void CntFTPRenameDocTask::handleReschedule()
{
	CntNode & rOldDocNode = *getJob().GetSubject();
	String aOldDocName(CntFTPImp::GetName(&rOldDocNode));
	String aNewDocName(ITEM_VALUE(CntStringItem, *getJob().GetRequest()));
	CntNode & rParentFolderNode = *rOldDocNode.GetParent();
	CntNodeRef xParentDirNode(CntFTPImp::GetDirectory(&rParentFolderNode));
	CntNodeRef xParentUserNode(CntFTPImp::GetUserData(&rParentFolderNode));
	String aOldDocID;
	String aNewDocID;
	if (xParentDirNode.Is() || xParentUserNode.Is())
	{
		aOldDocID.
			AssignAscii(RTL_CONSTASCII_STRINGPARAM(CNT_FTP_DOC_ENTRY_PREFIX));
		aOldDocID += aOldDocName;
		aNewDocID.
			AssignAscii(RTL_CONSTASCII_STRINGPARAM(CNT_FTP_DOC_ENTRY_PREFIX));
		aNewDocID += aNewDocName;
	}
	if (xParentDirNode.Is())
	{
		static_cast< CntFTPFolderNode * >(&rParentFolderNode)->
			getImp().storeChildren(*static_cast< CntStorageNode * >(
				                        &xParentDirNode));
		static_cast< CntStorageNode * >(&xParentDirNode)->rename(aOldDocID,
																 aNewDocID);
	}
	else
		static_cast< CntFTPFolderNode * >(&rParentFolderNode)->
			getImp().renameChild(aOldDocName, aNewDocName, true);
	if (xParentUserNode.Is())
		static_cast< CntStorageNode * >(&xParentUserNode)->rename(aOldDocID,
																  aNewDocID);
	String aNewDocURL(OWN_URL(&rParentFolderNode));
	aNewDocURL += CntFTPURL::encodeFSegment(aNewDocName);
	CntNodeRef xNewDocNode(rParentFolderNode.Query(aNewDocURL));
	if (xNewDocNode.Is())
	{
		getImp().GetDocNodeData(PTR_CAST(CntFTPDocNode, &xNewDocNode));
		getJob().Result(&xNewDocNode, CNT_ACTION_EXCHANGED);
		done();
	}
	else
		cancel();
}

//============================================================================
//
//  CntFTPDeleteDocTask
//
//============================================================================

// virtual
bool CntFTPDeleteDocTask::initialize()
{
	if (ITEM_VALUE(CntBoolItem, *getJob().GetRequest()))
	{
		bConnModeDetermined = true;
		for (;;)
		{
			eConnMode = getImp().GetConnMode();
			if (eConnMode == CNT_CONN_MODE_ONLINE)
				break;
			if (!error(ERRCODE_CHAOS_OFFLINE))
				return false;
		}
		return true;
	}
	else
	{
		if (getImp().IsProxyFolder(xTargetNode))
		{
			String aBase(getImp().GetServerBase());
			xTargetNode = aBase.Len() == 0 ?
				              0 :
				              getImp().GetFTPBoxNode().
				                  Query(CntFTPURL::prependBaseToFPath(
									        OWN_URL(xTargetNode), aBase));
		}

		if (&xTargetNode == getJob().GetSubject())
		{
			getImp().forceDirectoryStorage();
			CntNode * pParent = xTargetNode->GetParent();
			CntNodeRef xDirectory(CntFTPImp::GetDirectory(pParent));
			if (xDirectory.Is())
			{
				static_cast< CntFTPFolderNode * >(pParent)->
					getImp().storeChildren(*static_cast< CntStorageNode * >(
						                        &xDirectory));

				String aID(RTL_CONSTASCII_USTRINGPARAM(
					           CNT_FTP_DOC_ENTRY_PREFIX));
				aID += CntFTPImp::GetName(xTargetNode);
				UINT32 nAttribs = 0;
				static_cast< CntStorageNode * >(&xDirectory)->
					attrib(aID, 0, 0, nAttribs);
				if (!(nAttribs & CNTDIRENTRY_ATTRIB_MARKEDFORDELETE))
				{
					static_cast< CntStorageNode * >(&xDirectory)->
						attrib(aID, 0, CNTDIRENTRY_ATTRIB_MARKEDFORDELETE);
					CntNodeRef xUserData(CntFTPImp::GetUserData(pParent));
					if (xUserData.Is())
						static_cast< CntStorageNode * >(&xUserData)->
							attrib(aID, 0,
								   CNTDIRENTRY_ATTRIB_MARKEDFORDELETE);
					CntFTPImp::updateFolderCountsRemoveDoc(*pParent,
														   *xTargetNode,
														   true);
					getJob().GetSubject()->CntNode::ExecuteJob(&getJob());
					return false;
				}
			}
		}
		else if (xTargetNode.Is())
		{
			String aViewURL;
			if (CntAnchor * pAnchor = PTR_CAST(CntAnchor,
											   getJob().GetClient()))
				aViewURL = pAnchor->GetRootViewURL(true);
			if (aViewURL.Len() == 0)
				aViewURL = OWN_URL(xTargetNode);
			else
				aViewURL = CntAnchor::ToViewURL(aViewURL,
												OWN_URL(xTargetNode));
			CntAnchorRef xTargetAnchor(new CntAnchor(0, aViewURL));
			xTargetAnchor->Put(*getJob().GetRequest());
		}

		cancel();
		return false;
	}
}

//============================================================================
// virtual
void CntFTPDeleteDocTask::handleCallback(sal_Int32 nReplyCode,
										 sal_Char const * sReplyText)
{
	for (;;)
		switch (m_nState)
		{
			case STATE_DELE:
				if (&xTargetNode == getJob().GetSubject())
				{
					m_nState = STATE_DELE_DONE;
					if (!connectionRemove(aName)
						&& error(ERRCODE_CHAOS_FTP_GENERAL_FAILURE))
						errorRestart();
				}
				else
				{
					String aViewURL;
					if (CntAnchor * pAnchor
						    = PTR_CAST(CntAnchor, getJob().GetClient()))
						aViewURL = pAnchor->GetRootViewURL(true);
					if (aViewURL.Len() == 0)
						aViewURL = OWN_URL(xTargetNode);
					else
						aViewURL = CntAnchor::ToViewURL(aViewURL,
														OWN_URL(xTargetNode));
					CntAnchorRef xTargetAnchor(new CntAnchor(0, aViewURL));
					xTargetAnchor->Put(*getJob().GetRequest());
					cancel();
				}
				return;

			case STATE_DELE_DONE:
				if (nReplyCode / 100 == 2)
				{
					CntNode * pSubject = getJob().GetSubject();
					String aID(RTL_CONSTASCII_USTRINGPARAM(
						           CNT_FTP_DOC_ENTRY_PREFIX));
					aID += aName;
					CntNode * pParent = pSubject->GetParent();
					CntNodeRef xDirectory(CntFTPImp::GetDirectory(pParent));
					bool bWasLogicallyRemoved = false;
					if (xDirectory.Is())
					{
						static_cast< CntFTPFolderNode * >(pParent)->
							getImp().storeChildren(
								         *static_cast< CntStorageNode * >(
											  &xDirectory));
						UINT32 nDocDirAttribs = 0;
						static_cast< CntStorageNode * >(&xDirectory)->
							attrib(aID, 0, 0, nDocDirAttribs);
						bWasLogicallyRemoved
							= (nDocDirAttribs
							           & CNTDIRENTRY_ATTRIB_MARKEDFORDELETE)
							      != 0;
						static_cast< CntStorageNode * >(&xDirectory)->
							remove(aID);
					}
					else
						static_cast< CntFTPFolderNode * >(pParent)->
							getImp().removeChild(aName, true);

					CntNodeRef xUserData(CntFTPImp::GetUserData(pParent));
					if (xUserData.Is())
					{
						static_cast< CntStorageNode * >(&xUserData)->
							attrib(aID, CNTDIRENTRY_ATTRIB_CREATE, 0);
						static_cast< CntStorageNode * >(&xUserData)->
							remove(aID);
					}
					if (!bWasLogicallyRemoved)
						CntFTPImp::updateFolderCountsRemoveDoc(*pParent,
															   *pSubject,
															   true);
					getJob().GetSubject()->CntNode::ExecuteJob(&getJob());
				}
				else if (error(nReplyCode, sReplyText))
					errorRestart();
				return;
		}
}

//============================================================================
//
//  CntFTPUndeleteDocTask
//
//============================================================================

// virtual
bool CntFTPUndeleteDocTask::initialize()
{
	CntNode * pSubject = getJob().GetSubject();
	CntNode * pParent = pSubject->GetParent();
	CntNodeRef xDirectory(CntFTPImp::GetDirectory(pParent));
	if (xDirectory.Is())
	{
		String aID(RTL_CONSTASCII_USTRINGPARAM(CNT_FTP_DOC_ENTRY_PREFIX));
		aID += CntFTPImp::GetName(pSubject);
		UINT32 nDocDirAttribs = 0;
		static_cast< CntStorageNode * >(&xDirectory)->attrib(aID, 0, 0,
															 nDocDirAttribs);
		if (nDocDirAttribs & CNTDIRENTRY_ATTRIB_MARKEDFORDELETE)
		{
			static_cast< CntStorageNode * >(&xDirectory)->
				attrib(aID, CNTDIRENTRY_ATTRIB_MARKEDFORDELETE, 0);
			CntNodeRef xUserData(CntFTPImp::GetUserData(pParent));
			if (xUserData.Is())
				static_cast< CntStorageNode * >(&xUserData)->
					attrib(aID, CNTDIRENTRY_ATTRIB_MARKEDFORDELETE, 0);
			getImp().GetDocNodeData(PTR_CAST(CntFTPDocNode, pSubject));
			getImp().updateFolderCountsAddDoc(*pParent,
											  ITEMSET_VALUE(pSubject,
															CntBoolItem,
															WID_IS_READ)
											      != false,
											  ITEMSET_VALUE(pSubject,
															CntBoolItem,
															WID_IS_MARKED)
											      != false,
											  true);
			getJob().Result(pSubject);
			for (CntFTPRedirectionPointer const * p
					 = getImp().GetRedirectionPointers(OWN_URL(pParent));
				 p; p = p->GetNext())
			{
				CntNodeRef xRedNode(CntRootNodeMgr::Get()->
									    Query(p->GetPointerURL()));
				if (xRedNode.Is())
					xRedNode->Broadcast(CntNodeHint(pSubject,
													CNT_ACTION_INSERTED,
													&getJob()));
			}
			done();
			return false;
		}
	}
	cancel();
	return false;
}

//============================================================================
//
//  CntFTPRetrieveCacheLockBytes_Impl
//
//============================================================================

TYPEINIT1(CntFTPRetrieveCacheLockBytes_Impl, SvAsyncLockBytes)

//============================================================================
// virtual
CntFTPRetrieveCacheLockBytes_Impl::~CntFTPRetrieveCacheLockBytes_Impl()
{
	close();
	UINT32 nAttribs = 0;
	static_cast< CntStorageNode * >(&m_xStorage)->attrib(m_aID, 0, 0,
														 nAttribs);
	if (!(nAttribs & CNTDIRENTRY_ATTRIB_FTP_PERSISTENT))
		static_cast< CntStorageNode * >(&m_xStorage)->remove(m_aID);
}

//============================================================================
// static
CntFTPRetrieveCacheLockBytes_Impl *
CntFTPRetrieveCacheLockBytes_Impl::open(CntStorageNode * pTheStorage,
										String const & rTheID,
										StreamMode eMode)
{
	SvStream * pStream = pTheStorage->openStream(rTheID, eMode);
	return pStream ? new CntFTPRetrieveCacheLockBytes_Impl(pStream,
														   pTheStorage,
														   rTheID) :
		             0;
}

//============================================================================
//
//  CntFTPRetrieveTempLockBytes_Impl
//
//============================================================================

TYPEINIT1(CntFTPRetrieveTempLockBytes_Impl, SvAsyncLockBytes)

//============================================================================
CntFTPRetrieveTempLockBytes_Impl::CntFTPRetrieveTempLockBytes_Impl():
	SvAsyncLockBytes(new SvFileStream(DirEntry(String::CreateFromAscii(
		                                           RTL_CONSTASCII_STRINGPARAM(
													   "ftp*.tmp"))).
									      TempName().GetFull(),
									  STREAM_STD_READWRITE | STREAM_TRUNC),
					 true)
{}

//============================================================================
// virtual
CntFTPRetrieveTempLockBytes_Impl::~CntFTPRetrieveTempLockBytes_Impl()
{
	String aFileName(static_cast< const SvFileStream * >(GetStream())->
					     GetFileName());
	close();
	DirEntry(aFileName).Kill();
}

