/*************************************************************************
 *
 *  $RCSfile: thrditem.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: kso $ $Date: 2001/07/25 15:09:45 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _STREAM_HXX //autogen
#include <tools/stream.hxx>
#endif

#ifndef _CNTWIDS_HRC
#include <svtools/cntwids.hrc>
#endif

#ifndef _CNTPOOL_HXX
#include <cntpool.hxx>
#endif

#define _THRDITEM_CXX
#include <thrditem.hxx>

using namespace chaos;

//-------------------------------------------------------------------------

TYPEINIT1_AUTOFACTORY(CntThreadingItem, SfxPoolItem);
SV_IMPL_OBJARR(CntThreadingInfoArr, CntThreadingInfo);

//=========================================================================

BOOL CntThreadingInfo::operator==( const CntThreadingInfo &rOther ) const
{
	return _eType == rOther._eType &&
		   _nIsEnabledWID == rOther._nIsEnabledWID &&
		   _nParentWID == rOther._nParentWID &&
		   _nChildWID == rOther._nChildWID &&
		   _nTitleWID == rOther._nTitleWID &&
		   _cDelimiter == rOther._cDelimiter;
}

//-------------------------------------------------------------------------

SvStream& chaos::operator>>( SvStream &rStream, CntThreadingInfo &rInfo )
{
	USHORT nType;
	return rStream >> nType
				   >> rInfo._nIsEnabledWID
				   >> rInfo._nParentWID
				   >> rInfo._nChildWID
				   >> rInfo._nTitleWID
				   >> rInfo._cDelimiter;
	rInfo._eType = (CntThreadingType) nType;
}

//-------------------------------------------------------------------------

SvStream& chaos::operator<<( SvStream &rStream, const CntThreadingInfo &rInfo )
{
	return rStream << (USHORT) rInfo._eType
				   << rInfo._nIsEnabledWID
				   << rInfo._nParentWID
				   << rInfo._nChildWID
				   << rInfo._nTitleWID
				   << rInfo._cDelimiter;
}

//=========================================================================

CntThreadingItem::CntThreadingItem( USHORT nWhich )
:	SfxPoolItem(nWhich)
{
}

//-------------------------------------------------------------------------

CntThreadingItem::CntThreadingItem( USHORT nWhich, SvStream &rStream )
:	SfxPoolItem( nWhich )
{
	USHORT nCount = 0;
	rStream >> nCount;
	for ( USHORT n = 0; n < nCount; ++n )
	{
		CntThreadingInfo aInfo;
		rStream >> aInfo;
		Append( aInfo );
	}
}

//-------------------------------------------------------------------------

CntThreadingItem::CntThreadingItem( const CntThreadingItem &rOrig )
:	SfxPoolItem( rOrig )
{
	for ( USHORT n = 0; n < rOrig.Count(); ++n )
		Append( rOrig[n] );
}

//-------------------------------------------------------------------------

CntThreadingItem::~CntThreadingItem()
{
}

//-------------------------------------------------------------------------

int CntThreadingItem::operator==( const SfxPoolItem &rItem ) const
{
	const CntThreadingItem& rOther = (const CntThreadingItem&) rItem;
	if ( Count() != rOther.Count() )
		return FALSE;

	for ( USHORT n = 0; n < Count(); ++n )
		if ( operator[](n) != rOther[n] )
			return FALSE;

	return TRUE;
}

//-------------------------------------------------------------------------

SfxPoolItem* CntThreadingItem::Clone( SfxItemPool * ) const
{
	return new CntThreadingItem( *this );
}

//-------------------------------------------------------------------------

SfxPoolItem* CntThreadingItem::Create(SvStream &rStream, USHORT nItemVersion) const
{
	return new CntThreadingItem( Which(), rStream );
}

//-------------------------------------------------------------------------

SvStream& CntThreadingItem::Store(SvStream &rStream, USHORT nItemVersion ) const
{
	rStream << Count();
	for ( USHORT n = 0; n < Count(); ++n )
		rStream << operator[](n);
	return rStream;
}

//----------------------------------------------------------------------------
// virtual
BOOL CntThreadingItem::PutValue( const com::sun::star::uno::Any& rVal,
						   		 BYTE nMemberId )
{
	return FALSE;
}

//----------------------------------------------------------------------------
// virtual
BOOL CntThreadingItem::QueryValue( com::sun::star::uno::Any& rVal,
							 	   BYTE nMemberId ) const
{
	return FALSE;
}

