/*************************************************************************
 *
 *  $RCSfile: strmitem.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: kso $ $Date: 2001/07/25 15:09:45 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _COM_SUN_STAR_UNO_ANY_HXX_
#include <com/sun/star/uno/Any.hxx>
#endif
#ifndef _COM_SUN_STAR_UCB_EXPORTSTREAMINFO_HPP_
#include <com/sun/star/ucb/ExportStreamInfo.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_POSTCOMMANDARGUMENT_HPP_
#include <com/sun/star/ucb/PostCommandArgument.hpp>
#endif
#ifndef SVTOOLS_INSTRM_HXX
#include <svtools/instrm.hxx>
#endif
#ifndef SVTOOLS_OUTSTRM_HXX
#include <svtools/outstrm.hxx>
#endif
#ifndef _FSYS_HXX
#include <tools/fsys.hxx>
#endif

#ifndef _CHAOS_STRMITEM_HXX
#include <strmitem.hxx>
#endif

using namespace chaos;

using namespace com::sun::star::io;
using namespace com::sun::star::ucb;
using namespace com::sun::star::uno;

//============================================================================
//
//  CntGuaredStream
//
//============================================================================

// virtual
CntGuardedStream::~CntGuardedStream()
{
	delete m_pStream;
}

//============================================================================
//
//  CntStreamItem
//
//============================================================================

void CntStreamItem::setStream(SvStream * pStream)
{
	releaseStream();
	m_xGuard = new CntGuardedStream(pStream, TRUE);
}

//============================================================================
TYPEINIT1_AUTOFACTORY(CntStreamItem, SfxPoolItem);

//============================================================================
CntStreamItem::CntStreamItem(USHORT nWhich, SvStream * pStream):
	SfxPoolItem(nWhich),
	m_xGuard(new CntGuardedStream(pStream, TRUE)),
	m_pAcquiredStream(0)
{}

//============================================================================
CntStreamItem::CntStreamItem(USHORT nWhich,
							 const CntGuardedStreamRef & rTheGuard):
	SfxPoolItem(nWhich),
	m_xGuard(rTheGuard),
	m_pAcquiredStream(0)
{}

//============================================================================
// virtual
int CntStreamItem::operator ==(const SfxPoolItem & rItem) const
{
	const CntStreamItem * pItem = PTR_CAST(CntStreamItem, &rItem);
	return pItem && m_xGuard == pItem->m_xGuard;
}

//============================================================================
// virtual
BOOL CntStreamItem::PutValue(const com::sun::star::uno::Any & rVal, BYTE)
{
	return FALSE;
}

//============================================================================
// virtual
BOOL CntStreamItem::QueryValue(com::sun::star::uno::Any & rVal, BYTE) const
{
	return FALSE;
}

//============================================================================
// virtual
SfxPoolItem * CntStreamItem::Create(SvStream &, USHORT) const
{
	return new CntStreamItem(Which());
}

//============================================================================
// virtual
SfxPoolItem * CntStreamItem::Clone(SfxItemPool *) const
{
	return new CntStreamItem(*this);
}

//============================================================================
//
//  class CntInStreamItem
//
//============================================================================

TYPEINIT1_AUTOFACTORY(CntInStreamItem, CntStreamItem);

//============================================================================
// virtual
int CntInStreamItem::operator ==(const SfxPoolItem & rItem) const
{
	return rItem.ISA(CntInStreamItem) && CntStreamItem::operator ==(rItem);
}

//============================================================================
// virtual
BOOL CntInStreamItem::PutValue(const com::sun::star::uno::Any & rVal, BYTE)
{
	Reference< com::sun::star::uno::XInterface > xIfc;
	if ( rVal >>= xIfc )
	{
		if ( xIfc.is() )
		{
			Reference< XInputStream > xInStream( xIfc, UNO_QUERY );
			if ( xInStream.is() )
			{
				setStream( new SvInputStream( xInStream ) );
				return TRUE;
			}
		}
	}
	else
	{
		rtl::OUString aString;
		if ( rVal >>= aString )
		{
			setStream(new SvFileStream(DirEntry(aString, FSYS_STYLE_URL).
									       GetFull(),
									   STREAM_STD_READ));
			return TRUE;
		}
	}

	DBG_ERROR("CntInStreamItem::PutValue - Wrong type!");
	return FALSE;
}

//============================================================================
// virtual
SfxPoolItem * CntInStreamItem::Create(SvStream &, USHORT) const
{
	return new CntInStreamItem(Which());
}

//============================================================================
// virtual
SfxPoolItem * CntInStreamItem::Clone(SfxItemPool *) const
{
	return new CntInStreamItem(*this);
}

//============================================================================
//
//  class CntPostStreamItem
//
//============================================================================

TYPEINIT1_AUTOFACTORY(CntPostStreamItem, CntInStreamItem);

//============================================================================
// virtual
int CntPostStreamItem::operator ==(const SfxPoolItem & rItem) const
{
	return rItem.ISA(CntPostStreamItem) && CntInStreamItem::operator ==(rItem)
		   && m_xSink == static_cast< const CntPostStreamItem * >(&rItem)->
		                     m_xSink;
}

//============================================================================
// virtual
BOOL CntPostStreamItem::PutValue(const com::sun::star::uno::Any & rVal, BYTE)
{
	PostCommandArgument aValue;
	if (rVal >>= aValue)
	{
		setStream(new SvInputStream(aValue.Source));
		m_xSink = aValue.Sink;
		return TRUE;
	}

	DBG_ERROR("CntPostStreamItem::PutValue - Wrong type!");
	return FALSE;
}

//============================================================================
// virtual
SfxPoolItem * CntPostStreamItem::Create(SvStream &, USHORT) const
{
	return new CntPostStreamItem(Which());
}

//============================================================================
// virtual
SfxPoolItem * CntPostStreamItem::Clone(SfxItemPool *) const
{
	return new CntPostStreamItem(*this);
}

//============================================================================
//
//  class CntOutStreamItem
//
//============================================================================

TYPEINIT1_AUTOFACTORY(CntOutStreamItem, CntStreamItem);

//============================================================================
// virtual
int CntOutStreamItem::operator ==(const SfxPoolItem & rItem) const
{
	return rItem.ISA(CntOutStreamItem) && CntStreamItem::operator ==(rItem);
}

//============================================================================
// virtual
BOOL CntOutStreamItem::PutValue(const com::sun::star::uno::Any & rVal, BYTE)
{
	Reference< com::sun::star::uno::XInterface > xIfc;
	if ( rVal >>= xIfc )
	{
		if ( xIfc.is() )
		{
			Reference< XOutputStream > xOutStream( xIfc, UNO_QUERY );
			if ( xOutStream.is() )
			{
				setStream( new SvOutputStream( xOutStream ) );
				return TRUE;
			}
		}
	}
	else
	{
		rtl::OUString aString;
		if ( rVal >>= aString )
		{
			setStream(new SvFileStream(DirEntry(aString, FSYS_STYLE_URL).
									       GetFull(),
									   STREAM_STD_WRITE | STREAM_TRUNC));
			return TRUE;
		}
	}

	DBG_ERROR("CntOutStreamItem::PutValue - Wrong type!");
	return FALSE;
}

//============================================================================
// virtual
SfxPoolItem * CntOutStreamItem::Create(SvStream &, USHORT) const
{
	return new CntOutStreamItem(Which());
}

//============================================================================
// virtual
SfxPoolItem * CntOutStreamItem::Clone(SfxItemPool *) const
{
	return new CntOutStreamItem(*this);
}

//============================================================================
//
//  class CntExpStreamItem
//
//============================================================================

TYPEINIT1_AUTOFACTORY(CntExpStreamItem, CntOutStreamItem);

//============================================================================
// virtual
int CntExpStreamItem::operator ==(const SfxPoolItem & rItem) const
{
	const CntExpStreamItem * pItem = PTR_CAST(CntExpStreamItem, &rItem);
	return pItem && CntOutStreamItem::operator ==(rItem)
	       && m_bForceBodies == pItem->m_bForceBodies;
}

//============================================================================
// virtual
BOOL CntExpStreamItem::PutValue(const com::sun::star::uno::Any & rVal,
								BYTE nMemberID)
{
	ExportStreamInfo aStreamInfo;
	if (rVal >>= aStreamInfo)
	{
		m_bForceBodies = aStreamInfo.ForceBodies;
		setStream(new SvOutputStream(aStreamInfo.Target));
		return TRUE;
	}
	return CntOutStreamItem::PutValue(rVal, nMemberID);
}

//============================================================================
// virtual
SfxPoolItem * CntExpStreamItem::Create(SvStream &, USHORT) const
{
	return new CntExpStreamItem(Which());
}

//============================================================================
// virtual
SfxPoolItem * CntExpStreamItem::Clone(SfxItemPool *) const
{
	return new CntExpStreamItem(*this);
}

