/*************************************************************************
 *
 *  $RCSfile: silitem.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: kso $ $Date: 2001/07/25 15:09:45 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SVTOOLS_STRCRYPT_HXX_
#include <svtools/strcrypt.hxx>
#endif

#ifndef _CNTBASE_HXX
#include <cntbase.hxx>
#endif
#ifndef _CHAOS_SILITEM_HXX
#include <silitem.hxx>
#endif

using namespace chaos;

//============================================================================
//
//  struct CntSendInfoListEntry
//
//============================================================================

CntSendInfoListEntry::rep_type CntSendInfoListEntry::getRep() const
{
	return rep_type(CntRecipientInfo::ToProtocolString(first), second);
}

//============================================================================
BOOL CntSendInfoListEntry::setRep(const rep_type & rInfo)
{
	first_type eProtocol
		= CntRecipientInfo::ToProtocolType(rInfo.ProtocolType);
	if (eProtocol == CNT_OUTMSG_PROTOCOL_END)
		return FALSE;
	first = eProtocol;
	second = String(rInfo.Value);
	return TRUE;
}

//============================================================================
void CntSendInfoListEntry::write(SvStream & rStream) const
{
	rStream << USHORT(0x8000 | first);
	rStream.
		WriteByteString(SvStringEncode(ByteString(second,
												  RTL_TEXTENCODING_UTF8)));
};

//============================================================================
BOOL CntSendInfoListEntry::read(SvStream & rStream, bool bUnicode)
{
	USHORT nProtocol = CNT_OUTMSG_PROTOCOL_END;
	rStream >> nProtocol;

	bool bNew = nProtocol & 0x8000;
	nProtocol &= 0x7FFF;

	if (nProtocol >= CNT_OUTMSG_PROTOCOL_END)
		return FALSE;
	first = first_type(nProtocol);
	ByteString aTheSecond;
	rStream.ReadByteString(aTheSecond);
	second = UniString(CntStringDecode(bNew, aTheSecond),
					   bUnicode ? RTL_TEXTENCODING_UTF8 :
					              rStream.GetStreamCharSet());
	return TRUE;
}

//============================================================================
//
//  class CntSendInfoListItem
//
//============================================================================

TYPEINIT1_AUTOFACTORY(CntSendInfoListItem, SfxPoolItem);

//============================================================================
//
//  class CntMediaTypeSet
//
//============================================================================

CntMediaTypeSet::CntMediaTypeSet(const CntMediaTypeSet & rSet):
	List(rSet.size())
{
	for (size_type i = 0; i < rSet.size();)
		Insert(new value_type(rSet.getEntry(i++)), LIST_APPEND);
}

//============================================================================
CntMediaTypeSet & CntMediaTypeSet::operator =(const CntMediaTypeSet & rSet)
{
	if (&rSet != this)
	{
		clear();
		for (size_type i = 0; i < rSet.size();)
			Insert(new value_type(rSet.getEntry(i++)), LIST_APPEND);
	}
	return *this;
}

//============================================================================
BOOL CntMediaTypeSet::operator ==(const CntMediaTypeSet & rSet) const
{
	if (size() != rSet.size())
		return FALSE;
	for (size_type i = 0; i < rSet.size(); ++i)
		if (getEntry(i) != rSet.getEntry(i))
			return FALSE;
	return TRUE;
}

//============================================================================
void CntMediaTypeSet::insert(const value_type & rEntry)
{
	for (size_type i = 0; i < size();)
		if (getEntry(i++) == rEntry)
			return;
	Insert(new value_type(rEntry), LIST_APPEND);
}

//============================================================================
void CntMediaTypeSet::clear()
{
	while (size())
		delete INSECURE_DYNAMIC_CAST(value_type *, Remove(size() - 1));
}

//============================================================================
BOOL CntMediaTypeSet::findEntry(const key_type & rKey) const
{
	for (size_type i = 0; i < size();)
		if (getEntry(i++) == rKey)
			return TRUE;
	return FALSE;
}

//============================================================================
//
//  struct CntSendMediaTypesEntry
//
//============================================================================

CntSendMediaTypesEntry::rep_type CntSendMediaTypesEntry::getRep() const
{
	rep_type aMediaTypes;
	aMediaTypes.ProtocolType = CntRecipientInfo::ToProtocolString(first);
	aMediaTypes.Value.realloc(second.size());
	rtl::OUString * pArray = aMediaTypes.Value.getArray();
	for (CntMediaTypeSet::size_type i = 0; i < second.size();)
		*pArray++ = second.getEntry(i++).getCanonic();
	return aMediaTypes;
}

//============================================================================
BOOL CntSendMediaTypesEntry::setRep(const rep_type & rMediaTypes)
{
	first_type eProtocol
		= CntRecipientInfo::ToProtocolType(rMediaTypes.ProtocolType);
	if (eProtocol == CNT_OUTMSG_PROTOCOL_END)
		return FALSE;
	first = eProtocol;
	second.clear();
	const rtl::OUString * pArray = rMediaTypes.Value.getConstArray();
	for (sal_Int32 nSize = rMediaTypes.Value.getLength(); nSize--;)
	{
		second.insert(String(*pArray));
		pArray++;
	}
	return TRUE;
}

//============================================================================
void CntSendMediaTypesEntry::write(SvStream & rStream) const
{
	rStream << USHORT(first) << second.size();
	for (CntMediaTypeSet::size_type i = 0; i < second.size();)
		SfxPoolItem::writeUnicodeString(rStream,
										second.getEntry(i++).getCanonic());
};

//============================================================================
BOOL CntSendMediaTypesEntry::read(SvStream & rStream, bool bUnicode)
{
	USHORT nProtocol = CNT_OUTMSG_PROTOCOL_END;
	rStream >> nProtocol;
	if (nProtocol >= CNT_OUTMSG_PROTOCOL_END)
		return FALSE;
	first = first_type(nProtocol);
	second.clear();
	CntMediaTypeSet::size_type nSize = 0;
	rStream >> nSize;
	while (nSize--)
	{
		String aCanonic;
		SfxPoolItem::readUnicodeString(rStream, aCanonic, bUnicode);
		second.insert(aCanonic);
	}
	return TRUE;
}

//============================================================================
//
//  class CntSendMediaTypesItem
//
//============================================================================

TYPEINIT1_AUTOFACTORY(CntSendMediaTypesItem, SfxPoolItem);

