/*************************************************************************
 *
 *  $RCSfile: ipositem.cxx,v $
 *
 *  $Revision: 1.3.10.1 $
 *
 *  last change: $Author: hr $ $Date: 2002/05/30 09:23:48 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _STREAM_HXX
#include <tools/stream.hxx>
#endif

#include "cntpool.hxx"
#include "ipositem.hxx"
#include "cntrnmgr.hxx"
#ifndef _CNTBASE_HXX
#include "cntbase.hxx"
#endif
#ifndef _CHAOS_INIMGR_HXX
#include <inimgr.hxx>
#endif

using namespace chaos;

//-------------------------------------------------------------------------

TYPEINIT1_AUTOFACTORY(CntIconPosItem, SfxPoolItem);

//=========================================================================

namespace chaos {

struct CntIconPosList_Impl
{
	CntIconPosList* 	_pList;
	ULONG 				_nRefCount;

						CntIconPosList_Impl() : _pList(0), _nRefCount(1) {}
						~CntIconPosList_Impl() { delete _pList; }
};

}

//=========================================================================

CntIconPosList::CntIconPosList( const CntIconPosList& rList)
	: SvStrings (rList.Count())
{
	for( USHORT nCur = 0, nCount = rList.Count(); nCur < nCount; nCur++ )
	{
		const CntIconPosListEntry* pEntry = rList.GetObject( nCur );
		Insert( new CntIconPosListEntry( *pEntry ), nCur );
	}
}

//-------------------------------------------------------------------------

CntIconPosList::~CntIconPosList()
{
	USHORT nCount = Count();
  	for( USHORT nCur = 0; nCur < nCount; nCur++ )
		delete (CntIconPosListEntry*)GetObject( nCur );
}

//-------------------------------------------------------------------------

void CntIconPosList::Store( SvStream& rStream ) const
{
	USHORT nCount = Count();
	rStream << nCount;
  	for( USHORT nCur = 0; nCur < nCount; nCur++ )
	{
		const CntIconPosListEntry* pEntry = GetObject( nCur );
		SfxPoolItem::writeUnicodeString(rStream, *pEntry);
		rStream << pEntry->_aPos;
		rStream << pEntry->_nFlags;
	}
}

//-------------------------------------------------------------------------

void CntIconPosList::Load( SvStream& rStream, bool bUnicode )
{
	USHORT nCount = 0;
	rStream >> nCount;

	for( USHORT nCur = 0; nCur < nCount; nCur++ )
	{
		String aStr;
		SfxPoolItem::readUnicodeString(rStream, aStr, bUnicode);
		CntIconPosListEntry* pEntry = new CntIconPosListEntry(aStr);
		rStream >> pEntry->_aPos;
		rStream >> pEntry->_nFlags;
		Insert( pEntry, nCur );
	}
}

//-------------------------------------------------------------------------

int CntIconPosList::operator==( const CntIconPosList& rList ) const
{
	USHORT nCount = Count();
	if( nCount != rList.Count() )
		return FALSE;
	for( USHORT nCur = 0; nCur < nCount; nCur++ )
	{
		const CntIconPosListEntry* pObj1 = GetObject( nCur );
		const CntIconPosListEntry* pObj2 = rList.GetObject( nCur );
		if( *pObj1 != *pObj2 ||
			pObj1->GetPos() != pObj2->GetPos() ||
			pObj1->GetFlags() != pObj2->GetFlags() )
			return FALSE;
	}
	return TRUE;
}


//=========================================================================

CntIconPosItem::CntIconPosItem( USHORT nWhich )
:	SfxPoolItem(nWhich), _pImp(0)
{
}

//-------------------------------------------------------------------------

CntIconPosItem::CntIconPosItem( USHORT nWhich, SvStream &rStream,
								USHORT nVersion )
:	SfxPoolItem( nWhich )
{
	_pImp = new CntIconPosList_Impl;
	_pImp->_pList = new CntIconPosList;
	_pImp->_pList->Load( rStream, nVersion >= 1 );
}

//-------------------------------------------------------------------------

CntIconPosItem::CntIconPosItem( const CntIconPosItem &rOrig )
:	SfxPoolItem( rOrig )
{
	_pImp = rOrig._pImp;
	if( _pImp )
		_pImp->_nRefCount++;
}

//-------------------------------------------------------------------------

CntIconPosItem::~CntIconPosItem()
{
	ReleaseList();
}

//-------------------------------------------------------------------------

void CntIconPosItem::ReleaseList()
{
	if( _pImp )
	{
		_pImp->_nRefCount--;
		if ( _pImp->_nRefCount == 0 )
			delete _pImp;

		_pImp = 0;
	}
}

//-------------------------------------------------------------------------

int CntIconPosItem::operator==( const SfxPoolItem &rItem ) const
{
	const CntIconPosItem& rOther = (const CntIconPosItem&)rItem;
	if( _pImp == rOther._pImp )
		return TRUE;
	USHORT nThisCount = 0;
	if( _pImp && _pImp->_pList )
		nThisCount = _pImp->_pList->Count();
	USHORT nOtherCount = 0;
	if( rOther._pImp && rOther._pImp->_pList )
		nOtherCount = rOther._pImp->_pList->Count();
	if( nThisCount && nOtherCount )
		return _pImp->_pList->operator==( *rOther._pImp->_pList );
	if( nThisCount == nOtherCount )
		return TRUE;
	return FALSE;
}

//-------------------------------------------------------------------------

USHORT CntIconPosItem::GetVersion(USHORT) const
{
	return 1; // because it uses SfxPoolItem::read/writeUnicodeString()
}

//-------------------------------------------------------------------------

SfxPoolItem* CntIconPosItem::Create(SvStream &rStream, USHORT nItemVersion) const
{
	return new CntIconPosItem( Which(), rStream, nItemVersion );
}

//-------------------------------------------------------------------------

SvStream& CntIconPosItem::Store(SvStream &rStream, USHORT nItemVersion ) const
{
	if( _pImp && _pImp->_pList )
		_pImp->_pList->Store( rStream );
	else
	{
		USHORT nCount = 0;
		rStream << nCount;
	}
	return rStream;
}

//-------------------------------------------------------------------------

SfxPoolItem* CntIconPosItem::Clone( SfxItemPool *pPool ) const
{
	return new CntIconPosItem( *this );
}

//-------------------------------------------------------------------------

void CntIconPosItem::SetList( CntIconPosList* pList )
{
	ReleaseList();
	_pImp = new CntIconPosList_Impl;
	_pImp->_pList = pList;
}

//-------------------------------------------------------------------------

const CntIconPosList* CntIconPosItem::GetList() const
{
	return _pImp ? _pImp->_pList : 0;
}

//----------------------------------------------------------------------------
// virtual
BOOL CntIconPosItem::PutValue( const com::sun::star::uno::Any& rVal,
						   	   BYTE nMemberId )
{
	return FALSE;
}

//----------------------------------------------------------------------------
// virtual
BOOL CntIconPosItem::QueryValue( com::sun::star::uno::Any& rVal,
							 	 BYTE nMemberId ) const
{
	return FALSE;
}

