/*************************************************************************
 *
 *  $RCSfile: httpitem.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: kso $ $Date: 2001/07/25 15:09:44 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#define _CHAOS_HTTPITEM_CXX "$Revision: 1.2 $"

#ifndef _COM_SUN_STAR_UNO_ANY_HXX_
#include <com/sun/star/uno/Any.hxx>
#endif

#ifndef _SOLAR_H
#include <tools/solar.h>
#endif

#ifndef _STREAM_HXX
#include <tools/stream.hxx>
#endif

#ifndef _STRING_HXX
#include <tools/string.hxx>
#endif

#ifndef _SVTOOLS_CENUMITM_HXX
#include <svtools/cenumitm.hxx>
#endif

#ifndef _CHAOS_HTTPITEM_HXX
#include "httpitem.hxx"
#endif

using namespace chaos;

/*========================================================================
 *
 * CntHTTPVerifyModeItem implementation.
 *
 *======================================================================*/
TYPEINIT1_AUTOFACTORY(CntHTTPVerifyModeItem, CntEnumItem);

/*
 * Clone.
 */
SfxPoolItem* CntHTTPVerifyModeItem::Clone (SfxItemPool *pPool) const
{
	return new CntHTTPVerifyModeItem (Which(), (CntHTTPVerifyMode)GetValue());
}

/*
 * Create.
 */
SfxPoolItem* CntHTTPVerifyModeItem::Create (SvStream& rStrm, USHORT) const
{
	USHORT eMode = CNTHTTP_VERIFY_ALWAYS;
	rStrm >> eMode;

	return new CntHTTPVerifyModeItem (Which(), (CntHTTPVerifyMode)eMode);
}

/*
 * Store.
 */
SvStream& CntHTTPVerifyModeItem::Store (SvStream& rStrm, USHORT) const
{
	rStrm << (USHORT)GetValue();
	return rStrm;
}

/*
 * GetValueCount.
 */
USHORT CntHTTPVerifyModeItem::GetValueCount (void) const
{
	return CNTHTTP_VERIFYMODE_COUNT;
}

/*
 * QueryValue.
 */
BOOL CntHTTPVerifyModeItem::QueryValue (com::sun::star::uno::Any& rVal,
										BYTE nMemberId) const
{
	sal_Int16 nValue = CntEnumItem::GetValue();
	rVal <<= nValue;
	return TRUE;
}

/*
 * PutValue.
 */
BOOL CntHTTPVerifyModeItem::PutValue (const com::sun::star::uno::Any& rVal,
						   			  BYTE nMemberId)
{
	sal_Int16 nValue;
	if ( rVal >>= nValue )
	{
		CntEnumItem::SetValue( nValue );
		return TRUE;
	}

	DBG_ERROR( "CntHTTPVerifyModeItem::PutValue - Wrong type!" );
	return FALSE;
}

