/*************************************************************************
 *
 *  $RCSfile: cntmbitm.cxx,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: kso $ $Date: 2001/07/27 08:07:36 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SOLAR_H
#include <tools/solar.h>
#endif

#ifndef _OSL_FILE_HXX_
#include <osl/file.hxx>
#endif

#ifndef _STREAM_HXX
#include <tools/stream.hxx>
#endif
#ifndef _CACHESTR_HXX
#include <tools/cachestr.hxx>
#endif

#ifndef _INET_WRAPPER_HXX
#include <inet/wrapper.hxx>
#endif
#ifndef _INETCOREMAIL_HXX
#include <inet/inetmail.hxx>
#endif

#ifndef _INETTYPE_HXX
#include <svtools/inettype.hxx>
#endif
#ifndef SVTOOLS_INSTRM_HXX
#include <svtools/instrm.hxx>
#endif

#ifndef _COM_SUN_STAR_UNO_ANY_HXX_
#include <com/sun/star/uno/Any.hxx>
#endif
#ifndef _COM_SUN_STAR_UNO_REFERENCE_HXX_
#include <com/sun/star/uno/Reference.hxx>
#endif
#ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_
#include <com/sun/star/uno/Sequence.hxx>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XNAMED_HPP_
#include <com/sun/star/container/XNamed.hpp>
#endif
#ifndef _COM_SUN_STAR_IO_XACTIVEDATASINK_HPP_
#include <com/sun/star/io/XActiveDataSink.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XDATACONTAINER_HPP_
#include <com/sun/star/ucb/XDataContainer.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif

#ifndef _CNTMBITM_HXX
#include "cntmbitm.hxx"
#endif
#ifndef _CNTSTGND_HXX
#include "cntstgnd.hxx"
#endif
#ifndef _CNTRNMGR_HXX
#include "cntrnmgr.hxx"
#endif
#ifndef _CHAOS_SEQISTRM_HXX
#include "seqistrm.hxx"
#endif

using namespace chaos;

/*=======================================================================
 *
 * CntMessageBodyItem Internals.
 *
 *=====================================================================*/
#define CNT_MESSAGEBODY_MAGIC ((ULONG)0x58190322)

namespace chaos {

class CntMessageBodyItemImp
{
	friend class CntMessageBodyItem;

	USHORT              nRefCnt;
	USHORT              eType;
	INetCoreNewsMessage *pMessage;
	String              aURL;

	void DeleteMessage (INetCoreNewsMessage *pMsg);

public:
	CntMessageBodyItemImp (void);
	~CntMessageBodyItemImp (void);

	int operator== (const CntMessageBodyItemImp& rOther);

	INetCoreNewsMessage *CloneMessage (
		const INetCoreNewsMessage& rMsg, inet::INetCoreMailer *pMailer);
	INetCoreNewsMessage *DetachChildren (
		INetCoreNewsMessage& rMsg, inet::INetCoreMailer *pMailer,
		bool bRecursive);

	SvStream& LoadMessage  (
		SvStream& rStrm, INetCoreNewsMessage& rMsg,
		inet::INetCoreMailer *pMailer);
	SvStream& StoreMessage (
		SvStream& rStrm, INetCoreNewsMessage& rMsg);
};

}

/*=======================================================================
 *
 * CntMessageBodyItem Implementation.
 *
 *=====================================================================*/
/*
 * CntMessageBodyItem.
 */
TYPEINIT1_AUTOFACTORY (CntMessageBodyItem, SfxPoolItem);

CntMessageBodyItem::CntMessageBodyItem (void)
	: SfxPoolItem (),
	  pImp        (new CntMessageBodyItemImp)
{
}

CntMessageBodyItem::CntMessageBodyItem (USHORT nWhich, const String& rURL)
	: SfxPoolItem (nWhich),
	  pImp        (new CntMessageBodyItemImp)
{
	pImp->aURL = rURL;
}

CntMessageBodyItem::CntMessageBodyItem (const CntMessageBodyItem& rOther)
	: SfxPoolItem (rOther.Which()),
	  pImp        (rOther.pImp)
{
	pImp->nRefCnt++;
}

/*
 * ~CntMessageBodyItem.
 */
CntMessageBodyItem::~CntMessageBodyItem (void)
{
	pImp->nRefCnt--;
	if (pImp->nRefCnt == 0) delete pImp;
}

/*
 * operator==
 */
int CntMessageBodyItem::operator== (const SfxPoolItem& rItem) const
{
	const CntMessageBodyItem& rOther = (const CntMessageBodyItem&)rItem;

	return ((pImp != rOther.pImp) ? (*pImp == *rOther.pImp) : TRUE);
}

/*
 * Clone.
 */
SfxPoolItem* CntMessageBodyItem::Clone (SfxItemPool *pPool) const
{
	return new CntMessageBodyItem (*this);
}

/*
 * Create.
 */
SfxPoolItem* CntMessageBodyItem::Create (
	SvStream& rStrm, USHORT nVersion) const
{
	// (NYI).
	return NULL;
}

/*
 * Store.
 */
SvStream& CntMessageBodyItem::Store (SvStream& rStrm, USHORT nVersion) const
{
	// (NYI).
	return rStrm;
}

/*
 * GetType.
 */
USHORT CntMessageBodyItem::GetType (void) const
{
	return pImp->eType;
}

/*
 * Get.
 */
INetCoreNewsMessage* CntMessageBodyItem::Get (void) const
{
	return pImp->pMessage;
}

/*
 * Get.
 */
INetCoreNewsMessage* CntMessageBodyItem::Get (
	CntStorageNode *pNode, inet::INetCoreMailer *pMailer, BOOL bStore)
{
	if ((pImp->pMessage == NULL) && (pNode != NULL) && (pMailer != NULL))
	{
		SvStream *pStream =	pNode->openStream (pImp->aURL, STREAM_READ);
		if (pStream == NULL) return NULL;

		// Load message type. Create appropriate message.
		*pStream >> pImp->eType;

		switch (pImp->eType)
		{
			case CNT_MESSAGEBODY_NEWS:
			case CNT_MESSAGEBODY_NEWS_DATA:
				pImp->pMessage = pMailer->CreateINetCoreNewsMessage();
				break;

			default: // Failure.
				pImp->eType = CNT_MESSAGEBODY_NONE;
				break;
		}

		// Load message.
		if (pImp->pMessage)
		{
			if (pImp->eType == CNT_MESSAGEBODY_NEWS_DATA)
			{
				String aDataURL;
				pStream->ReadByteString(aDataURL, RTL_TEXTENCODING_UTF8);
				*pStream >> *(pImp->pMessage);

				SvStream *pDataStream =
					pNode->openStream (aDataURL, STREAM_READ);

				if (pDataStream == NULL)
				{
					// Failure.
					delete (pImp->pMessage);
					pImp->pMessage = NULL;
					pImp->eType = CNT_MESSAGEBODY_NONE;
				}
				else
				{
					// Create Message from data.
					pImp->pMessage->SetDocumentStream (pDataStream);
					INetCoreNewsMessage *pNewMsg = pImp->DetachChildren (
						*(pImp->pMessage), pMailer, false);
					if (pNewMsg == pImp->pMessage)
					{
						SvCacheStream *pStrm = new SvCacheStream;

						*pStrm << *pDataStream;
						pImp->pMessage->SetDocumentStream (pStrm);
					}
					else
					{
						delete (pImp->pMessage);
						pImp->pMessage = pNewMsg;
					}

					// Cleanup and remove message data stream.
					delete pDataStream;
					pNode->remove (aDataURL);

					// Exchange message type.
					pImp->eType = CNT_MESSAGEBODY_NEWS;

					delete pStream;
					pStream = NULL;

					// Exchange body stream?
					if (bStore)
					{
						// Create new body stream.
						pNode->attrib (
							pImp->aURL, 0, CNTDIRENTRY_ATTRIB_HIDDEN |
							               CNTDIRENTRY_ATTRIB_CREATE);
						pStream = pNode->openStream (
							pImp->aURL, STREAM_READWRITE);

						// Store.
						*pStream << pImp->eType;
						pImp->StoreMessage (*pStream, *(pImp->pMessage));
					}
					else
					{
						// Remove body stream.
						pNode->remove (pImp->aURL);
					}
				}
			}
			else
			{
				pImp->LoadMessage (*pStream, *(pImp->pMessage), pMailer);
			}
		}

		// Done.
		delete pStream;
	}
	return pImp->pMessage;
}

/*
 * Set.
 */
BOOL CntMessageBodyItem::Set (INetCoreNewsMessage *pMsg)
{
	pImp->pMessage = pMsg;
	return TRUE;
}

/*
 * Set.
 */
BOOL CntMessageBodyItem::Set (
	INetCoreNewsMessage *pMsg, CntStorageNode *pNode)
{
	if (pMsg && pNode)
	{
		// Create hidden storage stream.
		pNode->attrib (pImp->aURL, 0, CNTDIRENTRY_ATTRIB_HIDDEN |
		                              CNTDIRENTRY_ATTRIB_CREATE);
		SvStream *pStream =	pNode->openStream (pImp->aURL, STREAM_READWRITE);
		if (pStream == NULL) return FALSE;

		// Store message type.
		pImp->eType = CNT_MESSAGEBODY_NEWS;
		*pStream << pImp->eType;

		// Store message.
		pImp->StoreMessage (*pStream, *pMsg);

		// Done.
		delete pStream;
	}
	pImp->pMessage = pMsg;
	return TRUE;
}

/*
 * LoadMessage (using CntMessageBodyItemImp::LoadMessage).
 */
SvStream& CntMessageBodyItem::LoadMessage (
	SvStream& rStrm, INetCoreNewsMessage& rMsg, inet::INetCoreMailer *pMailer)
{
	CntMessageBodyItemImp aImp;
	aImp.eType = CNT_MESSAGEBODY_NEWS;	// always load NewsMessage
 	return aImp.LoadMessage (rStrm, rMsg, pMailer);
}

/*
 * StoreMessage (using CntMessageBodyItemImp::StoreMessage).
 */
SvStream& CntMessageBodyItem::StoreMessage (
	SvStream& rStrm, INetCoreNewsMessage& rMsg)
{
	CntMessageBodyItemImp aImp;
	return aImp.StoreMessage (rStrm, rMsg);
}

/*
 * Helper function: ContentTypeToEnum_Impl.
 */
static
INetCoreMessageContainerType ContentTypeToEnum_Impl( const String& rType )
{
	INetCoreMessageContainerType eType;
	INetContentType eContentType;

	eContentType = INetContentTypes::GetContentType( rType );

	switch ( eContentType )
	{
		case CONTENT_TYPE_INET_MESSAGE_RFC822:
			eType = INETCOREMSG_MESSAGE_RFC822;
			break;
		case CONTENT_TYPE_INET_MULTIPART_ALTERNATIVE:
			eType = INETCOREMSG_MULTIPART_ALTERNATIVE;
			break;
		case CONTENT_TYPE_INET_MULTIPART_DIGEST:
			eType = INETCOREMSG_MULTIPART_DIGEST;
			break;
		case CONTENT_TYPE_INET_MULTIPART_PARALLEL:
			eType = INETCOREMSG_MULTIPART_PARALLEL;
			break;
		case CONTENT_TYPE_INET_MULTIPART_RELATED:
			eType = INETCOREMSG_MULTIPART_RELATED;
			break;
		case CONTENT_TYPE_INET_MULTIPART_MIXED:
			eType = INETCOREMSG_MULTIPART_MIXED;
			break;
		default:
			eType = INETCOREMSG_MULTIPART_MIXED;
	}

	return eType;
}

/*
 * Helper function: CreateXDataContainer_Impl.
 */
static com::sun::star::uno::Reference< com::sun::star::ucb::XDataContainer >
CreateXDataContainer_Impl(
	const INetCoreMIMEMessage* pMsg,
	const com::sun::star::uno::Reference<
				com::sun::star::lang::XMultiServiceFactory>& xMgr )
{
	if ( !pMsg || !xMgr.is() )
		return com::sun::star::uno::Reference<
					com::sun::star::ucb::XDataContainer >();

	com::sun::star::uno::Reference<
        com::sun::star::ucb::XDataContainer > xContainer(
			xMgr->createInstance(
				rtl::OUString::createFromAscii(
					"com.sun.star.ucb.DataContainer" ) ),
			com::sun::star::uno::UNO_QUERY );

	// Set content type.
	xContainer->setContentType( pMsg->GetContentType() );

    // Try to obtain filename from content description.
    rtl::OUString aDesc( pMsg->GetContentDescription() );
    if ( aDesc.getLength() )
    {
        sal_Int32 nPos
            = aDesc.indexOf( rtl::OUString::createFromAscii( "filename=\"" ) );
        if ( nPos != -1 )
        {
            sal_Int32 nStart = nPos + sizeof( "filename=\"" );
            sal_Int32 nEnd = aDesc.indexOf( '\"', nStart );
            if ( ( nEnd != -1 ) && ( nStart < nEnd ) )
            {
                rtl::OUString aFilename( aDesc.copy( nStart, nEnd - nStart ) );
                com::sun::star::uno::Reference<
                    com::sun::star::container::XNamed > xNamed(
                        xContainer, com::sun::star::uno::UNO_QUERY );
                if ( xNamed.is() )
                    xNamed->setName( aFilename );
            }
        }
    }

	// Set document stream.
	SvStream* pDocStrm = pMsg->GetDocumentStream();
	if ( pDocStrm )
	{
		ULONG nSize = pDocStrm->Seek( STREAM_SEEK_TO_END );
		sal_Int8* pBuf = new sal_Int8[ nSize ];

		pDocStrm->Seek( STREAM_SEEK_TO_BEGIN );
		pDocStrm->Read( pBuf, nSize );

		com::sun::star::uno::Sequence< sal_Int8 > aSeq( pBuf, nSize );

		// Optional data sink interface supported?
		com::sun::star::uno::Reference<
			com::sun::star::io::XActiveDataSink > xDataSink(
				xContainer, com::sun::star::uno::UNO_QUERY );
		if ( xDataSink.is() )
			xDataSink->setInputStream( new SequenceInputStream( aSeq ) );
		else
			xContainer->setData( aSeq );

		delete [] pBuf;
	}

	// Create Children.
	ULONG nCount = pMsg->GetChildCount();
	for ( ULONG n = 0; n < nCount; ++n )
	{
		com::sun::star::uno::Reference<
			com::sun::star::ucb::XDataContainer > xChild =
				CreateXDataContainer_Impl( pMsg->GetChild( n ), xMgr );

		com::sun::star::uno::Any aAny;
		aAny <<= xChild;
		xContainer->insertByIndex( n, aAny );
	}

	return xContainer;
}

/*
 * QueryValue.
 */
BOOL CntMessageBodyItem::QueryValue( com::sun::star::uno::Any& rVal,
							 	  	 BYTE nMemberId ) const
{
	com::sun::star::uno::Reference<
				com::sun::star::lang::XMultiServiceFactory >
						xMgr( CntRootNodeMgr::getProcessServiceManager() );
	if ( !xMgr.is() )
		return FALSE;

	try
	{
		com::sun::star::uno::Reference<
			com::sun::star::ucb::XDataContainer > xContainer =
					CreateXDataContainer_Impl( pImp->pMessage, xMgr );
		rVal <<= xContainer;
	}
	catch ( ... )
	{
		return FALSE;
	}

	return TRUE;
}

/*
 * Helper function: CreateINetMessage_Impl.
 */
static INetCoreNewsMessage* CreateINetMessage_Impl(
			const com::sun::star::uno::Reference<
					com::sun::star::ucb::XDataContainer >& rxContainer,
			const inet::INetCoreMailer* pMailer )
{
	if ( !pMailer || !rxContainer.is() )
		return NULL;

	INetCoreNewsMessage* pMsg = pMailer->CreateINetCoreNewsMessage();

	// Set document stream.

	// Optional data sink interface supported?
	sal_Bool bStream = sal_False;
	com::sun::star::uno::Reference<
		com::sun::star::io::XActiveDataSink > xDataSink(
			rxContainer, com::sun::star::uno::UNO_QUERY );
	if ( xDataSink.is() )
	{
		com::sun::star::uno::Reference<
			com::sun::star::io::XInputStream > xStream
				= xDataSink->getInputStream();
		if ( xStream.is() )
		{
			com::sun::star::uno::Reference<
				com::sun::star::io:: XSeekable >
					xSeekable( xStream, com::sun::star::uno::UNO_QUERY );
			if ( xSeekable.is() )
			{
				SvInputStream* pStream = new SvInputStream( xStream );
				pMsg->SetDocumentStream( pStream );
				bStream = sal_True;
			}
		}
	}

	if ( !bStream )
	{
		rtl::OUString aDataPath = rxContainer->getDataURL();
		if ( aDataPath.getLength() )
		{
			// Convert URL to system dependent path.
    		osl::FileBase::getSystemPathFromFileURL( aDataPath, aDataPath );
			SvFileStream* pStream
				= new SvFileStream( aDataPath, STREAM_STD_READ );
			pMsg->SetDocumentStream( pStream );
		}
		else
		{
			com::sun::star::uno::Sequence< sal_Int8 > aSeq
				= rxContainer->getData();
			if ( aSeq.getLength() )
			{
				SvCacheStream* pStream = new SvCacheStream;
				pStream->Write( (void*)aSeq.getArray(), aSeq.getLength() );
				pMsg->SetDocumentStream( pStream );
			}
		}
	}

	sal_uInt32 nCount = rxContainer->getCount();

	// Set content type.
	if ( nCount )
		pMsg->EnableAttachChild( ContentTypeToEnum_Impl(
			rxContainer->getContentType() ) );
	else
		pMsg->SetContentType( rxContainer->getContentType() );

    // Set filename, if given.
	com::sun::star::uno::Reference<
        com::sun::star::container::XNamed > xNamed(
			rxContainer, com::sun::star::uno::UNO_QUERY );
    if ( xNamed.is() )
    {
        rtl::OUString aFilename( xNamed->getName() );
        if (  aFilename.getLength() )
        {
            // Set attachment filename.
            UniString aDesc( UniString::CreateFromAscii(
                                RTL_CONSTASCII_STRINGPARAM( "filename=\"" ) ) );
            aDesc += UniString( aFilename );
            aDesc += '\"';
            pMsg->SetContentDescription( aDesc );
        }
    }

	// Create Children.
	for ( sal_uInt32 n = 0; n < nCount; ++n )
	{
		com::sun::star::uno::Any aAny = rxContainer->getByIndex( n );
		com::sun::star::uno::Reference<
					com::sun::star::ucb::XDataContainer > xChild;
		if ( !( aAny >>= xChild  ) )
		{
			DBG_ERROR( "CreateINetMessage_Impl - Wrong type!" );
			continue;
		}

		INetCoreNewsMessage* pChild = CreateINetMessage_Impl( xChild, pMailer );
		pMsg->AttachChild( *pChild );
	}

	return pMsg;
}

/*
 * PutValue.
 */
BOOL CntMessageBodyItem::PutValue( const com::sun::star::uno::Any& rVal,
						   		BYTE nMemberId )
{
	com::sun::star::uno::Reference<
					com::sun::star::ucb::XDataContainer >	xContainer;
	if ( rVal >>= xContainer )
	{
		inet::INetWrapper* pWrapper = NULL;
		if ( !CNT_RNM()->getINetWrapper( pWrapper ) )
			return FALSE;

		inet::INetCoreMailer* pMailer = NULL;
		if ( !pWrapper->newINetCoreMailer( pMailer ) )
			return FALSE;

		CntMessageBodyItemImp* pNewImp = new CntMessageBodyItemImp;

		try
		{
			pNewImp->pMessage = CreateINetMessage_Impl( xContainer, pMailer);
		}
		catch ( ... )
		{
			delete pNewImp;
			delete pMailer;
			return FALSE;
		}

		pImp->nRefCnt--;
		if ( pImp->nRefCnt == 0 )
			delete pImp;

		pImp = pNewImp;
		delete pMailer;
		return TRUE;
	}

	DBG_ERROR( "CntMessageBodyItem::PutValue - Wrong type!" );
	return FALSE;
}

/*=======================================================================
 *
 * CntMessageBodyItemImp Implementation.
 *
 *=====================================================================*/
/*
 * CntMessageBodyItemImp.
 */
CntMessageBodyItemImp::CntMessageBodyItemImp (void)
	: nRefCnt  (1),
	  eType    (CNT_MESSAGEBODY_NONE),
	  pMessage (NULL)
{
}

/*
 * ~CntMessageBodyItemImp.
 */
CntMessageBodyItemImp::~CntMessageBodyItemImp (void)
{
	DBG_ASSERT ((nRefCnt < 0xffff), "pImp already deleted");
	DeleteMessage (pMessage);

	nRefCnt  = 0xffff;
	eType    = CNT_MESSAGEBODY_NONE;
	pMessage = NULL;
}

/*
 * operator==
 */
int CntMessageBodyItemImp::operator== (const CntMessageBodyItemImp& rOther)
{
	return ((eType    == rOther.eType   ) &&
			(aURL     == rOther.aURL    ) &&
			(pMessage == rOther.pMessage)    );
}

/*
 * DeleteMessage.
 */
void CntMessageBodyItemImp::DeleteMessage (INetCoreNewsMessage *pMsg)
{
	if (pMsg)
	{
		SvStream *pStream = pMsg->GetDocumentStream();
		if (pStream) delete pStream;

		ULONG nCount = pMsg->GetChildCount();
		for (ULONG i = 0; i < nCount; i++)
			DeleteMessage ((INetCoreNewsMessage *)(pMsg->GetChild (i)));

		delete pMsg;
	}
}

/*
 * CloneMessage.
 */
INetCoreNewsMessage *CntMessageBodyItemImp::CloneMessage (
	const INetCoreNewsMessage& rMsg, inet::INetCoreMailer *pMailer)
{
	INetCoreNewsMessage *pNewMsg =
		pMailer->CreateINetCoreNewsMessage();

	SvMemoryStream aStrm;
	aStrm << rMsg;
	aStrm.Seek (STREAM_SEEK_TO_BEGIN);
	aStrm >> *pNewMsg;
	pNewMsg->SetDocumentStream (NULL);

	return pNewMsg;
}

/*
 * DetachChildren.
 */
INetCoreNewsMessage *CntMessageBodyItemImp::DetachChildren (
	INetCoreNewsMessage& rMsg, inet::INetCoreMailer *pMailer, bool bRecursive)
{
	INetCoreNewsMessage *pNewMsg = &rMsg;
	if (rMsg.IsContainer())
	{
		// Clone container.
		pNewMsg = CloneMessage (rMsg, pMailer);

		// Detach children.
		ULONG nCount = rMsg.GetChildCount();
		for (ULONG i = 0; i < nCount; i++)
		{
			// Create child message.
			INetCoreNewsMessage *pChild =
				pMailer->CreateINetCoreNewsMessage();

			// Create child stream.
			SvCacheStream *pChildStrm = new SvCacheStream;
			pChild->SetDocumentStream (pChildStrm);

			// Detach child message.
			rMsg.DetachChild (i, *pChild);
			pChildStrm->Seek (STREAM_SEEK_TO_BEGIN);

			// Check for grand-children.
			INetCoreNewsMessage *pNewChild =
				DetachChildren (*pChild, pMailer, true);
			if (pNewChild != pChild)
			{
				// Cleanup pChild (replaced by pNewChild).
				delete pChild;
			}

			// Attach new child.
			pNewMsg->AttachChild (*pNewChild);
		}

		// Cleanup parent stream (if not toplevel storage).
		if (bRecursive)
		{
			SvStream *pParentStrm = rMsg.GetDocumentStream();
			delete pParentStrm;
		}
		rMsg.SetDocumentStream (NULL);
	}
	return pNewMsg;
}

/*
 * INetCoreNewsMessage::LoadMessage().
 */
SvStream& CntMessageBodyItemImp::LoadMessage (
	SvStream& rStrm, INetCoreNewsMessage& rMsg, inet::INetCoreMailer *pMailer)
{
	// Load message header.
	ULONG nMagic = 0;
	rStrm >> nMagic;

	DBG_ASSERT ((nMagic == CNT_MESSAGEBODY_MAGIC), "Magic number mismatch");
	if (!(nMagic == CNT_MESSAGEBODY_MAGIC))
		return rStrm;

	rStrm >> rMsg;

	// Load document size.
	nMagic = 0;
	rStrm >> nMagic;

	DBG_ASSERT ((nMagic == CNT_MESSAGEBODY_MAGIC), "Magic number mismatch");
	if (!(nMagic == CNT_MESSAGEBODY_MAGIC))
		return rStrm;

	ULONG nDocSiz = 0;
	rStrm >> nDocSiz;
	rMsg.SetDocumentSize (nDocSiz);

	// Load message document.
	if (nDocSiz > 0)
	{
		SvCacheStream *pStrm = new SvCacheStream;

		char  pBuffer[2048];
		ULONG nBufSiz = sizeof (pBuffer);
		ULONG nRead   = 0;

		while ((nRead = rStrm.Read (
			pBuffer, (nDocSiz > nBufSiz) ? nBufSiz : nDocSiz)) > 0)
			nDocSiz -= pStrm->Write (pBuffer, nRead);

		pStrm->Seek (STREAM_SEEK_TO_BEGIN);
		rMsg.SetDocumentStream (pStrm);
	}

	// Load children.
	ULONG nChildren = rMsg.GetChildCount();
	for (ULONG i = 0; i < nChildren; i++)
	{
		INetCoreNewsMessage *pChild = NULL;
		if (eType == CNT_MESSAGEBODY_NEWS)
			pChild = pMailer->CreateINetCoreNewsMessage();

		if (pChild)
		{
			LoadMessage (rStrm, *pChild, pMailer);
			rMsg.AttachChild (*pChild);
		}
	}

	// Done.
	return rStrm;
}

/*
 * INetCoreNewsMessage::StoreMessage().
 */
SvStream& CntMessageBodyItemImp::StoreMessage (
	SvStream& rStrm, INetCoreNewsMessage& rMsg)
{
	// Determine and set correct document size.
	ULONG nDocSiz = 0;
	SvStream *pDocStrm = rMsg.GetDocumentStream();
	if (pDocStrm)
	{
		pDocStrm->Seek (STREAM_SEEK_TO_END);
		nDocSiz = pDocStrm->Tell();
		pDocStrm->Seek (STREAM_SEEK_TO_BEGIN);
	}
	rMsg.SetDocumentSize (nDocSiz);

	// Store message header.
	rStrm << CNT_MESSAGEBODY_MAGIC; // Magic!
	rStrm << rMsg;

	// Store message document.
	rStrm << CNT_MESSAGEBODY_MAGIC; // Magic!
	rStrm << nDocSiz;
	if (pDocStrm) rStrm << *pDocStrm;

	// Store children.
	ULONG nChildren = rMsg.GetChildCount();
	for (ULONG i = 0; i < nChildren; i++)
	{
		INetCoreNewsMessage *pChild =
			(INetCoreNewsMessage *)(rMsg.GetChild (i));
		if (pChild) StoreMessage (rStrm, *pChild);
	}

	// Done.
	return rStrm;
}

