/*************************************************************************
 *
 *  $RCSfile: cntcook.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: kso $ $Date: 2001/07/25 15:09:44 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#define _CNTCOOK_CXX "$Revision: 1.2 $"

#ifndef _SOLAR_H
#include <tools/solar.h>
#endif

#ifndef _DATETIME_HXX
#include <tools/datetime.hxx>
#endif

#ifndef _LIST_HXX
#include <tools/list.hxx>
#endif

#ifndef _STRING_HXX
#include <tools/string.hxx>
#endif

#ifndef _STREAM_HXX
#include <tools/stream.hxx>
#endif

#ifndef _URLOBJ_HXX
#include <tools/urlobj.hxx>
#endif

#ifndef _SFXPOOLITEM_HXX
#include <svtools/poolitem.hxx>
#endif

#ifndef _CNTCOOK_HXX
#include "cntcook.hxx"
#endif

using namespace chaos;

/*=======================================================================
 *
 * CntHTTPCookie internals.
 *
 *=====================================================================*/
#define CNTCOOK_IS_INTERACTIVE(a) \
	((a) == CNTHTTP_COOKIE_POLICY_INTERACTIVE)

#define CNTCOOK_IS_ACCEPTED(a) \
    (((a) & CNTHTTP_COOKIE_POLICY_ACCEPTED) > 0)

#define CNTCOOK_IS_BANNED(a) \
	(((a) & CNTHTTP_COOKIE_POLICY_BANNED  ) > 0)

#define CNTCOOK_IS_DOMAIN(a) \
	(((a) & CNTHTTP_COOKIE_DOMAIN_POLICY  ) > 0)

/*=======================================================================
 *
 * CntHTTPCookieList implementation.
 *
 *=====================================================================*/
/*
 * ~CntHTTPCookieList.
 */
CntHTTPCookieList::~CntHTTPCookieList (void)
{
	Clear();
}

/*
 * Clear.
 */
void CntHTTPCookieList::Clear (void)
{
	ULONG i = 0, n = Count();
	while (i < n)
		delete GetObject(i++);
	List::Clear();
}

/*
 * operator==
 */
BOOL CntHTTPCookieList::operator== (const CntHTTPCookieList& rOther)
{
	if (!(Count() == rOther.Count()))
		return FALSE;

	for (ULONG i = 0; i < Count(); i++)
		if (!(GetObject(i) == rOther.GetObject(i))) return FALSE;

	return TRUE;
}

/*
 * write.
 */
void CntHTTPCookieList::write (SvStream& rStrm) const
{
	DateTime aNow;
	ULONG    i, n;

	for (i = 0, n = 0; i < Count(); i++)
	{
		CntHTTPCookie *pCookie = GetObject(i);
		if (pCookie->m_aExpires > aNow) n++;
	}
	rStrm << n;

	for (i = 0; i < Count(); i++)
	{
		CntHTTPCookie *pCookie = GetObject(i);
		if (pCookie->m_aExpires > aNow)
			pCookie->write(rStrm);
	}
}

/*
 * read.
 */
void CntHTTPCookieList::read (SvStream& rStrm, bool bUnicode)
{
	Clear();

	ULONG n = 0;
	rStrm >> n;

	for (ULONG i = 0; i < n; i++)
	{
		CntHTTPCookie *pCookie = new CntHTTPCookie();
		pCookie->read(rStrm, bUnicode);
		Insert (pCookie, LIST_APPEND);
	}
}

/*=======================================================================
 *
 * CntHTTPCookieManager implementation.
 *
 *=====================================================================*/
/*
 * getCookie.
 */
void CntHTTPCookieManager::getCookie (
	CntHTTPCookiePolicy& rPolicy,
	const String&        rUrl,
	List&                rUsageList)
{
	rUsageList.Clear();
	if (CNTCOOK_IS_BANNED (m_nGeneralPolicy))
		return;
	if (m_xCookieList->Count() == 0)
		return;

	INetURLObject aURL (rUrl);
	String aUrlHost (aURL.GetHost());
	String aUrlPath (aURL.GetURLPath());

	aUrlHost.Reverse();

	List aQueryList;
	ULONG i = 0, n = m_xCookieList->Count();
	while (i < n)
	{
		CntHTTPCookie *pCookie = m_xCookieList->GetObject(i++);
		if (CNTCOOK_IS_BANNED (pCookie->m_nPolicy))
			continue;

		String aDomain (pCookie->m_aDomain);
		aDomain.Reverse();
		if (aUrlHost.CompareIgnoreCaseToAscii (aDomain, aDomain.Len())
			    != COMPARE_EQUAL)
			continue;

		String aPath (pCookie->m_aPath);
		if (aUrlPath.CompareTo (aPath, aPath.Len()) != COMPARE_EQUAL)
			continue;

		if (CNTCOOK_IS_INTERACTIVE (pCookie->m_nPolicy))
			aQueryList.Insert (pCookie, LIST_APPEND);
		else
			rUsageList.Insert (pCookie, LIST_APPEND);
	}

	if (rPolicy.shouldUseCookie (rUrl, aQueryList))
	{
		for (i = 0; i < aQueryList.Count(); i++)
			rUsageList.Insert (aQueryList.GetObject(i), LIST_APPEND);
	}
	aQueryList.Clear();
}

/*
 * setCookie.
 */
void CntHTTPCookieManager::setCookie (
	CntHTTPCookiePolicy& rPolicy,
	const String&        rUrl,
	List&                rList)
{
	ULONG i, k, n = rList.Count();
	if (n == 0)
		return;

	if (CNTCOOK_IS_BANNED (m_nGeneralPolicy))
	{
		for (i = 0; i < rList.Count(); i++)
			delete ((CntHTTPCookie *)(rList.GetObject(i)));
		rList.Clear();
		return;
	}

	INetURLObject aURL (rUrl);
	String aHost (aURL.GetHost());
	aHost.Reverse();

	List aQueryList;
	for (i = 0; i < rList.Count(); i++)
	{
		CntHTTPCookie *pCookie = (CntHTTPCookie *)rList.GetObject(i);
		for (k = 0; k < m_xCookieList->Count(); k++)
		{
			CntHTTPCookie *pKnownCookie = m_xCookieList->GetObject(k);

#if 0  /* EXP */

			if (CNTCOOK_IS_DOMAIN (pKnownCookie->m_nPolicy))
			{
				String aDomain (pKnownCookie->m_aDomain);
				aDomain.Reverse();
				if (aHost.ICompare (aDomain, aDomain.Len()) != COMPARE_EQUAL)
					continue;

				if (CNTCOOK_IS_ACCEPTED (pKnownCookie->m_nPolicy))
					pCookie->m_nPolicy = CNTHTTP_COOKIE_POLICY_ACCEPTED;
				else
					pCookie->m_nPolicy = CNTHTTP_COOKIE_POLICY_BANNED;

				delete (m_xCookieList->Remove(k));
				k = m_xCookieList->Count() - 1;
			}

#endif /* EXP */

			if (pCookie->replaces (*pKnownCookie))
			{
				pCookie->m_nPolicy = pKnownCookie->m_nPolicy;
				delete (m_xCookieList->Remove(k));
				k = m_xCookieList->Count() - 1;
			}
		}

		if (k == m_xCookieList->Count())
		{
			if (!(pCookie->m_aExpires.IsValid()))
				pCookie->m_nPolicy = CNTHTTP_COOKIE_POLICY_ACCEPTED;

			if (CNTCOOK_IS_INTERACTIVE (pCookie->m_nPolicy))
				pCookie->m_nPolicy = m_nGeneralPolicy;

			if (CNTCOOK_IS_INTERACTIVE (pCookie->m_nPolicy))
				aQueryList.Insert (pCookie, LIST_APPEND);
			else
				m_xCookieList->Insert (pCookie, LIST_APPEND);
		}
	}

	if (rPolicy.shouldAcceptCookie (rUrl, aQueryList))
	{
		for (i = 0; i < aQueryList.Count(); i++)
		{
			CntHTTPCookie *pCookie = (CntHTTPCookie *)aQueryList.GetObject(i);
			if (CNTCOOK_IS_DOMAIN (pCookie->m_nPolicy))
			{
#if 0   /* EXP */
				CntHTTPCookie *pDomainCookie = new CntHTTPCookie;

				pDomainCookie->m_aDomain  = pCookie->m_aDomain;
				pDomainCookie->m_nFlags   = pCookie->m_nFlags;
				pDomainCookie->m_nPolicy  = pCookie->m_nPolicy;
				pDomainCookie->m_aExpires = DateTime (Date(~0), Time(~0));

				m_xCookieList->Insert (pDomainCookie, LIST_APPEND);
				pCookie->m_nPolicy &= ~CNTHTTP_COOKIE_DOMAIN_POLICY;
#endif  /* EXP */
			}
			m_xCookieList->Insert (pCookie, LIST_APPEND);
		}
		aQueryList.Clear();
	}

	for (i = 0; i < aQueryList.Count(); i++)
		delete ((CntHTTPCookie *)(aQueryList.GetObject(i)));
	aQueryList.Clear();
}

/*=======================================================================
 *
 * CntHTTPCookieManagerItem implementation.
 *
 *=====================================================================*/
/*
 * CntHTTPCookieManagerItem.
 */
TYPEINIT1_AUTOFACTORY (CntHTTPCookieManagerItem, SfxPoolItem);

CntHTTPCookieManagerItem::CntHTTPCookieManagerItem (
	USHORT nId, CntHTTPCookieManager *pCookieMgr)
	: SfxPoolItem (nId)
{
	if (pCookieMgr == NULL)
		pCookieMgr = new CntHTTPCookieManager();
	m_xCookieMgr = pCookieMgr;
}

CntHTTPCookieManagerItem::CntHTTPCookieManagerItem (
	USHORT nId, SvStream& rStrm, USHORT nVersion)
	: SfxPoolItem (nId)
{
	m_xCookieMgr = new CntHTTPCookieManager();
	m_xCookieMgr->read(rStrm, nVersion >= 1);
}

/*
 * operator==
 */
int CntHTTPCookieManagerItem::operator== (
	const SfxPoolItem& rItem) const
{
	const CntHTTPCookieManagerItem& rOther =
		(const CntHTTPCookieManagerItem&)rItem;

	return (*m_xCookieMgr == *rOther.m_xCookieMgr);
}

/*
 * GetVersion.
 */
USHORT CntHTTPCookieManagerItem::GetVersion (USHORT) const
{
	return 1; // because it uses SfxPoolItem::read/writeUnicodeString()
}

/*
 * Clone.
 */
SfxPoolItem* CntHTTPCookieManagerItem::Clone (SfxItemPool *pPool) const
{
	return new CntHTTPCookieManagerItem (*this);
}

/*
 * Create.
 */
SfxPoolItem* CntHTTPCookieManagerItem::Create (
	SvStream& rStrm, USHORT nVersion) const
{
	return new CntHTTPCookieManagerItem (Which(), rStrm, nVersion);
}

/*
 * Store.
 */
SvStream& CntHTTPCookieManagerItem::Store (
	SvStream& rStrm, USHORT nVersion) const
{
	m_xCookieMgr->write(rStrm);
	return rStrm;
}

/*=======================================================================
 *
 * CntHTTPCookieHint implementation.
 *
 *=====================================================================*/
TYPEINIT1 (CntHTTPCookieHint, SfxHint);

