/*************************************************************************
 *
 *  $RCSfile: alstitem.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: kso $ $Date: 2001/07/25 15:09:44 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _STREAM_HXX //autogen
#include <tools/stream.hxx>
#endif

#ifndef _CNTPOOL_HXX
#include <cntpool.hxx>
#endif

#define _ULSTITEM_CXX
#include <alstitem.hxx>

using namespace chaos;

//-------------------------------------------------------------------------

TYPEINIT1_AUTOFACTORY(CntActionListItem, SfxPoolItem);

//=========================================================================

CntActionListItem::CntActionListItem( USHORT nWhich )
:	SfxPoolItem(nWhich),
	_pActions(NULL)
{
}

//-------------------------------------------------------------------------

CntActionListItem::CntActionListItem( USHORT nWhich, SvStream &rStream,
									  USHORT nVersion )
:	SfxPoolItem( nWhich ),
	_pActions(NULL)
{
	USHORT nCount = 0;
	rStream >> nCount;
	for ( USHORT n = 0; n < nCount; ++n )
	{
		USHORT nUShort;
		String aString;
		rStream >> nUShort;
		readUnicodeString(rStream, aString, nVersion >= 1);
		Append( (CntNodeAction) nUShort, aString );
	}
}

//-------------------------------------------------------------------------

CntActionListItem::CntActionListItem( const CntActionListItem &rOrig )
:	SfxPoolItem( rOrig ),
	_pActions(NULL)
{
	CntActionListEntry *pItem;

	if ( rOrig._pActions )
	{
		pItem = rOrig._pActions->First();

		while( pItem )
		{
			Append( pItem->_eAction, pItem->_aParameter );
			pItem = rOrig._pActions->Next();
		}
	}
}

//-------------------------------------------------------------------------

CntActionListItem::~CntActionListItem()
{
	if ( _pActions )
	{
		CntActionListEntry *pItem = _pActions->First();

		while( pItem )
		{
			delete pItem;
			pItem = _pActions->Next();
		}

		delete _pActions;
	}
}

//============================================================================
// virtual
USHORT CntActionListItem::GetVersion(USHORT) const
{
	return 1; // because it uses SfxPoolItem::read/writeUnicodeString()
}

//-------------------------------------------------------------------------

int CntActionListItem::operator==( const SfxPoolItem &rItem ) const
{
	ActionList *pOther = ((const CntActionListItem&)rItem)._pActions;

	if ( ( _pActions == NULL ) && ( pOther == NULL ) )
		return TRUE;
	else if ( ! _pActions || ! pOther )
		return FALSE;
	else if ( _pActions->Count() != pOther->Count() )
		return FALSE;

	CntActionListEntry *pFirst, *pSecond;

	pFirst = _pActions->First();
	pSecond = pOther->First();

	while ( pFirst )
	{
		if ( pFirst->Compare( *pSecond ) != 0 )
			return FALSE;

		pFirst = _pActions->Next();
		pSecond = pOther->Next();
	}

	return TRUE;
}

//-------------------------------------------------------------------------

SfxPoolItem* CntActionListItem::Create(SvStream &rStream, USHORT nItemVersion) const
{
	return new CntActionListItem( Which(), rStream, nItemVersion );
}

//-------------------------------------------------------------------------

SvStream& CntActionListItem::Store(SvStream &rStream, USHORT nItemVersion ) const
{
	if ( _pActions )
	{
		rStream << (USHORT) _pActions->Count();
		CntActionListEntry *pEntry = _pActions->First();

		while ( pEntry )
		{
			rStream << (USHORT) pEntry->_eAction;
			writeUnicodeString(rStream, pEntry->_aParameter);
			pEntry = _pActions->Next();
		}
	}
	else
		rStream << (USHORT) 0;

	return rStream;
}

//-------------------------------------------------------------------------

SfxPoolItem* CntActionListItem::Clone( SfxItemPool *pPool ) const
{
	return new CntActionListItem( *this );
}

//-------------------------------------------------------------------------

void CntActionListItem::Append( CntNodeAction eAction,
								const String &rParameter )
{
	CntActionListEntry *pEntry = new CntActionListEntry;

	pEntry->_eAction = eAction;
	pEntry->_aParameter = rParameter;

	if ( !_pActions )
		_pActions = new ActionList( 16, 16 );

	_pActions->Insert( pEntry, CONTAINER_APPEND );
}

//-------------------------------------------------------------------------

BOOL CntActionListItem::Check( CntNodeAction eAction,
							   const String &rParameter ) const
{
	BOOL bFound = FALSE;

	if ( !_pActions || ! _pActions->Count() )
		return bFound;

	CntActionListEntry aData;

	aData._eAction = eAction;
	aData._aParameter = rParameter;

	long nStart = 0;
	long nEnd = _pActions->Count() - 1;
	long nMid = nEnd / 2;

	int nCompVal = 1;

	while ( nCompVal && ( nStart <= nEnd ) )
	{
		nMid = ( nEnd - nStart ) / 2 + nStart;
		CntActionListEntry* pMid = (CntActionListEntry*)_pActions->GetObject( nMid );

		nCompVal = pMid->Compare( aData );

        if ( nCompVal < 0 )		// pMid < pData
			nEnd = nMid - 1;
		else
			nStart = nMid + 1;
	}

	if ( nCompVal == 0 )
		bFound = TRUE;

	return bFound;
}

//-------------------------------------------------------------------------

BOOL CntActionListItem::Insert( CntNodeAction eAction,
								const String &rParameter )
{
	BOOL bRet = TRUE;

	if ( !_pActions || ! _pActions->Count() )
	{
		Append( eAction, rParameter );
		return bRet;
	}

	CntActionListEntry aData;

	aData._eAction = eAction;
	aData._aParameter = rParameter;

	long nStart = 0;
	long nEnd = _pActions->Count() - 1;
	long nMid = nEnd / 2;

	int nCompVal = 1;

	while ( nCompVal && ( nStart <= nEnd ) )
	{
		nMid = ( nEnd - nStart ) / 2 + nStart;
		CntActionListEntry* pMid = (CntActionListEntry*)_pActions->GetObject( nMid );

		nCompVal = pMid->Compare( aData );

        if ( nCompVal < 0 )		// pMid < pData
			nEnd = nMid - 1;
		else
			nStart = nMid + 1;
	}

	if ( nCompVal != 0 )
	{
		CntActionListEntry* pData = new CntActionListEntry;

		pData->_eAction = eAction;
		pData->_aParameter = rParameter;

		if ( nCompVal < 0 )			// pMid < pData
			_pActions->Insert( pData, nMid + 1 );
		else
			_pActions->Insert( pData, nMid );
	}
	else
		bRet = FALSE;

	return bRet;
}

//----------------------------------------------------------------------------
// virtual
BOOL CntActionListItem::PutValue( const com::sun::star::uno::Any& rVal,
						   		  BYTE nMemberId )
{
	DBG_ERROR( "CntActionListItem::PutValue - Not implemented" );
	return FALSE;
}

//----------------------------------------------------------------------------
// virtual
BOOL CntActionListItem::QueryValue( com::sun::star::uno::Any& rVal,
							 	  	BYTE nMemberId ) const
{
	DBG_ERROR( "CntActionListItem::QueryValue - Not implemented" );
	return FALSE;
}

//----------------------------------------------------------------------------

int CntActionListEntry::Compare( const CntActionListEntry& rOther ) const
{
	if ( _eAction == rOther._eAction )
	{
		StringCompare eCompare = _aParameter.CompareTo( rOther._aParameter );

		if ( eCompare == COMPARE_EQUAL )
			return 0;
		else if ( eCompare == COMPARE_LESS )
			return -1;
		else return 1;
	}
	else if ( (USHORT) _eAction < (USHORT) rOther._eAction )
		return -1;
	else
		return 1;
}

