/*************************************************************************
 *
 *  $RCSfile: storitem.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: mhu $ $Date: 2001/07/25 13:04:52 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _CHAOS_STORITEM_HXX
#define _CHAOS_STORITEM_HXX "$Revision: 1.2 $"

#ifndef _SOLAR_H
#include <tools/solar.h>
#endif

#ifndef _ERRCODE_HXX
#include <tools/errcode.hxx>
#endif

#ifndef _REF_HXX
#include <tools/ref.hxx>
#endif

#ifndef _STREAM_HXX
#include <tools/stream.hxx>
#endif

#ifndef _SFXITEMSET_HXX
#include <svtools/itemset.hxx>
#endif

class SfxPoolItem;
class SfxItemPool;

namespace chaos
{

/*========================================================================
 *
 * CntStoreItemSetRef interface.
 *
 *======================================================================*/
#ifndef _CHAOS_STORITEM_REF
#define _CHAOS_STORITEM_REF

class CntStoreItemSet;
SV_DECL_REF(CntStoreItemSet)

#endif /* !_CHAOS_STORITEM_REF */

/*========================================================================
 *
 * CntStoreItemSet interface.
 *
 *======================================================================*/
class CntStoreItemSet :
	public SfxItemSet,
	public SvRefBase
{
	/** Representation.
	*/
	SvLockBytesRef m_xLockBytes;
	BOOL           m_bChanged : 1;

#ifdef _CHAOS_STORITEM_CXX
	/** Construction.
	*/
	CntStoreItemSet (
		SfxItemPool& rPool)
		: SfxItemSet   (rPool, rPool.GetFrozenIdRanges()),
		  m_xLockBytes (NULL),
		  m_bChanged   (FALSE)
	{}

	CntStoreItemSet (
		SfxItemPool& rPool,
		const USHORT *pWhichPairTable)
		: SfxItemSet   (rPool, pWhichPairTable),
		  m_xLockBytes (NULL),
		  m_bChanged   (FALSE)
	{}

	/** Initialization (two-phase construction).
	*/
	ErrCode initialize (
		SvLockBytes *pLockBytes,
		StreamMode   eMode);

#endif /* _CHAOS_STORITEM_CXX */

	/** Changed.
	*/
	virtual void Changed (
		const SfxPoolItem &, const SfxPoolItem &);

	/** Not implemented.
	*/
	CntStoreItemSet (const CntStoreItemSet& rOther);
	CntStoreItemSet& operator= (const CntStoreItemSet& rOther);

protected:
	/** Destruction (SvRefBase).
	*/
	virtual ~CntStoreItemSet (void);

public:
	/** createItemSet (from LockBytes and Pool).
	*/
	static ErrCode createItemSet (
		CntStoreItemSet *&rpItemSet,
		SvLockBytes      *pLockBytes,
		StreamMode        eMode,
		SfxItemPool      &rPool,
		const USHORT     *pWhichPairTable = NULL);

	/** loadItemSet (from LockBytes and Pool).
	*/
	static ErrCode loadItemSet (
		SfxItemSet  &rItemSet,
		SvLockBytes &rLockBytes);
};

} // namespace chaos

#endif /* !_CHAOS_STORITEM_HXX */

