/*************************************************************************
 *
 *  $RCSfile: ipositem.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: kso $ $Date: 2001/07/25 15:09:42 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _IPOSITEM_HXX
#define _IPOSITEM_HXX

#define _SVSTDARR_STRINGS

#ifndef _SFXPOOLITEM_HXX
#include <svtools/poolitem.hxx>
#endif
#ifndef _GEN_HXX
#include <tools/gen.hxx>
#endif
#ifndef _STRING_HXX //autogen
#include <tools/string.hxx>
#endif

#include <svtools/svstdarr.hxx>

class SvStream;

namespace chaos {

struct CntIconPosList_Impl;

#define ICONPOS_FLAG_LOCKED			0x01
#define ICONPOS_FLAG_PREDECESSOR	0x02
#define ICONPOS_FLAG_CRC32			0x04

class CntIconPosListEntry : public String
{
public:
	Point			_aPos;
	unsigned char	_nFlags;

					CntIconPosListEntry( const String& rStr) :
						String( rStr ) { _nFlags = 0; }
					CntIconPosListEntry(
						const String& rStr,
						unsigned char nFlags,
						const Point& rPos ) :
						String( rStr ), _nFlags(nFlags),_aPos(rPos) {}

	const Point&	GetPos() const { return _aPos; }
	unsigned char	GetFlags() const { return _nFlags; }
};

class CntIconPosList : public SvStrings
{
public:

					CntIconPosList() : SvStrings() {}
					CntIconPosList( const CntIconPosList& );
					~CntIconPosList();

	const CntIconPosListEntry* GetObject( USHORT nPos ) const
						{ return (const CntIconPosListEntry*)
							SvStrings::GetObject(nPos);
						}

	void			Store( SvStream& rStream ) const;
	void			Load( SvStream& rStream, bool bUnicode );
	int 			operator==( const CntIconPosList& ) const;
};

// -----------------------------------------------------------------------

class CntIconPosItem : public SfxPoolItem
{
	CntIconPosList_Impl*		_pImp;
	void						ReleaseList();

public:
							 	TYPEINFO();
								CntIconPosItem( USHORT nWhich = 0 );
								CntIconPosItem( USHORT nWhich, SvStream&,
												USHORT nVersion );
								CntIconPosItem( const CntIconPosItem& );
								~CntIconPosItem();

	virtual int 			 	operator==( const SfxPoolItem& ) const;
	virtual USHORT				GetVersion(USHORT) const;
	virtual SfxPoolItem*	 	Create(SvStream &, USHORT nItemVersion) const;
	virtual SvStream&		 	Store(SvStream &, USHORT nItemVersion ) const;
	virtual SfxPoolItem*     	Clone( SfxItemPool *pPool = 0 ) const;

	void						SetList( CntIconPosList* ); // Eigentumsuebergang
	const CntIconPosList*		GetList() const;

	virtual	BOOL 				PutValue  ( const com::sun::star::uno::Any& rVal,
						     				BYTE nMemberId = 0 );
	virtual	BOOL 				QueryValue( com::sun::star::uno::Any& rVal,
							 				BYTE nMemberId = 0 ) const;
};

}

#endif

