/*************************************************************************
 *
 *  $RCSfile: cntstgnd.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: mhu $ $Date: 2001/07/25 13:04:52 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _CNTSTGND_HXX
#define _CNTSTGND_HXX

#ifndef _OSL_INTERLOCK_H_
#include <osl/interlck.h>
#endif

#ifndef _STREAM_HXX //autogen
#include <tools/stream.hxx>
#endif

#ifndef _CNTNODE_HXX
#include <cntnode.hxx>
#endif
#ifndef _CNTSTORE_HXX
#include <cntstore.hxx>
#endif

namespace chaos
{

class CntStorage;
class CntStoreItemSet;

//=========================================================================
//
// Misc definitions
//
//=========================================================================

// Also defined in cntbase.hxx - needed outside CHAOS.
#ifndef STG_FILE_EXTENSION
// extension for view storage files
#define STG_FILE_EXTENSION			"scc"
#endif

// extension for all other storage files
#define STG_NOTVIEW_FILE_EXTENSION	"scs"

// special URL-prefixes
#define	STG_PROTOCOL_CACHE		".cache:"	// cache node
#define	STG_PROTOCOL_USER		".user:"  	// userdata node

// property access
#define STG_OWN_PROPERTY_SET	"own"
#define STG_PROPS_EXTENSION	    ".props"

//=========================================================================
//
// class CntStorageNode
//
//=========================================================================

class CntStorageNode : public CntNode
{
	CntStorage* m_pStore;

private:
	// Forbidden and not implemented.
	CntStorageNode( const CntStorageNode& );
	// Forbidden and not implemented.
	CntStorageNode& operator=( const CntStorageNode& );

	CntNode* Initialize_Impl( CntNode* pParent,
							  const String& rNodeURL,
							  ErrCode& nError );

protected:
	String		_aStorageName;
	BOOL 		_bIsRestored : 1;

	virtual		~CntStorageNode();

	virtual CntStorage* CreateImplementation();
	CntStorage* GetStorage();

	CntNode*	Initialize( CntNode* pParent, CntNode* pReferedNode );
	ErrCode		InitStorage( String& rOwnURL );
	BOOL 		RestoreOwnProperties();
	ErrCode		CloseStorage();

public:
	TYPEINFO();
	CNT_NODE_SUBCLASS_DECL();

	CntStorageNode();

	static void			Own2FileURL( String& rOwnURL,
									 CntStorageNode* pNode = NULL,
									 BOOL bMustExist = FALSE );
	static String 		OwnURL2FileName  ( const String& rOwnURL );
	static BOOL			StorageFileExists( const String& rURL );

	virtual CntNode*	Initialize( CntNode* pParent,
									const String& rNodeURL );
	virtual CntNode*	Initialize( CntNode* pParent,
									const String& rNodeURL,
									ErrCode& nError );
	BOOL				IsRestored() const { return _bIsRestored; }
	const String&		GetStorageName() const { return _aStorageName; }

    virtual const SfxPoolItem*  Put( const SfxPoolItem& rProp, USHORT nWhich );
	const SfxPoolItem*	Put( const SfxPoolItem& rProp )
					    { return Put( rProp, rProp.Which() ); }

	virtual void		SetReferedNode( CntNode* pNode );

	virtual const SfxPoolItem*	InsertJob( CntNodeJob *pJob );
	virtual const SfxPoolItem*	ExecuteJob( CntNodeJob *pJob );

	virtual void 		Notify( SfxBroadcaster& rBC,
								const SfxHint& rHint );

	//====================================================================
	// Storage media interface
	//====================================================================

public:
	ErrCode				destroy();

	CntStoreItemSet* 	openItemSet( const String &rName,
                              	  	 StreamMode eMode = STREAM_STD_READWRITE );
	CntStoreItemSet* 	openItemSet( const USHORT *nWhichPairTable,
                               	  	 const String &rName,
                                  	 StreamMode eMode = STREAM_STD_READWRITE );
	SvStream*        	openStream ( const String &rName,
                                  	 StreamMode eMode = STREAM_STD_READWRITE );

	ErrCode 			rename( const String &rName, const String &rNewName );
	ErrCode 			remove( const String &rName );
	ErrCode 			link  ( const String &rName, const String &rNewName );
	ErrCode 			attrib( const String &rName,
								UINT32 nClearMask, UINT32 nSetMask,
								UINT32& nAttrib );
	ErrCode 			attrib( const String &rName,
	  		        			UINT32 nClearMask, UINT32 nSetMask );
	const String		iter  ( CntStorageIterator &rIter );

	static String 		makeShortName( const String &rLongName );
};

//=========================================================================
//
// class CntRootStorageNode
//
//=========================================================================

class CntRootStorageNode : public CntStorageNode
{
	CntNodeRef _xUserNode;

private:
	// Forbidden and not implemented.
	CntRootStorageNode( const CntRootStorageNode& );
	// Forbidden and not implemented.
	CntRootStorageNode&	operator=( const CntRootStorageNode& );

	CntNode* Initialize_Impl( CntNode* pParent, const String& rNodeURL,
							  ErrCode& nError );
	const SfxPoolItem* Rebuild_Impl( CntNodeJob* pJob );

protected:
	BOOL _bKillInDtor : 1;

	virtual	~CntRootStorageNode();
	virtual CntStorage* CreateImplementation();

public:
	TYPEINFO();
	CNT_NODE_SUBCLASS_DECL();

	CntRootStorageNode();

	virtual	CntNode* Initialize( CntNode* pParent, const String& rNodeURL );
	virtual CntNode* Initialize( CntNode* pParent, const String& rNodeURL,
								 ErrCode& nError );
	virtual void GetOwnURL( String& rOwnURL );

	virtual const SfxPoolItem* InsertJob( CntNodeJob *pJob );

	virtual void Flush();

	void SetUserNode( CntNode* pUser );
	void SetDestroyStorageInDtor( BOOL bNew ) { _bKillInDtor = bNew; }

	//====================================================================
	// Storage media interface
	//====================================================================

public:
	static ErrCode create( const String &rURL );
	ErrCode		   rebuild();
	ErrCode		   size( UINT32& rSize );
};

//=========================================================================
//
// class CntViewStorageNode
//
//=========================================================================

class CntViewStorageNode : public CntRootStorageNode
{
private:
	// Forbidden and not implemented.
	CntViewStorageNode( const CntViewStorageNode& );
	// Forbidden and not implemented.
	CntViewStorageNode&	operator=( const CntViewStorageNode& );

	CntNode* Initialize_Impl( CntNode* pParent, const String& rNodeURL,
							  ErrCode& nError );

	void Exchange_Impl( CntNodeJob* pJob );
	BOOL RenameStorage_Impl( CntNodeJob *pJob, const SfxPoolItem &rReq );

protected:
	virtual	~CntViewStorageNode();
	virtual CntStorage* CreateImplementation();

public:
	TYPEINFO();
	CNT_NODE_SUBCLASS_DECL();

	CntViewStorageNode();

	virtual	CntNode* Initialize( CntNode* pParent, const String& rNodeURL );
	virtual CntNode* Initialize( CntNode* pParent, const String& rNodeURL,
								 ErrCode& nError );
	virtual void SetReferedNode( CntNode* pNode );
	virtual const SfxPoolItem* InsertJob( CntNodeJob *pJob );

	virtual void Notify( SfxBroadcaster& rBC, const SfxHint& rHint );

	static BOOL	IsRootViewURL( const String& rURL );
	static BOOL	IsSubViewURL ( const String& rURL );

	//====================================================================
	// Storage media interface
	//====================================================================

public:
	oslInterlockedCount acquireStorage();
	oslInterlockedCount releaseStorage();
	oslInterlockedCount	storageLocks() const;
	BOOL isStorageLocked() const;
};

} // namespace chaos

#endif /* !_CNTSTGND_HXX */
