/*************************************************************************
 *
 *  $RCSfile: cntsrch.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: kso $ $Date: 2001/07/25 15:09:41 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _CNTSRCH_HXX
#define _CNTSRCH_HXX

#ifndef _CNTAPI_HXX
#include <cntapi.hxx>
#endif
#ifndef _CNTSDITM_HXX
#include <cntsditm.hxx>
#endif

namespace chaos {

class CntSearchWrapper;

//============================================================================
class CntSearchWaitingJob_Impl
{
	BOOL m_bInitialLocation;
	String m_aURL;
	CntAnchorRef m_xParent;
	CntNodeRef m_xNode;
	CntSearchData * m_pData;

public:
	CntSearchWaitingJob_Impl(const String & rTheURL,
							 CntSearchData * pTheData):
		m_bInitialLocation(TRUE), m_aURL(rTheURL), m_pData(pTheData) {}

	inline CntSearchWaitingJob_Impl(CntAnchor * pTheParent,
									CntNode * pTheNode,
									CntSearchData * pTheData);

	~CntSearchWaitingJob_Impl() { delete m_pData; }

	BOOL isInitialLocation() const { return m_bInitialLocation; }

	String getURL() const { return m_aURL; }

	CntAnchor * getParent() const { return m_xParent; }

	CntNode * getNode() const { return m_xNode; }

	inline CntSearchData * takeData();
};

inline CntSearchWaitingJob_Impl::CntSearchWaitingJob_Impl(CntAnchor *
														   pTheParent,
														  CntNode * pTheNode,
														  CntSearchData *
														   pTheData):
	m_bInitialLocation(FALSE),
	m_xParent(pTheParent),
	m_xNode(pTheNode),
	m_pData(pTheData)
{}

inline CntSearchData * CntSearchWaitingJob_Impl::takeData()
{
	CntSearchData * pTheData = m_pData;
	m_pData = 0;
	return pTheData;
}

//============================================================================
DECLARE_LIST(CntSearchWaitingJobList_Impl, CntSearchWaitingJob_Impl *)

//============================================================================
class CntSearchRunningJob_Impl
{
	CntAnchorRef m_xAnchor;
	SfxCancellable * m_pCancel;
	CntSearchData * m_pData;
	BOOL m_bFSysFolderJob;

public:
	CntSearchRunningJob_Impl():
		m_pCancel(0), m_pData(0), m_bFSysFolderJob(FALSE) {}

	~CntSearchRunningJob_Impl() { delete m_pData; }

	BOOL is(const CntAnchor * pAnAnchor) const
	{ return m_xAnchor == pAnAnchor; }

	BOOL is(const SfxCancellable & rACancel) const
	{ return m_pCancel == &rACancel; }

	void markAsFSysFolderJob() { m_bFSysFolderJob = TRUE; }

	const CntSearchData * getData() const { return m_pData; }

	void start(CntSearchWrapper & rWrapper, CntAnchorRef & rTheAnchor,
			   CntSearchData * pTheData, const Link & rErrorHandler);

	void end(CntSearchWrapper & rWrapper);

	void cancel(CntSearchWrapper & rWrapper);
};

//============================================================================
DECLARE_LIST(CntSearchRunningJobList_Impl, CntSearchRunningJob_Impl *)

//============================================================================
class CntSearchWrapper
{
	/** The maximum number of search jobs (incl. recursive ones) active at any
		one time.
	 */
	enum { MAX_SIMULTANEOUS_JOBS = 16 };

	enum State { STATE_INIT, STATE_START, STATE_RECURSIVE, STATE_IDLE,
				 STATE_DONE, STATE_CANCEL, STATE_CANCELED };

	State m_eState;
	CntSearchWaitingJobList_Impl m_aWaitingJobs;
	ULONG m_nWaitingFSysFolderJobCount;
	CntSearchRunningJobList_Impl m_aRunningJobs;
	CntSearchRunningJob_Impl * m_pRunningFSysFolderJob;
	long m_nUnsuccessfulCount;
	String m_aUnsuccessfulLocations;

	inline BOOL canStartWaitingJob() const;

	BOOL result(CntNode * pNode, const String & rURL);

	BOOL startWaitingJob(ULONG nIndex);

	void cancelJobs();

	DECL_LINK(errorHandler, CntErrorData *);

protected:
	CntSearchWrapper(): m_eState(STATE_INIT) {}

	void execute();

	BOOL notify(SfxBroadcaster & rBroadcaster, const SfxHint & rHint);

	void cancel();

	virtual BOOL initialize(const List *& rLocations,
							const CntSearchData *& rData) = 0;

	virtual void startTimeSlice() = 0;

	virtual BOOL endTimeSlice() = 0;

	virtual void wakeUp() = 0;

	virtual BOOL reportUnsuccessful(ULONG nCount, const String & rLocations)
		= 0;

	virtual BOOL reportMatch(CntNode * pNode, const String & rURL) = 0;

	virtual void startingJob() = 0;

	virtual void allJobsDone() = 0;

	virtual void done() = 0;

	virtual ErrCode handleError(const CntErrorData * pData) = 0;

public:
	virtual void startListening(SfxBroadcaster & rBroadcaster) = 0;

	virtual void endListening(SfxBroadcaster & rBroadcaster) = 0;
};

inline BOOL CntSearchWrapper::canStartWaitingJob() const
{
	return m_aRunningJobs.Count() < MAX_SIMULTANEOUS_JOBS
	       && m_aWaitingJobs.Count()
	           > (m_pRunningFSysFolderJob ? m_nWaitingFSysFolderJobCount : 0);
}

//============================================================================
class CntSearchMatchedURLHint: public SfxHint
{
	String m_aURL;

public:
	TYPEINFO();

	CntSearchMatchedURLHint(const String & rTheURL): m_aURL(rTheURL) {}

	String getURL() const { return m_aURL; }
};

}

#endif // _CNTSRCH_HXX

