/*************************************************************************
 *
 *  $RCSfile: cntjob.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: kso $ $Date: 2001/07/25 15:09:41 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _CNTJOB_HXX
#define _CNTJOB_HXX

//========================================================================

// Multithreaded job execution ( on/off )
#define USE_JOB_DISPATCHER

#ifdef USE_JOB_DISPATCHER

// Acquire Solar Mutex before broadcasting ( on/off )
//#define USE_SOLAR_MUTEX

#endif /* USE_JOB_DISPATCHER */

//========================================================================

#ifndef _VOS_MUTEX_HXX_ //autogen
#include <vos/mutex.hxx>
#endif

#ifndef _CNTBASE_HXX
#include <cntbase.hxx>
#endif
#ifndef _CNTSRCH_HXX
#include <cntsrch.hxx>
#endif

#ifdef USE_JOB_DISPATCHER

#ifndef _CNTDISP_HXX
#include <cntdisp.hxx>
#endif

#else

#ifndef _SV_TIMER_HXX
#include <vcl/timer.hxx>
#endif

#endif /* USE_JOB_DISPATCHER */

#ifdef USE_SOLAR_MUTEX

#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx> /* Application::GetSolarMutex() */
#endif

#define ACQUIRE_SOLAR_MUTEX() \
	NAMESPACE_VOS( OGuard ) aGuard( Application::GetSolarMutex() )

#else

#define ACQUIRE_SOLAR_MUTEX()

#endif /* USE_SOLAR_MUTEX */

#define BROADCAST( _bc_, _hint_ ) 		\
{                                 		\
	ACQUIRE_SOLAR_MUTEX(); 				\
	( _bc_ )->Broadcast( ( _hint_ ) );	\
}

class CntJobCancelable;
class Link;

namespace chaos {

class CntNodeJob;
class ChaosTaskBase;
class CntStorageNode;

/*========================================================================
 *
 * CntNodeJobList Interface.
 *
 *======================================================================*/

DECLARE_LIST( CntNodeJobList, CntNodeJob* )

/*========================================================================
 *
 * CntNodeJob Interface.
 *
 *======================================================================*/

SV_DECL_REF( CntNodeJob )

class CntNodeJob : public SvRefBase, public SfxBroadcaster
{
private:
    CntNodeJobRef               _xParent;
	CntInterfaceRef				_xClient;
	CntNodeRef					_xSubject;
	CntNodeRef					_xUserDataNode;
	CntNodeRef					_xViewDataNode;
	CntNodeRef					_xDirectoryNode;
	CntNodeRef					_xCacheNode;
	SfxPoolItem*				_pRequest;
	CntJobCancelable*			_pCancelable;
	CntNodeJobList*	  			_pChildJobs;
	void*                       _pRequestData;
	Link*						_pErrorHandler;
	ChaosTaskBase*              _pTaskBase;
	BOOL						_bStarted 	  : 1;
	BOOL						_bRescheduled : 1;
	BOOL						_bDone 	   	  : 1;
	BOOL						_bCanceled 	  : 1;
	BOOL						_bMakePersist : 1;
	BOOL						_bLogged   	  : 1;
#if !defined USE_JOB_DISPATCHER
public:
	BOOL						_bAlwaysReschedule: 1;
		// chaos::ThreadTask needs this, because the semantics of rescheduling
		// a finished job are different when USE_JOB_DISPATCHER is in effect
private:
#endif // USE_JOB_DISPATCHER

								// forbidden and not implemented
								CntNodeJob( const CntNodeJob& rJob );
								CntNodeJob& operator=( const CntNodeJob& rJob );

	void 						InsertChildJob_Impl( CntNodeJob* pChild );
	void						RemoveChildJob_Impl( CntNodeJob* pChild );
	String 						CreateTitle_Impl() const;
	BOOL						IsPublic_Impl() const;
	void						ClearRequest_Impl();
public:
								TYPEINFO();

								CntNodeJob( CntNodeJob*			pParent,
											CntInterface*		pClient,
											CntNode*    		pSubject,
											const SfxPoolItem&	rRequest,
											BOOL		bMakePersist = TRUE,
											BOOL   		bLog = FALSE,
											ChaosTaskBase* pTheTaskBase = 0 );
	            				~CntNodeJob ();

	CntNodeJob*					GetParent() const
								{ return _xParent; }
	CntInterface*				GetClient() const
								{ return _xClient; }
	const SfxPoolItem*			GetRequest() const
								{ return _pRequest; }
	void						SetRequest( const SfxPoolItem& rRequest );
	void*                       GetRequestData () const
	                            { return _pRequestData;	}
	void                        SetRequestData ( void *pRequestData )
	                            { _pRequestData = pRequestData;	}
	CntNode*					GetSubject() const
								{ return _xSubject;	}
	void						SetSubject( CntNode *pSubject )
								{ _xSubject = pSubject;	}

    SfxCancellable*    			GetCancelable( BOOL bCreate = TRUE );
    const String				GetTitle() const;

	CntStorageNode*				GetUserDataNode ( BOOL bCreate = TRUE );
	CntStorageNode*				GetViewDataNode ( BOOL bCreate = TRUE );
	CntStorageNode*				GetDirectoryNode( BOOL bCreate = TRUE );
	CntStorageNode*				GetCacheNode    ( BOOL bCreate = TRUE );

	CntInterface* 				GetViewDataTarget(
										CntInterface* pTarget = NULL ) const;

	// Result interface
	void 						Result( CntNode *pResult,
										CntAction eAction
										= CNT_ACTION_INSERTED );
	void						ResultSearchMatch(CntNode * pNode,
												  CntSearchMatchMode eMatchMode
												   = CNT_SEARCH_MATCH_UNKNOWN,
												  BOOL bRecurses = FALSE);

	// Child job management
	inline ULONG 	   ChildJobCount() const;
	inline CntNodeJob* GetChildJob( ULONG nPos );

	// Set/get job flags
	void Started();
	BOOL IsStarted() const { return _bStarted; }

	void Done( BOOL bScheduleNextChildJob = TRUE );
	BOOL IsDone() { return ( _bDone && !ChildJobCount() ); }

	void Cancel();
	BOOL IsCanceled()  const { return _bCanceled; }

	void Log();
	BOOL IsLogged() const { return _bLogged; }

	void SetRescheduled() { _bRescheduled = TRUE; }
	BOOL IsRescheduled() const { return _bRescheduled; }

	BOOL IsMakePersist() const { return _bMakePersist; }

	BOOL IsSynchronous() const;

	// Error handling
	void  SetErrorHandler( const Link& rLink );
	const Link* QueryErrorHandler() const;

	BOOL SetError( ErrCode       nError,
				   const String* pErrorStr = NULL,
				   void*         pData     = NULL );

	// What a word crap... but used everywhere.
    inline SfxCancellable* GetCancellable( BOOL bCreate = TRUE );
	BOOL IsCancelled() const { return _bCanceled; }

	ChaosTaskBase * getTaskBase() { return _pTaskBase; }
};

inline ULONG CntNodeJob::ChildJobCount() const
{
	return _pChildJobs ? _pChildJobs->Count() : 0;
}

inline CntNodeJob* CntNodeJob::GetChildJob( ULONG nPos )
{
	return _pChildJobs ? _pChildJobs->GetObject( nPos ) : NULL;
}

inline SfxCancellable* CntNodeJob::GetCancellable( BOOL bCreate )
{
	return GetCancelable( bCreate );
}

SV_IMPL_REF( CntNodeJob );

//========================================================================

DECL_PTRHINT( CntScheduleJobHint, CntNodeJob );

/*========================================================================
 *
 * CntJobRescheduler Interface.
 *
 *======================================================================*/

#ifdef USE_JOB_DISPATCHER

// Note: This class exists for compatibility issues only.

class CntJobRescheduler : public CntJobDispatchUnit
{
public:
	CntJobRescheduler( CntNode *pNode, CntNodeJob *pJob );
};

#else

class CntJobRescheduler : public Timer
{
private:
	CntNodeRef			_xNode;
	CntNodeJobRef 		_xJob;

	DECL_LINK( Reschedule, void* );
public:
	CntJobRescheduler( CntNode *pNode, CntNodeJob *pJob );
	~CntJobRescheduler();
};

#endif /* USE_JOB_DISPATCHER */

/*========================================================================
 *
 * CntTask Interface.
 *
 *======================================================================*/

class CntTask : public SfxListener, public SvRefBase
{
private:
	 // Forbidden and not implemented
	CntTask( const CntTask& );
	 // Forbidden and not implemented
	CntTask& operator=( const CntTask& );

protected:
	CntNodeJobRef _xJob;

public:
	CntTask( CntNodeJob* pJob );
	virtual ~CntTask();

	virtual void Notify( SfxBroadcaster& rBC, const SfxHint& rHint );

	virtual const SfxPoolItem* Execute() = 0;
};

#ifndef USE_JOB_DISPATCHER

/*========================================================================
 *
 * CntThreadSwitcher Interface.
 *
 *======================================================================*/

class CntThreadSwitcher
{
	NAMESPACE_VOS( OMutex ) m_aMutex;
	ULONG              		m_nUserId;

	DECL_LINK( Switch, void* );

protected:
	void SwitchToMain();
	virtual void SwitchedToMain() = 0;

public:
	CntThreadSwitcher() : m_nUserId( 0 ) {}
	virtual ~CntThreadSwitcher();
};

#endif /* USE_JOB_DISPATCHER */

}

#endif /* !_CNTJOB_HXX */
