/*************************************************************************
 *
 *  $RCSfile: alstitem.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: kso $ $Date: 2001/07/25 15:09:41 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _ALSTITEM_HXX
#define _ALSTITEM_HXX

#ifndef _STDARG_H
#include <stdarg.h>
#endif

#ifndef _LIST_HXX //autogen
#include <tools/list.hxx>
#endif

#ifndef _RTTI_HXX
#include <tools/rtti.hxx>
#endif

#ifndef _SFXPOOLITEM_HXX //autogen
#include <svtools/poolitem.hxx>
#endif

#ifndef _CHAOS_CNTRLDEF_HXX
#include <cntrldef.hxx>
#endif

#ifndef _CNTBASE_HXX
#include <cntbase.hxx>
#endif

class SvStream;

namespace chaos {

// -----------------------------------------------------------------------

struct CntActionListEntry
{
	CntNodeAction	_eAction;
	String			_aParameter;

	int				Compare( const CntActionListEntry &rEntry ) const;
};

DECLARE_LIST( ActionList, CntActionListEntry * )

class CntActionListItem: public SfxPoolItem

/**	[Description]

*/

{
	ActionList*				_pActions;

public:
							TYPEINFO();

							CntActionListItem( USHORT nWhich = 0 );
							CntActionListItem( USHORT nWhich, SvStream &,
											   USHORT nVersion );
							CntActionListItem( const CntActionListItem& );
							~CntActionListItem();

	virtual USHORT			GetVersion(USHORT) const;

	virtual int 			operator==( const SfxPoolItem& ) const;
	virtual SfxPoolItem*	Create(SvStream &, USHORT nItemVersion) const;
	virtual SvStream&		Store(SvStream &, USHORT nItemVersion ) const;
	virtual SfxPoolItem*    Clone( SfxItemPool *pPool = 0 ) const;

	void					Append( CntNodeAction eAction,
									const String &rParameter );
	BOOL					Check( CntNodeAction eAction,
								   const String &rParameter ) const;
	BOOL					Insert( CntNodeAction eAction,
									const String &rParameter );

	virtual	BOOL 			PutValue  ( const com::sun::star::uno::Any& rVal,
						    			BYTE nMemberId = 0 );
	virtual	BOOL 			QueryValue( com::sun::star::uno::Any& rVal,
										BYTE nMemberId = 0 ) const;
};

}

#endif

