/*************************************************************************
 *
 *  $RCSfile: import.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2001/10/12 16:37:36 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <limits>

#ifndef _INETCOREMAIL_HXX
#include <inet/inetmail.hxx>
#endif
#ifndef _INETCOREMSG_HXX
#include <inet/inetmsg.hxx>
#endif
#ifndef _INET_WRAPPER_HXX
#include <inet/wrapper.hxx>
#endif
#ifndef _SVTOOLS_CINTITEM_HXX
#include <svtools/cintitem.hxx>
#endif
#ifndef _SVTOOLS_CTYPEITM_HXX
#include <svtools/ctypeitm.hxx>
#endif
#ifndef _DATETIMEITEM_HXX
#include <svtools/dateitem.hxx>
#endif
#ifndef _FSYS_HXX
#include <tools/fsys.hxx>
#endif
#ifndef _STREAM_HXX
#include <tools/stream.hxx>
#endif

#ifndef _CNTINET_HXX
#include <cntinet.hxx>
#endif
#ifndef _CNTMBITM_HXX
#include <cntmbitm.hxx>
#endif
#ifndef _CNTRNMGR_HXX
#include <cntrnmgr.hxx>
#endif
#ifndef _CNTXREF_HXX
#include <cntxref.hxx>
#endif
#ifndef _CSTRITEM_HXX
#include <cstritem.hxx>
#endif
#ifndef _ILSTITEM_HXX
#include <ilstitem.hxx>
#endif
#ifndef _CHAOS_IMPORT_HXX
#include <import.hxx>
#endif
#ifndef _RCPNITEM_HXX
#include <rcpnitem.hxx>
#endif

namespace unnamed_chaos_import {} using namespace unnamed_chaos_import;
	// unnamed namespaces don't work well yet...

using namespace chaos;

//============================================================================
namespace unnamed_chaos_import {

class TempFileStream: public SvFileStream
{
public:
	TempFileStream();

	virtual ~TempFileStream();
};

}

//============================================================================
namespace chaos {

class CntMBXMessage: public INetCoreNewsMessage
{
public:
	void setBoundary(ByteString const & rBoundary)
	{ SetMultipartBoundary_Impl(rBoundary); }
};

}

//============================================================================
//
//  class CntImport
//
//============================================================================

ErrCode CntImport::determineSourceFormat()
{
	if (!m_bSourceFormatDetermined)
	{
		ErrCode nError = m_aScanner.determineSourceFormat(m_eSourceFormat);
		if (nError != ERRCODE_NONE)
			return nError;
		m_bSourceFormatDetermined = true;
		if (m_eSourceFormat == CntMBXScanner::FORMAT_OUTLOOK_EXPRESS)
		{
			m_pCharsRFC822 = CntMBXChars::aCharsRFC822NUL;
			m_pCharsMIME = CntMBXChars::aCharsMIMENUL;
			m_pCharsBoundary = CntMBXChars::aCharsBoundaryNUL;
			m_pCharsBody = CntMBXChars::aCharsBodyNUL;
			m_pCharsText = CntMBXChars::aCharsTextNUL;
			m_pCharsSText = CntMBXChars::aCharsSTextNUL;
			m_pCharsEToken = CntMBXChars::aCharsETokenNUL;
			m_pCharsEText = CntMBXChars::aCharsETextNUL;
		}
		else
		{
			m_pCharsRFC822 = CntMBXChars::aCharsRFC822;
			m_pCharsMIME = CntMBXChars::aCharsMIME;
			m_pCharsBoundary = CntMBXChars::aCharsBoundary;
			m_pCharsBody = CntMBXChars::aCharsBody;
			m_pCharsText = CntMBXChars::aCharsText;
			m_pCharsSText = CntMBXChars::aCharsSText;
			m_pCharsEToken = CntMBXChars::aCharsEToken;
			m_pCharsEText = CntMBXChars::aCharsEText;
		}
	}
	return ERRCODE_NONE;
}

//============================================================================
CntMBXMessage * CntImport::createMessage()
{
	if (!m_pMessageFactory)
	{
		inet::INetWrapper * pWrapper;
		if (CntRootNodeMgr::Get()->getINetWrapper(pWrapper))
		{
			CntINetConfig::load(pWrapper,
								CntRootNodeMgr::Get()->GetIniManager());
			pWrapper->newINetCoreMailer(m_pMessageFactory);
		}
	}
	return
		m_pMessageFactory ?
		    static_cast< CntMBXMessage * >(m_pMessageFactory->
										       CreateINetCoreNewsMessage()) :
		    0;
}

//============================================================================
ErrCode CntImport::skipToCRLF(CntMBXToken & rToken)
{
	while (rToken.getType() != CntMBXToken::TYPE_CRLF
		   && rToken.getType() != CntMBXToken::TYPE_ZERO
		   && rToken.getType() != CntMBXToken::TYPE_END)
	{
		ErrCode nError = m_aScanner.
			                 scan(rToken, m_aAtomTable, m_pCharsRFC822,
								  CntMBXScanner::ScanMode(
									  CntMBXScanner::FOLDED_LWSP
									      | CntMBXScanner::SKIP_LWSP
									      | CntMBXScanner::SKIP_COMMENTS));
		if (nError != ERRCODE_NONE)
			return nError;
	}
	return ERRCODE_NONE;
}

//============================================================================
ErrCode CntImport::parseDateTimeFieldBody(DateTime & rDateTime, bool & rValid)
{
	ByteString aBody;
	ErrCode nError = readHeaderFieldBody(aBody);
	rValid = nError == ERRCODE_NONE
		     && CntMBXFormat::parseDateTimeFieldBody(aBody, rDateTime);
	return nError;
}

//============================================================================
ErrCode CntImport::parseXrefFieldBody(UniString & rHost,
									  CntItemListItem & rList)
{
	rHost.Erase();

	CntMBXToken aToken;
	ErrCode nError = m_aScanner.scan(aToken, m_aAtomTable, m_pCharsRFC822,
									 CntMBXScanner::ScanMode(
										 CntMBXScanner::FOLDED_LWSP
										     | CntMBXScanner::SKIP_LWSP
										     | CntMBXScanner::SKIP_COMMENTS));
	if (nError != ERRCODE_NONE)
		return nError;
	if (aToken.getType() == CntMBXToken::TYPE_ATOM)
	{
		rHost = UniString(aToken.getValue(), RTL_TEXTENCODING_UTF8);

		bool bInList = true;
		do
		{
			ByteString aNewsgroup;
			for (;;)
			{
				nError = m_aScanner.
					         scan(aToken, m_aAtomTable, m_pCharsRFC822,
								  CntMBXScanner::ScanMode(
									  CntMBXScanner::FOLDED_LWSP
									      | CntMBXScanner::CANONIC_QSTR
									      | CntMBXScanner::SKIP_LWSP
									      | CntMBXScanner::SKIP_COMMENTS));
				if (nError != ERRCODE_NONE)
					return nError;
				if (aToken.getType() != CntMBXToken::TYPE_ATOM
					&& aToken.getType() != CntMBXToken::TYPE_QSTR)
				{
					bInList = false;
					break;
				}
				aNewsgroup += aToken.getCanonic();
				nError = m_aScanner.
				             scan(aToken, m_aAtomTable, m_pCharsRFC822,
								  CntMBXScanner::ScanMode(
									  CntMBXScanner::FOLDED_LWSP
									      | CntMBXScanner::SKIP_LWSP
									      | CntMBXScanner::SKIP_COMMENTS));
				if (nError != ERRCODE_NONE)
					return nError;
				if (aToken.getType() != CntMBXToken::TYPE_SPECIAL)
				{
					bInList = false;
					break;
				}
				if (aToken.getCharValue() == ':')
					break;
				if (aToken.getCharValue() != '.')
				{
					bInList = false;
					break;
				}
				aNewsgroup += '.';
			}
			if (bInList)
			{
				nError = m_aScanner.
				             scan(aToken, m_aAtomTable, m_pCharsRFC822,
								  CntMBXScanner::ScanMode(
									  CntMBXScanner::FOLDED_LWSP
									      | CntMBXScanner::SKIP_LWSP
									      | CntMBXScanner::SKIP_COMMENTS));
				if (aToken.getType() != CntMBXToken::TYPE_ATOM)
					break;
				sal_Char const * p = aToken.getValue().GetBuffer();
				sal_Char const * pEnd = p + aToken.getValue().Len();
				sal_uInt32 nValue;
				if (!INetMIME::scanUnsigned(p, pEnd, true, nValue)
					|| p != pEnd)
					break;
				rList.Append(new CntCrossReferenceItem(
					                 WID_NEWS_XREF,
									 UniString(aNewsgroup,
											   RTL_TEXTENCODING_UTF8),
									 nValue));
			}
		}
		while (bInList);
	}
	return skipToCRLF(aToken);
}

//============================================================================
ErrCode CntImport::parseNumericFieldBody(bool bHex, bool bLeadingZeroes,
										 sal_uInt32 & rValue, bool & rValid)
{
	ByteString aBody;
	ErrCode nError = readHeaderFieldBody(aBody);
	rValid = nError == ERRCODE_NONE
		     && CntMBXFormat::parseNumericFieldBody(aBody, bHex,
													bLeadingZeroes, rValue);
	return nError;
}

//============================================================================
ErrCode CntImport::parseBooleanFieldBody(bool & rValue, bool & rValid)
{
	// Parse a RFC 822 header field body containing either "YES" or "NO":
	//
	// body = LWSC
	//        ("YES" / "NO")
	//        LWSC
	// LWSC = [linear-white-space / comment]

	rValid = false;
	ByteString aBody;
	ErrCode nError = readHeaderFieldBody(aBody);
	if (nError != ERRCODE_NONE)
		return nError;
	sal_Char const * p = aBody.GetBuffer();
	sal_Char const * pEnd = p + aBody.Len();
	p = INetMIME::skipLinearWhiteSpaceComment(p, pEnd);
	sal_Char const * pAtomEnd = INetMIME::scanAtom(p, pEnd);
	if (INetMIME::equalIgnoreCase(p, pAtomEnd, "yes"))
	{
		rValue = true;
		rValid = true;
	}
	else if (INetMIME::equalIgnoreCase(p, pAtomEnd, "no"))
	{
		rValue = false;
		rValid = true;
	}
	rValid = rValid
		     && INetMIME::skipLinearWhiteSpaceComment(pAtomEnd, pEnd) == pEnd;
	return ERRCODE_NONE;
}

//============================================================================
ErrCode CntImport::parseXCHAOSRecipientsFieldBody(CntRecipientListItem &
												      rList)
{
	CntMBXToken aToken;

	do
	{
		bool bData = false;
		CntOutMsgProtocolType eProtocol = CNT_OUTMSG_PROTOCOL_SMTP;
		UniString aServer;
		UniString aUser;
		UniString aPassword;
		CntOutMsgInternalState eState = CNT_OUTMSG_INTERNALSTATE_WRITTEN;
		USHORT nReplyCode = 0;
		UniString aReply;
		USHORT nTries = 0;
		UniString aTo;
		UniString aCC;
		UniString aBCC;
		UniString aNews;

		for (;;)
		{
			ErrCode nError = m_aScanner.scan(aToken, m_aAtomTable,
											 m_pCharsRFC822);
			if (nError != ERRCODE_NONE)
				return nError;
			if (aToken.getType() != CntMBXToken::TYPE_SPECIAL
				|| aToken.getCharValue() != '<')
				break;

			bool bTokenProcessed = false;

			nError = m_aScanner.scan(aToken, m_aAtomTable, m_pCharsRFC822);
			if (nError != ERRCODE_NONE)
				return nError;
			if (aToken.getType() == CntMBXToken::TYPE_ATOM)
			{
				sal_uInt32 nKey = aToken.getAtom()->getKey();
				nError = m_aScanner.scan(aToken, m_aAtomTable,
										 m_pCharsRFC822);
				if (nError != ERRCODE_NONE)
					return nError;
				switch (nKey)
				{
					case CntMBXAtomTable::ATOM_PROTOCOL:
						if (aToken.getType() == CntMBXToken::TYPE_ATOM)
							switch (aToken.getAtom()->getKey())
							{
								case CntMBXAtomTable::ATOM_SMTP:
									bData = true;
									eProtocol = CNT_OUTMSG_PROTOCOL_SMTP;
									bTokenProcessed = true;
									break;

								case CntMBXAtomTable::ATOM_VIM:
									bData = true;
									eProtocol = CNT_OUTMSG_PROTOCOL_VIM;
									bTokenProcessed = true;
									break;

								case CntMBXAtomTable::ATOM_MAPI:
									bData = true;
									eProtocol = CNT_OUTMSG_PROTOCOL_MAPI;
									bTokenProcessed = true;
									break;

								case CntMBXAtomTable::ATOM_MBOX:
									bData = true;
									eProtocol = CNT_OUTMSG_PROTOCOL_MBOX;
									bTokenProcessed = true;
									break;

								case CntMBXAtomTable::ATOM_NNTP:
									bData = true;
									eProtocol = CNT_OUTMSG_PROTOCOL_NNTP;
									bTokenProcessed = true;
									break;

								case CntMBXAtomTable::ATOM_COPY:
									bData = true;
									eProtocol = CNT_OUTMSG_PROTOCOL_COPY;
									bTokenProcessed = true;
									break;
							}
						break;

					case CntMBXAtomTable::ATOM_SERVER:
						switch (aToken.getType())
						{
							case CntMBXToken::TYPE_ATOM:
							case CntMBXToken::TYPE_QSTR:
								bData = true;
								aServer = UniString(aToken.getCanonic(),
													RTL_TEXTENCODING_UTF8);
								bTokenProcessed = true;
								break;
						}
						break;

					case CntMBXAtomTable::ATOM_USER:
						switch (aToken.getType())
						{
							case CntMBXToken::TYPE_ATOM:
							case CntMBXToken::TYPE_QSTR:
								bData = true;
								aUser = UniString(aToken.getCanonic(),
												  RTL_TEXTENCODING_UTF8);
								bTokenProcessed = true;
								break;
						}
						break;

					case CntMBXAtomTable::ATOM_PASSWORD:
						switch (aToken.getType())
						{
							case CntMBXToken::TYPE_ATOM:
							case CntMBXToken::TYPE_QSTR:
								bData = true;
								aPassword
									= UniString(CntStringDecode(
													false,
										            aToken.getCanonic()),
												RTL_TEXTENCODING_UTF8);
								bTokenProcessed = true;
								break;
						}
						break;

					case CntMBXAtomTable::ATOM_MESSAGE_ID:
						// Password encoded in a better way than 'password'
						// and stored under an obscure key:
						switch (aToken.getType())
						{
							case CntMBXToken::TYPE_ATOM:
							case CntMBXToken::TYPE_QSTR:
								bData = true;
								aPassword
									= UniString(CntStringDecode(
													true,
													aToken.getCanonic()),
												RTL_TEXTENCODING_UTF8);
								bTokenProcessed = true;
								break;
						}
						break;

					case CntMBXAtomTable::ATOM_STATE:
						if (aToken.getType() == CntMBXToken::TYPE_ATOM)
							switch (aToken.getAtom()->getKey())
							{
								case CntMBXAtomTable::ATOM_WRITTEN:
									bData = true;
									eState = CNT_OUTMSG_INTERNALSTATE_WRITTEN;
									bTokenProcessed = true;
									break;

								case
								 CntMBXAtomTable::ATOM_PARTIALLY_LOCALLY_SENT:
									bData = true;
									eState
							= CNT_OUTMSG_INTERNALSTATE_PARTIALLY_LOCALLY_SENT;
									bTokenProcessed = true;
									break;

						   case CntMBXAtomTable::ATOM_COMPLETELY_LOCALLY_SENT:
									bData = true;
									eState
						   = CNT_OUTMSG_INTERNALSTATE_COMPLETELY_LOCALLY_SENT;
									bTokenProcessed = true;
									break;

						   case CntMBXAtomTable::ATOM_RECOVERABLE_LOCAL_ERROR:
									bData = true;
									eState
						   = CNT_OUTMSG_INTERNALSTATE_RECOVERABLE_LOCAL_ERROR;
									bTokenProcessed = true;
									break;

						case CntMBXAtomTable::ATOM_NONRECOVERABLE_LOCAL_ERROR:
									bData = true;
									eState
						= CNT_OUTMSG_INTERNALSTATE_NONRECOVERABLE_LOCAL_ERROR;
									bTokenProcessed = true;
									break;

								case CntMBXAtomTable::ATOM_EXTERNAL_ERROR:
									bData = true;
									eState
									= CNT_OUTMSG_INTERNALSTATE_EXTERNAL_ERROR;
									bTokenProcessed = true;
									break;

							  case CntMBXAtomTable::ATOM_WAITING_CONFIRMATION:
									bData = true;
									eState
							  = CNT_OUTMSG_INTERNALSTATE_WAITING_CONFIRMATION;
									bTokenProcessed = true;
									break;

								case CntMBXAtomTable::ATOM_CONFIRMED:
									bData = true;
									eState
										= CNT_OUTMSG_INTERNALSTATE_CONFIRMED;
									bTokenProcessed = true;
									break;
							}
						break;

					case CntMBXAtomTable::ATOM_REPLY_CODE:
						if (aToken.getType() == CntMBXToken::TYPE_ATOM)
						{
							sal_Char const * p
								= aToken.getValue().GetBuffer();
							sal_Char const * pEnd
								= p + aToken.getValue().Len();
							bool bNegative = false;
							if (*p == '-')
							{
								bNegative = true;
								++p;
							}
							sal_uInt32 nValue;
							if (INetMIME::scanUnsigned(p, pEnd, true, nValue)
								&& p == pEnd
								&& nValue
								       <= std::numeric_limits<
								              USHORT >::max())
							{
								bData = true;
								nReplyCode
									= USHORT(
										  bNegative ?
										      std::numeric_limits<
										              USHORT >::max()
										          - (nValue - 1) :
										      nValue);
								bTokenProcessed = true;
							}
						}
						break;

					case CntMBXAtomTable::ATOM_REPLY:
						switch (aToken.getType())
						{
							case CntMBXToken::TYPE_ATOM:
							case CntMBXToken::TYPE_QSTR:
								bData = true;
								aReply = UniString(aToken.getCanonic(),
												   RTL_TEXTENCODING_UTF8);
								bTokenProcessed = true;
								break;
						}
						break;

					case CntMBXAtomTable::ATOM_TRIES:
						if (aToken.getType() == CntMBXToken::TYPE_ATOM)
						{
							sal_Char const * p
								= aToken.getValue().GetBuffer();
							sal_Char const * pEnd
								= p + aToken.getValue().Len();
							sal_uInt32 nValue;
							if (INetMIME::scanUnsigned(p, pEnd, true, nValue)
								&& p == pEnd
								&& nValue
								       <= std::numeric_limits<
								              USHORT >::max())
							{
								bData = true;
								nTries = USHORT(nValue);
								bTokenProcessed = true;
							}
						}
						break;

					case CntMBXAtomTable::ATOM_TO:
						switch (aToken.getType())
						{
							case CntMBXToken::TYPE_ATOM:
							case CntMBXToken::TYPE_QSTR:
								bData = true;
								aTo = UniString(aToken.getCanonic(),
												RTL_TEXTENCODING_UTF8);
								bTokenProcessed = true;
								break;
						}
						break;

					case CntMBXAtomTable::ATOM_CC:
						switch (aToken.getType())
						{
							case CntMBXToken::TYPE_ATOM:
							case CntMBXToken::TYPE_QSTR:
								bData = true;
								aCC = UniString(aToken.getCanonic(),
												RTL_TEXTENCODING_UTF8);
								bTokenProcessed = true;
								break;
						}
						break;

					case CntMBXAtomTable::ATOM_BCC:
						switch (aToken.getType())
						{
							case CntMBXToken::TYPE_ATOM:
							case CntMBXToken::TYPE_QSTR:
								bData = true;
								aBCC = UniString(aToken.getCanonic(),
												 RTL_TEXTENCODING_UTF8);
								bTokenProcessed = true;
								break;
						}
						break;

					case CntMBXAtomTable::ATOM_NEWS:
						switch (aToken.getType())
						{
							case CntMBXToken::TYPE_ATOM:
							case CntMBXToken::TYPE_QSTR:
								bData = true;
								aNews = UniString(aToken.getCanonic(),
												  RTL_TEXTENCODING_UTF8);
								bTokenProcessed = true;
								break;
						}
						break;
				}
			}

			if (bTokenProcessed)
			{
				nError = m_aScanner.scan(aToken, m_aAtomTable,
										 m_pCharsRFC822);
				if (nError != ERRCODE_NONE)
					return nError;
			}
			while (aToken.getType() != CntMBXToken::TYPE_SPECIAL
				   || aToken.getCharValue() != '>')
			{
				nError = m_aScanner.scan(aToken, m_aAtomTable,
										 m_pCharsRFC822);
				if (nError != ERRCODE_NONE)
					return nError;
			}
		}

		if (bData)
			rList.Append(new CntRecipientInfo(aTo, aCC, aBCC, aNews, aServer,
											  aReply, eProtocol, eState,
											  nReplyCode, nTries, aUser,
											  aPassword, UniString()));
	}
	while (aToken.getType() == CntMBXToken::TYPE_SPECIAL
		   && aToken.getCharValue() == ',');

	return skipToCRLF(aToken);
}

//============================================================================
ErrCode CntImport::readHeaderFieldBody(ByteString & rBody)
{
	rBody.Erase();
	for (CntMBXScanner::ScanMode eMode
			 = CntMBXScanner::ScanMode(CntMBXScanner::FOLDED_LWSP
									       | CntMBXScanner::SKIP_LWSP);;
		 eMode = CntMBXScanner::ScanMode(CntMBXScanner::FOLDED_LWSP
										     | CntMBXScanner::CANONIC_LWSP))
	{
		CntMBXToken aToken;
		ErrCode nError = m_aScanner.scan(aToken, m_aAtomTable, m_pCharsText,
										 eMode);
		if (nError != ERRCODE_NONE)
			return nError;
		switch (aToken.getType())
		{
			case CntMBXToken::TYPE_CRLF:
			case CntMBXToken::TYPE_ZERO:
			case CntMBXToken::TYPE_END:
				return ERRCODE_NONE;
		}
		rBody += aToken.getCanonic();
	}
}

//============================================================================
ErrCode CntImport::readBodyLine(bool bHasBoundary,
								ByteString const & rBoundary, bool & rFound,
								ByteString & rLine, bool & rTerminated,
								BoundaryType & rBoundaryType)
{
	rFound = false;
	rLine.Erase();
	rTerminated = false;
	rBoundaryType = NO_BOUNDARY;

	CntMBXToken aToken;
	ErrCode nError = m_aScanner.scan(aToken, m_aAtomTable, m_pCharsBody,
									 CntMBXScanner::ScanMode(0));
	if (nError != ERRCODE_NONE)
		return nError;
	switch (aToken.getType())
	{
		case CntMBXToken::TYPE_ATOM:
			if (m_eSourceFormat == CntMBXScanner::FORMAT_GENERAL
				&& ByteString("From ").Match(aToken.getValue())
				       == STRING_MATCH)
			{
				m_aScanner.backUp();
				return ERRCODE_NONE;
			}
			else if (bHasBoundary
					 && aToken.getValue().Len() >= rBoundary.Len() + 2
					 && aToken.getValue().GetChar(0) == '-'
					 && aToken.getValue().GetChar(1) == '-'
					 && aToken.getValue().Copy(2, rBoundary.Len())
					        == rBoundary)
			{
				BoundaryType eTheBoundaryType;
				xub_StrLen i = rBoundary.Len() + 2;
				if (i + 1 < aToken.getValue().Len()
					&& aToken.getValue().GetChar(i) == '-'
					&& aToken.getValue().GetChar(i + 1) == '-')
				{
					i += 2;
					eTheBoundaryType = END_BOUNDARY;
				}
				else
					eTheBoundaryType = NEXT_BOUNDARY;
				bool bLWSP = true;
				for (; i < aToken.getValue().Len(); ++i)
					if (CntMBXChars(m_pCharsRFC822).
						        getClass(aToken.getValue().GetChar(i))
						    != CntMBXChars::LWSP)
					{
						bLWSP = false;
						break;
					}
				ByteString aTheLine;
				if (!bLWSP)
					aTheLine = aToken.getValue();
				bool bTheTerminated = false;
				bool bInLine = true;
				do
				{
					nError = m_aScanner.scan(aToken, m_aAtomTable,
											 m_pCharsBody,
											 CntMBXScanner::ScanMode(0));
					if (nError != ERRCODE_NONE)
						return nError;
					switch (aToken.getType())
					{
						case CntMBXToken::TYPE_CRLF:
							bTheTerminated = true;
						case CntMBXToken::TYPE_ZERO:
						case CntMBXToken::TYPE_END:
							bInLine = false;
							break;

						default:
							if (bLWSP)
								for (xub_StrLen i = 0;
									 i < aToken.getValue().Len(); ++i)
									if (CntMBXChars(m_pCharsRFC822).
										        getClass(aToken.getValue().
														     GetChar(i))
										    != CntMBXChars::LWSP)
									{
										bLWSP = false;
										break;
									}
							if (!bLWSP)
								aTheLine += aToken.getValue();
							break;
					}
				}
				while (bInLine);
				if (bLWSP)
					rBoundaryType = eTheBoundaryType;
				else
				{
					rFound = true;
					rLine = aTheLine;
					rTerminated = bTheTerminated;
				}
				return ERRCODE_NONE;
			}
		default:
			rFound = true;
			rLine = aToken.getValue();
			for (;;)
			{
				nError = m_aScanner.scan(aToken, m_aAtomTable, m_pCharsBody,
										 CntMBXScanner::ScanMode(0));
				if (nError != ERRCODE_NONE)
					return nError;
				switch (aToken.getType())
				{
					case CntMBXToken::TYPE_CRLF:
						rTerminated = true;
					case CntMBXToken::TYPE_ZERO:
					case CntMBXToken::TYPE_END:
						return ERRCODE_NONE;

					default:
						rLine += aToken.getValue();
						break;
				}
			}

		case CntMBXToken::TYPE_CRLF:
			rTerminated = true;
			rFound = true;
		case CntMBXToken::TYPE_ZERO:
		case CntMBXToken::TYPE_END:
			return ERRCODE_NONE;
	}
}

//============================================================================
ErrCode CntImport::parseMessage(CntMessageCachingPolicy & rPolicy,
								CntMBXVersion const * pVersion,
								bool bHasBoundary,
								ByteString const & rBoundary,
								bool bHasNewsHost,
								UniString const & rNewsHost,
								SfxItemSet * pItems, CntMBXMessage * pMessage,
								BoundaryType & rBoundaryType, bool bHeader)
{
	xub_StrLen nBoundaryPrefix = 0;
	if (bHasBoundary)
		for (;
			 nBoundaryPrefix < rBoundary.Len()
			 && CntMBXChars(m_pCharsRFC822).
				        getClass(rBoundary.GetChar(nBoundaryPrefix))
			        == CntMBXChars::ATOM;
			 ++nBoundaryPrefix);

	CntMBXMessage * pNestedMessage = pItems || pMessage ? createMessage() : 0;

	ErrCode nError = ERRCODE_NONE;
	ByteString aContentTypeBody;
	ByteString aContentType;
	ByteString aContentSubType;
	INetContentTypeParameterList aContentParameters;
	CntMBXAtom const * pContentTransferEncoding = 0;
	sal_uInt32 nMozillaStatus = 0x10000;
	UniString aBodyCacheName;
	bool bBody = false;
	bool bNoBody = false;
	while (bHeader)
	{
		CntMBXToken aToken;
		nError = m_aScanner.scan(aToken, m_aAtomTable, m_pCharsRFC822,
								 CntMBXScanner::ScanMode(
									 CntMBXScanner::CANONIC_ATOM
									     | CntMBXScanner::HASH_ATOM));
		bool bNewline = true;
		switch (aToken.getType())
		{
			case CntMBXToken::TYPE_LWSP:
			case CntMBXToken::TYPE_COMMENT:
				bNewline = false;
				nError = m_aScanner.scan(aToken, m_aAtomTable,
										 m_pCharsRFC822);
				if (nError != ERRCODE_NONE)
					goto end;
				break;
		}
		switch (aToken.getType())
		{
			case CntMBXToken::TYPE_ATOM:
			{
				sal_uInt32 nKey = aToken.getAtom()->getKey();
				bool bHeaderField = true;
				if (bNewline && nKey == CntMBXAtomTable::ATOM_FROM)
				{
					nError = m_aScanner.scan(aToken, m_aAtomTable,
											 m_pCharsRFC822,
											 CntMBXScanner::ScanMode(0));
					if (nError != ERRCODE_NONE)
						goto end;
					switch (aToken.getType())
					{
						case CntMBXToken::TYPE_LWSP:
							m_aScanner.backUp();
							m_aScanner.backUp();
							rBoundaryType = NO_BOUNDARY;
							nError = ERRCODE_NONE;
							goto end;

						case CntMBXToken::TYPE_COMMENT:
							nError = m_aScanner.scan(aToken, m_aAtomTable,
													 m_pCharsRFC822);
							if (nError != ERRCODE_NONE)
								goto end;
							break;
					}
				}
				else if (bNewline && bHasBoundary
						 && (aToken.getValue().Len() == nBoundaryPrefix + 2
							 || nBoundaryPrefix == rBoundary.Len()
							    && aToken.getValue().Len() == nBoundaryPrefix
							                                      + 4)
						 && aToken.getValue().GetChar(0) == '-'
						 && aToken.getValue().GetChar(1) == '-'
						 && aToken.getValue().Copy(2, nBoundaryPrefix)
						        == rBoundary.Copy(0, nBoundaryPrefix))
				{
					BoundaryType eTheBoundaryType = NO_BOUNDARY;
					if (nBoundaryPrefix == rBoundary.Len())
					{
						if (aToken.getValue().Len() == nBoundaryPrefix + 2)
							eTheBoundaryType = NEXT_BOUNDARY;
						else if (aToken.getValue().GetChar(nBoundaryPrefix
														       + 2)
								     == '-'
								 && aToken.getValue().GetChar(nBoundaryPrefix
															      + 3)
								        == '-')
							eTheBoundaryType = END_BOUNDARY;
					}
					else
					{
						nError = m_aScanner.scan(aToken, m_aAtomTable,
												 m_pCharsBoundary,
												 CntMBXScanner::ScanMode(0));
						if (nError != ERRCODE_NONE)
							goto end;
						if (aToken.getType() == CntMBXToken::TYPE_ATOM)
							if (aToken.getValue().Len()
								    == rBoundary.Len() - nBoundaryPrefix)
							{
								if (aToken.getValue()
									    == rBoundary.Copy(nBoundaryPrefix))
									eTheBoundaryType = NEXT_BOUNDARY;
							}
							else if (aToken.getValue().Len()
									     == rBoundary.Len() - nBoundaryPrefix
									            + 2
									 && aToken.getValue().
									            GetChar(aToken.getValue().
														        Len()
														    - 2)
									        == '-'
									 && aToken.getValue().
									            GetChar(aToken.getValue().
														        Len()
														    - 1)
									        == '-'
									 && aToken.getValue().
									            Copy(0,
													 aToken.getValue().Len()
													     - 2)
									        == rBoundary.
									               Copy(nBoundaryPrefix))
								eTheBoundaryType = END_BOUNDARY;
					}
					if (eTheBoundaryType != NO_BOUNDARY)
					{
						nError = m_aScanner.scan(aToken, m_aAtomTable,
												 m_pCharsRFC822);
						if (nError != ERRCODE_NONE)
							goto end;
						switch (aToken.getType())
						{
							case CntMBXToken::TYPE_CRLF:
							case CntMBXToken::TYPE_ZERO:
							case CntMBXToken::TYPE_END:
								rBoundaryType = eTheBoundaryType;
								nError = ERRCODE_NONE;
								goto end;
						}
					}
					bHeaderField = false;
				}
				else
				{
					nError = m_aScanner.scan(aToken, m_aAtomTable,
											 m_pCharsRFC822);
					if (nError != ERRCODE_NONE)
						goto end;
				}
				if (bHeaderField
					&& aToken.getType() == CntMBXToken::TYPE_SPECIAL
					&& aToken.getCharValue() == ':')
					switch (nKey)
					{
						case CntMBXAtomTable::ATOM_DATE:
						{
							DateTime aDateTime(0, 0);
							bool bValid;
							nError
								= parseDateTimeFieldBody(aDateTime, bValid);
							if (nError != ERRCODE_NONE)
								goto end;
							if (bValid && aDateTime.IsValid())
							{
								if (pItems)
									pItems->
										Put(SfxDateTimeItem(WID_DATE_CREATED,
															aDateTime));
								if (pNestedMessage)
								{
									INetMIMEUnicodeOutputSink aSink;
									INetMIME::writeDateTime(aSink, aDateTime);
									pNestedMessage->
										SetDate(aSink.takeBuffer());
								}
							}
							break;
						}

						case CntMBXAtomTable::ATOM_RETURN_PATH:
						{
							ByteString aBody;
							nError = readHeaderFieldBody(aBody);
							if (nError != ERRCODE_NONE)
								goto end;
							if (pNestedMessage)
								pNestedMessage->
									SetReturnPath(
										INetMIME::decodeHeaderFieldBody(
											INetMIME::HEADER_FIELD_STRUCTURED,
											aBody));
							break;
						}

						case CntMBXAtomTable::ATOM_RECEIVED:
						{
							ByteString aBody;
							nError = readHeaderFieldBody(aBody);
							if (nError != ERRCODE_NONE)
								goto end;
							if (pNestedMessage)
								pNestedMessage->
									SetReceived(
										INetMIME::decodeHeaderFieldBody(
											INetMIME::HEADER_FIELD_STRUCTURED,
											aBody));
							break;
						}

						case CntMBXAtomTable::ATOM_FROM:
						{
							ByteString aBody;
							nError = readHeaderFieldBody(aBody);
							if (nError != ERRCODE_NONE)
								goto end;
							UniString
								aTheBody(INetMIME::decodeHeaderFieldBody(
									         INetMIME::HEADER_FIELD_ADDRESS,
											 aBody));
							if (pItems)
								pItems->Put(CntNameItem(WID_FROM, aTheBody));
							if (pNestedMessage)
								pNestedMessage->SetFrom(aTheBody);
							break;
						}

						case CntMBXAtomTable::ATOM_SENDER:
						{
							ByteString aBody;
							nError = readHeaderFieldBody(aBody);
							if (nError != ERRCODE_NONE)
								goto end;
							if (pNestedMessage)
								pNestedMessage->
									SetSender(
										INetMIME::decodeHeaderFieldBody(
											INetMIME::HEADER_FIELD_ADDRESS,
											aBody));
							break;
						}

						case CntMBXAtomTable::ATOM_REPLY_TO:
						{
							ByteString aBody;
							nError = readHeaderFieldBody(aBody);
							if (nError != ERRCODE_NONE)
								goto end;
							UniString
								aTheBody(INetMIME::decodeHeaderFieldBody(
									         INetMIME::HEADER_FIELD_ADDRESS,
											 aBody));
							if (pItems)
								pItems->Put(CntStringItem(WID_REPLY_TO,
														  aTheBody));
							if (pNestedMessage)
								pNestedMessage->SetReplyTo(aTheBody);
							break;
						}

						case CntMBXAtomTable::ATOM_TO:
						{
							ByteString aBody;
							nError = readHeaderFieldBody(aBody);
							if (nError != ERRCODE_NONE)
								goto end;
							UniString
								aTheBody(INetMIME::decodeHeaderFieldBody(
									         INetMIME::HEADER_FIELD_ADDRESS,
											 aBody));
							if (pItems)
								pItems->Put(CntStringItem(WID_TO, aTheBody));
							if (pNestedMessage)
								pNestedMessage->SetTo(aTheBody);
							break;
						}

						case CntMBXAtomTable::ATOM_CC:
						{
							ByteString aBody;
							nError = readHeaderFieldBody(aBody);
							if (nError != ERRCODE_NONE)
								goto end;
							UniString
								aTheBody(INetMIME::decodeHeaderFieldBody(
									         INetMIME::HEADER_FIELD_ADDRESS,
											 aBody));
							if (pItems)
								pItems->Put(CntStringItem(WID_CC, aTheBody));
							if (pNestedMessage)
								pNestedMessage->SetCC(aTheBody);
							break;
						}

						case CntMBXAtomTable::ATOM_BCC:
						{
							ByteString aBody;
							nError = readHeaderFieldBody(aBody);
							if (nError != ERRCODE_NONE)
								goto end;
							UniString
								aTheBody(INetMIME::decodeHeaderFieldBody(
									         INetMIME::HEADER_FIELD_ADDRESS,
											 aBody));
							if (pItems)
								pItems->Put(CntStringItem(WID_BCC, aTheBody));
							if (pNestedMessage)
								pNestedMessage->SetBCC(aTheBody);
							break;
						}

						case CntMBXAtomTable::ATOM_MESSAGE_ID:
						{
							ByteString aBody;
							nError = readHeaderFieldBody(aBody);
							if (nError != ERRCODE_NONE)
								goto end;
							UniString
								aTheBody(
									INetMIME::decodeHeaderFieldBody(
										INetMIME::HEADER_FIELD_MESSAGE_ID,
										aBody));
							if (pItems)
								pItems->Put(CntStringItem(WID_MESSAGE_ID,
														  aTheBody));
							if (pNestedMessage)
								pNestedMessage->SetMessageID(aTheBody);
							break;
						}

						case CntMBXAtomTable::ATOM_IN_REPLY_TO:
						{
							ByteString aBody;
							nError = readHeaderFieldBody(aBody);
							if (nError != ERRCODE_NONE)
								goto end;
							UniString
								aTheBody(INetMIME::decodeHeaderFieldBody(
									         INetMIME::HEADER_FIELD_ADDRESS,
											 aBody));
							if (pItems)
								pItems->Put(CntStringItem(WID_IN_REPLY_TO,
														  aTheBody));
							if (pNestedMessage)
								pNestedMessage->SetInReplyTo(aTheBody);
							break;
						}

						case CntMBXAtomTable::ATOM_REFERENCES:
						{
							ByteString aBody;
							nError = readHeaderFieldBody(aBody);
							if (nError != ERRCODE_NONE)
								goto end;
							UniString
								aTheBody(INetMIME::decodeHeaderFieldBody(
									         INetMIME::HEADER_FIELD_ADDRESS,
											 aBody));
							if (pItems)
								pItems->Put(CntStringItem(WID_REFERENCES,
														  aTheBody));
							if (pNestedMessage)
								pNestedMessage->SetReferences(aTheBody);
							break;
						}

						case CntMBXAtomTable::ATOM_KEYWORDS:
						{
							ByteString aBody;
							nError = readHeaderFieldBody(aBody);
							if (nError != ERRCODE_NONE)
								goto end;
							if (pNestedMessage)
								pNestedMessage->
									SetKeywords(
										INetMIME::decodeHeaderFieldBody(
											INetMIME::HEADER_FIELD_PHRASE,
											aBody));
							break;
						}

						case CntMBXAtomTable::ATOM_SUBJECT:
						{
							ByteString aBody;
							nError = readHeaderFieldBody(aBody);
							if (nError != ERRCODE_NONE)
								goto end;
							UniString
								aTheBody(INetMIME::decodeHeaderFieldBody(
									         INetMIME::HEADER_FIELD_TEXT,
											 aBody));
							if (pItems)
								pItems->Put(CntStringItem(WID_TITLE,
														  aTheBody));
							if (pNestedMessage)
								pNestedMessage->SetSubject(aTheBody);
							break;
						}

						case CntMBXAtomTable::ATOM_COMMENTS:
						{
							ByteString aBody;
							nError = readHeaderFieldBody(aBody);
							if (nError != ERRCODE_NONE)
								goto end;
							if (pNestedMessage)
								pNestedMessage->
									SetComments(
										INetMIME::decodeHeaderFieldBody(
											INetMIME::HEADER_FIELD_TEXT,
											aBody));
							break;
						}

						case CntMBXAtomTable::ATOM_MIME_VERSION:
						{
							ByteString aBody;
							nError = readHeaderFieldBody(aBody);
							if (nError != ERRCODE_NONE)
								goto end;
							if (pNestedMessage)
								pNestedMessage->
									SetMIMEVersion(
										INetMIME::decodeHeaderFieldBody(
											INetMIME::HEADER_FIELD_STRUCTURED,
											aBody));
							break;
						}

						case CntMBXAtomTable::ATOM_CONTENT_TYPE:
							nError = readHeaderFieldBody(aContentTypeBody);
							if (nError != ERRCODE_NONE)
								goto end;
							break;

						case CntMBXAtomTable::ATOM_CONTENT_TRANSFER_ENCODING:
							nError = m_aScanner.scan(aToken,
															 m_aAtomTable,
															 m_pCharsRFC822);
							if (nError != ERRCODE_NONE)
								goto end;
							if (aToken.getType() == CntMBXToken::TYPE_ATOM)
							{
								pContentTransferEncoding = aToken.getAtom();
								if (pNestedMessage)
									pNestedMessage->
										SetContentTransferEncoding(
											UniString(
												pContentTransferEncoding->
												    getCanonic(),
												RTL_TEXTENCODING_ISO_8859_1));
							}
							nError = skipToCRLF(aToken);
							if (nError != ERRCODE_NONE)
								goto end;
							break;

						case CntMBXAtomTable::ATOM_CONTENT_ID:
						{
							ByteString aBody;
							nError = readHeaderFieldBody(aBody);
							if (nError != ERRCODE_NONE)
								goto end;
							if (pNestedMessage)
								pNestedMessage->
									SetContentID(
										INetMIME::decodeHeaderFieldBody(
											INetMIME::HEADER_FIELD_MESSAGE_ID,
											aBody));
							break;
						}

						case CntMBXAtomTable::ATOM_CONTENT_DESCRIPTION:
						{
							ByteString aBody;
							nError = readHeaderFieldBody(aBody);
							if (nError != ERRCODE_NONE)
								goto end;
							if (pNestedMessage)
								pNestedMessage->
									SetContentDescription(
										INetMIME::decodeHeaderFieldBody(
											INetMIME::HEADER_FIELD_TEXT,
											aBody));
							break;
						}

						case CntMBXAtomTable::ATOM_CONTENT_BASE:
						{
							ByteString aBody;
							nError = readHeaderFieldBody(aBody);
							if (nError != ERRCODE_NONE)
								goto end;
							if (pNestedMessage)
								pNestedMessage->
									SetContentBase(
										INetMIME::decodeHeaderFieldBody(
											INetMIME::HEADER_FIELD_TEXT,
											aBody));
							break;
						}

						case CntMBXAtomTable::ATOM_CONTENT_DISPOSITION:
						{
							ByteString aBody;
							nError = readHeaderFieldBody(aBody);
							if (nError != ERRCODE_NONE)
								goto end;
							if (pNestedMessage)
								pNestedMessage->
									SetContentDisposition(
										INetMIME::decodeHeaderFieldBody(
											INetMIME::HEADER_FIELD_STRUCTURED,
											aBody));
							break;
						}

						case CntMBXAtomTable::ATOM_CONTENT_LOCATION:
						{
							ByteString aBody;
							nError = readHeaderFieldBody(aBody);
							if (nError != ERRCODE_NONE)
								goto end;
							if (pNestedMessage)
								pNestedMessage->
									SetContentLocation(
										INetMIME::decodeHeaderFieldBody(
											INetMIME::HEADER_FIELD_TEXT,
											aBody));
							break;
						}

						case CntMBXAtomTable::ATOM_NEWSGROUPS:
						{
							ByteString aBody;
							nError = readHeaderFieldBody(aBody);
							if (nError != ERRCODE_NONE)
								goto end;
							UniString
								aTheBody(
									INetMIME::decodeHeaderFieldBody(
										INetMIME::HEADER_FIELD_STRUCTURED,
										aBody));
							if (pItems)
								pItems->Put(CntStringItem(WID_NEWSGROUPS,
														  aTheBody));
							if (pNestedMessage)
								pNestedMessage->SetNewsgroups(aTheBody);
							break;
						}

						case CntMBXAtomTable::ATOM_XREF:
						{
							UniString aHost;
							CntItemListItem aList(WID_NEWS_XREFLIST);
							nError = parseXrefFieldBody(aHost, aList);
							if (nError != ERRCODE_NONE)
								goto end;
							if (!bHasNewsHost
								|| rNewsHost.EqualsIgnoreCaseAscii(aHost))
							{
								if (pItems)
									pItems->Put(aList);
								if (pNestedMessage)
									pNestedMessage->
										SetXref(CntMBXFormat::translateXref(
											        aHost, aList));
							}
							break;
						}

						case CntMBXAtomTable::ATOM_X_MAILER:
						{
							ByteString aBody;
							nError = readHeaderFieldBody(aBody);
							if (nError != ERRCODE_NONE)
								goto end;
							if (pNestedMessage)
								pNestedMessage->
									SetXMailer(
										INetMIME::decodeHeaderFieldBody(
											INetMIME::HEADER_FIELD_TEXT,
											aBody));
							break;
						}

						case CntMBXAtomTable::ATOM_X_PRIORITY:
						{
							sal_uInt32 nPriority;
							bool bValid;
							nError = parseNumericFieldBody(false, false,
														   nPriority, bValid);
							if (nError != ERRCODE_NONE)
								goto end;
							if (bValid && nPriority >= CNT_PRIO_HIGHEST
								&& nPriority <= CNT_PRIO_LOWEST)
							{
								if (pItems)
									pItems->
										Put(CntPriorityItem(WID_PRIORITY,
															CntPriority(
																nPriority)));
								if (pNestedMessage)
									pNestedMessage->
										SetXPriority(
											CntMBXFormat::translateXPriority(
												CntPriority(nPriority)));
							}
							break;
						}

						case CntMBXAtomTable::ATOM_X_CHAOS_READ:
						{
							bool bRead;
							bool bValid;
							nError = parseBooleanFieldBody(bRead, bValid);
							if (nError != ERRCODE_NONE)
								goto end;
							if (bValid && pItems)
								pItems->Put(CntBoolItem(WID_IS_READ, bRead));
							break;
						}

						case CntMBXAtomTable::ATOM_X_CHAOS_MARKED:
						{
							bool bMarked;
							bool bValid;
							nError = parseBooleanFieldBody(bMarked, bValid);
							if (nError != ERRCODE_NONE)
								goto end;
							if (bValid && pItems)
								pItems->Put(CntBoolItem(WID_IS_MARKED,
														bMarked));
							break;
						}

						case CntMBXAtomTable::ATOM_X_CHAOS_RECIPIENTS:
						{
							CntRecipientListItem aList(WID_RECIPIENTLIST);
							nError = parseXCHAOSRecipientsFieldBody(aList);
							if (nError != ERRCODE_NONE)
								goto end;
							if (pItems)
								pItems->Put(aList);
							break;
						}

						case CntMBXAtomTable::ATOM_X_CHAOS_SIZE:
						{
							sal_uInt32 nSize;
							bool bValid;
							nError = parseNumericFieldBody(false, true, nSize,
														   bValid);
							if (nError != ERRCODE_NONE)
								goto end;
							if (bValid && pItems)
								pItems->Put(CntUInt32Item(WID_DOCUMENT_SIZE,
														  nSize));
							break;
						}

						case CntMBXAtomTable::ATOM_X_MOZILLA_STATUS:
						{
							sal_uInt32 nStatus;
							bool bValid;
							nError = parseNumericFieldBody(true, true,
														   nStatus, bValid);
							if (nError != ERRCODE_NONE)
								goto end;
							if (bValid && nStatus <= 0xFFFF)
								nMozillaStatus = nStatus;
							break;
						}

						default:
							nError = skipToCRLF(aToken);
							if (nError != ERRCODE_NONE)
								goto end;
							break;
					}
				else
				{
					nError = skipToCRLF(aToken);
					if (nError != ERRCODE_NONE)
						goto end;
				}
				break;
			}

			case CntMBXToken::TYPE_CRLF:
				bHeader = false;
				break;

			case CntMBXToken::TYPE_ZERO:
			case CntMBXToken::TYPE_END:
				rBoundaryType = NO_BOUNDARY;
				nError = ERRCODE_NONE;
				goto end;

			default:
				nError = skipToCRLF(aToken);
				if (nError != ERRCODE_NONE)
					goto end;
				break;
		}
	}

	while (!INetContentTypes::parse(aContentTypeBody, aContentType,
									aContentSubType, &aContentParameters))
		aContentTypeBody.Assign(RTL_CONSTASCII_STRINGPARAM(
			                        "text/plain; charset=us-ascii"));
	        // this default might not be right for certain multi part messages
	{
		UniString aTheContentTypeBody(aContentTypeBody,
									  RTL_TEXTENCODING_ISO_8859_1);
		if (pItems)
			pItems->Put(CntContentTypeItem(WID_CONTENT_TYPE,
										   aTheContentTypeBody));
		if (pNestedMessage)
			pNestedMessage->SetContentType(aTheContentTypeBody);
	}

	if (nMozillaStatus != 0x10000)
	{
		// MSG_FLAG_READ = 0x0001:
		if (pItems && pItems->GetItemState(WID_IS_READ) != SFX_ITEM_SET)
			pItems->Put(CntBoolItem(WID_IS_READ,
									(nMozillaStatus & 0x0001) != 0));

		// MSG_FLAG_MARKED = 0x0004:
		if (pItems && pItems->GetItemState(WID_IS_MARKED) != SFX_ITEM_SET)
			pItems->Put(CntBoolItem(WID_IS_MARKED,
									(nMozillaStatus & 0x0004) != 0));

		// MSG_FLAG_HAS_RE = 0x0010:
		if (nMozillaStatus & 0x0010)
		{
			if (pItems)
			{
				UniString aSubject = ITEMSET_VALUE(pItems, CntStringItem,
												   WID_TITLE);
				if (aSubject.Len() == 0)
					aSubject.AssignAscii(RTL_CONSTASCII_STRINGPARAM("Re:"));
				else
					aSubject.InsertAscii("Re: ", 0);
				pItems->Put(CntStringItem(WID_TITLE, aSubject));
			}
			if (pNestedMessage)
			{
				UniString aSubject = pNestedMessage->GetSubject();
				if (aSubject.Len() == 0)
					aSubject.AssignAscii(RTL_CONSTASCII_STRINGPARAM("Re:"));
				else
					aSubject.InsertAscii("Re: ", 0);
				pNestedMessage->SetSubject(aSubject);
			}
		}

		// MSG_FLAG_PARTIAL = 0x0400:
		if (nMozillaStatus & 0x0400)
			bNoBody = true;

		// MSG_FLAG_QUEUED = 0x0800:
		if (nMozillaStatus & 0x0800 && pItems
			&& pItems->GetItemState(WID_RECIPIENTLIST) != SFX_ITEM_SET)
		{
			CntRecipientInfo * pSMTP = 0;
			UniString aTo = ITEMSET_VALUE(pItems, CntStringItem, WID_TO);
			UniString aCC = ITEMSET_VALUE(pItems, CntStringItem, WID_CC);
			UniString aBCC = ITEMSET_VALUE(pItems, CntStringItem, WID_BCC);
			if (aTo.Len() != 0 || aCC.Len() != 0 || aBCC.Len() != 0)
				pSMTP = new CntRecipientInfo(
					            aTo, aCC, aBCC, UniString(), UniString(),
								UniString(), CNT_OUTMSG_PROTOCOL_SMTP,
								CNT_OUTMSG_INTERNALSTATE_WRITTEN,
								CNT_IMPORT_PARTIAL_RECIPIENT_INFO_ERROR, 0,
								UniString(), UniString(), UniString());

			CntRecipientInfo * pNNTP = 0;
			UniString aNewsgroups
				= ITEMSET_VALUE(pItems, CntStringItem, WID_NEWSGROUPS);
			if (aNewsgroups.Len() != 0)
				pNNTP = new CntRecipientInfo(
					            UniString(), UniString(), UniString(),
								aNewsgroups, UniString(), UniString(),
								CNT_OUTMSG_PROTOCOL_NNTP,
								CNT_OUTMSG_INTERNALSTATE_WRITTEN,
								CNT_IMPORT_PARTIAL_RECIPIENT_INFO_ERROR, 0,
								UniString(), UniString(), UniString());

			if (pSMTP || pNNTP)
			{
				CntRecipientListItem aList(WID_RECIPIENTLIST);
				if (pSMTP)
					aList.Append(pSMTP);
				if (pNNTP)
					aList.Append(pNNTP);
				pItems->Put(aList);
			}
		}
	}

	if (pItems && !rPolicy.doCache(pVersion, *pItems, aBodyCacheName))
	{
		delete pNestedMessage;
		m_bBodyScannerAvailable = true;
		return ERRCODE_NONE;
	}

	if (bNoBody || aContentType == "x-chaos")
	{
		nError = parseMessage(rPolicy, pVersion, bHasBoundary, rBoundary,
							  bHasNewsHost, rNewsHost, 0, 0, rBoundaryType,
							  false);
		if (nError != ERRCODE_NONE)
			goto end;
	}
	else if (aContentType == "message")
	{
		if (pNestedMessage)
			pNestedMessage->EnableAttachChild(INETCOREMSG_MESSAGE_RFC822);
		nError = parseMessage(rPolicy, pVersion, bHasBoundary, rBoundary,
							  bHasNewsHost, rNewsHost, 0, pNestedMessage,
							  rBoundaryType, true);
		if (nError != ERRCODE_NONE)
			goto end;
		bBody = true;
	}
	else if (aContentType == "multipart")
	{
		if (pNestedMessage)
			if (aContentSubType == "parallel")
				pNestedMessage->
					EnableAttachChild(INETCOREMSG_MULTIPART_PARALLEL);
			else if (aContentType == "digest")
				pNestedMessage->
					EnableAttachChild(INETCOREMSG_MULTIPART_DIGEST);
			else if (aContentType == "alternative")
				pNestedMessage->
					EnableAttachChild(INETCOREMSG_MULTIPART_ALTERNATIVE);
			else if (aContentType == "related")
				pNestedMessage->
					EnableAttachChild(INETCOREMSG_MULTIPART_RELATED);
			else
				pNestedMessage->
					EnableAttachChild(INETCOREMSG_MULTIPART_MIXED);
		ByteString aNestedBoundary;
		INetContentTypeParameter const * pBoundaryParameter
			= aContentParameters.
			      find(ByteString(RTL_CONSTASCII_STRINGPARAM("boundary")));
		if (pBoundaryParameter)
			if (pBoundaryParameter->m_bConverted)
				aNestedBoundary = ByteString(pBoundaryParameter->m_sValue,
											 RTL_TEXTENCODING_UTF8);
			else
				for (xub_StrLen i = 0; i < pBoundaryParameter->m_sValue.Len();
					 ++i)
				{
					DBG_ASSERT(INetMIME::isISO88591(pBoundaryParameter->
													    m_sValue.GetChar(i))
							   || pBoundaryParameter->m_sValue.GetChar(i)
							              / 0x100
							          == 0xF8,
							   "CntImport::parseMessage(): Bad boundary");
					aNestedBoundary
						+= pBoundaryParameter->m_sValue.GetChar(i) & 0xFF;
				}

		BoundaryType eNestedBoundaryType;
		nError = parseMessage(rPolicy, pVersion, true, aNestedBoundary,
							  bHasNewsHost, rNewsHost, 0, 0,
							  eNestedBoundaryType, false);
		if (nError != ERRCODE_NONE)
			goto end;
		while (eNestedBoundaryType == NEXT_BOUNDARY)
		{
			nError = parseMessage(rPolicy, pVersion, true, aNestedBoundary,
								  bHasNewsHost, rNewsHost, 0, pNestedMessage,
								  eNestedBoundaryType, true);
			if (nError != ERRCODE_NONE)
				goto end;
		}
		nError = parseMessage(rPolicy, pVersion, bHasBoundary, rBoundary,
							  bHasNewsHost, rNewsHost, 0, 0, rBoundaryType,
							  false);
		if (nError != ERRCODE_NONE)
			goto end;
		bBody = true;
	}
	else
	{
		TempFileStream * pStream = pNestedMessage ? new TempFileStream : 0;
		switch (pContentTransferEncoding ?
				    pContentTransferEncoding->getKey() :
				    CntMBXAtomTable::ATOM_NO)
		{
			case CntMBXAtomTable::ATOM_BASE64:
			{
				bool bData = true;
				sal_uInt32 nValue = 0;
				int nSignificance = 18;
				for (;;)
				{
					bool bFound;
					ByteString aLine;
					bool bTerminated;
					nError = readBodyLine(bHasBoundary, rBoundary, bFound,
										  aLine, bTerminated, rBoundaryType);
					if (nError != ERRCODE_NONE)
					{
						delete pStream;
						goto end;
					}
					if (!bFound)
						break;
					if (bData)
						for (xub_StrLen i = 0; i < aLine.Len(); ++i)
						{
							int nWeight
								= INetMIME::getBase64Weight(aLine.GetChar(i));
							if (nWeight >= 0)
							{
								nValue |= sal_uInt32(nWeight)
									          << nSignificance;
								if (nSignificance == 0)
								{
									if (pStream)
										*pStream
											<< sal_Char(nValue >> 16)
											<< sal_Char(nValue >> 8 & 0xFF)
											<< sal_Char(nValue & 0xFF);
									nValue = 0;
									nSignificance = 18;
								}
								else
									nSignificance -= 6;
							}
							else if (nWeight == -1) // '='
							{
								if (nSignificance == 6)
								{
									if (pStream)
										*pStream << sal_Char(nValue >> 16);
									bData = false;
									break;
								}
								else if (nSignificance == 0)
								{
									if (pStream)
										*pStream
											<< sal_Char(nValue >> 16)
											<< sal_Char(nValue >> 8 & 0xFF);
									bData = false;
									break;
								}
							}
						}
				}
				break;
			}

			case CntMBXAtomTable::ATOM_QUOTED_PRINTABLE:
				{for (bool bCRLF = false;;)
				{
					bool bFound;
					ByteString aLine;
					bool bTerminated;
					nError = readBodyLine(bHasBoundary, rBoundary, bFound,
										  aLine, bTerminated, rBoundaryType);
					if (nError != ERRCODE_NONE)
					{
						delete pStream;
						goto end;
					}
					if (!bFound)
					{
						if (pStream && bCRLF && rBoundaryType == NO_BOUNDARY)
							*pStream << "\x0D\x0A";
						break;
					}
					if (pStream && bCRLF)
						*pStream << "\x0D\x0A";
					bCRLF = bTerminated;
					for (xub_StrLen i = 0; i < aLine.Len(); ++i)
					{
						sal_Char c = aLine.GetChar(i);
						if (c == '=')
						{
							if (i == aLine.Len() - 1)
							{
								bCRLF = false;
								break;
							}
							if (i + 2 < aLine.Len())
							{
								int nWeight1 = INetMIME::getHexWeight(
									               aLine.GetChar(i + 1));
								int nWeight2 = INetMIME::getHexWeight(
									               aLine.GetChar(i + 2));
								if (nWeight1 >= 0 && nWeight2 >= 0)
								{
									if (pStream)
										*pStream << sal_Char(nWeight1 << 4
															     | nWeight2);
									i += 2;
									continue;
								}
							}
						}
						*pStream << c;
					}
				}}
				break;

			default:
				for (bool bCRLF = false;;)
				{
					bool bFound;
					ByteString aLine;
					bool bTerminated;
					nError = readBodyLine(bHasBoundary, rBoundary, bFound,
										  aLine, bTerminated, rBoundaryType);
					if (nError != ERRCODE_NONE)
					{
						delete pStream;
						goto end;
					}
					if (!bFound)
					{
						if (pStream && bCRLF && rBoundaryType == NO_BOUNDARY)
							*pStream << "\x0D\x0A";
						break;
					}
					if (pStream)
					{
						if (bCRLF)
							*pStream << "\x0D\x0A";
						*pStream << aLine.GetBuffer();
					}
					bCRLF = bTerminated;
				}
				break;
		}
		if (pNestedMessage)
		{
			pStream->Flush();
			pNestedMessage->SetDocumentStream(pStream);
			pNestedMessage->SetDocumentSize(pStream->Tell());
		}
		bBody = true;
	}

end:
	if (pNestedMessage)
		if (nError == ERRCODE_NONE && pItems && bBody)
		{
			CntMessageBodyItem aItem(WID_MESSAGEBODY, aBodyCacheName);
			aItem.Set(pNestedMessage, rPolicy.getCacheNode());
			pItems->Put(aItem);
		}
		else if (nError == ERRCODE_NONE && pMessage)
			pMessage->AttachChild(*pNestedMessage);
		else
			delete pNestedMessage;
	return nError;
}

//============================================================================
CntImport::~CntImport()
{
	delete m_pBodyScanner;
	delete m_pMessageFactory;
}

//============================================================================
ErrCode CntImport::getMessage(CntMessageCachingPolicy & rPolicy,
							  BOOL & rFound, CntMBXVersion *& rVersion,
							  SfxItemSet & rItems, ULONG & rProgress,
							  UniString const * pNewsHost)
{
	rFound = false;
	rVersion = 0;

	if (m_pBodyScanner)
		return ERRCODE_IO_RECURSIVE;
	m_bBodyScannerAvailable = false;

	ErrCode nError = determineSourceFormat();
	if (nError != ERRCODE_NONE)
		return nError;

	sal_uInt32 nVersionNumber = CntMBXVersion::NONE;

	// Find line starting message:
	switch (m_eSourceFormat)
	{
		case CntMBXScanner::FORMAT_OUTLOOK_EXPRESS:
		{
			// Find characters "\x00\x7F\x00\x7F" 12CHAR:
			enum State { STATE_SEARCHING, STATE_00, STATE_007F, STATE_007F00,
						 STATE_FOUND };
			State eState = STATE_SEARCHING;
			do
			{
				CntMBXToken aToken;
				nError = m_aScanner.scan(aToken, m_aAtomTable,
										 CntMBXChars::aCharsPlain,
										 CntMBXScanner::ScanMode(0));
				if (nError != ERRCODE_NONE)
					return nError;
				if (aToken.getType() == CntMBXToken::TYPE_END)
				{
					rProgress = m_aScanner.getInputProcessed();
					return ERRCODE_NONE;
				}
				switch (eState)
				{
					case STATE_SEARCHING:
						eState = aToken.getCharValue() == '\x00' ?
							         STATE_00 : STATE_SEARCHING;
						break;

					case STATE_00:
						eState = aToken.getCharValue() == '\x7F' ?
							         STATE_007F :
								 aToken.getCharValue() == '\x00' ?
						             STATE_00 : STATE_SEARCHING;
						break;

					case STATE_007F:
						eState = aToken.getCharValue() == '\x00' ?
						             STATE_007F00 : STATE_SEARCHING;
						break;

					case STATE_007F00:
						eState = aToken.getCharValue() == '\x7F' ?
						             STATE_FOUND :
						         aToken.getCharValue() == '\x00' ?
						             STATE_00 : STATE_SEARCHING;
						break;
				}
			}
			while (eState != STATE_FOUND);
			for (int i = 0; i < 12; ++i)
			{
				CntMBXToken aToken;
				nError = m_aScanner.scan(aToken, m_aAtomTable,
										 CntMBXChars::aCharsPlain,
										 CntMBXScanner::ScanMode(0));
				if (nError != ERRCODE_NONE)
					return nError;
				if (aToken.getType() == CntMBXToken::TYPE_END)
				{
					rProgress = m_aScanner.getInputProcessed();
					return ERRCODE_NONE;
				}
			}
			rFound = true;
			break;
		}

		default:
		{
			// Find line starting with "From ":
			bool bNewline = true;
			do
			{
				CntMBXToken aToken;
				nError = m_aScanner.scan(aToken, m_aAtomTable,
										 CntMBXChars::aCharsRFC822,
										 CntMBXScanner::ScanMode(
											 CntMBXScanner::CANONIC_ATOM));
				if (nError != ERRCODE_NONE)
					return nError;
				switch (aToken.getType())
				{
					case CntMBXToken::TYPE_ATOM:
						if (bNewline && aToken.getValue() == "From")
						{
							nError
								= m_aScanner.scan(aToken, m_aAtomTable,
												  CntMBXChars::aCharsRFC822,
												  CntMBXScanner::ScanMode(0));
							if (nError != ERRCODE_NONE)
								return nError;
							switch (aToken.getType())
							{
								case CntMBXToken::TYPE_LWSP:
									rFound = aToken.getValue().GetChar(0)
										         == ' ';
									break;

								case CntMBXToken::TYPE_CRLF:
									bNewline = true;
									break;

								case CntMBXToken::TYPE_ZERO:
								case CntMBXToken::TYPE_END:
									rProgress
										= m_aScanner.getInputProcessed();
									return ERRCODE_NONE;

								default:
									bNewline = false;
									break;
							}
						}
						else
							bNewline = false;
						break;

					case CntMBXToken::TYPE_CRLF:
						bNewline = true;
						break;

					case CntMBXToken::TYPE_ZERO:
					case CntMBXToken::TYPE_END:
						rProgress = m_aScanner.getInputProcessed();
						return ERRCODE_NONE;

					default:
						bNewline = false;
						break;
				}
			}
			while (!rFound);

			// Check if line is 'From CHAOS <version> <tag>':
			CntMBXToken aToken;
			nError = m_aScanner.scan(aToken, m_aAtomTable,
									 CntMBXChars::aCharsRFC822);
			if (nError != ERRCODE_NONE)
				return nError;
			if (aToken.getType() == CntMBXToken::TYPE_ATOM
				&& aToken.getAtom()->getKey() == CntMBXAtomTable::ATOM_CHAOS)
			{
				nError = m_aScanner.
					         scan(aToken, m_aAtomTable,
								  CntMBXChars::aCharsRFC822,
								  CntMBXScanner::ScanMode(
									  CntMBXScanner::SKIP_LWSP
									      | CntMBXScanner::SKIP_COMMENTS));
				if (nError != ERRCODE_NONE)
					return nError;
				if (aToken.getType() == CntMBXToken::TYPE_ATOM)
				{
					sal_Char const * p = aToken.getValue().GetBuffer();
					sal_Char const * pEnd = p + aToken.getValue().Len();
					sal_uInt32 nValue;
					if (INetMIME::scanUnsigned(p, pEnd, true, nValue)
						&& p == pEnd)
					{
						nVersionNumber = nValue;
						if (nVersionNumber == 0)
						{
							// Check if <tag> is 'message' or 'newsbox':
							nError
								= m_aScanner.scan(aToken, m_aAtomTable,
												  CntMBXChars::aCharsRFC822);
							if (nError != ERRCODE_NONE)
								return nError;
							if (aToken.getType() == CntMBXToken::TYPE_ATOM)
								switch (aToken.getAtom()->getKey())
								{
									case CntMBXAtomTable::ATOM_MESSAGE:
										rVersion
											= new CntMBXVersion0(
											    CntMBXVersion0::TYPE_MESSAGE);
										break;

									case CntMBXAtomTable::ATOM_MESSAGEBOX:
										rVersion
											= new CntMBXVersion0(
											 CntMBXVersion0::TYPE_MESSAGEBOX);
										break;

									case CntMBXAtomTable::ATOM_NEWSBOX:
										rVersion
											= new CntMBXVersion0(
											    CntMBXVersion0::TYPE_NEWSBOX);
										break;
								}
						}
					}
				}
			}
			nError = skipToCRLF(aToken);
			if (nError != ERRCODE_NONE)
				return nError;
			break;
		}
	}

	if (rVersion == 0)
		rVersion = new CntMBXVersion(nVersionNumber);

	// Read message:
	UniString aTheNewsHost;
	if (pNewsHost)
		aTheNewsHost = *pNewsHost;
	BoundaryType eBoundaryType;
	nError = parseMessage(rPolicy, rVersion, false, ByteString(),
						  pNewsHost != 0, aTheNewsHost, &rItems, 0,
						  eBoundaryType, true);
	if (nError != ERRCODE_NONE)
		return nError;

	rProgress = m_aScanner.getInputProcessed();
	return ERRCODE_NONE;
}

//============================================================================
CntMBXBodyScanner * CntImport::aquireBodyScanner()
{
	if (!m_bBodyScannerAvailable)
		return 0;
	m_bBodyScannerAvailable = false;
	m_pBodyScanner = new CntMBXBodyScanner(&m_aScanner, m_aAtomTable);
	return m_pBodyScanner;
}

//============================================================================
void CntImport::releaseBodyScanner()
{
	m_aScanner.scanBodyDone();
	delete m_pBodyScanner;
	m_pBodyScanner = 0;
}

//============================================================================
//
//  class TempFileStream
//
//============================================================================

TempFileStream::TempFileStream():
	SvFileStream(DirEntry(UniString::CreateFromAscii(
		                      RTL_CONSTASCII_STRINGPARAM("imp*.tmp"))).
				     TempName().GetFull(),
				 STREAM_READ | STREAM_WRITE | STREAM_TRUNC
				     | STREAM_SHARE_DENYALL)
{}

//============================================================================
// virtual
TempFileStream::~TempFileStream()
{
	Close();
	String aFilename(GetFileName());
	DirEntry(aFilename).Kill();
}

