/*************************************************************************
 *
 *  $RCSfile: imapmbx2.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:13:03 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SVTOOLS_CINTITEM_HXX
#include <svtools/cintitem.hxx>
#endif
#ifndef TOOLS_INETMIME_HXX
#include <tools/inetmime.hxx>
#endif

#ifndef _CNTAPI_HXX
#include <cntapi.hxx>
#endif
#ifndef _CNTMMITM_HXX
#include <cntmmitm.hxx>
#endif
#ifndef _CNTRESID_HXX
#include <cntresid.hxx>
#endif
#ifndef _CNTSTGND_HXX
#include <cntstgnd.hxx>
#endif
#ifndef _CNTTRITM_HXX
#include <cnttritm.hxx>
#endif
#ifndef _CSTRITEM_HXX
#include <cstritem.hxx>
#endif
#ifndef _CHAOS_IMAP_HXX
#include <imap.hxx>
#endif
#ifndef _CHAOS_MBXFORMT_HXX
#include <mbxformt.hxx>
#endif
#ifndef _PROCHAOS_HRC
#include <prochaos.hrc>
#endif
#ifndef _CHAOS_STORITEM_HXX
#include <storitem.hxx>
#endif

#ifndef CHAOS_IMAPACNT_HXX
#include <imapacnt.hxx>
#endif
#ifndef CHAOS_IMAPMBOX_HXX
#include <imapmbox.hxx>
#endif
#ifndef CHAOS_IMAPMBXT_HXX
#include <imapmbxt.hxx>
#endif
#ifndef CHAOS_IMAPMESG_HXX
#include <imapmesg.hxx>
#endif
#ifndef CHAOS_IMAPSTOR_HXX
#include <imapstor.hxx>
#endif
#ifndef CHAOS_IMAPURL_HXX
#include <imapurl.hxx>
#endif

using namespace chaos;

//============================================================================
//
//  CntIMAPMboxRenameTask
//
//============================================================================

// virtual
bool CntIMAPMboxRenameTask::initialize()
{
	if (CntIMAPURL::isInboxURL(OWN_URL(&getMbox().getNode())))
	{
		cancel();
		return false;
	}

	if (ITEM_VALUE(CntStringItem, *getJob().GetRequest())
		    == ITEMSET_VALUE(&getMbox().getNode(), CntStringItem, WID_TITLE))
	{
		done();
		return false;
	}

	while (!super::initialize())
		switch (handleError(ERRCODE_CHAOS_OFFLINE))
		{
			case ERROR_RESPONSE_ABORT:
			case ERROR_RESPONSE_IGNORE:
				cancel();
			case ERROR_RESPONSE_CANCELED:
				return false;
		}

	m_aAcntURL = OWN_URL(&getAcnt().getNode());
	return true;
}

//============================================================================
// virtual
CntIMAPOnlineTask::Execution
CntIMAPMboxRenameTask::executeState(const INetIMAPResponse * pResponse)
{
	switch (m_nState)
	{
		case STATE_SEND_CLOSE:
			if (ITEMSET_VALUE(&getMbox().getNode(), CntBoolItem,
							  WID_FLAG_SUBSCRIBED))
				m_aSscrbdMboxs.insert(getMboxLiteralFullName());

			if (!CntIMAPMbox::isSubMbox(getMboxLiteralFullName(),
										getHierarchySeparator(),
										getAcnt().getClient()->
										    getSelectedMailbox()))
			{
				m_nState = STATE_SEND_RENAME;
				return EXEC_CONTINUE;
			}

			// At least the 'Netscape IMAP4 Service 1.0' server immediately
			// shuts down the connection when the selected mailbox is renamed,
			// so close the mailbox first (and the 'IMAP4rev1 v10.183 server'
			// shuts down the connection when the selected mailbox is a child
			// of the mailbox being renamed):
			pushStatusInformation(CntResId(RID_CLOSING_FOLDER),
								  CntIMAPStatusInformation::TAG_NONE, true);

			++m_nState;
			return handleCommandFailure(clientCommandClose());

		case STATE_RECV_CLOSE:
			switch (pResponse->getType())
			{
				case INetIMAPResponse::TYPE_STATE:
				{
					const INetIMAPStateResponse & rStateResponse
						= *static_cast< const INetIMAPStateResponse * >(
							   pResponse);

					if (rStateResponse.isFinal()
						&& rStateResponse.getState()
						       == INetIMAPStateResponse::STATE_OK)
					{
						Execution eExecution
							= handleAlertResponse(rStateResponse);
						if (eExecution != EXEC_NOTHING)
							return eExecution;

						popStatusInformation();

						m_nState = STATE_SEND_RENAME;
						return EXEC_CONTINUE;
					}
					break;
				}
			}
			break;

		case STATE_SEND_RENAME:
		{
			ByteString aNewMboxLiteralLastName(
				           CntIMAPUTF7::translateToUTF7(
							   ITEM_VALUE(CntStringItem,
										  *getJob().GetRequest())));
			if (getHierarchySeparator()
				 && aNewMboxLiteralLastName.Search(getHierarchySeparator())
				        != STRING_NOTFOUND)
			{
				if (handleError(*new StringErrorInfo(
					                     ERRCODE_CHAOS_IMAP_BAD_TITLE,
										 ITEM_VALUE(CntStringItem,
													*getJob().GetRequest())))
					    != ERROR_RESPONSE_CANCELED)
					cancel();
				return EXEC_DONE;
			}

			m_aNewMboxURL
				= CntIMAPURL::createSubMboxURL(OWN_URL(getMbox().
													   getNode().GetParent()),
											   aNewMboxLiteralLastName);
			CntIMAPURL::getMboxLiteralFullName(m_aNewMboxURL,
											   getHierarchySeparator(),
											   m_aNewMboxLiteralFullName);
				// Using the old hierarchy separator to parse the new mailbox
				// name can be wrong in one case:  If the old mailbox was a
				// root mailbox, the new mailbox has another hierarchy
				// separator than the old one, and the new mailbox name
				// contains that new hierarchy separator, then we've renamed
				// the old mailbox into a sub mailbox of some other mailbox.

			++m_nState;
			return handleCommandFailure(clientCommandRename(
				                            getMboxLiteralFullName(),
											m_aNewMboxLiteralFullName));
		}

		case STATE_RECV_RENAME:
			switch (pResponse->getType())
			{
				case INetIMAPResponse::TYPE_STATE:
				{
					const INetIMAPStateResponse & rStateResponse
						= *static_cast< const INetIMAPStateResponse * >(
							   pResponse);

					if (rStateResponse.isFinal()
						&& rStateResponse.getState()
						       == INetIMAPStateResponse::STATE_OK)
					{
						getMbox().renameStorage(getJob(), m_aNewMboxURL);
							// once storages are no longer deleted across a
							// rename, this call can go...

						CntNodeRef xNewMboxNode
							= getMbox().getNode().GetParent()->
							      Query(m_aNewMboxURL);
						if (xNewMboxNode.Is())
						{
							static_cast< CntIMAPMboxNode * >(&xNewMboxNode)->
								getMbox().initialize(getJob());
							getJob().Result(xNewMboxNode,
											CNT_ACTION_EXCHANGED);
							static_cast< CntIMAPMboxNode * >(&xNewMboxNode)->
								getMbox().clearRenamed(false);
								// once storages are no longer deleted across
								// a rename, this call can go...
						}

						Execution eExecution
							= handleAlertResponse(rStateResponse);
						if (eExecution != EXEC_NOTHING)
							return eExecution;

						m_bNewHierarchySeparatorDetermined
							= xNewMboxNode.Is()
							  && static_cast< CntIMAPMboxNode * >(
								         &xNewMboxNode)->
							         getMbox().
							             hasDeterminedHierarchySeparator(
											 m_cNewHierarchySeparator);
						m_aSscrbdMboxIter = m_aSscrbdMboxs.begin();

						m_nState = STATE_SEND_LSUB;
						return EXEC_CONTINUE;
					}
					break;
				}
			}
			break;

		case STATE_SEND_LSUB:
		{
			sal_Char cSeparator = getHierarchySeparator();
			if (cSeparator == '\0')
			{
				m_nState = STATE_SEND_LIST;
				return EXEC_CONTINUE;
			}

			ByteString aPattern(getMboxLiteralFullName());
			aPattern += cSeparator;
			aPattern += INET_IMAP_LIST_WILDCARD_SEPARATOR;

			++m_nState;
			return handleCommandFailure(clientCommandLSub(ByteString(),
														  aPattern));
		}

		case STATE_RECV_LSUB:
			switch (pResponse->getType())
			{
				case INetIMAPResponse::TYPE_STATE:
				{
					INetIMAPStateResponse const & rStateResponse
						= *static_cast< INetIMAPStateResponse const * >(
							   pResponse);

					if (rStateResponse.isFinal()
						&& rStateResponse.getState()
						       == INetIMAPStateResponse::STATE_OK)
					{
						Execution eExecution
							= handleAlertResponse(rStateResponse);
						if (eExecution != EXEC_NOTHING)
							return eExecution;

						m_nState = STATE_SEND_LIST;
						return EXEC_CONTINUE;
					}
					break;
				}

				case INetIMAPResponse::TYPE_LIST:
				{
					INetIMAPListResponse const & rListResponse
						= *static_cast< INetIMAPListResponse const * >(
							   pResponse);

					for (ULONG i = 0; i < rListResponse.getMailboxCount();
						 ++i)
					{
						INetIMAPListResponseMailbox const & rSubMbox
							= rListResponse.getMailbox(i);
						ByteString aSubMboxLiteralFullName;
						if (isSubMbox(getMboxLiteralFullName(), rSubMbox,
									  aSubMboxLiteralFullName))
							m_aSscrbdMboxs.insert(aSubMboxLiteralFullName);
					}

					return EXEC_DONE;
				}
			}
			break;

		case STATE_SEND_LIST:
			if (m_aSscrbdMboxs.empty())
			{
				done();
				return EXEC_DONE;
			}

			if (m_bNewHierarchySeparatorDetermined)
			{
				m_nState = STATE_SEND_UNSUBSCRIBE;
				return EXEC_CONTINUE;
			}

			++m_nState;
			return handleCommandFailure(clientCommandLSub(
				                            ByteString(),
											m_aNewMboxLiteralFullName));

		case STATE_RECV_LIST:
			switch (pResponse->getType())
			{
				case INetIMAPResponse::TYPE_STATE:
				{
					INetIMAPStateResponse const & rStateResponse
						= *static_cast< INetIMAPStateResponse const * >(
							   pResponse);

					if (rStateResponse.isFinal()
						&& rStateResponse.getState()
						       == INetIMAPStateResponse::STATE_OK)
					{
						Execution eExecution
							= handleAlertResponse(rStateResponse);
						if (eExecution != EXEC_NOTHING)
							return eExecution;

						if (!m_bNewHierarchySeparatorDetermined)
							return handleCommandFailure(
								       *new StringErrorInfo(
										        ERRCODE_CHAOS_IMAP_BAD_SERVER,
												ITEMSET_VALUE(
													&getAcnt().getNode(),
													CntStringItem,
													WID_SERVERNAME)));

						m_nState = STATE_SEND_UNSUBSCRIBE;
						return EXEC_CONTINUE;
					}
					break;
				}

				case INetIMAPResponse::TYPE_LIST:
				{
					INetIMAPListResponse const & rListResponse
						= *static_cast< INetIMAPListResponse const * >(
							   pResponse);

					for (ULONG i = 0; i < rListResponse.getMailboxCount();
						 ++i)
					{
						INetIMAPListResponseMailbox const & rMbox
							= rListResponse.getMailbox(i);
						ByteString aMboxLiteralFullName;
						if (isRootMbox(rMbox, aMboxLiteralFullName)
							&& aMboxLiteralFullName
							       == m_aNewMboxLiteralFullName)
						{
							m_bNewHierarchySeparatorDetermined = true;
							m_cNewHierarchySeparator
								= rMbox.getHierarchySeparator();
						}
					}

					return EXEC_DONE;
				}
			}
			break;

		case STATE_SEND_UNSUBSCRIBE:
			if (m_aSscrbdMboxIter == m_aSscrbdMboxs.end())
			{
				done();
				return EXEC_DONE;
			}

			++m_nState;
			return handleCommandFailure(clientCommandUnSubscribe(
				                            *m_aSscrbdMboxIter));

		case STATE_RECV_UNSUBSCRIBE:
			switch (pResponse->getType())
			{
				case INetIMAPResponse::TYPE_STATE:
				{
					const INetIMAPStateResponse & rStateResponse
						= *static_cast< const INetIMAPStateResponse * >(
							   pResponse);

					if (rStateResponse.isFinal())
						switch (rStateResponse.getState())
						{
							case INetIMAPStateResponse::STATE_OK:
							{
								Execution eExecution
									= handleAlertResponse(rStateResponse);
								if (eExecution != EXEC_NOTHING)
									return eExecution;

								m_nState = STATE_SEND_SUBSCRIBE;
								return EXEC_CONTINUE;
							}

							case INetIMAPStateResponse::STATE_NO:
							{
								Execution eExecution
									= handleAlertResponse(rStateResponse);
								if (eExecution != EXEC_NOTHING)
									return eExecution;

								++m_aSscrbdMboxIter;
								m_nState = STATE_SEND_UNSUBSCRIBE;
								return EXEC_CONTINUE;
							}
						}
					break;
				}
			}
			break;

		case STATE_SEND_SUBSCRIBE:
		{
			ByteString aNewName(m_aNewMboxLiteralFullName);
			aNewName
				+= m_aSscrbdMboxIter->Copy(getMboxLiteralFullName().Len());
			if (m_cNewHierarchySeparator != getHierarchySeparator())
				for (xub_StrLen i = getMboxLiteralFullName().Len();; ++i)
				{
					i = aNewName.SearchAndReplace(getHierarchySeparator(),
												  m_cNewHierarchySeparator,
												  i);
					if (i == STRING_NOTFOUND)
						break;
				}

			++m_nState;
			return handleCommandFailure(clientCommandSubscribe(aNewName));
		}

		case STATE_RECV_SUBSCRIBE:
			switch (pResponse->getType())
			{
				case INetIMAPResponse::TYPE_STATE:
				{
					const INetIMAPStateResponse & rStateResponse
						= *static_cast< const INetIMAPStateResponse * >(
							   pResponse);

					if (rStateResponse.isFinal())
						switch (rStateResponse.getState())
						{
							case INetIMAPStateResponse::STATE_OK:
							case INetIMAPStateResponse::STATE_NO:
							{
								Execution eExecution
									= handleAlertResponse(rStateResponse);
								if (eExecution != EXEC_NOTHING)
									return eExecution;

								++m_aSscrbdMboxIter;
								m_nState = STATE_SEND_UNSUBSCRIBE;
								return EXEC_CONTINUE;
							}
						}
					break;
				}
			}
			break;

		default:
			return super::executeState(pResponse);
	}

	return EXEC_UNHANDLED;
}

//============================================================================
//
//  CntIMAPMboxCreateTask
//
//============================================================================

// virtual
bool CntIMAPMboxCreateTask::initialize()
{
	while (!super::initialize())
		switch (handleError(ERRCODE_CHAOS_OFFLINE))
		{
			case ERROR_RESPONSE_ABORT:
			case ERROR_RESPONSE_IGNORE:
				cancel();
			case ERROR_RESPONSE_CANCELED:
				return false;
		}

	m_aMboxURL = OWN_URL(&m_pMbox->getNode());
	m_aMboxLiteralLastName = CntIMAPURL::getMboxLiteralLastName(m_aMboxURL);
	return true;
}

//============================================================================
// virtual
CntIMAPOnlineTask::Execution
CntIMAPMboxCreateTask::executeState(const INetIMAPResponse * pResponse)
{
	switch (m_nState)
	{
		case STATE_SEND_LIST_ROOT:
			m_bHierarchySeparatorDetermined
				= m_pMbox->
				      hasDeterminedHierarchySeparator(m_cHierarchySeparator);
			if (m_bHierarchySeparatorDetermined)
			{
				m_nState = STATE_SEND_CREATE;
				return EXEC_CONTINUE;
			}

			if (m_pMbox->getNode().GetParent()->ISA(CntIMAPMboxNode))
				m_aPattern = CntIMAPURL::getRootLiteralName(m_aMboxURL);

			++m_nState;
			return handleCommandFailure(clientCommandList(ByteString(),
														  m_aPattern));

		case STATE_RECV_LIST_ROOT:
			switch (pResponse->getType())
			{
				case INetIMAPResponse::TYPE_STATE:
				{
					const INetIMAPStateResponse & rStateResponse
						= *static_cast< const INetIMAPStateResponse * >(
							   pResponse);

					if (rStateResponse.isFinal()
						&& rStateResponse.getState()
						       == INetIMAPStateResponse::STATE_OK)
					{
						Execution eExecution
							= handleAlertResponse(rStateResponse);
						if (eExecution != EXEC_NOTHING)
							return eExecution;

						if (!m_bHierarchySeparatorDetermined
							&& m_aPattern.Len() != 0)
							return handleCommandFailure(
								       *new StringErrorInfo(
										        ERRCODE_CHAOS_IMAP_BAD_SERVER,
												ITEMSET_VALUE(
													&getAcnt().getNode(),
													CntStringItem,
													WID_SERVERNAME)));

						m_nState = STATE_SEND_CREATE;
						return EXEC_CONTINUE;
					}
					break;
				}

				case INetIMAPResponse::TYPE_LIST:
				{
					const INetIMAPListResponse & rListResponse
						= *static_cast< const INetIMAPListResponse * >(
							   pResponse);

					for (ULONG i = 0;
						 !m_bHierarchySeparatorDetermined
						 && i < rListResponse.getMailboxCount();
						 ++i)
					{
						const INetIMAPListResponseMailbox & rRootMbox
							= rListResponse.getMailbox(i);

						bool bSuccess;
						if (m_aPattern.Len() == 0)
							bSuccess = rRootMbox.getMailboxName().Len() == 0
							           || rRootMbox.isMailboxNameNIL();
						else
						{
							ByteString aRootMboxLiteralFullName;
							bSuccess = isRootMbox(rRootMbox,
												  aRootMboxLiteralFullName)
							           && aRootMboxLiteralFullName
								              == m_aPattern;
							if (bSuccess)
								m_pMbox->
									setHierarchySeparator(
										getJob(),
										!(rRootMbox.getFlags()
							 & INetIMAPListResponseMailbox::FLAG_NOINFERIORS),
										!(rRootMbox.getFlags()
								& INetIMAPListResponseMailbox::FLAG_NOSELECT),
										rRootMbox.getHierarchySeparator());
						}

						if (bSuccess)
						{
							m_bHierarchySeparatorDetermined = true;
							m_cHierarchySeparator
								= rRootMbox.getHierarchySeparator();
						}
					}

					return EXEC_DONE;
				}
			}
			break;

		case STATE_SEND_CREATE:
		{
			ByteString aMboxLiteralFullName;
			if (m_bHierarchySeparatorDetermined)
			{
				if (m_cHierarchySeparator != '\0')
				{
					xub_StrLen nSep = m_aMboxLiteralLastName.
						                  Search(m_cHierarchySeparator);
					if (nSep != STRING_NOTFOUND
						&& (m_aMboxLiteralLastName.Len() < 2
							|| nSep < m_aMboxLiteralLastName.Len() - 1))
					{
						if (handleError(*new StringErrorInfo(
							                     ERRCODE_CHAOS_IMAP_BAD_TITLE,
												 ITEM_VALUE(
													 CntStringItem,
													 *getJob().GetRequest())))
							    != ERROR_RESPONSE_CANCELED)
							cancel();
						return EXEC_DONE;
					}

					if (m_aMboxLiteralLastName.Len() >= 2
						&& m_aMboxLiteralLastName.
						           GetChar(m_aMboxLiteralLastName.Len() - 1)
						       == m_cHierarchySeparator)
					{
						m_xExchangedMbox
							= m_pMbox->getNode().GetParent()->
						          Query(CntIMAPURL::createSubMboxURL(
									        OWN_URL(m_pMbox->getNode().
													             GetParent()),
											m_aMboxLiteralLastName.
											Copy(0,
												 m_aMboxLiteralLastName.Len()
												     - 1)));
						if (CntIMAPMboxNode * pTheExchangedMbox
							    = PTR_CAST(CntIMAPMboxNode,
										   &m_xExchangedMbox))
							m_pMbox = &pTheExchangedMbox->getMbox();
						else
						{
							if (handleError(
								        *new StringErrorInfo(
											     ERRCODE_CHAOS_IMAP_BAD_TITLE,
												 ITEM_VALUE(
													 CntStringItem,
													 *getJob().GetRequest())))
								    != ERROR_RESPONSE_CANCELED)
								cancel();
							return EXEC_DONE;
						}
					}
				}

				if (!CntIMAPURL::getMboxLiteralFullName(m_aMboxURL,
														m_cHierarchySeparator,
														aMboxLiteralFullName))
				{
					if (handleError(*new StringErrorInfo(
						                     ERRCODE_CHAOS_IMAP_BAD_TITLE,
											 ITEM_VALUE(CntStringItem,
														*getJob().
														     GetRequest())))
						    != ERROR_RESPONSE_CANCELED)
						cancel();
					return EXEC_DONE;
				}
			}
			else
				aMboxLiteralFullName = m_aMboxLiteralLastName;

			++m_nState;
			return handleCommandFailure(clientCommandCreate(
				                            aMboxLiteralFullName));
		}

		case STATE_RECV_CREATE:
			switch (pResponse->getType())
			{
				case INetIMAPResponse::TYPE_STATE:
				{
					const INetIMAPStateResponse & rStateResponse
						= *static_cast< const INetIMAPStateResponse * >(
							   pResponse);

					if (rStateResponse.isFinal()
						&& rStateResponse.getState()
						       == INetIMAPStateResponse::STATE_OK)
					{
						if (m_bHierarchySeparatorDetermined)
						{
							m_pMbox->initialize(getJob(), true, 0, false,
												true);
							if (m_xExchangedMbox.Is())
								getJob().Result(m_xExchangedMbox,
												CNT_ACTION_EXCHANGED);
							getJob().Result(&m_pMbox->getNode());
						}

						Execution eExecution
							= handleAlertResponse(rStateResponse);
						if (eExecution != EXEC_NOTHING)
							return eExecution;

						m_nState = STATE_SEND_LIST_CREATED;
						return EXEC_CONTINUE;
					}
					break;
				}
			}
			break;

		case STATE_SEND_LIST_CREATED:
			if (m_bHierarchySeparatorDetermined)
				CntIMAPURL::getMboxLiteralFullName(OWN_URL(&m_pMbox->
														        getNode()),
												   m_cHierarchySeparator,
												   m_aPattern);
			else
			{
				m_aPattern = INET_IMAP_LIST_WILDCARD_NON_SEPARATOR;
				m_bFound = false;
			}

			++m_nState;
			return handleCommandFailure(clientCommandList(ByteString(),
														  m_aPattern));

		case STATE_RECV_LIST_CREATED:
			switch (pResponse->getType())
			{
				case INetIMAPResponse::TYPE_STATE:
				{
					const INetIMAPStateResponse & rStateResponse
						= *static_cast< const INetIMAPStateResponse * >(
							   pResponse);

					if (rStateResponse.isFinal()
						&& rStateResponse.getState()
						       == INetIMAPStateResponse::STATE_OK)
					{
						Execution eExecution
							= handleAlertResponse(rStateResponse);
						if (eExecution != EXEC_NOTHING)
							return eExecution;

						if (!(m_bHierarchySeparatorDetermined || m_bFound))
						{
							if (handleError(
								        *new StringErrorInfo(
											     ERRCODE_CHAOS_IMAP_BAD_TITLE,
												 ITEM_VALUE(
													 CntStringItem,
													 *getJob().GetRequest())))
								    != ERROR_RESPONSE_CANCELED)
								cancel();
							return EXEC_DONE;
						}

						done();
						return EXEC_DONE;
					}
					break;
				}

				case INetIMAPResponse::TYPE_LIST:
				{
					const INetIMAPListResponse & rListResponse
						= *static_cast< const INetIMAPListResponse * >(
							   pResponse);

					for (ULONG i = 0; i < rListResponse.getMailboxCount();
						 ++i)
					{
						const INetIMAPListResponseMailbox & rListedMbox
							= rListResponse.getMailbox(i);

						if (m_bHierarchySeparatorDetermined)
						{
							if (rListedMbox.getMailboxName() == m_aPattern)
								m_pMbox->initialize(getJob(), true,
													&rListedMbox, false,
													false);
									// call initialize() with bCreate == true
									// to update the data from rListedMbox
						}
						else
						{
							if (m_bFound)
								break;

							ByteString aRootMboxLiteralFullName;
							if (isRootMbox(rListedMbox,
										   aRootMboxLiteralFullName)
								&& aRootMboxLiteralFullName.Len()
								       <= m_aMboxLiteralLastName.Len())
							{
								xub_StrLen i;
								for (i = 0;
									 i < aRootMboxLiteralFullName.Len(); ++i)
									if (aRootMboxLiteralFullName.GetChar(i)
										    != m_aMboxLiteralLastName.
										           GetChar(i))
										break;
								if (i == aRootMboxLiteralFullName.Len()
									&& (m_aMboxLiteralLastName.Len() == i
										|| m_aMboxLiteralLastName.GetChar(i)
										       == rListedMbox.
										             getHierarchySeparator()))
								{
									if (m_aMboxLiteralLastName.Len() != i)
									{
										m_xExchangedMbox
											= getAcnt().getNode().
										          Query(
												 CntIMAPURL::createSubMboxURL(
														  OWN_URL(
															  &getAcnt().
															       getNode()),
												   aRootMboxLiteralFullName));
										if (CntIMAPMboxNode *
											        pTheExchangedMbox
											    = PTR_CAST(CntIMAPMboxNode,
														   &m_xExchangedMbox))
											m_pMbox = &pTheExchangedMbox->
												           getMbox();
										else
										{
											if (handleError(
												        *new StringErrorInfo(
												 ERRCODE_CHAOS_IMAP_BAD_TITLE,
																ITEM_VALUE(
																CntStringItem,
																	*getJob().
															   GetRequest())))
												   != ERROR_RESPONSE_CANCELED)
												cancel();
											return EXEC_DONE;
										}
									}

									m_pMbox->initialize(getJob(), true,
														&rListedMbox, false,
														true);
									if (m_xExchangedMbox.Is())
										getJob().Result(m_xExchangedMbox,
														CNT_ACTION_EXCHANGED);
									getJob().Result(&m_pMbox->getNode());

									m_bFound = true;
								}
							}
						}
					}

					return EXEC_DONE;
				}
			}
			break;

		default:
			return super::executeState(pResponse);
	}

	return EXEC_UNHANDLED;
}

//============================================================================
CntIMAPMboxCreateTask::CntIMAPMboxCreateTask(CntNodeJob & rJob,
											 CntIMAPMbox & rTheMbox):
	CntIMAPOnlineTask(rJob, rTheMbox.getAcnt()),
	m_pMbox(&rTheMbox)
{}

//============================================================================
//
//  CntIMAPMboxTransferTask
//
//============================================================================

// virtual
bool CntIMAPMboxTransferTask::initialize()
{
	m_bAppend
		= static_cast< const CntTransferItem * >(getJob().GetRequest())->
		          getSpec()
		      == CntTransferItem::SPEC_DATA_TITLE;
	if (m_bAppend)
		skipSelect();
	else
	{
		String aSourceMesgURL;
		if (!CntIMAPURL::isMesgURL(OWN_URL(&getAcnt().getNode()),
								   static_cast< const CntTransferItem * >(
									       getJob().GetRequest())->
								       getSourceURL(),
								   aSourceMesgURL))
		{
			if (handleError(ERRCODE_CHAOS_TRANSFER_URL_NOT_SUPPORTED)
				    != ERROR_RESPONSE_CANCELED)
				cancel();
			return false;
		}

		String aSourceMboxURL;
		sal_uInt32 nSourceUIDValidity;
		CntIMAPURL::decomposeMesgURL(aSourceMesgURL, aSourceMboxURL,
									 nSourceUIDValidity, m_nSourceMesgUID);
		if (nSourceUIDValidity != 0)
		{
			cancel();
			return false;
		}

		m_xSourceMboxNode = getAcnt().getNode().Query(aSourceMboxURL);
		if (!m_xSourceMboxNode.Is())
		{
			cancel();
			return false;
		}
		static_cast< CntIMAPMboxNode * >(&m_xSourceMboxNode)->
			getMbox().initialize(getJob());
		exchangeMbox(static_cast< CntIMAPMboxNode * >(&m_xSourceMboxNode)->
					     getMbox());

		m_aTargetMboxURL = OWN_URL(&m_rTargetMbox.getNode());
	}

	while (!super::initialize())
		switch (handleError(ERRCODE_CHAOS_OFFLINE))
		{
			case ERROR_RESPONSE_ABORT:
			case ERROR_RESPONSE_IGNORE:
				cancel();
			case ERROR_RESPONSE_CANCELED:
				return false;
		}

	return true;
}

//============================================================================
// virtual
CntIMAPOnlineTask::Execution
CntIMAPMboxTransferTask::executeState(const INetIMAPResponse * pResponse)
{
	switch (m_nState)
	{
		case STATE_SWITCH:
			m_nState = m_bAppend ? STATE_SEND_APPEND : STATE_SEND_TARGET_LIST;
			return EXEC_CONTINUE;

		case STATE_SEND_APPEND:
		{
			pushStatusInformation(CntResId(RID_TRANSFERRING_MESSAGE),
								  CntIMAPStatusInformation::TAG_NONE, true);

			SvLockBytes * pLockBytes
				= static_cast< const CntTransferItem * >(getJob().
														     GetRequest())->
				      getSourceData();
			INetContentType eContentType
				= static_cast< CntTransferItem const * >(getJob().
														     GetRequest())->
				      getSourceType();
			if (eContentType == CONTENT_TYPE_INET_MESSAGE_RFC822)
			{
				++m_nState;
				return handleCommandFailure(
					       clientCommandAppend(
							   getMboxLiteralFullName(),
							   pLockBytes ? new SvStream(pLockBytes) : 0));
			}
			else
			{
				INetMIMEStringOutputSink aRFC822Header;

				aRFC822Header << "Date: ";
				DateTime aDateTime;
				aDateTime.ConvertToUTC();
				INetMIME::writeDateTime(aRFC822Header, aDateTime);
				aRFC822Header << INetMIMEOutputSink::endl;

				String aHost;
				sal_uInt16 nPort;
				if (getAcnt().getHostAndPort(aHost, nPort) == ERRCODE_NONE)
				{
					bool bHasUserIDAndAuthType;
					String aUserID;
					String aPassword;
					getAcnt().getUserIDAndPassword(bHasUserIDAndAuthType,
												   aUserID, aPassword);
					ByteString
						aAddrSpec(CntMBXFormat::translateRFC822AddrSpec(
							          aUserID, aHost));
					if (aAddrSpec.Len() != 0)
					{
						aRFC822Header << "From:";
						INetMIME::writeHeaderFieldBody(
							aRFC822Header, INetMIME::HEADER_FIELD_ADDRESS,
							aAddrSpec, osl_getThreadTextEncoding());
						aRFC822Header << INetMIMEOutputSink::endl << "To:";
						INetMIME::writeHeaderFieldBody(
							aRFC822Header, INetMIME::HEADER_FIELD_ADDRESS,
							aAddrSpec, osl_getThreadTextEncoding());
						aRFC822Header << INetMIMEOutputSink::endl;
					}
				}

				aRFC822Header << "Subject:";
				INetMIME::writeHeaderFieldBody(
					aRFC822Header, INetMIME::HEADER_FIELD_TEXT,
					static_cast< const CntTransferItem * >(getJob().
													           GetRequest())->
					    getTargetTitle(),
					osl_getThreadTextEncoding());
				aRFC822Header << INetMIMEOutputSink::endl;

				++m_nState;
				return handleCommandFailure(
					       clientCommandAppend(
							   getMboxLiteralFullName(),
							   aRFC822Header.takeBuffer(), eContentType,
							   pLockBytes ? new SvStream(pLockBytes) : 0));
			}
		}

		case STATE_RECV_APPEND:
			switch (pResponse->getType())
			{
				case INetIMAPResponse::TYPE_STATE:
				{
					const INetIMAPStateResponse & rStateResponse
						= *static_cast< const INetIMAPStateResponse * >(
							   pResponse);

					if (rStateResponse.isFinal()
						&& rStateResponse.getState()
						       == INetIMAPStateResponse::STATE_OK)
					{
						Execution eExecution
							= handleAlertResponse(rStateResponse);
						if (eExecution != EXEC_NOTHING)
							return eExecution;

						popStatusInformation();

						m_nState = STATE_UPDATE;
						return EXEC_CONTINUE;
					}
					break;
				}
			}
			break;

		case STATE_SEND_TARGET_LIST:
			m_bTargetHierarchySeparatorDetermined
				= m_rTargetMbox.hasDeterminedHierarchySeparator(
					                m_cTargetHierarchySeparator);
			if (m_bTargetHierarchySeparatorDetermined)
			{
				m_nState = STATE_SEND_COPY;
				return EXEC_CONTINUE;
			}

			m_aTargetRootLiteralName
				= CntIMAPURL::getRootLiteralName(m_aTargetMboxURL);

			++m_nState;
			return handleCommandFailure(clientCommandList(
				                            ByteString(),
											m_aTargetRootLiteralName));

		case STATE_RECV_TARGET_LIST:
			switch (pResponse->getType())
			{
				case INetIMAPResponse::TYPE_STATE:
				{
					const INetIMAPStateResponse & rStateResponse
						= *static_cast< const INetIMAPStateResponse * >(
							   pResponse);

					if (rStateResponse.isFinal()
						&& rStateResponse.getState()
						       == INetIMAPStateResponse::STATE_OK)
					{
						if (m_bTargetHierarchySeparatorDetermined)
							m_rTargetMbox.
								setHierarchySeparator(
									getJob(),
									!(m_eTargetRootMboxFlags
							 & INetIMAPListResponseMailbox::FLAG_NOINFERIORS),
									!(m_eTargetRootMboxFlags
								& INetIMAPListResponseMailbox::FLAG_NOSELECT),
									getHierarchySeparator());

						Execution eExecution
							= handleAlertResponse(rStateResponse);
						if (eExecution != EXEC_NOTHING)
							return eExecution;

						if (!m_bTargetHierarchySeparatorDetermined)
							return
								handleCommandFailure(
									*new StringErrorInfo(
										     ERRCODE_CHAOS_IMAP_BAD_SERVER,
											 ITEMSET_VALUE(&getAcnt().
														        getNode(),
														   CntStringItem,
														   WID_SERVERNAME)));

						m_nState = STATE_SEND_COPY;
						return EXEC_CONTINUE;
					}
					break;
				}

				case INetIMAPResponse::TYPE_LIST:
				{
					const INetIMAPListResponse & rListResponse
						= *static_cast< const INetIMAPListResponse * >(
							   pResponse);

					for (ULONG i = 0; i < rListResponse.getMailboxCount();
						 ++i)
					{
						const INetIMAPListResponseMailbox & rMbox
							= rListResponse.getMailbox(i);
						ByteString aMboxLiteralFullName;
						if (isRootMbox(rMbox, aMboxLiteralFullName)
							&& aMboxLiteralFullName
							       == m_aTargetRootLiteralName)
						{
							m_bTargetHierarchySeparatorDetermined = true;
							m_cTargetHierarchySeparator
								= rMbox.getHierarchySeparator();
							m_eTargetRootMboxFlags = rMbox.getFlags();
						}
					}

					return EXEC_DONE;
				}
			}
			break;

		case STATE_SEND_COPY:
		{
			ByteString aTargetMboxLiteralFullName;
			if (!CntIMAPURL::getMboxLiteralFullName(
				     m_aTargetMboxURL, m_cTargetHierarchySeparator,
					 aTargetMboxLiteralFullName))
			{
				cancel();
				return EXEC_DONE;
			}

			pushStatusInformation(CntResId(RID_TRANSFERRING_MESSAGE),
								  CntIMAPStatusInformation::TAG_NONE, true);

			INetIMAPMessageNumberSet * pSet
				= getAcnt().getClient()->createMessageNumberSet();
			pSet->add(m_nSourceMesgUID);

			++m_nState;
			ErrCode nError = clientCommandCopy(true, *pSet,
											   aTargetMboxLiteralFullName);
			delete pSet;
			return handleCommandFailure(nError);
		}

		case STATE_RECV_COPY:
			switch (pResponse->getType())
			{
				case INetIMAPResponse::TYPE_STATE:
				{
					const INetIMAPStateResponse & rStateResponse
						= *static_cast< const INetIMAPStateResponse * >(
							   pResponse);

					if (rStateResponse.isFinal()
						&& rStateResponse.getState()
						       == INetIMAPStateResponse::STATE_OK)
					{
						Execution eExecution
							= handleAlertResponse(rStateResponse);
						if (eExecution != EXEC_NOTHING)
							return eExecution;

						popStatusInformation();

						if (static_cast< const CntTransferItem * >(
							        getJob().GetRequest())->
							    isMoveOperation())
						{
							CntAnchorRef xSourceMesgAnchor
								= new CntAnchor(
									      0,
										  static_cast
										          < const CntTransferItem * >(
												      getJob().GetRequest())->
										      getSourceURL());
							xSourceMesgAnchor->Put(CntBoolItem(WID_DELETE,
															   true));
						}

						m_nState = STATE_UPDATE;
						return EXEC_CONTINUE;
					}
					break;
				}
			}
			break;

		case STATE_UPDATE:
			getJob().GetSubject()->
				InsertJob(new CntNodeJob(0, getJob().GetClient(),
										 getJob().GetSubject(),
										 CntOpenModeItem(WID_UPDATE,
														 CNT_OPEN_MESSAGES)));
			done();
			return EXEC_DONE;

		default:
			return super::executeState(pResponse);
	}

	return EXEC_UNHANDLED;
}

//============================================================================
//
//  CntIMAPMboxDeleteTask
//
//============================================================================

// virtual
void CntIMAPMboxDeleteTask::beingCanceled()
{
	delete m_pCurrentMboxDirIter;
	super::beingCanceled();
}

//============================================================================
// virtual
bool CntIMAPMboxDeleteTask::initialize()
{
	if (getMbox().getNode().GetItemState(WID_DELETE, false)
		    & SFX_ITEM_DISABLED)
	{
		cancel();
		return false;
	}

	if (!ITEM_VALUE(CntBoolItem, *getJob().GetRequest()))
	{
		if (!getMbox().isDeleted())
		{
			CntNodeRef xParentDirNode
				= getMbox().getParentFldr().getDirNode(getJob());
			if (!xParentDirNode.Is())
			{
				cancel();
				return false;
			}

			sal_uInt32 nMboxDirAttribs;
			if (static_cast< CntStorageNode * >(&xParentDirNode)->
				        attrib(OWN_URL(&getMbox().getNode()), 0,
							   CNTDIRENTRY_ATTRIB_MARKEDFORDELETE,
							   nMboxDirAttribs)
				    != ERRCODE_NONE)
			{
				cancel();
				return false;
			}

			getMbox().setDeleted(true);

			static_cast< CntIMAPFldrNode * >(getMbox().
											     getNode().GetParent())->
				getFldr().changeMboxCounts(
					          getJob(), CntIMAPFldr::COUNT_DEC,
							  nMboxDirAttribs
							          & CNTDIRENTRY_ATTRIB_IMAP_MBOX_SSCRBD ?
							      CntIMAPFldr::COUNT_DEC :
							      CntIMAPFldr::COUNT_STAY);

			getJob().Result(&getMbox().getNode(), CNT_ACTION_DELETED);
		}

		done();
		return false;
	}

	m_aAcntURL = OWN_URL(&getAcnt().getNode());
	m_aMboxNodes.push(getMbox().getNode());
	m_bGoOnline = false;
	m_bOnline = false;
	m_nProgress = CntIMAPStatusInformation::NO_PROGRESS;
	m_pCurrentMbox = 0;

	return false;
}

//============================================================================
// virtual
CntIMAPOnlineTask::Execution
CntIMAPMboxDeleteTask::executeState(const INetIMAPResponse * pResponse)
{
	switch (m_nState)
	{
		case STATE_SEND_LIST:
		{
			if (m_pCurrentMbox)
			{
				m_nState = STATE_SEND_CLOSE;
				return EXEC_CONTINUE;
			}

			CntIMAPURL::getMboxLiteralFullName(m_aCurrentMboxURL,
											   getHierarchySeparator(),
											   m_aCurrentMboxLiteralFullName);

			ByteString aPattern(m_aCurrentMboxLiteralFullName);
			aPattern += getHierarchySeparator();
			aPattern += INET_IMAP_LIST_WILDCARD_NON_SEPARATOR;

			++m_nState;
			return handleCommandFailure(clientCommandList(ByteString(),
														  aPattern));
		}

		case STATE_RECV_LIST:
			switch (pResponse->getType())
			{
				case INetIMAPResponse::TYPE_STATE:
				{
					const INetIMAPStateResponse & rStateResponse
						= *static_cast< const INetIMAPStateResponse * >(
							   pResponse);

					if (rStateResponse.isFinal()
						&& rStateResponse.getState()
						       == INetIMAPStateResponse::STATE_OK)
					{
						Execution eExecution
							= handleAlertResponse(rStateResponse);
						if (eExecution != EXEC_NOTHING)
							return eExecution;

						m_bOnline = false;
						m_xCurrentMboxNode = 0;

						m_nState = STATE_START_OFFLINE;
						return EXEC_RESCHEDULE;
					}
					break;
				}

				case INetIMAPResponse::TYPE_LIST:
				{
					const INetIMAPListResponse & rListResponse
						= *static_cast< const INetIMAPListResponse * >(
							   pResponse);

					for (ULONG i = 0; i < rListResponse.getMailboxCount();
						 ++i)
					{
						const INetIMAPListResponseMailbox & rSubMbox
							= rListResponse.getMailbox(i);
						ByteString aSubMboxLiteralFullName;
						if (isDirectSubMbox(m_aCurrentMboxLiteralFullName,
											rSubMbox,
											aSubMboxLiteralFullName))
						{
							String
								aSubMboxURL(CntIMAPURL::createMboxURL(
									            m_aAcntURL,
												aSubMboxLiteralFullName,
												rSubMbox.
												    getHierarchySeparator()));
							CntNodeRef xSubMboxNode
								= m_xCurrentMboxNode->Query(aSubMboxURL);
							if (xSubMboxNode.Is())
							{
								static_cast< CntIMAPMboxNode * >(
									    &xSubMboxNode)->
									getMbox().initialize(getJob(), true,
														 &rSubMbox, false,
														 false);

								m_aMboxNodes.
									push(*static_cast< CntIMAPMboxNode * >(
										      &xSubMboxNode));
							}
						}
					}

					return EXEC_DONE;
				}
			}
			break;

		case STATE_SEND_CLOSE:
			CntIMAPURL::getMboxLiteralFullName(m_aCurrentMboxURL,
											   getHierarchySeparator(),
											   m_aCurrentMboxLiteralFullName);
			if (m_aCurrentMboxLiteralFullName
				    != getAcnt().getClient()->getSelectedMailbox())
			{
				m_nState = STATE_SEND_UNSUBSCRIBE;
				return EXEC_CONTINUE;
			}

			// At least the 'Netscape IMAP4 Service 1.0' server immediately
			// shuts down the connection when the selected mailbox is deleted,
			// so close the mailbox first:
			pushStatusInformation(CntResId(RID_CLOSING_FOLDER),
								  CntIMAPStatusInformation::TAG_NONE, true);

			++m_nState;
			return handleCommandFailure(clientCommandClose());

		case STATE_RECV_CLOSE:
			switch (pResponse->getType())
			{
				case INetIMAPResponse::TYPE_STATE:
				{
					const INetIMAPStateResponse & rStateResponse
						= *static_cast< const INetIMAPStateResponse * >(
							   pResponse);

					if (rStateResponse.isFinal()
						&& rStateResponse.getState()
						       == INetIMAPStateResponse::STATE_OK)
					{
						Execution eExecution
							= handleAlertResponse(rStateResponse);
						if (eExecution != EXEC_NOTHING)
							return eExecution;

						popStatusInformation();

						m_nState = STATE_SEND_UNSUBSCRIBE;
						return EXEC_CONTINUE;
					}
					break;
				}
			}
			break;

		case STATE_SEND_UNSUBSCRIBE:
			if (!ITEMSET_VALUE(m_xCurrentMboxNode, CntBoolItem,
							   WID_FLAG_SUBSCRIBED))
			{
				m_nState = STATE_SEND_DELETE;
				return EXEC_CONTINUE;
			}

			// At least the 'Netscape IMAP4 Service 1.0', in response to LSUB,
			// lists mailboxes that where subscribed when they were deleted,
			// so unsubscribe them first:
			++m_nState;
			return handleCommandFailure(clientCommandUnSubscribe(
				                            m_aCurrentMboxLiteralFullName));

		case STATE_RECV_UNSUBSCRIBE:
			switch (pResponse->getType())
			{
				case INetIMAPResponse::TYPE_STATE:
				{
					const INetIMAPStateResponse & rStateResponse
						= *static_cast< const INetIMAPStateResponse * >(
							   pResponse);

					// Some IMAP servers list mailboxes as subscribed but send
					// a NO response when asked to unsubscribe those
					// mailboxes.  It seems to be better to ignore that error
					// response here...
					if (rStateResponse.isFinal())
						switch (rStateResponse.getState())
						{
							case INetIMAPStateResponse::STATE_OK:
								static_cast< CntIMAPMboxNode * >(
									    &m_xCurrentMboxNode)->
									getMbox().
									    storeProperty(getJob(),
													  CntBoolItem(
														  WID_FLAG_SUBSCRIBED,
														  false));
							case INetIMAPStateResponse::STATE_NO:
								Execution eExecution
									= handleAlertResponse(rStateResponse);
								if (eExecution != EXEC_NOTHING)
									return eExecution;

								m_nState = STATE_SEND_DELETE;
								return EXEC_CONTINUE;
						}
					break;
				}
			}
			break;

		case STATE_SEND_DELETE:
			++m_nState;
			return handleCommandFailure(clientCommandDelete(
				                            m_aCurrentMboxLiteralFullName));

		case STATE_RECV_DELETE:
			switch (pResponse->getType())
			{
				case INetIMAPResponse::TYPE_STATE:
				{
					const INetIMAPStateResponse & rStateResponse
						= *static_cast< const INetIMAPStateResponse * >(
							   pResponse);

					if (rStateResponse.isFinal()
						&& rStateResponse.getState()
						       == INetIMAPStateResponse::STATE_OK)
					{
						if (m_xCurrentMboxDirNode.Is())
							static_cast< CntStorageNode * >(
								    m_xCurrentMboxDirNode->GetParent())->
								remove(m_aCurrentMboxURL);

						if (!static_cast< CntIMAPMboxNode * >(
							         &m_xCurrentMboxNode)->
							     getMbox().isDeleted())
							static_cast< CntIMAPFldrNode * >(
								    m_xCurrentMboxNode->GetParent())->
								getFldr().
								    changeMboxCounts(
										getJob(), CntIMAPFldr::COUNT_DEC,
										ITEMSET_VALUE(m_xCurrentMboxNode,
													  CntBoolItem,
													  WID_FLAG_SUBSCRIBED) ?
										    CntIMAPFldr::COUNT_DEC :
										    CntIMAPFldr::COUNT_STAY);
						static_cast< CntIMAPMboxNode * >(
							    &m_xCurrentMboxNode)->
							getMbox().setDeleted(false);

						Execution eExecution
							= handleAlertResponse(rStateResponse);
						if (eExecution != EXEC_NOTHING)
							return eExecution;

						if (m_xCurrentMboxDirNode.Is())
							m_pCurrentMboxDirIter
								= new CntStorageIterator(
									      0,
										  CNTDIRENTRY_ATTRIB_HIDDEN
										      | CNTDIRENTRY_ATTRIB_SUBDIR
										      | CNTSTORE_ATTRIB_ISDIR
										      | CNTDIRENTRY_ATTRIB_IMAP_MBOX);

						m_bOnline = false;

						m_nState = STATE_REMOVE_BODIES;
						return EXEC_RESCHEDULE;
					}
					break;
				}
			}
			break;

		case STATE_REMOVE_BODIES:
		{
			if (m_nProgress == CntIMAPStatusInformation::NO_PROGRESS)
			{
				pushStatusInformation(CntResId(RID_PROT_REMOVING_MESSAGES), 0,
									  static_cast< CntIMAPMboxNode * >(
										      &m_xCurrentMboxNode)->
									      getMbox().getLMesgCount()
									  + static_cast< CntIMAPMboxNode * >(
										        &m_xCurrentMboxNode)->
									        getMbox().getLSMesgCount());
				m_nProgress = 0;
			}

			startTimeSlice();

			CntStorageNode * pCacheNode = getJob().GetCacheNode();
			if (!pCacheNode)
			{
				delete m_pCurrentMboxDirIter;
				m_pCurrentMboxDirIter = 0;
			}

			while (m_pCurrentMboxDirIter)
			{
				String aID(static_cast< CntStorageNode * >(
					               &m_xCurrentMboxDirNode)->
						       iter(*m_pCurrentMboxDirIter));
				if (m_pCurrentMboxDirIter->eof())
				{
					delete m_pCurrentMboxDirIter;
					m_pCurrentMboxDirIter = 0;
					break;
				}

				sal_uInt32 nUIDValidity;
				sal_uInt32 nMesgUID;
				if (CntIMAPMesgNode::isMesgDirID(aID, nUIDValidity, nMesgUID))
				{
					pCacheNode->remove(CntIMAPMesgNode::createBodyStreamID(
						                   m_aCurrentMboxURL, nUIDValidity,
										   nMesgUID));

					++m_nProgress;
				}

				if (checkTimeSliceExhausted())
				{
					progressStatusInformation(m_nProgress);
					return EXEC_RESCHEDULE;
				}
			}

			popStatusInformation();
			m_nProgress = CntIMAPStatusInformation::NO_PROGRESS;

			m_aMboxNodes.pop();
			m_pCurrentMbox = 0;
			m_xCurrentMboxNode = 0;

			m_nState = STATE_START_OFFLINE;
			return EXEC_CONTINUE;
		}

		case STATE_START_OFFLINE:
		{
			if (m_bOnline)
			{
				cancel();
				return EXEC_DONE;
			}

			if (!m_pCurrentMbox)
			{
				m_pCurrentMbox = m_aMboxNodes.getTop();
				if (!m_pCurrentMbox)
					return EXEC_BASE;

				m_xCurrentMboxNode = &m_pCurrentMbox->getMboxNode();
				m_aCurrentMboxURL = OWN_URL(m_xCurrentMboxNode);
				m_xCurrentMboxDirNode
					= static_cast< CntIMAPMboxNode * >(&m_xCurrentMboxNode)->
				          getMbox().getDirNode(getJob());

				if (!m_pCurrentMbox->wasFresh())
				{
					m_nState = STATE_GO_ONLINE;
					return EXEC_CONTINUE;
				}

				if (m_xCurrentMboxDirNode.Is())
					m_pCurrentMboxDirIter
						= new CntStorageIterator(
							      CNTDIRENTRY_ATTRIB_IMAP_MBOX,
								  CNTDIRENTRY_ATTRIB_HIDDEN
								      | CNTDIRENTRY_ATTRIB_SUBDIR
								      | CNTSTORE_ATTRIB_ISDIR);

				pushStatusInformation(CntResId(RID_PROT_REMOVING_MESSAGES), 0,
									  ITEMSET_VALUE(m_xCurrentMboxNode,
													CntUInt32Item,
													WID_IMAP_MBOX_COUNT));
				m_nProgress = 0;
			}

			while (m_pCurrentMboxDirIter)
			{
				String aID(static_cast< CntStorageNode * >(
					               &m_xCurrentMboxDirNode)->
						       iter(*m_pCurrentMboxDirIter));
				if (m_pCurrentMboxDirIter->eof())
				{
					delete m_pCurrentMboxDirIter;
					m_pCurrentMboxDirIter = 0;
					break;
				}

				if (CntIMAPURL::isDirectSubMboxURL(m_aCurrentMboxURL, aID))
				{
					CntNodeRef xSubMboxNode = m_xCurrentMboxNode->Query(aID);
					if (xSubMboxNode.Is())
					{
						static_cast< CntIMAPMboxNode * >(&xSubMboxNode)->
							getMbox().initialize(getJob());

						m_aMboxNodes.push(*static_cast< CntIMAPMboxNode * >(
							                   &xSubMboxNode));
					}

					++m_nProgress;
				}

				if (checkTimeSliceExhausted())
				{
					progressStatusInformation(m_nProgress);
					return EXEC_RESCHEDULE;
				}
			}

			popStatusInformation();
			m_nProgress = CntIMAPStatusInformation::NO_PROGRESS;

			m_pCurrentMbox = 0;

			sal_uInt32 nCurrentMboxDirAttribs = 0;
			if (m_xCurrentMboxDirNode.Is())
				static_cast< CntStorageNode * >(m_xCurrentMboxDirNode->
												    GetParent())->
					attrib(m_aCurrentMboxURL, 0, 0, nCurrentMboxDirAttribs);

			if (!(nCurrentMboxDirAttribs
				      & CNTDIRENTRY_ATTRIB_IMAP_MBOX_MBOXS))
				m_nState = STATE_GO_ONLINE;
			return EXEC_CONTINUE;
		}

		case STATE_GO_ONLINE:
			if (m_bGoOnline || super::initialize())
			{
				m_bGoOnline = true;
				m_bOnline = true;

				m_nState = STATE_RESTART_ONLINE;
				return EXEC_CONTINUE;
			}

			switch (handleError(ERRCODE_CHAOS_OFFLINE))
			{
				case ERROR_RESPONSE_RETRY:
					return EXEC_CONTINUE;

				default:
					cancel();
				case ERROR_RESPONSE_CANCELED:
					return EXEC_DONE;
			}

		default:
			return super::executeState(pResponse);
	}

	return EXEC_UNHANDLED;
}

//============================================================================
//
//  CntIMAPMboxUnDeleteTask
//
//============================================================================

// virtual
bool CntIMAPMboxUnDeleteTask::executeTimeSlice(bool)
{
	if (!m_rMbox.isDeleted())
	{
		done();
		return false;
	}

	CntStorageNode * pParentDirNode = getJob().GetDirectoryNode();
	if (pParentDirNode)
		pParentDirNode = PTR_CAST(CntStorageNode,
								  pParentDirNode->GetParent());
	if (!pParentDirNode)
	{
		cancel();
		return false;
	}

	sal_uInt32 nMboxDirAttribs;
	if (pParentDirNode->attrib(OWN_URL(&m_rMbox.getNode()),
							   CNTDIRENTRY_ATTRIB_MARKEDFORDELETE, 0,
							   nMboxDirAttribs))
	{
		cancel();
		return false;
	}

	m_rMbox.setDeleted(false);

	static_cast< CntIMAPFldrNode * >(m_rMbox.getNode().GetParent())->
		getFldr().
		    changeMboxCounts(getJob(), CntIMAPFldr::COUNT_INC,
							 nMboxDirAttribs
							         & CNTDIRENTRY_ATTRIB_IMAP_MBOX_SSCRBD ?
							     CntIMAPFldr::COUNT_INC :
								 CntIMAPFldr::COUNT_STAY);

	getJob().Result(&m_rMbox.getNode());

	done();
	return false;
}

//============================================================================
CntIMAPMboxUnDeleteTask::CntIMAPMboxUnDeleteTask(CntNodeJob & rJob,
												 CntIMAPMbox & rTheMbox):
	CntIMAPOfflineTask(rJob, rTheMbox.getAcnt().getNode(),
					   rTheMbox.getAcnt()),
	m_rMbox(rTheMbox)
{}

//============================================================================
//
//  CntIMAPMboxFlagMesgsTask
//
//============================================================================

// virtual
bool CntIMAPMboxFlagMesgsTask::initialize()
{
	if (getMbox().getNode().GetItemState(getJob().GetRequest()->Which(),
										 false)
		    & SFX_ITEM_DISABLED)
	{
		cancel();
		return false;
	}

	const SfxPoolItem * pFlaggedCount;
	if (getMbox().getNode().GetItemState(getJob().GetRequest()->Which()
										         == WID_IS_READ ?
										     WID_IMAP_READ_MESG_COUNT :
										     WID_IMAP_MARKED_MESG_COUNT,
										 false, &pFlaggedCount)
		    == SFX_ITEM_SET
		&& (ITEM_VALUE(CntBoolItem, *getJob().GetRequest()) ?
			    ITEM_VALUE(CntUInt32Item, *pFlaggedCount)
			        >= ITEMSET_VALUE(&getMbox().getNode(), CntUInt32Item,
									 WID_IMAP_MESG_COUNT) :
			    ITEM_VALUE(CntUInt32Item, *pFlaggedCount) == 0))
	{
		done();
		return false;
	}

	m_aMboxURL = OWN_URL(&getMbox().getNode());
	m_xMboxDirNode = getMbox().getDirNode(getJob());

	return false;
}

//============================================================================
// virtual
CntIMAPOnlineTask::Execution
CntIMAPMboxFlagMesgsTask::executeState(const INetIMAPResponse * pResponse)
{
	switch (m_nState)
	{
		case STATE_START_OFFLINE:
			if (m_bOfflineDone)
			{
				cancel();
				return EXEC_DONE;
			}

			if (super::initialize())
			{
				m_bOfflineDone = true;
				m_nState = STATE_RESTART_ONLINE;
				return EXEC_CONTINUE;
			}

			switch (handleError(ERRCODE_CHAOS_OFFLINE))
			{
				case ERROR_RESPONSE_RETRY:
					return EXEC_CONTINUE;

				default:
					cancel();
				case ERROR_RESPONSE_CANCELED:
					return EXEC_DONE;
			}

		case STATE_SEND_FETCH:
		{
			sal_uInt32 nMboxDirAttribs = 0;
			if (m_xMboxDirNode.Is())
				static_cast< CntStorageNode * >(m_xMboxDirNode->GetParent())->
					attrib(m_aMboxURL, 0, 0, nMboxDirAttribs);
			if (nMboxDirAttribs & CNTDIRENTRY_ATTRIB_IMAP_MBOX_MESGS)
			{
				m_nState = STATE_SEND_STORE;
				return EXEC_CONTINUE;
			}

			pushStatusInformation(CntResId(RID_READING_MESSAGES),
								  CntIMAPStatusInformation::TAG_NONE, true);

			INetIMAPMessageNumberSet * pSet
				= getAcnt().getClient()->createMessageNumberSet();
			pSet->addHalfOpen(1);

			++m_nState;
			ErrCode nError
				= clientCommandFetch(true, *pSet,
									 INetIMAPClient::FetchAttributes(
										 INetIMAPClient::FETCH_ALL
										     | INetIMAPClient::FETCH_UID),
									 0, 0, Link());
			delete pSet;
			return handleCommandFailure(nError);
		}

		case STATE_RECV_FETCH:
			switch (pResponse->getType())
			{
				case INetIMAPResponse::TYPE_STATE:
				{
					const INetIMAPStateResponse & rStateResponse
						= *static_cast< const INetIMAPStateResponse * >(
							   pResponse);

					if (rStateResponse.isFinal()
						&& rStateResponse.getState()
						       == INetIMAPStateResponse::STATE_OK)
					{
						Execution eExecution
							= handleAlertResponse(rStateResponse);
						if (eExecution != EXEC_NOTHING)
							return eExecution;

						if (m_xMboxDirNode.Is())
							static_cast< CntStorageNode * >(m_xMboxDirNode->
															    GetParent())->
								attrib(m_aMboxURL, 0,
									   CNTDIRENTRY_ATTRIB_IMAP_MBOX_MESGS);

						popStatusInformation();

						m_nState = STATE_SEND_STORE;
						return EXEC_CONTINUE;
					}
					break;
				}

				case INetIMAPResponse::TYPE_FETCH:
				{
					const INetIMAPFetchResponse & rFetchResponse
						= *static_cast< const INetIMAPFetchResponse * >(
							   pResponse);

					if (rFetchResponse.getPresentParts()
						    & INetIMAPFetchResponse::PART_UID)
					{
						String
							aMesgURL(CntIMAPURL::createMesgURL(m_aMboxURL, 0,
															   rFetchResponse.
															       getUID()));
						CntNodeRef
							xMesgNode(getMbox().getNode().Query(aMesgURL));
						if (xMesgNode.Is())
							static_cast< CntIMAPMesgNode * >(&xMesgNode)->
								initialize(getJob(), true, &rFetchResponse,
										   0);
					}

					return EXEC_DONE;
				}
			}
			break;

		case STATE_SEND_STORE:
		{
			INetIMAPMessageNumberSet * pSet
				= getAcnt().getClient()->createMessageNumberSet();
			pSet->addHalfOpen(1);

			++m_nState;
			ErrCode nError
				= clientCommandStore(
					  true, *pSet,
					  ITEM_VALUE(CntBoolItem, *getJob().GetRequest()) ?
					      INetIMAPClient::STORE_ADD_FLAGS_SILENT :
					      INetIMAPClient::STORE_REMOVE_FLAGS_SILENT,
					  getJob().GetRequest()->Which() == WID_IS_READ ?
					      INET_IMAP_FLAG_SEEN : INET_IMAP_FLAG_FLAGGED,
					  0);
			delete pSet;
			return handleCommandFailure(nError);
		}

		case STATE_RECV_STORE:
			switch (pResponse->getType())
			{
				case INetIMAPResponse::TYPE_STATE:
				{
					const INetIMAPStateResponse & rStateResponse
						= *static_cast< const INetIMAPStateResponse * >(
							   pResponse);

					if (rStateResponse.isFinal()
						&& rStateResponse.getState()
						       == INetIMAPStateResponse::STATE_OK)
					{
						Execution eExecution
							= handleAlertResponse(rStateResponse);
						if (eExecution != EXEC_NOTHING)
							return eExecution;

						m_nState = STATE_FLAG;
						return EXEC_RESCHEDULE;
					}
					break;
				}
			}
			break;

		case STATE_FLAG:
		{
			if (m_xMboxDirNode.Is())
			{
				CntStorageIterator
					aMboxDirIter(0,
								 CNTDIRENTRY_ATTRIB_NOTITER
								     | CNTSTORE_ATTRIB_ISDIR
								     | CNTDIRENTRY_ATTRIB_IMAP_MBOX);
				for (;;)
				{
					String aID(static_cast< CntStorageNode * >(
						               &m_xMboxDirNode)->
							       iter(aMboxDirIter));
					if (aMboxDirIter.eof())
						break;

					sal_uInt32 nUIDValidity;
					sal_uInt32 nMesgUID;
					if (CntIMAPMesgNode::isMesgDirID(aID, nUIDValidity,
													 nMesgUID))
					{
						CntNodeRef
							xMesgNode(getMbox().getNode().
									      Query(CntIMAPURL::createMesgURL(
											        m_aMboxURL, nUIDValidity,
													nMesgUID)));
						if (xMesgNode.Is())
						{
							static_cast< CntIMAPMesgNode * >(&xMesgNode)->
								initialize(getJob());

							if ((ITEMSET_VALUE(xMesgNode, CntBoolItem,
											   getJob().GetRequest()->Which())
								         != false)
								    != (ITEM_VALUE(CntBoolItem,
												   *getJob().GetRequest())
										    != false))
								static_cast< CntIMAPMesgNode * >(&xMesgNode)->
									storeProperty(getJob(),
												  *getJob().GetRequest());
						}
					}
				}
			}

			done();
			return EXEC_DONE;
		}

		default:
			return super::executeState(pResponse);
	}

	return EXEC_UNHANDLED;
}

//============================================================================
//
//  CntIMAPMboxSubscribeTask
//
//============================================================================

// virtual
bool CntIMAPMboxSubscribeTask::initialize()
{
	if ((ITEMSET_VALUE(&getMbox().getNode(), CntBoolItem, WID_FLAG_SUBSCRIBED)
		         != false)
		    == (ITEM_VALUE(CntBoolItem, *getJob().GetRequest()) != false))
	{
		done();
		return false;
	}

	for (;;)
		if (super::initialize())
			return true;
		else
			switch (handleError(ERRCODE_CHAOS_OFFLINE))
			{
				case ERROR_RESPONSE_ABORT:
				case ERROR_RESPONSE_IGNORE:
					cancel();
				case ERROR_RESPONSE_CANCELED:
					return false;
			}
}

//============================================================================
// virtual
CntIMAPOnlineTask::Execution
CntIMAPMboxSubscribeTask::executeState(const INetIMAPResponse * pResponse)
{
	switch (m_nState)
	{
		case STATE_SEND_SUBSCRIBE:
			++m_nState;
			return handleCommandFailure(ITEM_VALUE(CntBoolItem,
												   *getJob().GetRequest()) ?
										    clientCommandSubscribe(
												getMboxLiteralFullName()) :
										    clientCommandUnSubscribe(
												getMboxLiteralFullName()));

		case STATE_RECV_SUBSCRIBE:
			switch (pResponse->getType())
			{
				case INetIMAPResponse::TYPE_STATE:
				{
					const INetIMAPStateResponse & rStateResponse
						= *static_cast< const INetIMAPStateResponse * >(
							   pResponse);

					if (rStateResponse.isFinal()
						&& rStateResponse.getState()
						       == INetIMAPStateResponse::STATE_OK)
					{
						getMbox().storeProperty(getJob(),
												*getJob().GetRequest());

						Execution eExecution
							= handleAlertResponse(rStateResponse);
						if (eExecution != EXEC_NOTHING)
							return eExecution;

						done();
						return EXEC_DONE;
					}
					break;
				}
			}
			break;

		default:
			return super::executeState(pResponse);
	}

	return EXEC_UNHANDLED;
}

//============================================================================
//
//  CntIMAPMboxStoreMesgBodiesTask
//
//============================================================================

// virtual
bool CntIMAPMboxStoreMesgBodiesTask::executeTimeSlice(bool bFirst)
{
	if (bFirst)
	{
		if (!getJob().GetParent())
			pushStatusInformation(CntResId(RID_STORING_MESSAGES), 0,
								  getExecNode().SubNodeCount());
		m_nIndex = 0;
	}

	while (m_nIndex < getExecNode().SubNodeCount())
	{
		CntNode * pSubNode = getExecNode().GetSubNode(m_nIndex++);
		if (pSubNode->ISA(CntIMAPMesgNode))
		{
			if (!static_cast< CntIMAPMesgNode * >(pSubNode)->
				     hasKeepBodyFlag())
				static_cast< CntIMAPMesgNode * >(pSubNode)->
					setKeepBodyFlag(getJob(), false);
		}
		else if (!static_cast< CntIMAPMboxNode * >(pSubNode)->
				      getMbox().hasKeepBodiesFlag())
		{
			m_xSubJob = new CntNodeJob(&getJob(), getJob().GetClient(),
									   pSubNode, *getJob().GetRequest(),
									   false);
				// the sub job should not need a client, but one is required
			StartListening(*m_xSubJob);
			pSubNode->InsertJob(m_xSubJob);

			if (!getJob().GetParent())
				progressStatusInformation(m_nIndex - 1);
			return false;
		}

		if (checkTimeSliceExhausted())
		{
			if (!getJob().GetParent())
				progressStatusInformation(m_nIndex);
			return true;
		}
	}

	done();
	return false;
}

//============================================================================
// virtual
void CntIMAPMboxStoreMesgBodiesTask::notification(SfxBroadcaster &
												      rBroadcaster,
												  const SfxHint & rHint)
{
	if (&rBroadcaster == &m_xSubJob)
	{
		if (const CntStatusHint * pStatusHint
			    = PTR_CAST(CntStatusHint, &rHint))
			switch (pStatusHint->GetStatus())
			{
				case CNT_STATUS_DONE:
					EndListening(*m_xSubJob);
					m_xSubJob = 0;
					if (!getJob().GetParent())
						progressStatusInformation(m_nIndex);
					reschedule();
					break;

				case CNT_STATUS_ERROR:
					if (pStatusHint->GetError() == ERRCODE_ABORT)
					{
						EndListening(*m_xSubJob);
						m_xSubJob = 0;
						cancel();
					}
					break;
			}
	}
	else
		super::notification(rBroadcaster, rHint);
}

